// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef MINIMALIST_INTERACTION_GRAPH_H
#define MINIMALIST_INTERACTION_GRAPH_H

#include "InteractionGraphBase.h"
#include "OnTheFlyInteractionGraph.h"

#include <ObjexxFCL/FArray3D.hh>

namespace pack
{

class MinimalistNode;
class MinimalistEdge;
class MinimalistInteractionGraph;


class MinimalistNode : public OnTheFlyNode
{

public:
	MinimalistNode(
		InteractionGraphBase * owner,
		int node_id,
		int num_states
	);

	virtual ~MinimalistNode();

	//virtual methods inherited from NodeBase
	virtual void prepare_for_simulated_annealing();
	virtual void print() const;
	virtual bool state_unassigned() const { return current_state_ == 0;}
	virtual float get_totalE() const { return curr_state_total_energy_;}

	void assign_zero_state();
	void assign_state(int new_state);
	void partial_assign_state( int new_state );
	void complete_state_assignment();

	inline
	int get_current_state() const { return current_state_; }

	inline
	float get_one_body_energy_current_state() const
	{ return curr_state_one_body_energy_; }

	inline
	float project_deltaE_for_substitution
	(
		int alternate_state,
		float & prev_node_energy
	);

	void commit_considered_substitution();
	float compute_pair_energy_for_current_state( int edge_making_energy_request );

	inline
	void acknowledge_neighbors_state_substitution(
		int edge_to_altered_neighbor,
		float new_edge_energy,
		int other_node_new_state,
		SparseMatrixIndex const & other_node_new_state_sparse_info
	);

	void
	acknowledge_neighbors_partial_state_substitution(
		int edge_to_altered_neighbor,
		int other_node_new_,
		SparseMatrixIndex const & other_node_new_state_sparse_info
	);

	inline
	SparseMatrixIndex const &
	get_sparse_mat_info_for_curr_state() const;

	void print_internal_energies();

	void update_internal_energy_sums();

	virtual unsigned int count_static_memory() const;
	virtual unsigned int count_dynamic_memory() const;

protected:

	inline
	rotamer_trie const &
	get_current_rotamer()
	{
		return get_rotamer( current_state_ );
	}

	inline
	float &
	get_curr_rotamer_actcoords();

	//Hooks for SASANode< V, E, G > class
	float get_curr_pd_energy_total() const { return curr_state_total_energy_;}
	float get_alt_pd_energy_total() const { return alternate_state_total_energy_;}
	void set_alternate_state( int alt ) { alternate_state_ = alt; }
	int get_alternate_state() const { return alternate_state_; }
	void calc_deltaEpd( int alternate_state );
	bool considering_alternate_state() const
	{
		return alternate_state_is_being_considered_;
	}

private:

	//void
	//set_alt_aa_offsets_from_edge(int edge_index, FArray2D_int const & offsets);

	/*
	float
	compute_rotamer_pair_energy(
		int edge_making_energy_request,
		int state_this,
		int state_other,
		int aa_this,
		int aa_other,
		rotamer_trie const & this_rotamer,
		rotamer_trie const & other_rotamer,
		FArray1Da_float & this_rotamer_actcoords,
		FArray1Da_float & other_rotamer_actcoords
	);
	*/

	void update_internal_vectors();

	inline
	MinimalistEdge* get_incident_minimalist_edge( int index ) const
	{
		return ( MinimalistEdge* ) get_incident_edge( index );  // c-style cast since static_cast won't compile
	}

	inline
	MinimalistNode* get_adjacent_minimalist_node( int index ) const
	{
		return ( MinimalistNode* ) get_adjacent_node( index );  // c-style cast since static_cast won't compile
	}

	inline
	MinimalistInteractionGraph* get_minimalist_ig_owner() const
	{
		return ( MinimalistInteractionGraph* ) get_owner(); // c-style cast since static_cast won't compile
	}

	FArray3D< unsigned char > aa_neighbors_for_edges_;
	std::vector< int > neighbors_curr_state_;
	std::vector< SparseMatrixIndex > neighbors_curr_state_sparse_info_;

	int current_state_;
	SparseMatrixIndex curr_state_sparse_mat_info_;
	float curr_state_one_body_energy_;
	float curr_state_total_energy_;
	std::vector< float > curr_state_two_body_energies_;

	int alternate_state_;
	SparseMatrixIndex alt_state_sparse_mat_info_;
	float alternate_state_one_body_energy_;
	float alternate_state_total_energy_;
	std::vector< float > alternate_state_two_body_energies_;

	bool alternate_state_is_being_considered_;

	//no default constructor, uncopyable
	MinimalistNode();
	MinimalistNode( MinimalistNode const & );
	MinimalistNode & operator = ( MinimalistNode const & );

};

class MinimalistEdge : public OnTheFlyEdge
{
public:
	MinimalistEdge(
		InteractionGraphBase* owner,
		int first_node_ind,
		int second_node_ind
	);

	virtual ~MinimalistEdge();

	virtual
	void
	set_sparse_aa_info(
		FArray2DB_bool const &
	);

	//virtual methods inherited from EdgeBase
	virtual void prepare_for_simulated_annealing();

	float get_current_two_body_energy() const;

	void acknowledge_state_change(
		int node_ind,
		int new_state,
		SparseMatrixIndex const & new_state_sparse_info,
		float & new_energy
	);
	void acknowledge_state_zeroed( int node_ind );

	void acknowledge_partial_state_change(
		int node_ind,
		int new_state,
		SparseMatrixIndex const & new_state_sparse_info
	);
	float get_energy_following_partial_state_assignment();

	inline
	void acknowledge_substitution(
		int substituted_node_index,
		float const curr_state_energy,
		int nodes_new_state,
		SparseMatrixIndex const & nodes_new_state_sparse_info
	);

	int get_two_body_table_size() const;
	virtual void declare_energies_final();

	void print_current_energy() const;


	FArray2D< unsigned char > const & get_sparse_aa_neighbor_info( );
	FArray1D_int const & get_second_node_num_states_per_aa();

	static float const NOT_YET_COMPUTED_ENERGY; //an energy lower than any RPE could ever be

	virtual unsigned int count_static_memory() const;
	virtual unsigned int count_dynamic_memory() const;

protected:
	//Hooks for SASAEdge< V, E, G > class
	void declare_energies_final_no_deletion() { MinimalistEdge::prepare_for_simulated_annealing(); }
	void prepare_for_simulated_annealing_no_deletion() { MinimalistEdge::prepare_for_simulated_annealing(); }
	bool pd_edge_table_all_zeros() const { return false;}


private:

	inline
	MinimalistNode* get_minimalist_node( int index ) const
	{
		return (MinimalistNode*) get_node( index ); //c-style cast since static_cast won't compile
	}

	inline
	MinimalistInteractionGraph* get_minimalist_ig_owner() const
	{
		return (MinimalistInteractionGraph*) get_owner(); //c-style cast since static_cast won't compile
	}

	FArray2D< unsigned char > sparse_aa_neighbors_;
	float curr_state_energy_;
	bool partial_state_assignment_;

	//no default constructor, uncopyable
	MinimalistEdge();
	MinimalistEdge( MinimalistEdge const & );
	MinimalistEdge & operator = ( MinimalistEdge const & );

};

class MinimalistInteractionGraph : public OnTheFlyInteractionGraph
{
public:
	MinimalistInteractionGraph( int numNodes );
	virtual ~MinimalistInteractionGraph();

	//virtual methods inherited from InteractionGraphBase
	virtual void  blanket_assign_state_0();
	virtual float set_state_for_node(int node_ind, int new_state);
	virtual float set_network_state( FArray1DB_int & node_states);
	virtual void consider_substitution(
		int node_ind,
		int new_state,
		float & delta_energy,
		float & prev_energy_for_node
	);
	virtual float  commit_considered_substitution();
	virtual float get_energy_current_state_assignment();
	virtual int get_edge_memory_usage() const;
	virtual void print_current_state_assignment() const;
	virtual void set_errorfull_deltaE_threshold( float deltaE );
	virtual float get_energy_sum_for_vertex_group( int group_id );

	bool build_sc_only_rotamer() const;

	virtual unsigned int count_static_memory() const;
	virtual unsigned int count_dynamic_memory() const;

protected:

	virtual NodeBase* create_new_node( int node_index, int num_states);
	virtual EdgeBase* create_new_edge( int index1, int index2);

	//Hooks for SASAInterationGraph< V, E, G >
	float get_energy_PD_current_state_assignment();
	void update_internal_energy_totals();

	inline
	MinimalistNode* get_minimalist_node(int index) const
	{
		return (MinimalistNode*) get_node( index ); //c-style cast since static_cast won't compile
	}

private:

	int num_aa_types_;
	int num_commits_since_last_update_;
	float total_energy_current_state_assignment_;
	float total_energy_alternate_state_assignment_;
	int node_considering_alt_state_;

	static const int COMMIT_LIMIT_BETWEEN_UPDATES = 1024; // 2^10

	//no default constructor, uncopyable
	MinimalistInteractionGraph();
	MinimalistInteractionGraph( MinimalistInteractionGraph const & );
	MinimalistInteractionGraph & operator = ( MinimalistInteractionGraph const & );

};


}

#endif
