// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef MULTIPLE_COOLING_CYCLES_SIM_ANNEALER_H
#define MULTIPLE_COOLING_CYCLES_SIM_ANNEALER_H

#include "SimAnnealerBase.h"
#include "RotamerAssigningAnnealer.h"
#include "InteractionGraphFWD.h"

#include <ObjexxFCL/ObjexxFCL.Project.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>

class RotamerSet;

namespace pack{

extern bool use_multi_cool_annealer;

class MultiCoolAnnealer;

class MultiCoolAnnealer : public RotamerAssigningAnnealer
{
 public:
      MultiCoolAnnealer(
      std::vector<int> & rot_to_pack,
      FArray1D_int & bestrotamer_at_seqpos,
      float & bestenergy,
      bool start_with_current, // start simulation with current rotamers
      InteractionGraphBase * ig,
      const RotamerSet * p_rotamer_set,
      FArray1DB_int & current_rot_index,
      bool calc_rot_freq,
      FArray1D_float & rot_freq
      );

      MultiCoolAnnealer(
      FArray1D_int & bestrotamer_at_seqpos,
      float & bestenergy,
      bool start_with_current, // start simulation with current rotamers
      InteractionGraphBase * ig,
      const RotamerSet * p_rotamer_set,
      FArray1DB_int & current_rot_index,
      bool calc_rot_freq,
      FArray1D_float & rot_freq
      );

      virtual ~MultiCoolAnnealer();
      void run();

      //int pick_a_rotamer( int iteration_number, bool first_round);

		static void set_top_to_keep( int );

 private:

		void cool();
		void run_quench(
			FArray1D_int & state_on_node,
			FArray1D_int & best_state_on_node,
			float & best_energy,
			int num_cycles );

		void run_constant_temp_rotamer_substitutions(
			FArray1D_int & state_on_node,
			FArray1D_int & best_state_on_node,
			float & best_energy,
			int num_cycles
		);

		void store_top_energy(
			FArray1D_int const & state_on_node,
			float energy );

      InteractionGraphBase* ig_;
      MultiCoolAnnealer(const MultiCoolAnnealer& rhs);
      //std::vector<int> rot_to_pack_;

		static int top_to_keep_static;

		FArray1D_int nsteps_for_rot_;
		int nsteps_;
		int top_to_keep;
		FArray2D_int top_netstates_;
		FArray1D_float energy_top_;
		float worst_top_energy_;
		int which_netstate_worst_top_;
		int num_top_kept_;
};

}//end of namespace

#endif
