// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 08:39:36 +0200 (Sun, 18 Mar 2007) $
//  $Author: stuartm $

#ifndef INCLUDED_all_atom_type
#define INCLUDED_all_atom_type


// Rosetta Headers
#include "aaproperties_pack.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray3D.hh>

// C++ Headers
#include <cstdlib>
#include <iostream>


//Utility Headers
#include <utility/basic_sys_util.hh>

////////////////////////////////////////////////////////////////////////////////
//\BEGIN all_atom_type
//
//\BRIEF
//
//\FULL
//
//\PARAM - aa - in/out -
//\PARAM - aav - in/out -
//\PARAM - atm - in/out -
//\PARAM - fullatom - in/out -
//
//\RETURN
//
//\GLOBAL_READ
//
//\GLOBAL_WRITE
//
//\NOTES
//
//\COMMENTERS
//
//\END
////////////////////////////////////////////////////////////////////////////////
inline
int
all_atom_type(
	int const aa,
	int const aav,
	int const atm,
	bool const fullatom
)
{
	using namespace aaproperties_pack;

	if ( fullatom ) {
		return fullatom_type(atm,aa,aav);
	} else { //car these are equivalent to the values in atom_type
		if ( atm <= 2 ) {
			return atm;
		} else if ( atm == 3 ) {
			return 4;
		} else if ( atm == 4 ) {
			return 5;
		} else if ( atm == 5 ) {
			if ( aa == 6 ) {
				return 0; // gly cb
			} else {
				return 3;
			}
		} else if ( atm == 6 ) { //car equivalent to atom_type_cen
			return 5 + aa;
		} else {
			std::cerr << "ERROR:all_atom_type can not be defined !!!\n";
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
			return 0;
		}
	}
}


#endif
