// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12596 $
//  $Date: 2007-02-09 21:42:29 +0200 (Fri, 09 Feb 2007) $
//  $Author: sammond $

#ifndef INCLUDED_analyze_interface_ddg_ns
#define INCLUDED_analyze_interface_ddg_ns

#include "pose.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


//tk variables and parameters for interface mode


namespace analyze_interface_ddg_ns {


//tk max_sizes

extern int const MAX_MUT_PER_STRUCT;

extern int const MAX_CHAINNUMS;

extern int const MAX_FILENAMELENGTH;


//tk filenames

namespace int_chars {
	extern std::string mutlist;
	extern std::string intout;
}
using namespace int_chars;


//tk flags

namespace int_flags {
	extern bool ddg_bind_only; // calculate binding energy of complex only
	extern bool Wpack_only; // use packer weights for both packing and scoring
	extern bool Wint_only; // use int weights for both packing and scoring
	extern bool safety_check; // activate safety checks
	extern bool output_structure; // output all the structures during ddg calculation
	extern bool alter_spec_format; // output energy table with special format for alter_spec
	extern bool chain_energies; // output energies for each binding partner
	extern bool repack_neighbors; // allow analyze_interface to repack neighbors to each mut
	extern bool min_interface; // gradient based minimization of the interface
	extern bool ddg_per_residue;

	//flags for specifying what can move during minimization
	extern bool bb; //backbone torsion
	extern bool int_bb; //interface backbone torsion
	extern bool chi; // chi angles
	extern bool int_chi; // interface chi angles
	extern bool rb; // rigid body optimization
	extern bool use_cst;
	extern float cstW;

	extern bool relax_unbound; // repack and/or minimize unbound state
	extern bool ala_scan;//calculate delta delta binding energy for alanine scan
	extern bool pmut_scan;// point mutant scan
	extern bool output_mabo_input;//special output if ala_scan
	extern int n_partner; //number of partners	1: single protein	3: complex
	extern bool single_protein; //true if calculate the single protein chain
	extern bool ddg_decoystats;
	extern bool affin_incr; //adds filter to pmutscan and adds #neighbors to energy file

}
using namespace int_flags;

//tk oiriginal pack weights for resetting scoring functions

namespace int_weight_parameters {
	extern FArray1D_float Waa_saved;
}
using namespace int_weight_parameters;


namespace complex_orig {
	extern FArray3D_float xyz_orig;
	extern FArray1D_float phi_orig;
	extern FArray1D_float psi_orig;
	extern FArray1D_int aan_orig;
	extern FArray1D_int aav_orig;
	extern FArray1D_char residue1_orig;
	extern FArray1D_string residue3_orig;
	extern int nres_orig;
	extern FArray1D_int number_of_neighbors_orig;
}
using namespace complex_orig;


//ds original complex coordinates for chain A after relaxing interface residues

namespace chainA_orig {
	extern FArray3D_float xyz_chA;
	extern FArray1D_float phi_chA;
	extern FArray1D_float psi_chA;
	extern FArray1D_int aan_chA;
	extern FArray1D_int aav_chA;
	extern FArray1D_char residue1_chA;
	extern FArray1D_string residue3_chA;
	extern int endres_chA;
}
using namespace chainA_orig;


//ds original complex coordinates for chain B after relaxing interface residues

namespace chainB_orig {
	extern FArray3D_float xyz_chB;
	extern FArray1D_float phi_chB;
	extern FArray1D_float psi_chB;
	extern FArray1D_int aan_chB;
	extern FArray1D_int aav_chB;
	extern FArray1D_char residue1_chB;
	extern FArray1D_string residue3_chB;
	extern int endres_chB;
}
using namespace chainB_orig;

//bk save constraint sets based on the starting structure
namespace cst_set_start {
	extern cst_set_ns::Cst_set cst_complex;
	extern cst_set_ns::Cst_set cst_partner1;
	extern cst_set_ns::Cst_set cst_partner2;
}
using namespace cst_set_start;

//tk complex_definitions
namespace param_chains_data {
	extern FArray1D_char const chain_name;
}
using namespace param_chains_data;


//cmd tracking variable to monitor which domain is being scored
namespace track_complex_state {
	extern int complex_state;
}
using namespace track_complex_state;


} // namespace analyze_interface_ddg_ns


#endif
