// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 19:37:52 +0200 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_angles
#define INCLUDED_angles


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// angles Function Declarations


void
angles_get_final_stub(
	FArray1DB_float & ni,
	FArray1DB_float & ca,
	FArray1DB_float & cc
);


void
angles_get_template(
	FArray2DB_double & Bxyz2,
	FArray2DB_double & Bcentroids2
);


void
angles_get_default_stub(
	FArray1DB_double & n,
	FArray1DB_double & ca,
	FArray1DB_double & c
);


void
angles_save_final_stub(
	FArray1DB_double & n,
	FArray1DB_double & ca,
	FArray1DB_double & c
);


void
copy_coordinates(
	int begin,
	int end,
	bool fullatom,
	FArray3Da_float best_position,
	FArray3Da_float position,
	FArray2Da_float best_centroid,
	FArray2Da_float centroid,
	FArray3Da_float best_full_coord,
	FArray3Da_float full_coord
);


void
transform_coordinates(
	int begin,
	int end,
	bool fullatom,
	FArray3Da_float best_position,
	FArray3Da_float position,
	FArray2Da_float best_centroid,
	FArray2Da_float centroid,
	FArray3Da_float best_full_coord,
	FArray3Da_float full_coord,
	FArray2Da_double mat,
	FArray1Da_double off
);


void
mover2(
	FArray1DB_double const & c1,
	FArray2DB_double const & mat,
	FArray1DB_double const & vec,
	FArray1DB_double & t1
);


void
transform(
	int first,
	int last,
	FArray2Da_double mat,
	FArray1Da_double off,
	FArray2Da_float source, // note physical dim may be > last_res here
	FArray2Da_float dest // note phycical dim may be > than last_res
);


void
angles_initialize_template();


void
angles_precompute_rot(
	FArray1Da_double a1,
	FArray1Da_double a2,
	FArray2Da_double coef
);


void
angles_precompute_mat(
	double & phi,
	double & psi,
	FArray2Da_double aa,
	FArray2Da_double coef
);


void
angles_get_rot_coef(
	FArray2DB_double const & coef,
	double kappa,
	FArray2DB_double & aa
);


void
getrot(
	FArray1Da_double a1,
	FArray1Da_double a2,
	double const chi,
	FArray2Da_double mat,
	FArray1Da_double vec
);


void
Sgetrot(
	FArray1Da_float a1,
	FArray1Da_float a2,
	float const chi,
	FArray2Da_float mat,
	FArray1Da_float vec
);


void
getmat(
	double & phi,
	double & psi,
	double const kappa,
	FArray2Da_double aa
);


void
Sgetmat(
	float & phi,
	float & psi,
	float const kappa,
	FArray2Da_float aa
);


void
angles_putres(
	int restype, // residue type
	FArray1DB_double & xn,
	FArray1DB_double & xca,
	FArray1DB_double & xc,
	float omega,
	float psi,
	float phi,
	FArray2Da_float position,
	FArray1Da_float centroid
);


void
Smover(
	FArray1Da_float c1,
	FArray2Da_float mat,
	FArray1Da_float vec,
	FArray1Da_float t1
);


void
Smove_in_place(
	FArray1Da_float c1,
	FArray2Da_float mat,
	FArray1Da_float vec
);


void
Ssubmover(
	FArray1Da_float c1,
	FArray2Da_float mat,
	FArray1Da_float vec,
	FArray1Da_float t1
);


void
Stransmover(
	FArray1Da_float c1,
	FArray2Da_float mat,
	FArray1Da_float vec,
	FArray1Da_float t1
);


void
Ssubtransmover(
	FArray1Da_float c1,
	FArray2Da_float mat,
	FArray1Da_float vec,
	FArray1Da_float t1
);


void
Suntransmover(
	FArray1Da_float c1,
	FArray2Da_float mat,
	FArray1Da_float vec,
	FArray1Da_float t1
);


void
copyXYZ(
	int first,
	int last,
	FArray2Da_float source,
	FArray2Da_float dest
);


void
DcopyXYZ(
	int first,
	int last,
	FArray2Da_double source,
	FArray2Da_double dest
);


void
angles_coord_sys(
	FArray1Da_float p1,
	FArray1Da_float p2,
	FArray1Da_float p3,
	FArray2Da_float mat
);


void
Dangles_coord_sys(
	FArray1DB_double & p1,
	FArray1DB_double & p2,
	FArray1DB_double & p3,
	FArray2DB_double & mat
);


void
angles_align_transform(
	FArray1Da_float p1,
	FArray1Da_float p2,
	FArray1Da_float p3,
	FArray1Da_float q1,
	FArray1Da_float q2,
	FArray1Da_float q3,
	FArray2DB_float & Mat
);


void
Dangles_align_transform(
	FArray1Da_double p1,
	FArray1Da_double p2,
	FArray1Da_double p3,
	FArray1Da_double q1,
	FArray1Da_double q2,
	FArray1Da_double q3,
	FArray2DB_double & Mat
);


void
build_fullcoord(
	FArray3DB_float const & position, // source of bb coord
	int first,
	int last,
	FArray1DB_int const & aa, // sequence of passed coordinates
	FArray1DB_int const & aav, // amino acid variant
	FArray1DB_bool const & nterm, // Nterminus
	FArray1DB_bool const & cterm, // Cterminus
	float const phi_first,
	FArray3DB_float const & source, // source of sc coordinates
	FArray3DB_float & dest // output coordinates
);


void
put_nh(
	FArray3DB_float & xyz,
	int first,
	int last,
	FArray1DB_int const & aan, // specifies amino acid at each seqpos
	FArray1DB_int const & aa_variant,
	FArray1DB_bool const & nterm,
	FArray1DB_bool const & cterm,
	float const phi_first
);


void
put_nh_residue(
	FArray3DB_float const & xyz, // see comment below
	int const aan, // amino acid type
	int const residue,
	float const phi_first,
	FArray1DB_float & nhcoord
);


void
get_HN_coords(
	FArray1Da_float Cxyz,
	FArray1Da_float Nxyz,
	FArray1Da_float CAxyz,
	FArray1DB_float & HNxyz
);


void
place_atom_linear(
	FArray1Da_float atm1,
	FArray1Da_float atm2,
	FArray1Da_float atm_out,
	float dis
);


#endif
