// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 23432 $
//  $Date: 2008-06-24 16:25:52 +0300 (Tue, 24 Jun 2008) $
//  $Author: yab $

#include "atom_chem.h"

//Debug only headers
//#include<iostream>

namespace atom_chem{


	ElementType
	get_element_type_from_symbol(
		const std::string & chem_symbol
	){
		for( size_t i=0; i<number_element_types_;i++){
			if( chem_symbol==element_type_symbol[i]){
				return ElementType(i);
			}
		}
		return UNDEFINED_ELEMENT_TYPE;
	}



	ElementType
	get_element_type_from_atom_name(
		const std::string & atom_type
	){
			if      ( atom_type=="CNH2" ) { return CARBON;}
			else if ( atom_type=="COO " ) { return CARBON;}
			else if ( atom_type=="CH1 " ) { return CARBON;}
			else if ( atom_type=="CH2 " ) { return CARBON;}
			else if ( atom_type=="CH3 " ) { return CARBON;}
			else if ( atom_type=="aroC" ) { return CARBON;}
			else if ( atom_type==" C  " ) { return CARBON;}
			else if ( atom_type=="Ntrp" ) { return NITROGEN;}
			else if ( atom_type=="Nhis" ) { return NITROGEN;}
			else if ( atom_type=="NH2O" ) { return NITROGEN;}
			else if ( atom_type=="Nlys" ) { return NITROGEN;}
			else if ( atom_type=="Narg" ) { return NITROGEN;}
			else if ( atom_type=="Npro" ) { return NITROGEN;}
			else if ( atom_type==" N  " ) { return NITROGEN;}
			else if ( atom_type=="OH  " ) { return OXYGEN;}
			else if ( atom_type=="ONH2" ) { return OXYGEN;}
			else if ( atom_type=="OOC " ) { return OXYGEN;}
			else if ( atom_type==" O  " ) { return OXYGEN;}
			else if ( atom_type=="S   " ) { return SULFUR;}
			else if ( atom_type==" S  " ) { return SULFUR;}
			else if ( atom_type=="Nbb " ) { return NITROGEN;}
			else if ( atom_type=="CAbb" ) { return CARBON;}
			else if ( atom_type=="CObb" ) { return CARBON;}
			else if ( atom_type=="OCbb" ) { return OXYGEN;}
			else if ( atom_type=="OPha" ) { return OXYGEN;}
			else if ( atom_type=="OHha" ) { return OXYGEN;}
			else if ( atom_type=="Phos" ) { return PHOSPHORUS;}
			else if ( atom_type=="Pha " ) { return PHOSPHORUS;}
			else if ( atom_type==" P  " ) { return PHOSPHORUS;}
			else if ( atom_type=="Hpol" ) { return HYDROGEN;}
			else if ( atom_type=="Hapo" ) { return HYDROGEN;}
			else if ( atom_type=="Haro" ) { return HYDROGEN;}
			else if ( atom_type=="HNbb" ) { return HYDROGEN;}
			else if ( atom_type=="Hha " ) { return HYDROGEN;}
			else if ( atom_type=="HOH " ) { return HYDROGEN;}
			else if ( atom_type==" H  " ) { return HYDROGEN;}
			else if ( atom_type=="F   " ) { return FLUORINE;}
			else if ( atom_type==" F  " ) { return FLUORINE;}
			else if ( atom_type=="Cl  " ) { return CHLORINE;}
			else if ( atom_type==" Cl " ) { return CHLORINE;}
			else if ( atom_type=="Br  " ) { return BROMINE;}
			else if ( atom_type==" Br " ) { return BROMINE;}
			else if ( atom_type=="I   " ) { return IODINE;}
			else if ( atom_type==" I  " ) { return IODINE;}
			else if ( atom_type==" Zn " ) { return ZINC;}
			else if ( atom_type=="Zn2p" ) { return ZINC;}
			else if ( atom_type=="Fe2p" ) { return IRON;}
			else if ( atom_type=="Fe3p" ) { return IRON;}
			else if ( atom_type==" Fe " ) { return IRON;}
			else if ( atom_type=="Mg2p" ) { return MAGNESIUM;}
			else if ( atom_type==" Mg " ) { return MAGNESIUM;}
			else if ( atom_type=="Ca2p" ) { return CALCIUM;}
			else if ( atom_type==" Ca " ) { return CALCIUM;}
			else if ( atom_type=="Na1p" ) { return SODIUM;}
			else if ( atom_type==" Na " ) { return SODIUM;}
			else if ( atom_type=="K1p " ) { return POTASSIUM;}
			else if ( atom_type==" K  " ) { return POTASSIUM;}
			else if ( atom_type=="Au  " ) { return GOLD;}
			else if ( atom_type==" Au " ) { return GOLD;}
			else if ( atom_type=="Oice" ) { return OXYGEN;}
			else if ( atom_type=="Hice" ) { return HYDROGEN;}
			else if ( atom_type=="Si  " ) { return SILICON;}
			else if ( atom_type==" Si " ) { return SILICON;}
			else if ( atom_type=="Osi " ) { return OXYGEN;}
			else if ( atom_type=="OP  " ) { return OXYGEN;}
			else if ( atom_type=="OHP " ) { return OXYGEN;}
			else if ( atom_type=="HOP " ) { return HYDROGEN;}
			else if ( atom_type=="VOOC" ) { return VIRTUAL;}
                        else if ( atom_type=="VCOO" ) { return VIRTUAL;}
                        else if ( atom_type=="VOCN" ) { return VIRTUAL;}
                        else if ( atom_type=="VNOC" ) { return VIRTUAL;}
                        else if ( atom_type=="VCON" ) { return VIRTUAL;}
                        else if ( atom_type=="VSOG" ) { return VIRTUAL;}
                        else if ( atom_type=="VSCB" ) { return VIRTUAL;}
                        else if ( atom_type=="VCSG" ) { return VIRTUAL;}
                        else if ( atom_type=="VCCB" ) { return VIRTUAL;}
                        else if ( atom_type=="VRNH" ) { return VIRTUAL;}
                        else if ( atom_type=="VRNE" ) { return VIRTUAL;}
                        else if ( atom_type=="VKNZ" ) { return VIRTUAL;}
                        else if ( atom_type=="VKCE" ) { return VIRTUAL;}
                        else if ( atom_type=="VHND" ) { return VIRTUAL;}
                        else if ( atom_type=="VHNE" ) { return VIRTUAL;}
                        else if ( atom_type=="VHCB" ) { return VIRTUAL;}
                        else if ( atom_type=="VHPO" ) { return VIRTUAL;}
			else {
				
				ElementType return_e_type=UNDEFINED_ELEMENT_TYPE;
				if( atom_type.length() == 4 ){
					//This section is supposed to check the standard convention
					//of the element symbol starting of the second column of the name file
       					return_e_type=get_element_type_from_symbol( atom_type.substr(2,2) );
					if( return_e_type != atom_chem::UNDEFINED_ELEMENT_TYPE ){
						return return_e_type;
					}
					return_e_type=get_element_type_from_symbol( atom_type.substr(2,1) );
					if( return_e_type != atom_chem::UNDEFINED_ELEMENT_TYPE ){
						return return_e_type;
					}
				}
				if( atom_type.length() >=2 ){
					//need to parse out sections of the string to find the correct substring
					//containing the element designation
					
					//this for loop looks for element symbols with 2 characters
					for(size_t i=0; i<atom_type.length()-2;i++){
						std::string chem_symbol=atom_type.substr(i,2);
						return_e_type=get_element_type_from_symbol(chem_symbol);
						if( return_e_type != UNDEFINED_ELEMENT_TYPE ){
							return return_e_type;
						}
					}
					
					//this for loop looks for element symbols with 1 character
					for(size_t i=0; i<atom_type.length()-1;i++){
						std::string chem_symbol= " " + atom_type.substr(i,1);
						//std::cout << "testing for element types: " << chem_symbol << std::endl;
						return_e_type=get_element_type_from_symbol(chem_symbol);
						if( return_e_type != UNDEFINED_ELEMENT_TYPE ){
							return return_e_type;
						}
					}
				}else{
					//atom_type has length 1 or less and thus contains only characters
					//denote element type
					return_e_type=get_element_type_from_symbol(atom_type);
				}
				return return_e_type;
			}
	}


	////////////////////////////////////////////////////////////////////////////////
	/// @begin get_max_bond_length
	///
	/// @brief
	///		returns float of max bond length given two elements
	/// @detailed
	///		returns the value of 1/2 the sum of the van der Waals
	/// 	radii as reported in A. Bondi J. Phys.Chem. 1964 68(3)
	///	p.441-451
	/// @param  element1, element2 [in]
	///
	/// @global_read
	///
	/// @global_write
	///
	/// @remarks
	///
	/// @references
	///		A. Bondi J. Phys. Chem. 2964 68(3) p441-451
	/// @authors
	///		Kristian Kaufmann
	/// @last_modified 11-23-2005
	/////////////////////////////////////////////////////////////////////////////////
	float
	get_max_bond_length(
		atom_chem::ElementType element1,
		atom_chem::ElementType element2
	){
		float element1radius,element2radius;
		switch (element1){
			case HYDROGEN: {element1radius=1.20;break;}
			case HELIUM: {element1radius=1.40;break;}
			case CARBON: {element1radius=1.70;break;}
			case NITROGEN: {element1radius=1.55;break;}
			case OXYGEN: {element1radius=1.52;break;}
			case FLUORINE: {element1radius=1.47;break;}
			case NEON: {element1radius=1.54;break;}
			case SILICON: {element1radius=2.10;break;}
			case PHOSPHORUS: {element1radius=1.80;break;}
			case SULFUR: {element1radius=1.80;break;}
			case CHLORINE: {element1radius=1.75;break;}
			case ARGON: {element1radius=1.88;break;}
			case ARSENIC: {element1radius=1.85;break;}
			case SELENIUM: {element1radius=1.90;break;}
			case BROMINE: {element1radius=1.85;break;}
			case KRYPTON: {element1radius=2.02;break;}
			case TELLURIUM: {element1radius=2.06;break;}
			case IODINE: {element1radius=1.98;break;}
			case XENON: {element1radius=2.16;break;}
			default : element1radius=1.00;break;
		}
		switch (element2){
			case HYDROGEN: {element2radius=1.20;break;}
			case HELIUM: {element2radius=1.40;break;}
			case CARBON: {element2radius=1.70;break;}
			case NITROGEN: {element2radius=1.55;break;}
			case OXYGEN: {element2radius=1.52;break;}
			case FLUORINE: {element2radius=1.47;break;}
			case NEON: {element2radius=1.54;break;}
			case SILICON: {element2radius=2.10;break;}
			case PHOSPHORUS: {element2radius=1.80;break;}
			case SULFUR: {element2radius=1.80;break;}
			case CHLORINE: {element2radius=1.75;break;}
			case ARGON: {element2radius=1.88;break;}
			case ARSENIC: {element2radius=1.85;break;}
			case SELENIUM: {element2radius=1.90;break;}
			case BROMINE: {element2radius=1.85;break;}
			case KRYPTON: {element2radius=2.02;break;}
			case TELLURIUM: {element2radius=2.06;break;}
			case IODINE: {element2radius=1.98;break;}
			case XENON: {element2radius=2.16;break;}
			default : element2radius=1.00; break;
		}
		return (element1radius+element2radius)/2;
	}// function end

}
