// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 18466 $
//  $Date: 2007-11-16 23:05:47 +0200 (Fri, 16 Nov 2007) $
//  $Author: yab $

#ifndef INCLUDED_atom_chem
#define INCLUDED_atom_chem
#include<string>

namespace atom_chem {
		/// number bond types
		const size_t number_bond_types_ = 9;
		/// custom type bond type
		enum BondType {NO_BOND, SINGLE, DOUBLE, TRIPLE,
			AROMATIC, CONJUGATED, HYDROGEN_BOND,
			METALLIC_BOND, UNDEFINED_BOND_TYPE};

		/// number elements
		const size_t number_element_types_ = 113;
		/// custom type element type
		enum ElementType {UNDEFINED_ELEMENT_TYPE, HYDROGEN,
			HELIUM, LITHIUM, BERYLLIUM, BORON, CARBON,
			NITROGEN, OXYGEN, FLUORINE, NEON, SODIUM,
			MAGNESIUM, ALUMINIUM, SILICON, PHOSPHORUS,
			SULFUR, CHLORINE, ARGON, POTASSIUM, CALCIUM,
			SCANDIUM, TITANIUM, VANADIUM, CHROMIUM,
			MANGANESE, IRON, COBALT, NICKEL, COPPER, ZINC,
			GALLIUM, GERMANIUM, ARSENIC, SELENIUM, BROMINE,
			KRYPTON, RUBIDIUM, STRONTIUM, YTTRIUM, ZIRCONIUM,
			NIOBIUM, MOLYBDENUM, TECHNETIUM, RUTHENIUM,
			RHODIUM, PALLADIUM, SILVER, CADMIUM, INDIUM, TIN,
			ANTIMONY, TELLURIUM, IODINE, XENON, CAESIUM,
			BARIUM, LANTHANUM, CERIUM, PRASEODYMIUM,
			NEODYMIUM, PROMETHIUM, SAMARIUM, EUROPIUM,
			GADOLINIUM, TERBIUM, DYSPROSIUM, HOLMIUM, ERBIUM,
			THULIUM, YTTERBIUM, LUTETIUM, HAFNIUM, TANTALUM,
			TUNGSTEN, RHENIUM, OSMIUM, IRIDIUM, PLATINUM,
			GOLD, MERCURY, THALLIUM, LEAD, BISMUTH, POLONIUM,
			ASTATINE, RADON, FRANCIUM, RADIUM, ACTINIUM,
			THORIUM, PROTACTINIUM, URANIUM, NEPTUNIUM,
			PLUTONIUM, AMERICIUM, CURIUM, BERKELIUM,
			CALIFORNIUM, EINSTEINIUM, FERMIUM, MENDELEVIUM,
			NOBELIUM, LAWRENCIUM, RUTHERFORDIUM, DUBNIUM,
			SEABORGIUM, BOHRIUM, HASSIUM, MEITNERIUM,
			DARMSTADTIUM, ROENTGENIUM, VIRTUAL};


		// array of two character symbols for element types.
		const static std::string element_type_symbol[]={"Uu", " H", "He", "Li", "Be",
			" B", " C", " N", " O", " F", "Ne", "Na", "Mg", "Al",
			"Si", " P", " S", "Cl", "Ar", " K", "Ca", "Sc", "Ti",
			" V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga",
			"Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", " Y", "Zr",
			"Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In",
			"Sn", "Sb", "Te", " I", "Xe", "Cs", "Ba", "La", "Ce",
                        "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho",
                        "Er", "Tm", "Yb", "Lu", "Hf", "Ta", " W", "Re", "Os",
			"Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At",
			"Rn", "Fr", "Ra", "Ac", "Th", "Pa", " U", "Np", "Pu",
			"Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr",
			"Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Vi"};

		ElementType
		get_element_type_from_symbol(
			const std::string & chem_symbol
		);

		ElementType
		get_element_type_from_atom_name(
			const std::string & atom_type);


		const size_t number_of_ligand_atom_types_=31;

		enum LigandAtomType { UNDEFINED_ATOM_TYPE, QUATERNARY_CARBON, TERTIARY_CARBON,
                        SECONDARY_CARBON, PRIMARY_CARBON, ALKENE_CARBON,
                        ALKENE_CARBON_W_HYDROGEN, ALKYNE_CARBON, AROMATIC_CARBON,
                        AROMATIC_CARBON_W_HYDROGEN, TERTIARY_NITROGEN, SECONDARY_NITROGEN,
                        PRIMARY_NITROGEN, IMINE_NITROGEN, NITRILE_NITROGEN, NITRO_NITROGEN,
                        AROMATIC_NITROGEN, AZIDE_NITROGEN, ETHER_OXYGEN, HYDROXYL_OXYGEN,
                        KETONE_OXYGEN, TERTIARY_PHOSPHORUS, PHOSPHORUS_W_OXYGEN, THIOL_SULFUR,
                        DOUBLE_BONDED_SULFUR, DOUBLE_BONDED_SULFUR_W_ONE_OXYGEN, SULPHONIC_SULFUR,
                        FLUORINE_ATOM, CHLORINE_ATOM, BROMINE_ATOM, IODINE_ATOM };

		const static std::string ligandatomtype_string[] = {"UNDEFINED_ATOM_TYPE", "QUATERNARY_CARBON", "TERTIARY_CARBON",
			"SECONDARY_CARBON", "PRIMARY_CARBON", "ALKENE_CARBON",
			"ALKENE_CARBON_W_HYDROGEN", "ALKYNE_CARBON", "AROMATIC_CARBON",
			"AROMATIC_CARBON_W_HYDROGEN", "TERTIARY_NITROGEN", "SECONDARY_NITROGEN",
			"PRIMARY_NITROGEN", "IMINE_NITROGEN", "NITRILE_NITROGEN", "NITRO_NITROGEN",
			"AROMATIC_NITROGEN", "AZIDE_NITROGEN", "ETHER_OXYGEN", "HYDROXYL_OXYGEN",
			"KETONE_OXYGEN", "TERTIARY_PHOSPHORUS", "PHOSPHORUS_W_OXYGEN", "THIOL_SULFUR",
			"DOUBLE_BONDED_SULFUR", "DOUBLE_BONDED_SULFUR_W_ONE_OXYGEN", "SULPHONIC_SULFUR",
			"FLUORINE_ATOM", "CHLORINE_ATOM", "BROMINE_ATOM", "IODINE_ATOM"};

		inline
		LigandAtomType
		get_ligandatomtype_from_string(
			const std::string ligatmtyp_string
		){
			for( size_t i=0; i<number_of_ligand_atom_types_; i++){
				if( ligatmtyp_string==ligandatomtype_string[i]){
					return LigandAtomType(i);
				}
			}
			return UNDEFINED_ATOM_TYPE;
		}
		float
		get_max_bond_length(
			const atom_chem::ElementType element1,
			const atom_chem::ElementType element2
		);

		//! check whether an element is in a defined state
		inline bool IsValid( const atom_chem::ElementType & A) {
			return (A) == UNDEFINED_ELEMENT_TYPE ? false : true;}

		//! check whether a bond is in a defined state
		inline bool IsValid( const atom_chem::BondType & A) {
			return (A) == UNDEFINED_BOND_TYPE ? false : true;}


}


#endif
