// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 23432 $
//  $Date: 2008-06-24 16:25:52 +0300 (Tue, 24 Jun 2008) $
//  $Author: yab $

#include "atom_descriptor.h"
#include "aaproperties_pack.h"
#include "hbonds_ns.h"
#include "rotamer_descriptor.h" // just for utility atomtype_isdonorH, which should be put elsewhere.

#include <ObjexxFCL/FArray1Da.hh>

// C++ Headers
#include <ostream>

using namespace std;

atom_descriptor::atom_descriptor() : _atom_type(0)
{  _xyz[0] = _xyz[1] = _xyz[2] = 0;
	_ovect[0] = _ovect[1] =_ovect[2] = 0;
}

atom_descriptor::~atom_descriptor() {}
atom_descriptor::atom_descriptor( const atom_descriptor & rhs)
{ _atom_type = rhs._atom_type;
  _xyz[0]    = rhs._xyz[0];
  _xyz[1]    = rhs._xyz[1];
  _xyz[2]    = rhs._xyz[2];
  _ovect[0]  = rhs._ovect[0];
  _ovect[1]  = rhs._ovect[1];
  _ovect[2]  = rhs._ovect[2];
}

atom_descriptor::atom_descriptor(
	int atom_type,
	FArray1Da_float xyz,
	FArray1Da_float base_xyz,
	FArray1Da_float base2_xyz
)  :
	_atom_type(atom_type)
{
    init_atom_descriptor(atom_type, xyz, base_xyz, base2_xyz);
}

atom_descriptor::atom_descriptor (
  int atom_index,
  int aa,
  int aav,
  FArray2DB_float & rotamer_coords
) : _atom_type(aaproperties_pack::fullatom_type(atom_index, aa, aav))
{
  using namespace aaproperties_pack;
  init_atom_descriptor(_atom_type, rotamer_coords(1, atom_index),
                       rotamer_coords(1, atom_base(atom_index, aa, aav)),
                       rotamer_coords(1, abase2(atom_index, aa, aav)));
}


bool atom_descriptor::operator < (const atom_descriptor & rhs) const
{
	return _atom_type == rhs._atom_type ? (_xyz[0] == rhs._xyz[0] ? (_xyz[1] == rhs._xyz[1] ?
	   (_xyz[2] == rhs._xyz[2] ? (_ovect[0] == rhs._ovect[0] ? (_ovect[1] == rhs._ovect[1] ?
	   (_ovect[2] == rhs._ovect[2] ? false : _ovect[2] < rhs._ovect[2])
	   : _ovect[1] < rhs._ovect[1]) : _ovect[0] < rhs._ovect[0] ) : _xyz[2] < rhs._xyz[2])
	   : _xyz[1] < rhs._xyz[1]) : _xyz[0] < rhs._xyz[0] ) : _atom_type < rhs._atom_type;

}

bool atom_descriptor::operator == (const atom_descriptor & rhs) const
{  return ((_atom_type == rhs._atom_type) &&
	   (_xyz[0] == rhs._xyz[0]) && (_xyz[1] == rhs._xyz[1]) && (_xyz[2] == rhs._xyz[2]) &&
      (_ovect[0] == rhs._ovect[0]) && (_ovect[1] == rhs._ovect[1]) && (_ovect[2] == rhs._ovect[2]));
}

void
atom_descriptor::init_atom_descriptor(
                                      int atom_type,
                                      FArray1Da_float xyz,
                                      FArray1Da_float base_xyz,
                                      FArray1Da_float base2_xyz
                                      )
{
  using namespace aaproperties_pack;
  using namespace hbonds;
	//xyz.dimension(3);
  //base_xyz.dimension(3);
  //base2_xyz.dimension(3);
  _xyz[0] = xyz[0];
	_xyz[1] = xyz[1];
 	_xyz[2] = xyz[2];
  int const acc_type = HBaccchemtype(atom_type);
  if ( (acc_type == hbacc_NO) && !atomtype_isdonorH( atom_type )) { // no ovect needed

    _ovect[0] = _ovect[1] =_ovect[2] = 0;

  } else { // set up and normalize ovect for acceptors and donors

    switch (acc_type) {
    case hbacc_NO: // must be donorH -- vector to donor atom from H
      _ovect[0] = base_xyz[0] - _xyz[0];
      _ovect[1] = base_xyz[1] - _xyz[1];
      _ovect[2] = base_xyz[2] - _xyz[2];
      break;
    case hbacc_RING: //-- vector points to average of neighbors
      _ovect[0] = _xyz[0] - 0.5f * (base_xyz[0] + base2_xyz[0]) ;
      _ovect[1] = _xyz[1] - 0.5f * (base_xyz[1] + base2_xyz[1]) ;
      _ovect[2] = _xyz[2] - 0.5f * (base_xyz[2] + base2_xyz[2]) ;
      break;
    case hbacc_SP3: //-- vector points to acceptor from acceptor base2 == Hatom.
      _ovect[0] = _xyz[0] - base2_xyz[0];
      _ovect[1] = _xyz[1] - base2_xyz[1];
      _ovect[2] = _xyz[2] - base2_xyz[2];
      break;
    default: //-- assume acceptor: vector points to acceptor from acceptor base.
      assert(acc_type == hbacc_BB || acc_type == hbacc_SP2);
      _ovect[0] = _xyz[0] - base_xyz[0];
      _ovect[1] = _xyz[1] - base_xyz[1];
      _ovect[2] = _xyz[2] - base_xyz[2];
      break;
    }

    float ovectmag = sqrt(_ovect[0]*_ovect[0] +  _ovect[1]*_ovect[1] + _ovect[2]*_ovect[2]);
    assert(ovectmag > 0.1); // acceptor and base should be distinct atoms
    _ovect[0] /= ovectmag; // normalize ovect
    _ovect[1] /= ovectmag;
    _ovect[2] /= ovectmag;
  }
}


ostream & operator << (ostream & os, const atom_descriptor & ad)
{  os.precision(5);
	os << "(" << (int) ad._atom_type << ",[" << ad._xyz[0];
   os << "," << ad._xyz[1] << "," << ad._xyz[2] << "],";
   os << ")";
   return os;
}

