// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8637 $
//  $Date: 2006-06-02 02:51:57 +0300 (Fri, 02 Jun 2006) $
//  $Author: havranek $

#ifndef INCLUDED_atom_is_backbone
#define INCLUDED_atom_is_backbone


// Rosetta Headers
#include "aaproperties_pack.h"
#include "param_aa.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray2D.hh>


//------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//\BEGIN atom_is_backbone
//
//\BRIEF is this atoms a backbone atom
//
//\FULL  true if the atom number in the residue type is a backbone atom
//
//\PARAM  - atm     - in - atom number
//\PARAM  - restype - in - residue type
//\PARAM  - resvar  - in - residue variant
//
//\RETURN - true if the atom number in the residue type is a backbone atom
//
//\GLOBAL_READ
// variables from "param_aa.h"
//     aa_gly   -  glycine
// variables from "aaproperties_pack.h"
//     HNpos    -  backbone HN position
//     HApos    -  hydrogen atttached to Ca atom
//
//\GLOBAL_WRITE none
//
//\NOTES
//
//\COMMENTERS Lin Jiang  08/19/03
//
//\END
////////////////////////////////////////////////////////////////////////////////
inline
bool
atom_is_backbone(
	int atm,
	int restype,
	int resvar
)
{
//car returns true if atom number atm in residue type restype is a backbone atom
//car backbone atoms are HN,N,HA,CA,C,O

	using namespace aaproperties_pack;
	using namespace param_aa;

	if ( atm < first_scatom( restype, resvar ) ) return true;
	if ( restype == aa_gly ) return true;
	int const l = HNpos.index(restype,resvar); // HApos has same dimensions
	if ( atm == HNpos[ l ] ) return true;
	if ( atm == HApos[ l ] ) return true;
	return false;
}


#endif
