// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7212 $
//  $Date: 2006-01-04 07:49:01 -0800 (Wed, 04 Jan 2006) $
//  $Author: pbradley $

#ifndef INCLUDED_atom_tree_minimize
#define INCLUDED_atom_tree_minimize


#include "pose_fwd.h"
#include "kin_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <numeric/all.fwd.hh>


// jumping_minimize Function Declarations
typedef  float (*Scoring_Function)();


kin::Minimizer_map const &
retrieve_min_map();


void
atom_tree_minimize(
	pose_ns::Pose & pose,
	std::string const & min_type,
	std::string const & move_type,
	Scoring_Function score_fxn
);


float
calculate_torsion_constraint_deriv(
	kin::Torsion_node const & tor,
	pose_ns::Pose const & pose
);


void
numerical_derivative_check(
	kin::Minimizer_map const & min_map,
	FArray1DB_float & phipsi, // should be const!
	FArray1DB_float & dE_dphipsi, // should be const!
	int nangles
);


void
assign_rosetta_torsions(
	pose_ns::Pose const & pose,
	kin::Minimizer_map & min_map
);


void
atom_tree_dfunc_vdw(
	pose_ns::Pose & pose,
	FArray1DB_float & phipsi,
	FArray1DB_float & dE_dphipsi
);


void
pose_eval_dunbrack_deriv(
	pose_ns::Pose & pose,
	FArray2D_float & dunbrack_deriv
);


void
atom_tree_get_atompairE_deriv(
	pose_ns::Pose & pose,
	kin::Minimizer_map & min_map,
	bool const fullatom
);


void
compute_atom_gen_born_deriv(
	int const ii, // atomno
	int const i, // rsd
	float const gb_weight,
	pose_ns::Pose const & pose,
	numeric::xyzVector_float & F1, // accumulate contributions
	numeric::xyzVector_float & F2
);



void
get_atom_fa_pair_deriv(
	int const seqpos1,
	int const total_residue,
	FArray1D_int const & res,
	FArray2D_float const & actcoord,
	FArray2D_bool const & neighborlist,
	float const weight,
	numeric::xyzVector_float & F1,
	numeric::xyzVector_float & F2
);


void
atom_tree_update_nblist(
	pose_ns::Pose & pose,
	kin::Minimizer_map & min_map
);


float
atom_tree_func_vdw(
	pose_ns::Pose & pose,
	FArray1DB_float const & phipsi
);





#endif
