// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8635 $
//  $Date: 2006-06-01 15:21:58 -0700 (Thu, 01 Jun 2006) $
//  $Author: pbradley $

#ifndef INCLUDED_atom_tree_routines
#define INCLUDED_atom_tree_routines

// Rosetta Headers
#include "pose_fwd.h"
#include "kin_fwd.h"
#include "cst_set.h"

bool
get_vary_bond_geometry_no_hydrogens();

bool
get_tether_to_ideal_geometry_flag();

void
set_sidechain_bond_angle_allow_move(
	pose_ns::Pose & pose
													);

void
add_all_bond_constraints(
												 pose_ns::Pose & pose
												 );

void
add_ring_constraint(
		pose_ns::Pose & pose,
		cst_set_ns::Cst_set & cst_set,
		int const res,
		int const ring_atom1,
		int const ring_atom2,
		float const ring_tether
);

void
create_totally_new_ideal_pose( pose_ns::Pose &  ideal_pose, pose_ns::Pose & pose );


void
set_all_bond_distance_allow_move(
		pose_ns::Pose & pose
);

void
set_all_bond_distance_allow_move(
		pose_ns::Pose & pose,
		pose_ns::Pose & pose_with_desired_geometry
																 );

bool is_this_phi_psi_omega_chi(
	 pose_ns::Pose & pose,
	 int pos,
	 int atomnum );

void
set_all_bond_angle_allow_move(
	  pose_ns::Pose & pose );

void
set_all_bond_angle_allow_move(
	 pose_ns::Pose & pose,
	 pose_ns::Pose & pose_with_desired_geometry );


void
atom_tree_set_allow_move(
	 pose_ns::Pose & pose,
	 bool const allow_move_backbone,
	 bool const allow_move_sidechain,
	 bool const allow_move_jump
);


void
add_heavyatom_coordinate_constraints( pose_ns::Pose & pose );

void
add_distance_constraint_from_2_atoms(
			kin::Atom_id const & atom1,
			kin::Atom_id const & atom2,
			float const weight,
			kin::Coords_FArray_const const & coords,
			cst_set_ns::Cst_set & cst_set);

void add_angle_cst_with_theta_from_3_atoms(
			kin::Atom_id const & atom1,
			kin::Atom_id const & atom2,
			kin::Atom_id const & atom3,
			float const weight,
			kin::Coords_FArray_const const & coords,
			cst_set_ns::Cst_set & cst_set);

void add_dihedral_cst_with_dihedral_from_4_atoms(
			kin::Atom_id const & atom1,
			kin::Atom_id const & atom2,
			kin::Atom_id const & atom3,
			kin::Atom_id const & atom4,
			float const weight,
			kin::Coords_FArray_const const & coords,
			cst_set_ns::Cst_set & cst_set);

void add_disulf_pose_constraints( pose_ns::Pose & pose);

#endif
