// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14367 $
//  $Date: 2007-04-19 12:08:54 +0300 (Thu, 19 Apr 2007) $
//  $Author: yab $

#ifndef INCLUDED_barcode_stats
#define INCLUDED_barcode_stats


// Rosetta Headers
#include "barcode_stats_classes.h"
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <numeric/all.fwd.hh>

// C++ Headers
#include <map>
#include <string>


// Forward
namespace silent_io { class Silent_file_data; }


typedef std::map< std::string, std::map< int, int > > vall_hairpins_type;


void
get_barcode_stats();


void
barcode_stats_decoys(
	barcode_stats_ns::hairpin_counter & decoy_hairpin_count,
	silent_io::Silent_file_data & silent_data,
	bool const count_hairpins
);


void
barcode_stats_score_ss();


void
count_decoy_hairpins(
	barcode_stats_ns::hairpin_counter & counter
);


void
barcode_stats_fragments(
	barcode_stats_ns::hairpin_counter & frag_hairpin_count
);


void
read_vall_hairpins(
	vall_hairpins_type & vall_hairpins
);


bool
get_store_ss_scores();


void
set_store_ss_scores(
	bool const value
);


void
store_residue_pairing(
	int const dimer_pos1,
	int const dimer_pos2,
	float const dimer_score,
	int const nres
);


void
get_CA_vectors(
	FArray2D_float const & ca1, // pass by reference, so no tricks:: 3x3
	FArray2D_float const & ca2, // pass by reference, so no tricks:: 3x3
	FArray1D_float & a,
	FArray1D_float & b,
	FArray1D_float & c
);


void
get_pairing_geometry(
	int const pos1,
	int const pos2,
	float & orientation,
	float & pleating1,
	float & pleating2
);


bool
local_max(
	int const i,
	int const j,
	int const o,
	FArray2D_float const & freq
);


barcode_stats_ns::Feature_list::const_iterator
get_closest_feature(
	barcode_stats_ns::Beta_feature const & f,
	std::vector< barcode_stats_ns::Beta_feature > const & feature_list,
	int const big_threshold,
	int const small_threshold
);


void
get_decoy_features(
	barcode_stats_ns::Feature_list const & feature_list,
	FArray2D_int const & dec_pairing_count, // shadowing namespace: decoy_pairing_count
	int const big_threshold,
	int const small_threshold,
	barcode_stats_ns::Feature_list & decoy_features
);


void
identify_beta_features(
	int const total_residue,
	FArray2D_int const & pairing_count,
	int const total_decoys,
	barcode_stats_ns::Feature_list & feature_list
);


bool
Same_strand(
	int const pos1,
	int const pos2,
	FArray1D_char const & ss
);


bool
Same_strand(
	barcode_stats_ns::Feature_list const & l1,
	barcode_stats_ns::Feature_list const & l2,
	FArray1D_char const & ss
);


void
ss_analyze_silent_data(
	silent_io::Silent_file_data const & data
);


void
evaluate_sheet_packing(
	barcode_stats_ns::Beta_feature const & f1,
	barcode_stats_ns::Beta_feature const & f2,
	FArray3D_float const & Epos,
	float const MAX_DISTANCE,
	std::string const & tag
);


void
get_pairing_vectors(
	barcode_stats_ns::Beta_feature const & f,
	FArray3D_float const & Epos,
	numeric::xyzVector_float & n,
	numeric::xyzVector_float & v,
	numeric::xyzVector_float & c
);


void
main_test_interleaved();


void
find_interleaved_pairings(
	pose_ns::Pose & pose,
	std::string const & tag,
	bool const update_ss,
	bool const verbose = true
);


bool
same_side(
	int const s1_pos1,
	int const s2_pos,
	int const s1_pos2,
	int const s3_pos
);


int
get_pleating(
	int const pos1,
	int const pos2
);


void
pose_barcode_stats();


void
get_misc_pairings(
	std::vector< barcode_stats_ns::Beta_feature > & pairings
);


bool
output_topology_info();


void
update_topology_info();


std::string const &
retrieve_topology_info();


char
torsion2big_bin(
	float const phi,
	float const psi,
	float const omega
);
#endif
