// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14080 $
//  $Date: 2007-04-09 23:55:07 +0300 (Mon, 09 Apr 2007) $
//  $Author: yab $

#ifndef _BOINC_ROSETTA_UTIL_H_
#define _BOINC_ROSETTA_UTIL_H_


// Boinc Headers
#ifdef _WIN32
#include "boinc_win.h"
#endif
#include "boinc_api.h"

// C++ Headers
#include <string>

// <murphp>
#include <time.h>
// </murphp>

#define BOINC_MAX_NSTRUCT 99999  // maximum nstruct that the assimilator can handle


namespace boinc_params {
	extern double pct_complete;
	extern double cpu_time_per_nstruct;
	extern double cpu_time;
	extern int current_nstruct;
	extern int orig_number_of_output;
	extern int orig_nstartnm;
  extern int no_progress_init_cnt;
  extern std::string init_cnt_filename;
	extern bool rosetta_is_running;
	extern bool pct_complete_handled_by_watchdog;
}

namespace boinc_project_prefs {
	extern APP_INIT_DATA app_init_data;
	extern double max_fps;
	extern double max_cpu;
	extern int cpu_run_time;

	extern float default_max_fps;
	extern float default_max_cpu;
	extern int default_cpu_run_time;
}


void
resolve_filename_boinc( std::string & filename );


void
parse_boinc_project_prefs(char*);


void
default_boinc_project_prefs();


void
reread_boinc_project_prefs();

void
update_boinc_params( int & num_decoys, int & number_of_output );

bool
boinc_checkpoint_in_main_loop(int & attempted_decoys, int & num_decoys, int & number_of_output, int & farlx_stage);

void rosetta_has_started();

void rosetta_has_finished();

// <murphp>
time_t
cross_benchmark();
// </murphp>

#endif //_BOINC_ROSETTA_UTIL_H_
