// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7523 $
//  $Date: 2006-02-20 15:10:59 -0800 (Mon, 20 Feb 2006) $
//  $Author: jiangl $

//////////////////////////////////////////////
#ifndef INCLUDED_cst_countpair
#define INCLUDED_cst_countpair

// Rosetta Headers
#include "kin_atom.h"
#include "fullatom_id.h"
#include "cst_allow_move.h"
#include "cst_packer.h"
#include "cst_set.h"
#include "pose_fwd.h"

#define DEFAULT_CLASH_LJENERGY  10          //lin lj energy cutoff if covalent bond

namespace cst_countpair_ns {

  //lin single line format constraint setup for pose type minimization
	bool cst_from_file(
					std::string const & filename_in,
					pose_ns::Pose & pose,
					cst_set_ns::Cst_set & pose_cst,
					packer_cst_ns::Packer_cst_set & packer_cst,
          cst_allow_move_ns::Allow_move_set & allow_move );

	//lin additional count pair from the cst descriptor
	//lin data for count pair by giving the covalent bonds
	//{
		extern float clash_Erep_cutoff;  // lj rep energy cutoff if covalent bond
		extern bool covalent_from_cstfile; // take covalent bond from cstfile
		typedef std::pair<  kin::Fullatom_id , kin::Fullatom_id > Fullatom_pair;
		//colvalent bonding information
		extern std::vector< Fullatom_pair > covalent_bonds;
		extern std::vector< int > countpair_poslist;
		extern std::vector< std::pair<int , int> > atompair_list;
	//}

	//lin method for count pair by giving the covalent bonds
  bool is_covalent_bond(
					kin::Fullatom_id const & A,
					kin::Fullatom_id const & B,
					float const & distanceAB
					);

  void fill_cst_count_pair( ) ;
	void fill_cst_count_pair( pose_ns::Pose & pose ) ;
	void fill_cst_count_pair( Fullatom_pair const & bonds) ;
	void show_cst_count_pair( ) ;

	//lin set up internal residue minimization by KIN_1D_CST (torsion/bond/angle tether)
	void set_cst_pose_by_rsd(
		pose_ns::Pose & pose,
		cst_set_ns::Cst_set & cst_set,
		int const rsd,
		int const root_atomno,
		bool const minimize_bonds,
		bool const minimize_angles,
		bool const minimize_torsions
		);

	void
	get_pose_cst_atom_id(
    pose_ns::Pose & pose,
		int & atomno,
		int & rsd,
		kin::Atom_id & a1,
		kin::Fullatom_id & p_a1 );
}
#endif

