// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.12 $
//  $Date: 2005/08/25 21:39:29 $
//  $Author: johnk $

#ifndef INCLUDED_decoystats_interface_classes
#define INCLUDED_decoystats_interface_classes

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>

// C++ Headers
#include <iosfwd>
#include <string>


// jk Class definition for interface_energy_quantifier
class interface_energy_quantifier
{

private:

	// jk Name of quantifier, which properties to compute, arrays used to compute them
	std::string name;
	bool initialized;
	bool include_delta;
	bool include_interface_sum;
	bool include_VsPDB;
	bool include_max;
	bool include_min;
	bool include_maxVsPDB;
	bool include_minVsPDB;
	FArray1D_float * ene_res;
	FArray2D_float * ene_pair;
	FArray2D_float * ene_VsPDB;

	// jk Data describing this interface
	float delta_val;
	float interface_sum;
	float core_interface_sum;
	float interface_sum_VsPDB;
	float core_interface_sum_VsPDB;
	float interface_max;
	float core_interface_max;
	float interface_min;
	float core_interface_min;
	float interface_max_VsPDB;
	float core_interface_max_VsPDB;
	float interface_min_VsPDB;
	float core_interface_min_VsPDB;

public:

	interface_energy_quantifier() { initialized = false; return; };

	void reset();

	void reset_energies();

	void compute_energies( FArray1DB_bool & interface_res, FArray1DB_bool & core_interface_res );

	void write_to_PDB( int num_interface_res, int num_core_interface_res );

	void allow_min();

	void allow_max();

	void allow_min_VsPDB();

	void allow_max_VsPDB();

	inline void initialize( std::string const newname )
	  { initialized = true; name=newname; };

	inline bool is_initialized() { return initialized; };

	inline void allow_delta( FArray2D_float & ref_ene_pair )
	  { include_delta=true; ene_pair = &ref_ene_pair; };

	inline void allow_interface_sum( FArray1D_float & ref_ene_res )
	  { include_interface_sum=true; ene_res = &ref_ene_res; };

	inline void allow_VsPDB( FArray1D_float & ref_ene_res,
													 FArray2D_float & ref_eneVsPDB )
	  { include_VsPDB=true; ene_res = &ref_ene_res; ene_VsPDB = &ref_eneVsPDB; };

	inline bool do_delta() { return include_delta; };

	inline bool do_interface_sum() { return include_interface_sum; };

	inline bool do_VsPDB() { return include_VsPDB; };

	inline bool do_min() { return include_min; };

	inline bool do_max() { return include_max; };

	inline bool do_min_VsPDB() { return include_minVsPDB; };

	inline bool do_max_VsPDB() { return include_maxVsPDB; };

	inline float report_delta_val() { return delta_val; };

	inline float report_interface_sum() { return interface_sum; };

	inline float report_interface_sum_VsPDB() { return interface_sum_VsPDB; };

};

#endif

