// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16334 $
//  $Date: 2007-08-01 23:39:03 +0300 (Wed, 01 Aug 2007) $
//  $Author: yab $

#ifndef INCLUDED_design_structure
#define INCLUDED_design_structure


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <iosfwd>
#include <vector>

// Rosetta++ headers
#include "pose.h"

// Types
typedef  float (*Scoring_Function)();

void
design_structure();


void
design_for_loops();


void
move_tail( bool fix_helix );


void
move_backbone();

void
design_minimize_interface();

void
design_minimize_interface(
	float const start_fa_rep,
	float const	start_min_tolerance,
	float const	start_cst_weight,
	float const final_fa_rep,
	float const	final_min_tolerance,
	float const	final_cst_weight,
	int const num_iter,
	int const num_ramp,
	bool const constrain_from_initial_coords
);

void
design_and_dock_mcm();


void
dock_design_minimize_interface();


void
point_mut();


void
dg_for_complex(
	float & dG_bind,
	int & dgUns,
	float & dSASA
);

void
rdesign_setup();


void
shakenbake_backbone( bool is_seq_fixed );

void
design_flex_peptide();

void
set_feedback_potential();


void
dlogfile_output( int jk );


void
main_design_trial(
	Scoring_Function scoring_function,
	std::string const & mode
);


void
main_design_force_accept(
	Scoring_Function scoring_function,
	std::string const & mode
);


void
write_sequence( int jk );


void
get_optE();


void
fixed_backbone( std::string const & packmode );


void
get_design_pdb_name(
	int const run,
	std::string & fullname
);


void
check_design_pdb_exists(
	int run,
	bool & file_exists
);


void
create_design_pdb_file( int run );


//void
//open_design_pdb_file( int run );


void
update_design_profile(
	FArray1Da_int sequence,
	int total_residue,
	int & num
);


void
output_fasta(
	std::ostream & iunit,
	FArray1Da_int sequence,
	int & length,
	std::string & label
);


void
output_design_profile(int total_residue);


void
get_clusters(
  pose_ns::Pose & pose,
	int & nclusters,
	FArray1Da_int cluster_sizes,
	FArray2Da_int cluster_members,
	bool & make_only_one_cluster
);


void
design_interface( std::string const & packmode );


void
interface_residues();

void
get_loop_pack_residues(
	FArray1Da_bool contact_residue,
	std::string const & mode
);

void
altered_specificity();

void
mutated_clusters();

bool
get_alter_spec_flag();


void
design_from_mut_list();


void
design_from_cluster();

// void
// design_from_cluster_old();

void
identify_contacts(
	int const seqpos1,
	FArray3Da_float coord,
	FArray1Da_int sequence,
	FArray1Da_int aav,
	int const nres,
	FArray1Da_bool contacts
);

// void
// find_contact_clusters(
// 	int const seqpos1,
// 	int const n_cluster,
// 	FArray3Da_float coord,
// 	FArray1Da_int sequence,
// 	FArray1Da_int aav,
// 	int const nres,
// 	FArray1Da_bool clusters,
// 	FArray1Da_bool contacts
// );

// void
// find_seqpos_design_repack_regions(
// 	int const seqpos1,
// 	FArray3Da_float coord,
// 	FArray1Da_int sequence,
// 	FArray1Da_int aav,
// 	int const nres,
// 	FArray1Da_bool design_region,
// 	FArray1Da_bool repack_region
// 	);

void
find_repack_regions_from_design(
	FArray3Da_float coord,
	FArray1Da_int sequence,
	FArray1Da_int aav,
	int const nres,
	FArray1Da_bool design_region,
	FArray1Da_bool repack_region,
	bool & is_good_cluster
	);

void
find_cluster_from_design_regions(
	FArray3Da_float coord,
	FArray1Da_int sequence,
	FArray1Da_int aav,
	int const nres,
	int const n_cluster,
	FArray1Da_bool design_region,
	bool & is_good_cluster
	);

void
get_redesign_mutation_list(
	FArray2Da_int mutation_seqpos,
	FArray2Da_int mutation_aa,
	int & nsim,
	FArray1Da_int nmut
);


float
get_ddG_bind_mut(
	int & nmut,
	FArray1DB_int & mut_pos,
	FArray1DB_int & mut_aa
);

void
set_pmut_to_scan(
	std::vector< int > & scan_pmut
);


void
get_fixlist(
	FArray1DB_bool & fix_res
);

void
apply_dock_perturbation(
  int total_residue,
  FArray3D_float Eposition
);


void
minimize_allow_insert_trial(
	std::string const & min_type,
	bool vary_phipsi,
	bool vary_chi,
	float min_tol
);

#endif
