// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 16334 $
//  $Date: 2007-08-01 23:39:03 +0300 (Wed, 01 Aug 2007) $
//  $Author: yab $

// Rosetta headers
#include "DesignMap.h"
#include "misc.h"
#include "param.h"
#include "designmap_tools.h"

// Utility headers
#include <utility/vector1.hh>

// ObjexxFCL headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray2Da.hh>

// C++ headers
#include <cstdlib>
#include <cstdio>
#include <iostream>

void protamers_to_dm(
		     FArray1DB_bool & protamers,
		     DesignMap & design_map
		     ) {
  using namespace misc;
  for (int seqpos=1; seqpos<=total_residue; seqpos++){
    if(!protamers(seqpos))
      design_map.fix_completely(seqpos);
    else if(protamers(seqpos))
      design_map.set(seqpos,res(seqpos));
  }
}


void dm_to_protamers(
		     DesignMap & design_map,
		     FArray1DB_bool & protamers
		     ) {
  using namespace misc;
  for (int seqpos=1; seqpos<=total_residue; seqpos++){
    if(design_map.repack_residue(seqpos))
      protamers(seqpos) = true;
    else if(!design_map.repack_residue(seqpos))
      protamers(seqpos) = false;
  }
}

void protamers_to_dm(
		     FArray1DB_bool & protamers,
		     DesignMap & design_map
		     ) {
  using namespace misc;
  for (int seqpos=1; seqpos<=total_residue; seqpos++){
    if(!protamers(seqpos))
      design_map.fix_completely(seqpos);
    else if(protamers(seqpos))
      design_map.set(seqpos,res(seqpos));
  }
}


void dm_to_protamers(
		     DesignMap & design_map,
		     FArray1DB_bool & protamers
		     ) {
  using namespace misc;
  for (int seqpos=1; seqpos<=total_residue; seqpos++){
    if(design_map.repack_residue(seqpos))
      protamers(seqpos) = true;
    else if(!design_map.repack_residue(seqpos))
      protamers(seqpos) = false;
  }
}


void protamers_to_dm(
		     FArray1DB_bool & protamers,
		     DesignMap & design_map
		     ) {
  using namespace misc;
  for (int seqpos=1; seqpos<=total_residue; seqpos++){
    if(!protamers(seqpos))
      design_map.fix_completely(seqpos);
    else if(protamers(seqpos))
      design_map.set(seqpos,res(seqpos));
  }
}



void dm_to_protamers(
		     DesignMap & design_map,
		     FArray1DB_bool & protamers
		     ) {
  using namespace misc;
  for (int seqpos=1; seqpos<=total_residue; seqpos++){
    if(design_map.repack_residue(seqpos))
      protamers(seqpos) = true;
    else if(!design_map.repack_residue(seqpos))
      protamers(seqpos) = false;
  }
}


void protamers_to_dm(
		     FArray1DB_bool const & protamers,
		     DesignMap & design_map
		     ) {
  using namespace misc;
  for (int seqpos=1; seqpos<=total_residue; seqpos++){
    if(!protamers(seqpos))
      design_map.fix_completely(seqpos);
    else if(protamers(seqpos))
      design_map.set(seqpos,res(seqpos));
  }
}



void sidechain_to_dm(
		     FArray2DB_bool & sidechain,
		     DesignMap & design_map
		     ){
  using namespace misc;
  using namespace param;
  for (int seqpos=1; seqpos<=total_residue; seqpos++){
    for (int aa=1; aa<=MAX_AA(); aa++){
      if (sidechain(aa,seqpos))
	design_map.set(seqpos,aa);
      else if(!sidechain(aa,seqpos))
	design_map.disable(seqpos,aa);
    }
  }
}



void dm_to_sidechain(
		     DesignMap & design_map,
		     FArray2DB_bool & sidechain
		     ){
  using namespace misc;
  using namespace param;
  for (int seqpos=1; seqpos<=total_residue; seqpos++) {
    for (int aa=1; aa<=MAX_AA(); aa++){
      if (design_map.get(seqpos,aa))
	sidechain(aa,seqpos) = true;
      else if(!design_map.get(seqpos,aa))
	sidechain(aa,seqpos) = false;
    }
  }
}

void sidechain_to_dm(
		     FArray2DB_bool & sidechain,
		     DesignMap & design_map
		     ){
  using namespace misc;
  using namespace param;
  for (int seqpos=1; seqpos<=total_residue; seqpos++){
    for (int aa=1; aa<=MAX_AA(); aa++){
      if (sidechain(aa,seqpos))
	design_map.set(seqpos,aa);
      else if(!sidechain(aa,seqpos))
        design_map.disable(seqpos,aa);
    }
  }
}



void dm_to_sidechain(
		     DesignMap & design_map,
		     FArray2DB_bool & sidechain
		     ){
  using namespace misc;
  using namespace param;
  for (int seqpos=1; seqpos<=total_residue; seqpos++) {
    for (int aa=1; aa<=MAX_AA(); aa++){
      if (design_map.get(seqpos,aa))
	sidechain(aa,seqpos) = true;
      else if(!design_map.get(seqpos,aa))
	sidechain(aa,seqpos) = false;
    }
  }
}



void pands_to_dm(
	      FArray1DB_bool & protamers,
	      FArray2DB_bool & sidechain,
	      DesignMap & design_map
	      ){
  using namespace misc;
  using namespace param;
  for (int seqpos=1; seqpos<=total_residue; seqpos++) {
    if(!protamers(seqpos)) design_map.fix_completely(seqpos);
    else if(protamers(seqpos)){
      for (int aa=1; aa<=MAX_AA()(); aa++){
	if(sidechain(aa,seqpos))
	  design_map.set(seqpos,aa);
	else if(!sidechain(aa,seqpos))
	  design_map.disable(seqpos,aa);
      }
    }
  }
}


void dm_to_pands(
		 DesignMap & design_map,
		 FArray1DB_bool & protamers,
		 FArray2DB_bool & sidechain
		 ){
  using namespace misc;
  using namespace param;
  for (int seqpos=1; seqpos<=total_residue; seqpos++) {
    for (int aa=1; aa<=MAX_AA()(); aa++){
      if(design_map.get(seqpos,aa)) sidechain(aa,seqpos) = true;
      else if(!design_map.get(seqpos,aa)) sidechain(aa,seqpos) = false;
    }
    if(design_map.repack_residue(seqpos)){
      protamers(seqpos) = true;
    }
    else if(!design_map.repack_residue(seqpos)){
      protamers(seqpos) = false;
    }
  }
}


void pands_to_dm(
	      FArray1DB_bool & protamers,
	      FArray2DB_bool & sidechain,
	      DesignMap & design_map
	      ){
  using namespace misc;
  using namespace param;
  for (int seqpos=1; seqpos<=total_residue; seqpos++) {
    if(!protamers(seqpos)) design_map.fix_completely(seqpos);
    else if(protamers(seqpos)){
      for (int aa=1; aa<=MAX_AA()(); aa++){
	if(sidechain(aa,seqpos))
	  design_map.set(seqpos,aa);
	else if(!sidechain(aa,seqpos))
	  design_map.disable(seqpos,aa);
      }
    }
  }
}


void dm_to_pands(
		 DesignMap & design_map,
		 FArray1DB_bool & protamers,
		 FArray2DB_bool & sidechain
		 ){
  using namespace misc;
  using namespace param;
  for (int seqpos=1; seqpos<=total_residue; seqpos++) {
    for (int aa=1; aa<=MAX_AA()(); aa++){
      if(design_map.get(seqpos,aa)) sidechain(aa,seqpos) = true;
      else if(!design_map.get(seqpos,aa)) sidechain(aa,seqpos) = false;
    }
    if(design_map.repack_residue(seqpos)){
      protamers(seqpos) = true;
    }
    else if(!design_map.repack_residue(seqpos)){
      protamers(seqpos) = false;
    }
  }
}

 void pands_to_dm(
	      FArray1DB_bool & protamers,
	      FArray2DB_bool & sidechain,
	      DesignMap & design_map
	      ){
   using namespace misc;
   using namespace param;
   for (int seqpos=1; seqpos<=total_residue; seqpos++) {
     if(!protamers(seqpos)) design_map.fix_completely(seqpos);
     else if(protamers(seqpos)){
       for (int aa=1; aa<=MAX_AA()(); aa++){
	 if(sidechain(aa,seqpos))
	   design_map.set(seqpos,aa);
	 else if(!sidechain(aa,seqpos))
	   design_map.disable(seqpos,aa);
       }
     }
   }
 }


void dm_to_pands(
		 DesignMap & design_map,
		 FArray1DB_bool & protamers,
		 FArray2DB_bool & sidechain
		 ){
  using namespace misc;
  using namespace param;
  for (int seqpos=1; seqpos<=total_residue; seqpos++) {
    for (int aa=1; aa<=MAX_AA()(); aa++){
      if(design_map.get(seqpos,aa)) sidechain(aa,seqpos) = true;
      else if(!design_map.get(seqpos,aa)) sidechain(aa,seqpos) = false;
    }
    if(design_map.repack_residue(seqpos)){
      protamers(seqpos) = true;
    }
    else if(!design_map.repack_residue(seqpos)){
      protamers(seqpos) = false;
    }
  }
}

