// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12624 $
//  $Date: 2007-02-10 00:38:57 +0200 (Sat, 10 Feb 2007) $
//  $Author: yab $

#ifndef INCLUDED_dipolar
#define INCLUDED_dipolar


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <iosfwd>


// dipolar Function Declarations


bool
get_dipolar_exist();


void
dipolar_set_verbose( bool flag );


bool
dipolar_get_verbose();


void
dipolar_set_verbose_unit( std::ostream & iunit );


void
read_dipolar(
	std::string const & filename, // filename with dipolar constraints
	int const total_residue,
	FArray1DB_int & res_type,
	bool & exist
);

int
dipolartype( FArray1Da_int pairDipolar );


double
get_invDcnst( FArray1Da_int pairDipolar );


void
eval_dipolar(
	FArray3DB_float const & xyz, // coordinates for first to last residues only
	int first,
	int last,
	FArray1DB_int & res_type,
	float & score
);


void
calc_orderparam(
	FArray1Da_double x,
	FArray2Da_double vec, // eigenvectors
	double & Azz,
	double & eta
);


void
calc_dipscore(
	FArray1DB_int & res_type,
	FArray2DB_double const & A,
	FArray1Da_double x,
	FArray1DB_double const & b,
	FArray1DB_int const & map,
	int ndata,
	double Azz,
	double & score
);


void
assemble_datamatrix(
	FArray3DB_float const & xyz,
	int first,
	int last,
	int iset,
	FArray2DB_double & A,
	FArray1DB_double & b,
	int & nrow,
	FArray1DB_int & map // Jdipolar(map(i))=coupling constant of row(i)
);


void
get_atomxyz(
	FArray3DB_float const & xyz, // coordinates
	int res, // residue (ie third index of xyz)
	int atom,
	FArray1Da_float atomxyz
);


void
compute_hxyz(
	int type, // proton type 0=HN,-1=HA,-2=glyHA2
	FArray1Da_float atom1, // coordinates of atom N-term to proton-bound atom
	FArray1Da_float atom2, // coordinates of proton-bound atom
	FArray1Da_float atom3, // coordinates of atom C-term to proton-bound atom
	FArray1Da_float hxyz
);


void
calc_ordermatrix(
	int & nrow,
	FArray2DB_double const & A,
	FArray1DB_double const & b,
	FArray1Da_double x,
	bool & reject
);


void
svdcmp(
	FArray2DB_double & a,
	int m,
	int n,
	FArray1DB_double & w,
	FArray2DB_double & v
);


double
pythag(
	double a,
	double b
);


void
svbksb(
	FArray2DB_double const & u,
	FArray1DB_double const & w,
	FArray2DB_double const & v,
	int m,
	int n,
	FArray1DB_double const & b,
	FArray1DB_double & x
);


void
sortdipolar(
	int n,
	FArray2DB_int & ra,
	FArray1DB_double & rb
);


void
eval_projection(
	float & proj_score,
	FArray3Dp_float const & Eposition
);


void
translate_rdc_to_projection();


void
get_eigenvalues(
	FArray1DB_double & eigenvalues,
	int const set
);


void
get_coupling_distribution(
	int & barcount,
	double & minimum,
	double & maximum,
	FArray1DB_double & histogram,
	int const set
);


void
get_proj_ang_restriction(
	double const xax,
	double const rho,
	double const Jdipolar_A,
	double const Jdipolar_B,
	FArray1Da_float angle_restriction
);


#endif
