// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8304 $
//  $Date: 2006-05-11 00:17:43 +0300 (Thu, 11 May 2006) $
//  $Author: sraman $


// Rosetta Headers
#include "dipolar_ns.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// C++ Headers
#include <cassert>
#include <fstream>
#include <iostream>


namespace dipolar {


int const MAXDIPOLAR = { 100 };
int const MAXDIPSETS = { 2 };
int const ORDERSIZE = { 5 }; // # independent elements in ordermatrix
int const MAXDIPTYPES = { 6 }; // types for which data is precomputed in vall
 // 1:HN-N,2:HA-CA,3:CA-C,4:C(i-1)-N,5:C(i-1)-HN,HN(i)-HA(i)

float const dipolar_cutoff = { 30.0 }; // score cutoff for full atom

	// (key,index) key:1=res1,2=atom1
	//                 3=res2,4=atom2
	//                 5=set#
	// <0 for atoms whose distance is variable
	// when Ddist2 < 0 (ie variable dist) invDmax
	// is equal to the last calculated value


namespace dipolar_private {
	int Ndipolar; // number of dipolar constraints
	FArray2D_int pairDipolar( 5, MAXDIPOLAR );
	int Ndipolar_sets;
	FArray1D_double Jdipolar( MAXDIPOLAR );
	 // coupling constant of ith constraint (Hz)
	FArray1D_double invDcnst( MAXDIPOLAR ); // 1/dipolar interaction constant
	FArray1D_float Ddist( MAXDIPOLAR );
	 // dist for atom pairs whose distance is fixed
	FArray1D_double invDmax( MAXDIPOLAR );
	 // dist^3/Dcnst/dist^3 for fixed dist pairs
	std::ostream * dunit_p = { &std::cout }; // stream to dump output to

	std::ostream &
	dunit() // Function returning dump stream
	{
		assert( dunit_p != 0 );
		return *dunit_p;
	}
}


	// (res1,atom1,res2,atom2,res3,atom3,res4,atom4)
	// (angle1...angle2) and (angle3...angle4)
	// allowed ranges for the projection angle


namespace projection_private {
	Dimension Nprojection; // number of projection angles
	FArray2D_int pairProjection( 8, Nprojection );
	FArray2D_float anglProjection( 4, Nprojection );
}


namespace dipolar_public {
	bool dipolar_exist;
}


} // namespace dipolar


// private dipolar namespaces

namespace dipolar_vflag {
	bool verbose = { false };
}

namespace align_tensor {
	using namespace dipolar;
	FArray2D_double x( ORDERSIZE, MAXDIPSETS );
	FArray1D_double Azz( MAXDIPSETS );
	FArray1D_double eta( MAXDIPSETS );
	FArray3D_double paf_rot( 3, 3, MAXDIPSETS );
	FArray1D_bool reject( MAXDIPSETS );
}
