// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 19066 $
//  $Date: 2007-12-12 10:37:37 +0200 (Wed, 12 Dec 2007) $
//  $Author: yab $

#ifndef INCLUDED_dna
#define INCLUDED_dna

#include "dna_classes.h" // required for ResInfo default argument

#include <ObjexxFCL/ObjexxFCL.hh>

// forward declarations
#include "InteractionGraphFWD.h"
#include "PackerTask_fwd.h"
#include "pose_fwd.h"
#include "RotamerSetFWD.h"
#include <utility/io/all.fwd.hh>
#include <numeric/all.fwd.hh>

// C++ Headers
#include <iosfwd>
#include <list>
#include <vector>

// dna_variables namespace interface, to avoid includes
void set_design_by_base( bool const setval );
void set_dna_minimize_flag( bool const setval );
void set_enable_dna( bool const setval );
void enable_rna( bool const setval );

bool dna_enabled();
bool rna_enabled();
bool get_dna_minimize_flag();
bool get_dna_scan();

void
unclash_phosphate(
	pose_ns::Pose & pose
);

void
mutate_base(
	pose_ns::Pose & pose,
	int const pos,
	int const sub
);

void
mutate_bases(
	pose_ns::Pose & pose,
	DnaSeqInfo const & mutseq
);

float
calculate_specificity(
	std::list< NamedFloat > const & spec_map,
	std::string target_seq,
	float const ref_energy,
	float const temp = 0.6 // Boltzmann temperature
);

float
bumpcheck_phosphate(
	int const pos,
	int const na,
	pose_ns::Pose const & pose
);

bool
base_proximity(
	int const paa,
	int const daa,
	FArray2Da_float xyz1,
	FArray2Da_float xyz2,
	float const & threshold2
);

bool
argrot_base_specific_neighbor(
	int const ppos,
	int const dpos,
	pose_ns::Pose const & pose,
	float const & threshold2
);

float
rotamer_base_distance(
	int const daa,
	int const daav,
	int const raa,
	int const raav,
	FArray2Da_float dna_coord,
	FArray2Da_float rot_coord,
	float const & threshold2
);

float
z_axis_check(
	FArray1Da_float pcoord,
	int const dtype,
	FArray2Da_float dcoord
);

numeric::xyzVector<float>
base_z_axis(
	int const dtype,
	FArray2Da_float dcoord
);

float
base_specific_hbond(
	int const daa,
	int const daav,
	int const paa,
	int const paav,
	FArray2Da_float dcoord,
	FArray2Da_float pcoord
);

bool thy_vdw_contact(
	int const rot_aa,
	int const rot_aav,
	FArray2DB_float const & dna_coord,
	FArray2DB_float const & rot_coord
);

void
all_dna_combinations(
	unsigned index,
	std::vector<int> const & positions,
	DnaSeqInfo & seq,
	std::list< DnaSeqInfo > & seqs
);

void
debug_print_seqs(
	std::list< DnaSeqInfo > & seqs
);

void
restrict_dna_rotamers(
	RotamerSet const & set,
	DnaSeqInfo & seq,
	std::vector<int> & rot_to_pack
);

void
restrict_dna_rotamers(
	RotamerSet const & set,
	FArray1DB_int const & res,
	std::vector<int> & rot_to_pack
);

void
start_scan_at(
	std::string const & start_scan_seq,
	std::list< DnaSeqInfo > & seqs
);

void
ref_seq_from_resfile(
	std::vector<int> & ref_seq,
	FArray1DB_int const & res,
	int const total_residue
);

void
dna_scan_bumpcheck(
	RotamerSet & rotamer_set,
	pose_ns::Pose const & Model
);

void dna_ddG(
	utility::io::orstream & iunit,
	std::list< ResInfo > const & interface_list = std::list< ResInfo >()
);

void
output_NA_base_specific_energy(
	utility::io::orstream & iunit,
	DnaSeqInfo const & dna
);

void
NA_base_specific_energy(
	float & sol,
	float & atr,
	float & rep,
	float & hb,
  float & elec,
	DnaSeqInfo const & dna
);

void
residue_distance_check(
	int const res1,
	int const res2,
	FArray2Da_float xyz1,
	FArray2Da_float xyz2,
	bool & neighbor,
	float & dis2
);

int
sub_missing_atomtypes(
	int const atm1,
	int const aa1,
	int const aav1,
	int const pos1
);

void
output_res_list(
	std::string const tag,
	utility::io::orstream & iunit,
	std::list< std::string > & residues
);

void
dna_hbond_info(
	utility::io::orstream & iunit,
	std::list< ResInfo > const & interface_list = std::list< ResInfo >()
);

std::string
dna_bb_or_base(
	int const dna_type,
	int const dna_atom
);

std::string
dna_specificity(
	int const dna_type,
	int const dna_atom,
	int const dna_variant
);

bool
screen_exploded_rotamers_dna(
	int const ppos,
	int const paa,
	int const paav,
	FArray1DB_float const & temp_chi,
	DesignMap const & design_map
);

void
align_dna_base(
	int const mob_na,
	int const mob_v,
	FArray2Da_float mob_xyz,
	int const ref_na,
	int const ref_v,
	FArray2Da_float const ref_xyz
);

float
func_dna(
	FArray1Da_float active_angles,
	bool & gfrag
);

std::vector< std::vector<int> >
basepair_rotamers(
	RotamerSet const & set
);

std::vector<int>
set_DNA_rotamer_ratio(
	RotamerSet const & set,
	float const target_ratio
);

int
na_partner( int const na );

void
find_basepairs(
	pose_ns::Pose const & pose,
	DnaSeqInfo & basepairs,
	bool const include_unpaired = false
);

bool
is_NA_backbone_atom(
	int const atomno,
	int const aa,
	int const aav
);

void
get_y_axis_atoms(
	int const aa,
	int const strand, // 1 or 2
	int & a1,
	int & a2
);

numeric::xyzVector_float
get_y_axis(
	int const aa,
	int const strand,
	FArray2Da_float coords
);

void
init_triad_coords();

void
LoadDNAParams();

int
get_basepair_index( char const l );

int
get_basestep_index(
	std::string const & l1,
	std::string const & l2
);

void
ReadMomentsTable(
	std::string const & filename,
	FArray2D_float & table
);

void
ReadFijTable(
	std::string const & filename,
	FArray3D_float & table
);

void
ReadGijTable(
	std::string const & filename,
	FArray3D_float & table
);

#endif
