// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10024 $
//  $Date: 2006-08-28 13:54:52 -0700 (Mon, 28 Aug 2006) $
//  $Author: ashworth $

// NOTE: these methods will be deprecated as newer, simpler Pose-based DNA kinematics are developed
// currently only pose_dna.cc and dna.cc (necessarily) include this header

#ifndef INCLUDED_dna_am_min
#define INCLUDED_dna_am_min

// Rosetta Headers

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>

// C++ Headers

// forward declarations
#include "PackerTask_fwd.h"

void
map_interface_2_minimize(
	int const nres,
	FArray1Da_int aan,
	FArray3Da_float xyz,
	std::string const & prot_mode,
	std::string const & dna_mode,
	DesignMap & design_map
);

void
protdna_bump_detector(
	int const nres,
	FArray1Da_int aan,
	FArray3Da_float xyz,
	std::string const & prot_mode,
	std::string const & dna_mode
);

void
load_dihedral_angles(
	int const nres,
	FArray1Da_int aan,
	FArray3Da_float xyz
);

void
refold_dna(
	int begin_frag,
	int end_frag,
	FArray1Da_int aan,
	FArray3Da_float xyz,
	FArray3Da_float refolded_xyz
);

void
refold_prot(
	int begin_frag,
	int end_frag,
	FArray1Da_int aan,
	FArray3Da_float xyz,
	FArray3Da_float refolded_xyz
);

void
build_new_atom_dihedral(
	FArray1Da_float a1_old,
	FArray1Da_float a2_old,
	FArray1Da_float a3_old,
	FArray1Da_float a4_old,
	FArray1Da_float a1_new,
	FArray1Da_float a2_new,
	FArray1Da_float a3_new,
	FArray1Da_float a4_new, // out
	float dih_angle
);

void
build_new_atom_fixed(
	FArray1Da_float a1_old,
	FArray1Da_float a2_old,
	FArray1Da_float a3_old,
	FArray1Da_float a4_old,
	FArray1Da_float a1_new,
	FArray1Da_float a2_new,
	FArray1Da_float a3_new,
	FArray1Da_float a4_new  // out
);

void
apply_rotation(
	FArray1Da_float v,
	FArray1Da_float R,
	FArray1Da_float pos, // out
	double theta
);

void
get_basestep_prms(
	FArray2Da_float base1, int ind1, int aa1, // base1 & base2 = base-pair
	FArray2Da_float base2, int ind2, int aa2,
	FArray2Da_float base3, int ind3, int aa3, // base3 & base4 = base-pair
	FArray2Da_float base4, int ind4, int aa4,
	FArray1Da_float params // out
);

void
get_basepair_prms(
	FArray2Da_float base1, int aa1, int ind1, // base1 & base2 = base-pair
	FArray2Da_float base2, int aa2, int ind2,
	FArray1Da_float params
);

void
load_basestep_prms(
	FArray1Da_int aan,
	FArray3Da_float xyz,
	int const begin,
	int const end
);

void
load_basepair_prms(
	FArray1D_int const & aan,
	FArray3D_float const & xyz,
	int const begin,
	int const end
);

void
find_dna_chains(
	int const nres,
	FArray1D_int const & aan,
	FArray3D_float const & xyz
);

void
find_dna_chains_seq(
	int const nres,
	FArray1D_int const & aan,
	FArray3D_float const & xyz,
	float const bp_cutoff
);

void
find_dna_chains_local(
	FArray1Da_int aan,
	FArray3Da_float xyz,
	float const bp_cutoff
);

int
CountDnaDomains(
	FArray1Da_int aan,
	FArray3Da_float xyz
);

void
set_chain_dir(
	int const nres,
	FArray3D_float const & xyz
);

void
find_basesteps(
	int const nres,
	FArray1D_int const & aan,
	FArray3D_float const & xyz,
	float const bs_cutoff
);

void
print_basesteps(
	int const nres,
	FArray1D_int const & aan
);

void
superimpose_bases(
	FArray2Da_float exp_base,   // in
	FArray2Da_float ideal_base, // in
	FArray2Da_float ideal_base_superimposed // out
);

void
lsf_plane_normal(
	FArray2Da_float base1,
	FArray2Da_float base2,
	int ind1,
	int ind2,
	int const natoms2fit,
	FArray1Da_float normal_i,
	FArray1Da_float normal_f
);

void
lsf_plane_normal(
	FArray2Da_float base,
	int ind,
	int const natoms2fit,
	FArray1Da_float normal_i,
	FArray1Da_float normal_f
);

void
test_lsf_plane_normal();

void
build_triad(
	FArray2Da_float base, // xyz coords of the base
	int aa,
	int res,
	int strand,
	FArray2Da_float M
);

void
build_bp_triad(
	FArray2Da_float base1, // xyz coords of base 1
	FArray2Da_float base2, // xyz coords of base 2
	int aa1,
	int aa2,
	int res1,
	int res2,
	FArray2Da_float M
);

void
test_refold(
	int const begin,
	int const end,
	FArray1Da_int aan,
	FArray3Da_float xyz,
	FArray3Da_float refolded_xyz
);

void
test_build_new_atom_dihedral();

void
init_dna_scores(
	int const nres,
	FArray1D_int const & aan,
	FArray3D_float const & xyz
);

float
score_dna_bs(
	FArray1D_int const & aan,
	int const begin,
	int const end
);

float
score_dna_bp(
	FArray1D_int const & aan,
	int const begin,
	int const end
);

void
minimize_dna_interface();

int
count_angles();

void
pack_angles(
	FArray1Da_float active_angles,
	int & nangles
);

void unpack_angles(
	FArray1Da_float active_angles,
	int const nangles
);

void
reset_clusters(
	FArray1Da_bool changed_angles,
	int const nangles
);

void
rebuild_coords();

void
map_clusters( bool init_run );

float
compute_energy();

float
dna_geom_energy();

void
print_dihedral(
	std::string const & mode,
	int const begin,
	int const end
);

#endif
