// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 16334 $
//  $Date: 2007-08-01 23:39:03 +0300 (Wed, 01 Aug 2007) $
//  $Author: yab $


// Header for dna-protein motif design

#ifndef INCLUDED_dna_motifs
#define INCLUDED_dna_motifs


// Rosetta Headers
#include "dna_motifs_ns.h"
#include "pose_constraints.h"
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <vector>


void ReadDNARegionsFile( std::string regions_file,
	DNA_Motifs::RegionPair &SearchInfo,
	std::vector< DNA_Motifs::RegionPair > &OmitPairVector,
	std::vector< DNA_Motifs::RegionPair > &DesignBaseVector,
	std::vector< int > &shave_positions );

///jjh Build and return a library of Inverse rotamers which make DNA motifs
DNA_Motifs::DNAMotifRotamerLibrary GetDNAMotifRotamerLibrary(
	DNA_Motifs::RegionPair &SearchInfo,
	DNA_Motifs::RegionPairLibrary &OmitPairVector,
	DNA_Motifs::RegionPairLibrary &DesignBaseVector,
	pose_ns::Pose const & pose );



void dna_motifs_setup_template_pack(
	pose_ns::Pose const & pose
);


void dna_motifs_place_rotamers(
	pose_ns::Pose const & pose,
	int pos,
	DNA_Motifs::RegionPair & search_region,
	std::vector< JJH_Rotamer > & rotamer_vector,
	DNA_Motifs::Motif * motif_ptr
);


void MoveRegionAwayFromPoint(
	DNA_Motifs::RegionPair & move_region,
	FArray1Da_float rigid_com,
	FArray3Da_float full_coord,
	FArray1Da_int res,
	FArray1Da_int res_variant
);


void MoveRegionRandomRigid(
	DNA_Motifs::RegionPair & move_region,
	FArray3Da_float full_coord,
	FArray1Da_int res,
	FArray1Da_int res_variant
);


int CountInverseRotamers(
	float rmsd_cutoff,
	FArray3Da_float xyz,
	DNA_Motifs::RegionPair & search_region,
	std::vector< JJH_Rotamer > & rot_vector
);


int FillInverseRotamers(
	FArray3Da_float xyz,
	FArray1Da_int res,
	FArray1Da_int res_variant,
	std::vector< JJH_Rotamer > & rot_vector
);


int CheckInverseRotamers(
	FArray3Da_float xyz,
	FArray1Da_int res,
	FArray1Da_int res_variant,
	std::vector< JJH_Rotamer > & rot_vector
);

int
find_inv_rot_overlaps(
	DNA_Motifs::DNAMotifRotamerLibrary & inv_rot_lib,
	DNA_Motifs::RegionPair & loop_region
);

void
mutate_vector_to_aa(
	pose_ns::Pose & pose,
	std::vector<int> & positions,
	int aa_code
);

void
store_loop_region_coords(
	DNA_Motifs::RegionPair & loop_region,
	FArray3Da_float stored_coords
);

void
recover_loop_region_coords(
	DNA_Motifs::RegionPair & loop_region,
	FArray3Da_float stored_coords
);

void
mutate_region_to_aa(
	pose_ns::Pose & pose,
	DNA_Motifs::RegionPair & loop_region,
	int aa_code,
	std::vector<int> &keep_the_same
);

bool do_bb_atoms_overlap(
	FArray2Da_float xyz1,
	int aa1,
	FArray2Da_float xyz2,
	int aa2,
	float & rmsd
);

void
score_dna_motif_inv_rotamers(
	DNA_Motifs::DNAMotifRotamerLibrary & inv_rot_lib,
	DNA_Motifs::RegionPairLibrary & target_regions
);

void
find_closest_to_dna_motif_inv_rotamers(
	pose_ns::Pose & pose,
	DNA_Motifs::DNAMotifRotamerLibrary & inv_rot_lib,
	DNA_Motifs::RegionPair & target_regions
);

void
res_bump_check(
	int & aa,
	int & aav,
	int & res,
	FArray2Da_float coord,
	FArray3Da_float xyz,
	FArray1Da_int aan,
	FArray1Da_int aa_variant,
	FArray1Da_bool omit_res,
	int & nres,
	float & bumpenergy
);

void
align_rotamer(
	pose_ns::Pose & pose,
	int const seqpos,
	int const aa,
	int const aav,
	FArray2Da_float coord
);

void
reset_dna_match_info();

void
set_dna_match_library( DNA_Motifs::DNAMotifRotamerLibrary * inv_rot_lib );

void
add_dna_match_region( DNA_Motifs::RegionPair & loop_region );

float
get_dna_match_score();

float
get_motif_tether_score();

void
clear_motif_set();

void
add_motif_to_set(
	int motif_id,
	int res_num,
	FArray2Da_float coord
);

bool
cond_fetch_motif_set_coords(
	int res_id,
	FArray1Da_int atoms,
	FArray2Da_float coord
);

void
FetchAtomsByMotif(
  int m_id,
  int & atm1,
  int & atm2,
  int & atm3
);

void
set_motif_sidechain_cst(
	cst_set_ns::Cst_set & cst_set,
	JJH_Rotamer & inv_rot,
	int bb_pos
);

int
set_vector_motif_sidechain_cst(
	cst_set_ns::Cst_set & cst_set,
	std::vector< JJH_Rotamer > & inv_rot_lib,
	FArray1Da_int  bb_pos_array,
	int nres
);


#endif
