// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 16334 $
//  $Date: 2007-08-01 23:39:03 +0300 (Wed, 01 Aug 2007) $
//  $Author: yab $


// Structure definitions and global declarations for
// dna-protein motif design

#ifndef INCLUDED_dna_motifs_ns
#define INCLUDED_dna_motifs_ns


// Rosetta Headers
#include "Rotamer.h"
#include "param_aa.h"
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2Da.hh>
#include <ObjexxFCL/FArray3Da.hh>

// C++ Headers
#include <fstream>
#include <string>
#include <vector>


int na_from_str( std::string str_in );
void Matrix_From_Euler_angles( FArray1Da_float, FArray2Da_float );
void Rotate_Angle_About_Axis( int, float, FArray1Da_float, FArray2Da_float );


// Class for rotamer info
class JJH_Rotamer : public Rotamer {

 public:

  int motif_id;
  int motif_pos;
  int base_pos;
  int base_pos2;
  float energy;
  float rmsd;
  bool found;

  JJH_Rotamer();

  // allow copy constructor from Rotamer
  JJH_Rotamer(const Rotamer& b);

  inline void set_seqpos(int const newval) { seqpos_ = newval; return; };
};

namespace DNA_Motifs {

	extern float Motifs_close_enough;
	extern float Motifs_far_dist;
	extern float Motifs_bump_value;
	extern float motifs_match_weight;
	extern int Motifs_num_rots_required;

	extern int para_total;
	extern int para_me;

	class HelixDM {
	public:
		FArray2D_float matrix;
		int offset;
		HelixDM();
		bool close_enough( FArray2Da_float this_dm );
		float worst_miss( FArray2Da_float this_dm );
	};

	struct RigidBodyMove {
		float transx;
		float transy;
		float transz;
		float angle1;
		float angle2;
		float angle3;
	};

// Base class for motifs
	class Motif {

	protected:
		int _aa_type;

		FArray1D_float trans;
		FArray1D_float euler;
		FArray2D_float rotate;

	public:
		int aa_atm1, aa_atm2, aa_atm3;
		int id;
		Motif();
		Motif( int aa, int a1, int a2, int a3,
						float tx, float ty, float tz,
						float theta, float psi, float phi );
		inline int aa_type() { return _aa_type; };
		virtual ~Motif() {};
		virtual bool ApplyMotif( pose_ns::Pose const & pose, int aa, int pos ) = 0;
		virtual void PlaceRotamer( pose_ns::Pose const & pose, int aa, int aav,
			int pos, FArray2Da_float aa_coords, FArray2Da_float act_coords,
			int & pos2 ) = 0;
		void GenericPlaceRotamer( int aa, int aav, FArray1Da_float ref1,
			FArray1Da_float ref2, FArray1Da_float ref3, FArray2Da_float aa_coords,
			FArray2Da_float act_coords );

	};

// Single base motifs

	class SingleMotif : public Motif {

	private:
		int na_type;
		int na_atm1, na_atm2, na_atm3;

	public:
		SingleMotif( int na, int n1, int n2, int n3,
									int aa, int a1, int a2, int a3,
									float tx, float ty, float tz,
									float theta, float psi, float phi );
		SingleMotif( std::ifstream & file_input );
		~SingleMotif() {};
		bool ApplyMotif( pose_ns::Pose const &, int na, int )
								{return ( na == na_type ? true : false  ); };
		void PlaceRotamer( pose_ns::Pose const & pose, int aa, int aav, int pos,
			FArray2Da_float aa_coords, FArray2Da_float act_coords, int & pos2 );

	};

	class DoubleMotif : public Motif {

	protected:
		int na_type1;
		int na_atm1;
		int na_type2;
		int na_atm2, na_atm3;

	public:
		DoubleMotif( int na1, int n1,
									int na2, int n2, int n3,
									int aa, int a1, int a2, int a3,
									float tx, float ty, float tz,
									float theta, float psi, float phi );
		DoubleMotif( std::ifstream & file_input );
		~DoubleMotif() {};
		virtual bool ApplyMotif( pose_ns::Pose const & pose, int na, int pos ) = 0;
		virtual void PlaceRotamer( pose_ns::Pose const & pose, int aa, int aav,
			int pos, FArray2Da_float aa_coords, FArray2Da_float act_coords,
			int & pos2 ) = 0;

	};

	class StackedMotif : public DoubleMotif {

	public:
		StackedMotif( int na1, int n1,
									int na2, int n2, int n3,
									int aa, int a1, int a2, int a3,
									float tx, float ty, float tz,
									float theta, float psi, float phi );
		StackedMotif( std::ifstream & file_input );
		~StackedMotif() {};
		bool ApplyMotif( pose_ns::Pose const & pose, int na, int pos );
		void PlaceRotamer( pose_ns::Pose const & pose, int aa, int aav,
			int pos, FArray2Da_float aa_coords, FArray2Da_float act_coords,
			int & pos2 );

	};

	class DiagonalMotif : public DoubleMotif {

	public:
		DiagonalMotif( int na1, int n1,
									int na2, int n2, int n3,
									int aa, int a1, int a2, int a3,
									float tx, float ty, float tz,
									float theta, float psi, float phi );
		DiagonalMotif( std::ifstream & file_input );
		~DiagonalMotif() {};
		bool ApplyMotif( pose_ns::Pose const & pose, int na, int pos );
		void PlaceRotamer( pose_ns::Pose const & pose, int aa, int aav,
			int pos, FArray2Da_float aa_coords, FArray2Da_float act_coords,
			int & pos2 );

	};

// Region pair definition
	class RegionPair{
	private:
		int _start, _end;
	public:
		RegionPair( int s = 0 , int e = 0 ) : _start( s ), _end( e ) {};
		RegionPair( std::ifstream & file_input ) { file_input >> _start; file_input >> _end; };
		inline int start() { return _start; };
		inline int end() { return _end; };
		inline void set_start( int const inval ) { _start = inval; };
		inline void set_end( int const inval ) { _end = inval; };
		inline int size() { return (_end - _start + 1); };
		inline bool in_check( int pos ) {
			return ( ( pos >= _start && pos <= _end ) ? true : false );
		};
	};

	extern RegionPair SearchRegion;

	typedef std::vector< DNA_Motifs::RegionPair > RegionPairLibrary;
	typedef std::vector< JJH_Rotamer > DNAMotifRotamerLibrary;


// Motif tethering widget
	class MotifTether{
	public:
		MotifTether();
		int res_num;
		FArray1D_int atom_num;
		FArray2D_float coords;
	};

	typedef std::vector< DNA_Motifs::MotifTether > MotifTetherLibrary;
	extern MotifTetherLibrary motif_set;

	namespace dna_match_namespace {
		extern DNAMotifRotamerLibrary * dna_match_library;
		extern RegionPairLibrary dna_match_regions;
		extern int num_matches;
	}
	using namespace dna_match_namespace;

}


#endif
