// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7412 $
//  $Date: 2006-02-06 18:27:25 -0500 (Mon, 06 Feb 2006) $
//  $Author: aroop $
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/...
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   rosetta++/dle_ns.cc
///
/// @brief  Namespace that handles all options, global variables for the files
///         dle.cc & antibody_modeling.cc. The global variable
///         is designed to hold upto five loop ensembles. The loop_begin &
///         loop_end information is also stored in the global arrays specified.
/// @author Aroop Sircar (aroop@jhu.edu)

// Rosetta Headers
#include "fragment_class.h"
#include "pose.h"
#include "dock_loop_ensemble_ns.h"

// ObjexxFCL Headers

// Numeric Headers

// C++ Headers

/////////////////////////////////////////////////////////////////////////////

namespace dle_ns {
	std::vector< Fragment > dock_loop[DOCK_MAX_LOOPS];
	int dock_flex_total_loops(0);
	int dock_flex_loop_begin[DOCK_MAX_LOOPS];
	int dock_flex_loop_end[DOCK_MAX_LOOPS];
	pose_ns::Loops dle_loops;
	bool dle_calc_rmsg_flag(false);
	char light_chain = 'L'; // default light chain identifier
	// only refinement of loops in loop lib
	bool dle_refine(false);
	bool dle_build(false); // only build loops
	bool dle_cluster(false); // only cluster loops
	// fold tree with 2 cutpoints for H3 & dock rg-body jump
	bool simultaneous_minimization(false);
	// insert one loop at a time and do a local refine
	bool insert_all_loops_with_local_refine(false);
	// do not enforce any filters while outputing decoy
	bool output_with_no_filters(false);
	std::string pdb_filename; // four letter pdb filename
	bool repack_loop_neighbors(true); // repack neighbors of loop
	bool fullatom_loop_relax(false); // loop relax with small/shear moves
	std::string loop_def_filename; // file containing loop definition
	bool dle_cter_flag(false); // cter flexibility in dock
	int cter_modeling_size(0); // length of c-terminal to be modeled
	bool dle_model_H3(false); //H3 modelling in dle
	/// @brief actually enables H3 filter for H3 operations
	bool dle_H3_filter( false );
	/// @brief flag to switch on frags of
	///        loop length only
	bool loop_frags(false);
	/// @brief frag offset for frag file
	int loop_frag_offset(0);
	/// @brief do not idealize any bonds
	bool freeze_bonds( false );
	/// @brief cutpoint whose separation is computed in scorefile
	int decoy_loop_cutpoint(0);
	/// @brief just refine input loop
	bool refine_input_loop( false );
	/// @brief pose with starting sidechains
	pose_ns::Pose starting_sidechain_pose;
	/// @brief enable filter for decoys
	bool decoy_filter( false );
	/// @brief idealization of modeled regions
	///        in native structures for comparison
	bool idealize_native( false );
	/// @brief refine loops more than default
	bool refine_more( false );
}

namespace fv_loop_insert_ns {
	int fv_loop_insert_begin(0);
	int fv_loop_insert_end(0);
}


namespace antibody_ns {
	bool antibody_build(false); // build H3 only
	bool antibody_refine(false); // refine H3 only
	bool antibody_cluster(false); // cluster H3 only
	bool H3_base_mode(false); // only calculate H3 base dihedrals
	std::vector< Fragment > H3_base_library; // H3 base dihedrals
	std::vector< Fragment > H3_nter_library; // H3 nter dihedrals
	bool graft_l1(false); // graft in l1 from default file l1.pdb
	bool graft_l2(false); // graft in l2 from default file l2.pdb
	bool graft_l3(false); // graft in l3 from default file l3.pdb
	bool graft_h1(false); // graft in h1 from default file h1.pdb
	bool graft_h2(false); // graft in h2 from default file h2.pdb
	/// @brief graft in h3 from default file h3.pdb
	bool graft_h3(false);
	bool model_h3(false); // model h3 loop from fragments
	// file from which to copy stem coords for light loop
	std::string unaligned_framework_light_monomer_filename;
	// file from which to copy stem coords for heavy loop
	std::string unaligned_framework_heavy_monomer_filename;
	bool fv_linker_mode(false); // Flag to turn on mode for builing Fv linker
	/// @brief enable use of nter frags
	bool use_nter_frags(false);
	/// @brief do not use cter frags
	bool dont_use_cter_frags(false);
	/// @brief Number of ADDITIONAL residues modeled from H3_NTERM
	///        These residues normally range from H:92-95
	///        not const because it can be set to zero by command
	///        line option -nter
	int nter(3);
	/// @brief Number of ADDITIONAL residues modeled from H3_CTERM
	///        These residues range from H:n-2,n-1,n,n+1 of H3
	int base(1);
	/// @brief flag to trigger loading of native and computation
  ///        of H3 rmsg from native
	bool use_native(false);
	/// @brief Number of flanking cdr residues to graft in template
	int deep_graft(0);
	/// @brief Fragment sizes of H3 nter fragment files
	// not const because it can be set to zero by command
  // line option -nter
	int h3_nter_frag_size(4);
	/// @brief Fragment sizes of H3 base fragment files
	int h3_base_frag_size(4);
	/// @brief switch to fast_ccd based loop closure instead of
  ///        default ccd_moves
	bool fast_ccd(false);
	/// @brief use random cutpoints for h3 modeling
	bool h3_random_cut(false);
	/// @brief lower amplitude during base relaxation
	bool min_base_relax(false);
	/// @brief bias use of antibody fragments
	bool bias_frags(false);
	/// @brief bias weight of antibody fragments
	float bias_fraction(0.00);
	/// @brief enforces strand ss in base
	bool enforce_base_strand(false);
	/// @brief select base based on kink/extended match only
	bool select_all_kink_match(false);
	/// @brief Storing cdrs in Chu's new loop class
	pose_ns::Loops all_cdrs;
	/// @brief Pose with loops grafted in
	pose_ns::Pose grafted_pose;
	/// @brief check to see if cdrs already grafted in or not
	bool already_grafted(false);
	/// @brief unaligned framework heavy monomer
	///        in absence of nter flag is used to read
	///        psi-omega angles of begin-1 residues
	pose_ns::Pose unaligned_framework_heavy_monomer;
	/// @brief unaligned framework light monomer
	///        in absence of nter flag is used to read
	///        psi-omega angles of begin-1 residues
	pose_ns::Pose unaligned_framework_light_monomer;
	/// @brief sequential numbering of h3 begin
  ///        in unaligned heavy chain monomer
	int unaligned_h3_loop_begin(0);
	/// @brief sequential numbering of h3 end
  ///        in unaligned heavy chain monomer
	int unaligned_h3_loop_end(0);
	/// @brief graft cdr by superimposing stems of cdr
	bool superimpose_cdr(false);
	/// @brief insert all h3's from library
	///        just repack, nothing else
	bool antibody_insert_all_h3(false);
	/// @brief stores library of putative h3 conformations
	std::vector< Fragment > h3_library;
	/// @brief flag to prevent extensive repacking
	bool norepack_antibody(false);
	/// @brief force hbond computation
	bool compute_hbond(false);
	/// @brief enable docking local refine of L-H chains & simultaneous H3 min
	bool snug_fit( false );
	/// @brief relax all cdrs after CDR-H3 modeling
	bool relax_cdrs( false );
	/// @brief relax all cdrs while docking
	bool relax_dock( false );
	/// @brief freeze h3 during all cdr relax and local refine
	bool freeze_h3( false );
	/// @brief relax flanking regions of h3
	bool flank_relax( false );
	/// @brief number of flanking residues:default 5
	int h3_flank( 2 );
	/// @brief sequential residue number of end of light chain
	int L_end( 0 );
	/// @brief enable cdr minimization during snugdock
	bool snugloop( false );
	/// @brief relax h3 during snugdock
	bool snugh3( false );
	/// @brief load native for snugdock calculations
	bool snugnative( false );
	/// @brief populate both VL-VH & Ab-Ag interfaces in intrf list
	bool LH_AbAg_interface( false );
}

// Namespace specific for grafting cdrs in antibody modeling mode
namespace cdr_ns {
	/// @brief pdb containing CDR-L1 to be grafted in
	pose_ns::Pose cdr_l1;
	/// @brief pdb containing CDR-L2 to be grafted in
	pose_ns::Pose cdr_l2;
	/// @brief pdb containing CDR-L3 to be grafted in
	pose_ns::Pose cdr_l3;
	/// @brief pdb containing CDR-H1 to be grafted in
	pose_ns::Pose cdr_h1;
	/// @brief pdb containing CDR-H2 to be grafted in
	pose_ns::Pose cdr_h2;
	/// @brief Sequential Residue Number of CDR-L1 begin
	int cdr_l1_begin(0);
	/// @brief Sequential Residue Number of CDR-L1 end
	int cdr_l1_end(0);
	/// @brief Sequential Residue Number of CDR-L2 begin
	int cdr_l2_begin(0);
	/// @brief Sequential Residue Number of CDR-L2 end
	int cdr_l2_end(0);
	/// @brief Sequential Residue Number of CDR-L3 begin
	int cdr_l3_begin(0);
	/// @brief Sequential Residue Number of CDR-L3 end
	int cdr_l3_end(0);
	/// @brief Sequential Residue Number of CDR-H1 begin
	int cdr_h1_begin(0);
	/// @brief Sequential Residue Number of CDR-H1 end
	int cdr_h1_end(0);
	/// @brief Sequential Residue Number of CDR-H2 begin
	int cdr_h2_begin(0);
	/// @brief Sequential Residue Number of CDR-H2 end
	int cdr_h2_end(0);
	/// @brief Sequential Residue Number of CDR-H3 begin
	int cdr_h3_begin(0);
	/// @brief Sequential Residue Number of CDR-H3 end
	int cdr_h3_end(0);
}

// Namespace to store native information
// used mainly for protocol testing
namespace native_cdr {
	/// @brief native antibody filename
	std::string native_pdb_filename;
	/// @brief native antibody fv
	pose_ns::Pose native_fv;
	/// @brief Sequential Residue Number of end of light
  ///        chain in native antibody fv
	int native_chain_L_end(0);
	/// @brief Sequential Residue Number of CDR-L1 begin
  ///        in native antibofy fv
	int native_l1_begin(0);
	/// @brief Sequential Residue Number of CDR-L1 end
	///        in native antibody fv
	int native_l1_end(0);
	/// @brief Sequential Residue Number of CDR-L2 begin
  ///        in native antibofy fv
	int native_l2_begin(0);
	/// @brief Sequential Residue Number of CDR-L2 end
	///        in native antibody fv
	int native_l2_end(0);
	/// @brief Sequential Residue Number of CDR-L3 begin
  ///        in native antibofy fv
	int native_l3_begin(0);
	/// @brief Sequential Residue Number of CDR-L3 end
	///        in native antibody fv
	int native_l3_end(0);
	/// @brief Sequential Residue Number of CDR-H1 begin
  ///        in native antibofy fv
	int native_h1_begin(0);
	/// @brief Sequential Residue Number of CDR-H1 end
	///        in native antibody fv
	int native_h1_end(0);
	/// @brief Sequential Residue Number of CDR-H2 begin
  ///        in native antibofy fv
	int native_h2_begin(0);
	/// @brief Sequential Residue Number of CDR-H2 end
	///        in native antibody fv
	int native_h2_end(0);
	/// @brief Sequential Residue Number of CDR-H3 begin
  ///        in native antibofy fv
	int native_h3_begin(0);
	/// @brief Sequential Residue Number of CDR-H3 end
	///        in native antibody fv
	int native_h3_end(0);
	/// @brief Start positions of framework region in
	///        light chain
	int L_framework_begin[7];
	/// @brief End positions of framework region in
	///        light chain
	int L_framework_end[7];
	/// @brief Start positions of framework region in
	///        heavy chain
	int H_framework_begin[6];
	/// @brief End positions of framework region in
	///        heavy chain
	int H_framework_end[6];
}

void
dle_ns_main()
{
	return;
}
