// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 19:37:52 +0200 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_dock_pivot
#define INCLUDED_dock_pivot


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// Types
typedef  float (*Scoring_Function)();


// dock_pivot Function Declarations


bool
get_dock_pivot_flag();


void
adjust_pivot_MC_step(
	float & pivot_magnitude,
	float const pivot_success_rate
);


void
perform_pivot_MC(
	Scoring_Function scorefxn,
	int const cycle_number,
	bool const repack_flag,
	float const pivot_magnitude,
	int & pivot_accepts
);


void
main_pivot_residue_trial(
	Scoring_Function scoring_function, // which score to use
	int const cycle_number, // for labelling output
	bool const repack_flag, // repack sidechains after the move?
	float const pivot_magnitude // magnitude of phi-psi pivot
);


void
initialize_pivot_residues();


void
load_pivot_residue_file( bool & isSuccess );


void
validate_pivot_residues( bool & isSuccess );


void
show_pivot_pert();


float
dist(
	int const mres,
	int const natom
);


void
copy_fullcoord_to_position(
	FArray3Da_float position,
	FArray3Da_float fullcoord,
	int const maxatom,
	int const nres
);


void
torsion_from_fullcoord(
	int const maxatom,
	int const mres,
	FArray3Da_float coord,
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_float omega
);


void
pivot_refold( int & pivot_residue );


void
pivot_refold_coordinates(
	int const refold_dir, // refold direction
	int const pivot_residue, // residue which torsion angles change
	int const seg_begin,
	int const seg_end,
	bool const fullatom, // should full_coord be updated?
	FArray1Da_int res, // sequence
	FArray3Da_float best_position, // source coordinates
	FArray2Da_float best_centroid,
	FArray3Da_float best_full_coord, // source rotamers
	FArray1Da_float phi, // angles to use for folding
	FArray1Da_float psi,
	FArray3Da_float position, // updated coords
	FArray2Da_float centroid,
	FArray3Da_float full_coord,
	FArray1Da_float best_phi,
	FArray1Da_float best_psi,
	FArray1Da_int res_variant
);


void
get_pivot_rmsd(
	int const seg_begin,
	int const seg_end
);


void
global_optimize_pivot( float const magnitude );


void
optimize_pivot( float const magnitude );


float
func_pivot(
	FArray1Da_float TA
);


void
pivot_move( FArray1Da_float TA );


void
pivot_repack( bool const rotamers_exist /* passed to pack */ );


void
detect_pivot_surrouding();


void
docking_pivot_perturb_segment( float const magnitude );


void
docking_pivot_store_cen_scores();


#endif
