// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15424 $
//  $Date: 2007-06-12 21:26:56 +0300 (Tue, 12 Jun 2007) $
//  $Author: bcorreia $

#ifndef INCLUDED_docking_minimize
#define INCLUDED_docking_minimize


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// Types
typedef  float (*Scoring_Function)();


// docking_minimize Function Declarations


void
docking_mcm_protocol();


bool
docking_mcm_filter(
	float margin, // points to allow for passing scorefilter, bkrepfilter
	float & score_storage // variable to store the current score
);


void
docking_rigidbdy_minimize_trial(
	std::string const & type, // type of minimization to perform
	Scoring_Function scoring_fn, // which score to use
	float func_tol // tolerance on the minimization function
);


void
docking_monte_carlo_minimize(
	int cycles, // number of monte carlo minimizations
	std::string const & type, // type of minimization to perform
	Scoring_Function scoring_fn, // which score to use
	float trans_magnitude, // size of translation moves
	float rot_magnitude, // size of rotation moves
	float minimization_threshold, // energy difference (score - best_score) needed for minimization
	float func_tol // tolerance on the minimization function
);


void
dMCM_open_file();


void
dMCM_close_file();


void
dMCM_output(
	int icycle, // cycle number
	int state // whether the structure has been repacked or minimized
);


void
docking_MCM_move(
	float Tmag, // in Angstroms
	float Rmag // in radians
);


void
docking_generate_MCM_move(
	FArray1Da_float delta_TR,
	float Tmag, // in Angstroms
	float Rmag // in radians
);


void
docking_MCM_pack_side_chains(
  int i, // cycle number in MCM loop
	Scoring_Function scoring_fn // which score to use
);


void
docking_minimize_position(
	std::string const & type, // type of minimization to perform:
	Scoring_Function scoring_fn, // which score to use
	float func_tol // tolerance for the minimize functions
);


void
docking_pack_best_position( FArray1Da_float TR );


void
docking_unpack_position( FArray1Da_float TR );


float
func_dvdw(
	FArray1Da_float TR,
	bool & gfrag // indicates success of this function
);


void
dfunc_dvdw(
	FArray1Da_float TR,
	FArray1Da_float dE_dTR,
	int nfree
);


void
derivative_protein_pos(
	FArray1Da_float TR,
	FArray1Da_float dE_dTR,
	int nfree
);


void
docking_get_brians_neighborlist( FArray2Da_bool nl_out );


void
docking_get_brians_neighbors( FArray1Da_int n_out );


void
eval_dE_dr_docking(
	int & ires,
	int & iat,
	int & jres,
	int & jat,
	int & itype,
	int & jtype,
	float & dE_dr, // derivative of energy with respect to atom-atom distance
	FArray1Da_float dr_dx,
	 // derivative of atom-atom distance along each coord. axis
	FArray1Da_float q, // position of j-atom relative to center of rotation
	float const cp_weight
);


void
accumulate_dE_dTR(
	FArray1DB_float & dE_dTR,
	float const dE_dr, // derivative of energy with respect to atom-atom distance
	FArray1DB_float const & dr_dx,
	// derivative of atom-atom distance along each coord. axis
	FArray1DB_float const & q // position of j-atom relative to center of rotation
);


void
pairderiv(
	FArray1Da_float atom1,
	FArray1Da_float atom2,
	int const attype1,
	int const attype2,
	float & ljderiv,
	float & attract,
	float & repulse,
	float & solvate
);


void
get_total_pair_deriv_docking(
	FArray1DB_float & dE_dTR,
	FArray2DB_bool & jneighborlist
);


void
calc_pair_deriv_dock(
	int ires,
	int aa1,
	int jres,
	int aa2,
	float & dpairE_dr, // derivative of energy with respect to atom-atom distance
	FArray1DB_float & dr_dx, // derivative of atom-atom distance along each coord. axis
	FArray1DB_float & q // position of j-atom relative to center of rotation
);


void
get_total_elec_deriv_docking(
	FArray1DB_float & dE_dTR
);


void
calc_and_accumulate_elec_deriv(
	float q1,
	float q2,
	float r2,
	FArray1Da_float atomi,
	FArray1Da_float atomj,
	FArray1DB_float & dE_dTR
);

void
calc_and_accumulate_elec_deriv_smooth(
	float q1,
	float q2,
	float r2,
	FArray1Da_float atomi,
	FArray1Da_float atomj,
	FArray1DB_float & dE_dTR
);

void
docking_fullatom_min_score_pose( bool repack );


void
docking_fullatom_mcm_score_pose( bool repack );


void
check_derivatives_numerically(
	FArray1Da_float TR,
	FArray1Da_float dE_dTR,
	int nfree
);


float
vmax(
	FArray1Da_float v,
	int n
);


float
vmin(
	FArray1Da_float v,
	int n
);


void
docking_test_packunpack( FArray1Da_float TR );


void
docking_test_lj_deriv(
	int & itype,
	int & jtype,
	float & dsq
);


void
test_if_updated( FArray3Da_float fcoord );


#endif
