// Rosetta Headers
#include "domins_score.h"
#include "cenlist.h"
#include "current_pose.h"
#include "DomainInsertionMode.h"
#include "domins_ns.h"
#include "files_paths.h"
#include "jumping_ns.h"
#include "interface.h"
#include "misc.h"
#include "nblist.h"
#include "param_pack.h"
#include "pose.h"
#include "pose_io.h"
#include "pose_vdw.h"
#include "runlevel.h"
#include "score.h"
#include "score_ns.h"

// ObexxFCL Headers
#include <ObjexxFCL/string.functions.hh>

// C++ Headers
#include <cstdlib>
#include <iostream>
#include <fstream>

void
evaluate_contact_scores( float & domain_score )
{
	using namespace scorefxns;
	using namespace scores;
	using namespace domins_ns;

	bool flag ( true );

	if ( !pose_flag() ) {
		flag = false;
		set_pose_flag( true );
	}
	// detect the interface residues
	domain_detect_interf_res(score_get_current_pose());
	// calculate the end and contact scores
	domain_calc_contact_scores();

	// add distance constraints on the loops
	//domain_evaluate_distance_score();

	//domain_score = domain_contact_weight * domain_contact_score +
	//	domain_dc_weight * domain_dc_score;
	domain_score = domain_contact_weight * domain_contact_score;
	if ( flag == false ) set_pose_flag( false );
}

void
domain_detect_interf_res(
	pose_ns::Pose & pose
)
{
	using namespace pose_ns;
	using namespace interface;
	using namespace runlevel_ns;

	int const total_residue( pose.total_residue() );

	for ( int i=1; i <= total_residue; ++i ) {
		int_res(i) = false;
		int_res8(i) = false;
	}

	for( int i=1; i <= max_docking_sites; ++i ) {
		int_res_list(i).clear();
		int_pair_list(i).clear();
		int_res_list8(i).clear();
		int_pair_list8(i).clear();
	}

	pose_update_cendist( pose );
	Fold_tree const & fold_tree ( pose.fold_tree() );
	FArray1D_bool partner( pose.total_residue(), false );

	int const dock_jump = 1; // docking rigid-body jump is always 1
	fold_tree.partition_by_jump( dock_jump, partner );

	FArray2D_float const & cendist ( pose.get_2D_score( CENDIST ) );

	for ( int i=1; i<=total_residue; ++i ) {
		for ( int j=i+1; j<=total_residue; ++j ) {
			if ( partner(i) == partner(j) ) continue;
			if ( int_res(i) && int_res(j) ) continue;
			if ( cendist(i,j) < 64 ) { // if under 8A
				// predefine int_res_list8(X,2)
				if ( !int_res8(j) ) {
					int_res_list8(2).push_back(j);
				}
				// predefine int_pair_list8
				int_res(i) = int_res(j) = true;
				int_pair_list8(1).push_back(i);
				int_pair_list8(2).push_back(j);

				if ( cendist(i,j) < 36.0 ) {
					//predefine int_res_list(X,2)
					if ( !int_res(j) ) {
						int_res_list(2).push_back(j);
					}
					//predefine int_pair_list
					int_res(i) = int_res(j) = true;
					int_pair_list(1).push_back(i);
					int_pair_list(2).push_back(j);
				} // 6A
			} // 8A
		} // partner2

		//predefine int_res_list(X,1)
		if ( int_res(i) ) {
			int_res_list(1).push_back(i);
		}
		// predefine int_res_list8(X,1)
		if ( int_res8(i) ) {
			int_res_list8(1).push_back(i);
		}
	} // partner1

	assert( int_pair_list(1).size() == int_pair_list(2).size() );
	assert( int_pair_list8(1).size() == int_pair_list8(2).size() );

	if ( runlevel >= yap ) {
		std::cout << "interface sizes under 6A: " <<
			int_res_list(1).size() << ' ' << int_res_list(2).size() << std::endl;
		std::cout << "interface pairs under 6A: " << int_pair_list(1).size() << std::endl;
		std::cout << "interface sizes under 8A: " <<
			int_res_list8(1).size() << ' ' << int_res_list8(2).size() << std::endl;
		std::cout << "interface pairs under 8A: " << int_pair_list8(1).size() << std::endl;
	}
	return;
}

//////////////////////////////////////////////////////////////////////////////
/// @begin domain_calc_contact_scores
///
/// @brief calculate domain_contact score
///
/// @detailed
///			This function scores the domain contact
///			score, modeled after docking scores
///
/// @global_read interface array, cen10 array data block
///
/// @global_write domain_contact_score
///
/// @remarks
///
/// @references
///
/// @authors Monica Berrondo July 11 2006
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
domain_calc_contact_scores()
{
	using namespace cenlist_ns;
	using namespace interface;
	using namespace scores;

	// local variables
	int total_interface_residues;

	total_interface_residues = int_res_list(1).size() + int_res_list(2).size();

	domain_contact_score = ( 20 - total_interface_residues ) *0.5;

	// extra penalties for losing contact
	if ( total_interface_residues == 0 ) domain_contact_score += 2.0;
	if ( total_interface_residues == 1 ) domain_contact_score += 1.0;
	if ( total_interface_residues == 2 ) domain_contact_score += 0.5;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin domain_evaluate_distance_score()
///
/// @brief
///		score to measure whether loop distance constraint is met
///
/// @detailed
///		give a bonus of 100 points if the distance constraint is met.  If not,
///		ramp the score down with the cendist (modeled after docking_dist_constr_bonus)
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Monica Berrondo February 09 2007
///
/// @last_modified February 09 2007
/////////////////////////////////////////////////////////////////////////////////
void
domain_evaluate_distance_score()
{
	using namespace interface;
	using namespace cenlist_ns;
	using namespace scores;
	using namespace domins_ns;

	domain_dc_score = 0.0;

	int loop_size(10), dist_constraint, dist_constraint_sq;
	float domain_dist_constr_bonus = 0.0; // Return value

	float extrad;

	// add distance constraints
	dist_constraint = 2*loop_size;
	dist_constraint_sq = dist_constraint * dist_constraint;

	dist_constraint_residues(1) = hostp_begin-loop_size/2;
	dist_constraint_residues(2) = insertp_begin+loop_size/2;
	std::cout << "constraints: " << dist_constraint_residues(1) << ' ' << dist_constraint_residues(2) << std::endl;

	extrad = cendist(dist_constraint_residues(1), dist_constraint_residues(2)) - dist_constraint_distance_sq;

	domain_dist_constr_bonus = -100 + extrad;

	dist_constraint_residues(3) = insertp_end-loop_size/2;
	dist_constraint_residues(4) = hostp_end+loop_size/2;
	std::cout << "constraints: " << dist_constraint_residues(3) << ' ' << dist_constraint_residues(4) << std::endl;

	extrad = cendist(dist_constraint_residues(3), dist_constraint_residues(4)) - dist_constraint_distance_sq;

	domain_dist_constr_bonus = -100 + extrad;

	if ( domain_dist_constr_bonus < -100.0 ) domain_dist_constr_bonus = -100.0;

	domain_dc_score += domain_dist_constr_bonus;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score8di
///
/// @brief
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score8di()
{
	using namespace scorefxns;
	using namespace param_pack;

	score_reset_weights();

	domain_scorefxn = true;

	vdw_weight = 1.0;
	env_weight = 1.0;
	pair_weight = 1.0;
	ramachandran_weight = 0.2;
	pack_wts.set_Whb_srbb(0.5);
	pack_wts.set_Whb_lrbb(1.0);
  pack_wts.set_Whb_srbb(0.5);
	sheet_weight = 1.0;
	ss_weight = 1.0;
	hs_weight = 1.0;
	rsigma_weight = 1.0;
	pc_weight = 1.0;
	contact_prediction_weight = 1.0;
	dipolar_weight = 1.0;

	ss_lowstrand = 0;
	ss_cutoff = 6;

	barcode_weight = 1.0; // like phipsi tether
	taboo_weight = 1.0;

	// chain break weights
	jmp_chainbreak_weight = 1.0;
	jumping::jmp_chainbreak_overlap = 0;

	domain_dc_weight = 1.0;
	domain_contact_weight = 2.0;
	domain_contact_cap = -10.0;

	score_apply_user_defined_reweights();

	return scorefxn();
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score12di
///
/// @brief
///bk fullatom scoring function for design
///car this is the same function as used by the packer except::
///car         no rama score in packer
///car         rep_weight not modified by rep_reduce in packer
///car         includes constraints, chain_gaps if in use
///
///car INTENDED USE:  design, refinement
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score12di()
{
	using namespace scorefxns;
	using namespace param_pack;

	score_reset_weights();
	fa_scorefxn = true;
	//domain_scorefxn = true;

	splicemsd_weight = loop_weight;
	pc_weight = cst_weight;
	dipolar_weight = dpl_weight;
	ramachandran_weight = 0.2;
	if (get_score_contact_fullatom()) contact_prediction_weight = 1.0;

// db 4-6-06  changed default long range hydrogen bonding weight to 1.0 for all sstypes.
	pack_wts.set_Whb_srlrsc(0.5, 1.0, 1.0);

	fa_atr_weight = 1.0;
	fa_rep_weight = 1.0 * rep_reduce;
	fa_dun_weight = 1.0;

	fa_pair_weight = 1.0;
	fa_solv_weight = 1.0;
	fa_gb_elec_weight = 1.0;
	fa_ref_weight = 1.0;
	fa_prob1b_weight = 0.5;
	fa_h2o_weight = 1.0;
	fa_plane_weight = 1.0; // plane score will be zero, though, unless you set Wplane_total = 1.0.

	disulf_cendist_weight = 5.0;
	disulf_bb_dih_weight = 3.0;
	disulf_cbdist_weight = 5.0;
	disulf_cacbcb_weight = 1.0;
	disulf_cacbcbca_weight = 3.0;

	barcode_weight = 1.0;
	taboo_weight = 1.0;

	omega_weight=0.0;

	//chain break weights
	jmp_chainbreak_weight = 1.0;
	jumping::jmp_chainbreak_overlap = 0;

	score_apply_user_defined_reweights();

	return scorefxn();
}

void
output_all_scores()
{
	using namespace scorefxns;
	using namespace scores;
	using namespace param_pack;

	std::cout << "fa_atr_score: " << fa_atr_score << std::endl;
	std::cout << "fa_atr_weight: " << fa_atr_weight << std::endl;
	std::cout <<"fa_rep_score: " << fa_rep_score << std::endl;
	std::cout << "fa_rep_weight: " << fa_rep_weight << std::endl;
	std::cout << "fa_dun_score: " << fa_dun_score << std::endl;
	std::cout << "fa_dun_weight: " << fa_dun_weight << std::endl;
	std::cout << "fa_pair_score: " << fa_pair_score << std::endl;
	std::cout << "fa_pair_weight: " << fa_pair_weight << std::endl;
	std::cout << "fa_plane_score: " << fa_plane_score << std::endl;
	std::cout << "fa_plane_weight: " << fa_plane_weight << std::endl;
	std::cout << "fa_solv_score: " << fa_solv_score << std::endl;
	std::cout << "fa_solv_weight: " << fa_solv_weight << std::endl;
	std::cout << "fa_h2o_solv_score: " << fa_h2o_solv_score << std::endl;
	std::cout << "fa_solv_weight: " << fa_solv_weight << std::endl;
	std::cout << "fa_ref_score: " << fa_ref_score << std::endl;
	std::cout << "fa_ref_weight: " << fa_ref_weight << std::endl;
	std::cout << "fa_pH_score: " << fa_pH_score << std::endl;
	std::cout << "fa_pH_weight: " << fa_pH_weight << std::endl;
	std::cout << "fa_h2o_score: " << fa_h2o_score << std::endl;
	std::cout << "fa_h2o_weight: " << fa_h2o_weight << std::endl;
	std::cout << "fa_h2o_hb_score: " << fa_h2o_hb_score << std::endl;
	std::cout << "fa_h2o_weight: " << fa_h2o_weight << std::endl;
	std::cout << "fa_prob1b_score: " << fa_prob1b_score << std::endl;
	std::cout << "fa_prob1b_weight: " << fa_prob1b_weight << std::endl;
	std::cout << "fa_intrares_score: " << fa_intrares_score << std::endl;
	std::cout << "fa_rep_weight: " << fa_rep_weight << std::endl;
	std::cout << "fa_gb_elec_score: " << fa_gb_elec_score << std::endl;
	std::cout << "fa_gb_elec_weight: " << fa_gb_elec_weight << std::endl;
	std::cout << "hb_srbb_weight: " << pack_wts.Whb_srbb() << std::endl;
	std::cout << "hb_srbb_score: " << hb_srbb_score << std::endl;
	std::cout << "hb_lrbb_weight: " << pack_wts.Whb_lrbb() << std::endl;
	std::cout << "hb_lrbb_score: " << hb_lrbb_score << std::endl;
	std::cout << "hb_sc_weight: " << pack_wts.Whb_sc() << std::endl;
	std::cout << "hb_sc_score: " << hb_sc_score << std::endl;
	std::cout << "vdw_weight: " << vdw_weight << std::endl;
	std::cout << "vdw_score: " << vdw_score << std::endl;
	std::cout << "env_weight: " << env_weight << std::endl;
	std::cout << "env_score: " << env_score << std::endl;
	std::cout << "pair_weight: " << pair_weight << std::endl;
	std::cout << "pair_score: " << pair_score << std::endl;
	std::cout << "cb_weight: " << cb_weight << std::endl;
	std::cout << "cb_score: " << cb_score << std::endl;
	std::cout << "sheet_weight: " << sheet_weight << std::endl;
	std::cout << "sheet_score: " << sheet_score << std::endl;
	std::cout << "ss_weight: " << ss_weight << std::endl;
	std::cout << "ss_score: " << ss_score << std::endl;
	std::cout << "hs_weight: " << hs_weight << std::endl;
	std::cout << "hs_score: " << hs_score << std::endl;
	std::cout << "rsigma_weight: " << rsigma_weight << std::endl;
	std::cout << "rsigma_score: " << rsigma_score << std::endl;
	std::cout << "rg_weight: " << rg_weight << std::endl;
	std::cout << "rg: " << rg << std::endl;
	std::cout << "co_weight: " << co_weight << std::endl;
	std::cout << "co: " << co << std::endl;
	std::cout << "ramachandran_weight: " << ramachandran_weight << std::endl;
	std::cout << "ramachandran_score: " << ramachandran_score << std::endl;
	std::cout << "contact_prediction_weight: " << contact_prediction_weight << std::endl;
	std::cout << "contact_prediction: " << contact_prediction << std::endl;
	std::cout << "dipolar_weight: " << dipolar_weight << std::endl;
	std::cout << "dipolar_score: " << dipolar_score << std::endl;
	std::cout << "projection_weight: " << projection_weight << std::endl;
	std::cout << "projection_score: " << projection_score << std::endl;
	std::cout << "pair_weight: " << pair_weight << std::endl;
	std::cout << "homolog_pair_score: " << homolog_pair_score << std::endl;
}
