// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 19:37:52 +0200 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_elliptic_msd
#define INCLUDED_elliptic_msd


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// elliptic_msd Function Declarations


void
double_move(
	int size,
	float cutoff_in,
	int tag1,
	int tag2,
	int & total_begin,
	int & total_end
);


void
eliptic_rmsd_2(
	FArray2Da_float A1,
	FArray1Da_float U1,
	FArray1Da_float EL,
	FArray1Da_float EL2,
	FArray2Da_float C_EL,
	float cutoff,
	float & rmsd,
	float & rcm
);


void
eliptic_rmsd(
	FArray2Da_float A1,
	FArray1Da_float U1,
	FArray2Da_float A2,
	FArray1Da_float U2,
	FArray1Da_float EL, // the inertial ellipsoid
	float & rmsd,
	float & rms_off
);


void
eliptic_moments(
	FArray2Da_float atoms,
	int N_atoms, // (logical) number of atoms in list
	FArray1Da_float atom_weights,
	FArray1Da_float origin, // offset for atom coordinate system
	FArray1Da_float EL // the inertial moments XX,YY,ZZ,XY,XZ,YZ,X,Y,Z in that order
);


void
eliptic_cross_moments(
	FArray2Da_float atoms,
	int N_atoms, // (logical) number of atoms in list
	FArray1Da_float atom_weights,
	FArray2Da_float A2,
	FArray1Da_float U2,
	FArray1Da_float origin, // offset for atom coordinate system
	FArray2Da_float C_EL, // the inertial cross moments
	FArray1Da_float EL2,
	FArray1Da_float EL,
	FArray2Da_float ZtC
);


void
eliptic_rotate(
	FArray2Da_float A1,
	FArray1Da_float EL,
	FArray1Da_float EL_out
);


void
eliptic_rotate_cross_moments(
	FArray2Da_float A1,
	FArray2Da_float C_EL
);


void
eliptic_translate(
	FArray1Da_float U1,
	FArray1Da_float EL
);


void
frag_effect(
	FArray1Da_float P1,
	FArray1Da_float P2,
	FArray1Da_float P3,
	FArray1Da_float Q1,
	FArray1Da_float Q2,
	FArray1Da_float Q3,
	FArray2Da_float A1,
	FArray1Da_float D1
);


void
debug_mat(
	std::string const & name,
	FArray2Da_float mat
);

void
debug_vec(
	std::string const & name,
	FArray1Da_float vec
);


void
Ddebug_mat(
	std::string const & name,
	FArray2Da_double mat
);


void
debug_3(
	std::string const & name,
	FArray1Da_float a1,
	FArray1Da_float b1,
	FArray1Da_float c1
);


#endif
