// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 23432 $
//  $Date: 2008-06-24 16:25:52 +0300 (Tue, 24 Jun 2008) $
//  $Author: yab $


// Rosetta Headers
#include "enzyme.h"
#include "aa_name_conversion.h"
#include "enzyme_ns.h"
#include "aaproperties_pack.h"
#include "after_opts.h"
#include "are_they_neighbors.h"
#include "atom_tree_routines.h"
#include "cst_countpair.h"
#include "cst_descriptor.h"
#include "current_packer_cst.h"
#include "current_pose.h"
#include "design.h"
#include "docking_ns.h"
#include "etable.h"
#include "FArray_xyz_functions.h"
#include "fast_pairenergy.h"
#include "favor_residue_ns.h"
#include "files_paths.h"
#include "hbonds_ns.h"
#include "interface.h"
#include "jumping_refold.h"
#include "jumping_util.h"
#include "ligand.h"
#include "ligand_ns.h"
#include "loop_class.h"
#include "loop_relax.h"
#include "make_pdb.h"
#include "misc.h"
#include "minimize.h"
#include "monte_carlo.h"
#include "nblist.h"
#include "pack_fwd.h"
#include "pack_geom_inline.h"
#include "PackerTask.h"
#include "param.h"
#include "param_aa.h"
#include "param_pack.h"
#include "pdb.h"
#include "pdbstatistics_pack.h"
#include "pose.h"
#include "pose_ligand.h"
#include "pose_io.h"
#include "pose_loops.h"
#include "pose_design.h"
#include "pose_fwd.h"
#include "pose_vdw.h"
#include "read_aaproperties.h"
#include "read_paths.h"
#include "RotamerSet.h"
#include "recover.h"
#include "rotamer_functions.h"
#include "runlevel.h"
#include "scale_res_energy.h"
#include "score.h"
#include "smallmove.h"
#include "template_pack.h"
#include "water_ns.h"
#include "weights_manager.h"
#include "DesignMap.h"
#include "InteractionGraphSupport.h"
#ifdef GL_GRAPHICS
#include "gl_graphics.h"
#include "protein_graphics.h"
#endif
#ifdef BOINC_GRAPHICS
#include "protein_graphics.h"
#include "trajectory.h"
#endif

// ObjexxFCL Headers
#include <ObjexxFCL/byte.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/formatted.io.hh>

// Numeric Headers
#include <numeric/constants.hh>
#include <numeric/conversions.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/izstream.hh>
#include <utility/io/orstream.hh>
#include <utility/io/ozstream.hh>

// C++ Headers
#include <cmath>
#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <sstream>
#include <list>


//
//     enzyme.cc
//
//     Lin Jiang   Octobor 2004
//
// - buildup the inverse rotamer tree based on the function group of key residue
// - Jens Meiler developed the code computing virtual energy for constraint
//   on catalytic geometry
//
//   In future, I will incoporate the geometric hashing algorithm for searching
//   backbone match between different scaffolds (C code developed by Gong Cheng)
//
// These are the codes handling enzyme design in the fullatom energy evaluation,
// docking, and design parts. A new flag " -enzyme_design " was added.
//

////////////////////////////////////////////////////////////////////////////////
/// @begin get_enzyme_flag
///
/// @brief
///     bool function to check on enzyme_flag
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
bool
get_enzyme_flag()
{
	using namespace enzyme;
	using namespace param_pack;

	static bool init = { false };

	if ( !init ) {
		enzyme_flag = truefalseoption("enzyme_design");
		init = true;
		enzyme_vrot = false;
		if ( enzyme_flag ) {

			// set virtual ligand weight
			if ( truefalseoption( "Wlig_vir") ) {
				pack_wts.set_Wlig_vir(realafteroption( "Wlig_vir", 3.0));
				std::cout << "Wlig_vir set to " << pack_wts.Wlig_vir() << " as requested by the -Wlig_vir flag" << "\n";
			}

			// set the cutoff distance for virtual energy
			if ( truefalseoption( "lig_virE_dmax") ) {
				realafteroption( "lig_virE_dmax", 4.0, lig_virE_dmax);
				std::cout << "lig_virE_dmax set to " << lig_virE_dmax << " as requested by the -lig_virE_dmax flag" << "\n";
			}

			//lin flag to increase virtual energy to force an exact match of virtual atoms
			exact_match_vatom = truefalseoption( "exact_match_vatom");

			//lin set flag for inverse rotamer tree
			enzyme_vrot = truefalseoption("enzyme_vrot");
			if ( enzyme_vrot ) {
				max_vrotamers = 800; // Set size and allocate related arrays
				realafteroption("vrot_perc",0.9,vrot_perc);
				std::cout << "virtual rotamer probability cutoff set to " << vrot_perc
				 << " as requested by the -vrot_perc flag" << "\n";
				realafteroption("vrot_repmaxE",3.0,vrot_repmaxE);
				std::cout << "max repE between virtual rotamer and ligand set to " << vrot_perc
				 << " as requested by the -vrot_resmaxE flag" << "\n";
			}
		}
	}

	return enzyme_flag;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_enzyme_flag
///
/// @brief
///
/// @detailed
///
/// @param  setting - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_enzyme_flag( bool setting )
{
	using namespace enzyme;

	enzyme_flag = setting;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin reset_flag
///
/// @brief
///
/// @detailed
///
/// @param  setting - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
reset_enzyme()
{
	using namespace enzyme;

	enzyme_flag = false;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_enable_ligaa_flag
///
/// @brief
///
/// @detailed
///
/// @param  setting - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_enable_ligaa_flag( bool setting )
{
	using namespace enzyme;

	enable_ligaa = setting;

	static bool init = { false };

	if( enable_ligaa ) {
		if ( !init ) {
			init = true;

			set_read_ligaa_flag( true );
			read_occ_weights=truefalseoption("use_atom_weights");
			read_bvalue_charge=truefalseoption("read_input_charge");
			attach_ligaa_by_jump = !truefalseoption("attach_by_bond");
			read_ligaa_mdl = truefalseoption("mdlfile");
			use_mdl_connect = truefalseoption("use_mdl_connect");
			realafteroption("Wligaa",1.0,ligand_weight_scale);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin reset_flag
///
/// @brief
///
/// @detailed
///
/// @param  setting - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
bool
get_enable_ligaa_flag()
{
	using namespace enzyme;

	return enable_ligaa;

}

/////////////////////////////////////////////////////////////////////////////////
void
set_read_ligaa_flag( bool setting )
{
	using namespace enzyme;

	read_ligaa = setting;

}

/////////////////////////////////////////////////////////////////////////////////
bool
get_read_ligaa_flag()
{
	using namespace enzyme;

	return read_ligaa;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_inverse_rotamers
///
/// @brief
///   generate inverse rotamer trees based on the function group of the sidechain.
///   the input is the virutal atoms in certain order from hetero atoms
///   for each amino acid, three key atoms defining the geometry of sidechain functional
///   group are picked up. The chi angle array is taken from dunbrack backbone independent
///   rotamer library (bbind02.May.lib), and the rotamer is buildup on the three key atoms.
///   The clash between ligand and inverse rotamer is checked and the clash table between
///   inverse rotamers is created.
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_inverse_rotamers()
{
	using namespace enzyme;
	using namespace misc;
	using namespace files_paths;

//lin generate inverse rotamer trees  based on the function group of the sidechain.
	if ( !enzyme_vrot ) return;

	//lin local fillname
	std::string vrot_rep_table;
	std::string vrot_decoys;

	std::cout << "building the inverse rotamer tree." << "\n";

        //finding the function group of the sidechain
	detect_virtual_residue_base();

	//get inverse rotamer based on function group geometry
	build_virtual_residue_fullcoord();

        //detect clashes between rotamers
	detect_virtual_rotamer_clash();

	//make clash table
	vrot_rep_table = pdb_out_path + output_file + "_rot_rep.table";
	make_table_file( vrot_rep_table );

// 	//write the combination of no-clash virtual rotamers
// 	if ( output_all ) {
// 	  vrot_decoys = pdb_out_path + output_file + "_decoys.pdb";
// 	  vrot_pdb(vrot_decoys);
// 	}

	std::cout << "finish building the inverse rotamer tree." << "\n";
}

////////////////////////////////////////////////////////////////////////////////
/// @begin detect_virtual_residue_base
///
/// @brief
///   assign the virtual atom to virtual residues
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
detect_virtual_residue_base()
{
	using namespace param;
	using namespace enzyme;
	using namespace ligand;
	using namespace runlevel_ns;

//kwk local vairables for conversion between Farray coordinates and xyzVector
	FArray1D_float het_coord(3);
//lin function body
	if ( ! enzyme_vrot || ligand::ligand_one->atom_vector.empty() == 0 ) return;

//lin find virtual group base
	virtual_residue_count = 0; //erase all existing virtual group base
	int count = 4;
	for ( size_t atom_1 = 1; atom_1 <= ligand::ligand_one->atom_vector.size(); ++atom_1 ) {
		if ( ligand::ligand_one->atom_vector[atom_1-1]->Is_Virtual() ) {
			copy_to_FArray(ligand::ligand_one->atom_vector[atom_1-1]->get_coordinates(), het_coord);
			++count;
			if ( count > 3 ) {
				count=1;
				++virtual_residue_count;
				virtual_residue_id(virtual_residue_count) =
				 ligand::ligand_one->hetero_atom_resid(atom_1);
			}
			for ( int i = 1; i <= 3; ++i ) {
				virtual_resbase_coord(i,count,virtual_residue_count) =
				 het_coord(i);
			}
			 virtual_resbase_name(count,virtual_residue_count)=ligand::ligand_one->
					atom_vector[atom_1-1]->get_atom_name();
		}
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin build_virtual_residue_fullcoord
///
/// @brief
///  build up the inverse rotamers on virtual residues
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
build_virtual_residue_fullcoord()
{
	using namespace param;
	using namespace param_aa;
	using namespace enzyme;
	using namespace runlevel_ns;

	if ( ! enzyme_vrot || virtual_residue_count == 0 ) return;

	int nrotamers = 0;
	int aan;

	for ( int i=1;i <= VIRTUAL_RESIDUE_MAX;++i ) {
		vrot_begin(i)=0;
		vrot_end(i)=0;
	}

	for ( int i = 1; i <= virtual_residue_count; ++i ) {
		vrot_begin(i) = nrotamers+1;
		num_from_name( virtual_residue_id(i), aan );
		for ( int j = 1, je = vdun_count(aan); j <= je; ++j ) {
			if ( aan == aa_asp || aan == aa_glu || aan == aa_tyr ) {
				get_vrot_vseqpos_vaan_vaav(aan,1,i,j,nrotamers,false,true,0.0);

				get_vrot_vseqpos_vaan_vaav(aan,1,i,j,nrotamers,true,true,0.0);

			} else if ( aan == aa_lys ) {
				get_vrot_vseqpos_vaan_vaav(aan,1,i,j,nrotamers,false,true,0.0);

				get_vrot_vseqpos_vaan_vaav(aan,1,i,j,nrotamers,false,false,120.0);

				get_vrot_vseqpos_vaan_vaav(aan,1,i,j,nrotamers,false,false,-120.0);

			} else if ( aan == aa_ser ) {
				get_vrot_vseqpos_vaan_vaav(aan,1,i,j,nrotamers,false,true,0.0);

				get_vrot_vseqpos_vaan_vaav(aan,1,i,j,nrotamers,false,false,60.0);

				get_vrot_vseqpos_vaan_vaav(aan,1,i,j,nrotamers,false,false,120.0);

				get_vrot_vseqpos_vaan_vaav(aan,1,i,j,nrotamers,false,false,-60.0);

				get_vrot_vseqpos_vaan_vaav(aan,1,i,j,nrotamers,false,false,-120.0);

				get_vrot_vseqpos_vaan_vaav(aan,1,i,j,nrotamers,false,false,180.0);

			} else {
				get_vrot_vseqpos_vaan_vaav(aan,1,i,j,nrotamers,false,true,0.0);

			}
		}
		vrot_end(i) = nrotamers;
	}

	vrot_counts = nrotamers;
//$$$      do i=1,virtual_residue_count
//$$$         call get_rotamers_seqpos_aa_aav(virtual_residue_id(i),1,i,vrotcoord,
//$$$     *        rperc,rchi,rrot,rindex,rot_aa_variant,nrotamers,
//$$$     *        nrotaa,rotactcoord,include_current,'pack',protamers,
//$$$     *        base_rotamer)
//$$$
}


////////////////////////////////////////////////////////////////////////////////
/// @begin get_vrot_vseqpos_vaan_vaav
///
/// @brief
///  get inverse rotamers on virtual residue position given aan and aav
///  IMPORTANT: different from the normal rotamer building, the aan and aav
///             SHOULD be consistant to virtual residue type.
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_vrot_vseqpos_vaan_vaav(
	int aan,
	int aav,
	int seqpos,
	int nrot,
	int & nrotamers,
	bool const flip,
	bool const rot,
	float const rot_ang
)
{
	using namespace param;
	using namespace ligand;
	using namespace enzyme;
	using namespace runlevel_ns;

	//local
	float lig_solE,lig_atrE,lig_repE,lig_virE;

	std::list< FArray1D_float > total_chi_set;
	std::list< FArray1D_int > total_rot_set;

	FArray1D_float base_chi( 4 );
	FArray1D_float base_sd( 4 );
	int neighbor = 20;
	int dummy_seqpos = 1;
	DesignMap dummy_design_map(MAX_RES(), misc::res );

	for ( int i = 1; i <= MAX_CHI; ++i ) {
		base_chi(i) = vdun_chi(aan,nrot,i);
		base_sd(i) = vdun_sd(aan,nrot,i);
	}
	get_extrachi(aan,aav,base_chi,base_sd,neighbor,
	 total_chi_set,total_rot_set,dummy_seqpos,dummy_design_map);

	for( std::list<FArray1D_float>::iterator chiset = total_chi_set.begin();
			 chiset != total_chi_set.end(); ++chiset ) {

		++nrotamers;
		if ( nrotamers >= max_vrotamers ) {
			std::cout << "STOP: nrotamers > max_vrotamers " << max_vrotamers << "\n";
			std::cout << "enzyme.cc get_vrot_vseqpos_aa_aav" << "\n";
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}

		vrotaa(nrotamers) = aan;
		vrotres(nrotamers) = seqpos;

		for ( int i = 1; i <= MAX_CHI; ++i ) {
			vrchi(i,nrotamers) = (*chiset)(i);
		}

		get_funrot_coord(virtual_resbase_coord, aan,aav,vrchi(1,nrotamers),
		 vrotcoord(1,1,nrotamers),seqpos,flip,rot,rot_ang);

		get_sc_ha_virtualE(seqpos,aan,aav,vrotcoord(1,1,nrotamers),lig_virE,
		 false,true,false, *ligand::ligand_one);
		get_sc_haE(seqpos,aan,aav,vrotcoord(1,1,nrotamers),lig_solE,lig_atrE,
		 lig_repE,true,true,(*ligand::ligand_one));
		vrot_repE(nrotamers) = lig_repE;
		if ( runlevel < verbose && lig_repE > vrot_repmaxE ) --nrotamers;
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_funrot_coord
///
/// @brief
///  the derivative of get_rot_coord(), but determines coordinates for rotamers
///  superimposed on sidechain function group
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
void
get_funrot_coord(
	FArray3Da_float xyz,
	int const aan,
	int const aav,
	FArray1Da_float chi,
	FArray2Da_float rotcoord,
	int const vpos,
	bool const flip,
	bool const fixed,
	float const rot_ang
)
{
	using namespace param;
	using namespace aaproperties_pack;
	using namespace misc;
	using namespace ligand;
	using namespace enzyme;
	using numeric::conversions::radians;

	xyz.dimension( 3, 3, VIRTUAL_RESIDUE_MAX );
	chi.dimension( MAX_CHI );
	rotcoord.dimension( 3, MAX_ATOM() );

//lin determines coordinates for rotamers superimposed on sidechain function group

//------------------------------------------------------------------------------
//lin function arguments
//lin xyz         :coordinates of virtual atoms defining sidechain fucntional group geometry
//lin aan         :amino acid
//lin chi         :desired chi angles
//lin rotcoord    :inverse rotamer coordinates

//lin local variables
	std::string aanname;
	FArray2D_float coor( 3, MAX_ATOM()() );
	FArray2D_float mat( 3, 3 );
	FArray1D_float vec( 3 );
	FArray2D_float rescoord( 3, 3 );
	FArray1D_float nhcoord( 3 );
	float ichi, rot;
	float ang;
	int maxatom,c1,c2,c3,c4,b1,b2,b3;

//------------------------------------------------------------------------------
//lin assign diffent atoms to the anchor atoms which the rotamer is on
	for ( int j = 1; j <= 3; ++j ) {
		for ( int i = 1; i <= 3; ++i ) {
			rescoord(i,j) = xyz(i,j,vpos);
		}
	}

	if ( flip ) {
		for ( int i = 1; i <= 3; ++i ) {
			rescoord(i,1) = xyz(i,3,vpos);
		}
		for ( int i = 1; i <= 3; ++i ) {
			rescoord(i,3) = xyz(i,1,vpos);
		}
	}

	if ( ! fixed ) {
		ang = radians( rot_ang );
//lin   generate rotation vector and matrix
		getrot_bk( rescoord(1,1), rescoord(1,2), ang, mat, vec );
//lin   move atoms
		move_bk( rescoord(1,3), mat, vec );
	}

//bk read in template coordinates for this amino acid
	for ( int j = 1, je = natoms( aan, aav ); j <= je; ++j ) {
		for ( int i = 1; i <= 3; ++i ) {
			coor(i,j) = icoor( i, j, aan, aav );
		}
	}

	for ( int ch = 1; ch <= MAX_CHI; ++ch ) {
//bk change chi angle if it exists
		if ( nchi(aan,aav) >= ch ) {
			c1 = chi_atoms(1,ch,aan,aav);
			c2 = chi_atoms(2,ch,aan,aav);
			c3 = chi_atoms(3,ch,aan,aav);
			c4 = chi_atoms(4,ch,aan,aav);
//** determine initial chi angle
			dihedral_bk(coor(1,c1),coor(1,c2),coor(1,c3), coor(1,c4), ichi);
//** rotate angle by new-initial degrees
			rot = radians( chi(ch) - ichi );
//**   generate rotation vector and matrix
			getrot_bk(coor(1,c2), coor(1,c3), rot, mat, vec);
//** move atoms
			for ( int i = 1, ie = natoms( aan, aav ); i <= ie; ++i ) {
				if ( chi_required( ch, i, aan, aav ) ) {
					move_bk( coor(1,i), mat, vec );
				}
			}
		}
	}

//lin   superimpose the rotamer on to the sidechain key atoms
//lin   find the matrix/vector that lines up the "b1" and "b2" atoms
//lin   and apply this operation to all the atoms in the rotamer
	b1 = 1; //" N  "
	b2 = 2; //" CA "
	b3 = 4; //" O  "
	name_from_num( aan, aanname );
	if ( aanname == "ASP" ) {
		b1 = 7; //" OD1"
		b2 = 5; //" CB "
		b3 = 8; //" OD2"
	}
	if ( aanname == "ASN" ) {
		b1 = 7; //" OD1"
		b2 = 5; //" CB "
		b3 = 8; //" ND1"
	}
	if ( aanname == "GLU" ) {
		b1 = 8; //" OE1"
		b2 = 6; //" CG "
		b3 = 9; //" OE2"
	}
	if ( aanname == "GLN" ) {
		b1 = 8; //" OE1"
		b2 = 6; //" CG "
		b3 = 9; //" NE2"
	}
	if ( aanname == "HIS" ) {
		b1 = 7; //" ND1"
		b2 = 5; //" CB "
		b3 = 10; //" NE2"
	}
	if ( aanname == "ARG" ) {
		b1 = 8; //" NE "
		b2 = 10; //" NH1"
		b3 = 11; //" NH2"
	}
	if ( aanname == "LYS" ) {
		b1 = 8; //" CE "
		b2 = 9; //" NZ "
		b3 = 11; //"1HZ "
	}
	if ( aanname == "SER" ) {
		b1 = 5; //" CB "
		b2 = 6; //" OG "
		b3 = 8; //" HG "
	}
	if ( aanname == "THR" ) {
		b1 = 7; //" CG2"
		b2 = 6; //" OG1"
		b3 = 9; //" HG1"
	}
	//	if ( aanname == "TYR" ) {
	//		b1 = 7; //" CD1 "
	//		b2 = 12; //" OH "
	//		b3 = 8; //" CD2 "
	//	}

	lineup_bk(coor(1,b2),coor(1,b1),rescoord(1,2), rescoord(1,1),mat,vec);
//jjh These should be equivalent, and the second is general
//	maxatom = nside(aan,aav) + 4;
	maxatom = natoms(aan,aav);
	for ( int i = 1; i <= maxatom; ++i ) {
		move_bk(coor(1,i),mat,vec);
	}

//lin   find the matrix/vector that lines up the "b2"->"b3"
//lin   and apply this operation to the rotamer
	align_bk(coor(1,b1),coor(1,b2),coor(1,b3),rescoord(1,3), mat(1,1),vec(1));
	for ( int i = 1; i <= maxatom; ++i ) {
		move_bk(coor(1,i),mat,vec);
	}

//lin  store coordinates in rotcoord
	for ( int j = 1, je = natoms(aan,aav); j <= je; ++j ) {
		for ( int k = 1; k <= 3; ++k ) {
			rotcoord(k,j) = coor(k,j);
		}
	}

}


////////////////////////////////////////////////////////////////////////////////
/// @begin get_vrot_vrotE
///
/// @brief
///  get the energise between inverse rotamers, currently only repulsive energy
///  is returned
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
inline
void
get_vrot_vrotE(
	int res1,
	int res2,
	int aa1,
	int aa2,
	int aav1,
	int aav2,
	FArray2Da_float coord1,
	FArray2Da_float coord2,
	float & repE
)
{
	using namespace param;
	using namespace aaproperties_pack;

	if ( res1 == res2 ) {
		repE = -1.0;
		return;
	}

	coord1.dimension( 3, MAX_ATOM() );
	coord2.dimension( 3, MAX_ATOM() );

	float const cp_weight = { 1.0 };
	float d2;
	float solvE, atrE;

	repE = 0.0;

	for ( int atom1 = 1, atom1e = natoms( aa1, aav1 ), atom2e = natoms( aa2, aav2 );
	 atom1 <= atom1e; ++atom1 )
		for ( int atom2 = 1; atom2 <= atom2e; ++atom2 )
			fast_pairenergy( coord1(1,atom1), coord2(1,atom2), fullatom_type(atom1,aa1,aav1),
			 fullatom_type(atom2,aa2,aav2), solvE, atrE, repE, d2, cp_weight );
}


////////////////////////////////////////////////////////////////////////////////
/// @begin detect_virtual_rotamer_clash
///
/// @brief
///  detect the clash between inverse rotamers and ligand
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
detect_virtual_rotamer_clash()
{
	using namespace param;
	using namespace param_aa;
	using namespace enzyme;
	using namespace runlevel_ns;

	if ( ! enzyme_vrot || virtual_residue_count == 0 ) return;

	float repE;
	for ( int i = 1; i <= vrot_counts; ++i )
		for ( int j = i; j <= vrot_counts; ++j ) vrot_vrot_repE(i,j)=0.0;
	for ( int i = 1; i <= vrot_counts; ++i )
		for ( int j = i; j <= vrot_counts; ++j ) {
			get_vrot_vrotE(vrotres(i),vrotres(j),vrotaa(i),vrotaa(j),1,1,vrotcoord(1,1,i),
										 vrotcoord(1,1,j),repE);
			vrot_vrot_repE(i,j) = repE;
		}
}


////////////////////////////////////////////////////////////////////////////////
/// @begin make_table_file
///
/// @brief
/// ouput clash table for inverse rotamers
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
make_table_file( std::string const & VROT_REP_TABLE )
{
	using namespace enzyme;

	std::ofstream table_out_stream( VROT_REP_TABLE.c_str() );
	if ( !table_out_stream ) {
		std::cout << "Open failed for file: " << VROT_REP_TABLE << "\n";
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	for ( int i = 1; i <= vrot_counts; ++i ) {
		for ( int j = 1; j <= vrot_counts; ++j ) {
			table_out_stream << F( 6, 2, vrot_vrot_repE(i,j) ) << " ";
		}
		table_out_stream << "\n";
	}
	table_out_stream.close();
	table_out_stream.clear();
}

////////////////////////////////////////////////////////////////////////////////
/// @begin vrot_pdb
///
/// @brief
/// output the combination of inverse rotamers
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
vrot_pdb( std::string const & filename )
{
	using namespace files_paths;
	using namespace runlevel_ns;
	using namespace enzyme;

//	if ( runlevel > standard ) std::cout << "Outputting " << filename << "..." << "\n";
	utility::io::ozstream pdb_out_xstream( filename );
	if ( !pdb_out_xstream ) {
		std::cout << "Open failed for file: " << filename << "\n";
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	//make_vrot_decoy_file(1,pdb_out_xstream);
	make_vrot_decoy_file( virtual_residue_count, pdb_out_xstream );

	pdb_out_xstream.close();
	pdb_out_xstream.clear();

}

////////////////////////////////////////////////////////////////////////////////
/// @begin make_vrot_decoy_file
///
/// @brief
/// output the combination of inverse rotamers
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
make_vrot_decoy_file(
	int const cycle,
	utility::io::orstream & iunit
)
{
	using namespace enzyme;
	using namespace misc;
	using namespace param;
	using namespace files_paths;

	float const repE_limit = {0.5};
	FArray1D_int vres_id( vrot_counts );
	FArray1D_int vres_variant( vrot_counts );
	FArray1D_int vdom_end( MAX_SEGMENTS );
	FArray2D_float vocc( MAX_ATOM()(), vrot_counts );
	FArray2D_float vbval( MAX_ATOM()(), vrot_counts );
	int vdoms;
	int vnres;
	int vrot_tmp;

 	for ( int i = 1, max_atom = MAX_ATOM(); i <= vrot_counts; ++i ) {
		vres_variant(i) = 1;
		for ( int j = 1; j <= max_atom; ++j ) {
			vocc(j,i) = vrotres(i);
			vbval(j,i) = vrot_repE(i);
		}
	}
	vdom_end(1) = 1;
	vdoms = 1;
	vnres=1;

	//std::cout << "cycle: " << cycle << "\n";
	switch( cycle ) {

	case  1:
		for ( int vrot1 = vrot_begin(1), vrot1e = vrot_end(1); vrot1 <= vrot1e; ++vrot1 ) {
			vrot_tmp = vrot1;
			output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
					vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
					vbval(1,vrot_tmp), iunit );
			iunit << "TER" << "\n";
		}
		return;
	case  2:
		for ( int vrot1 = vrot_begin(1), vrot1e = vrot_end(1); vrot1 <= vrot1e; ++vrot1 )
			for ( int vrot2 = vrot_begin(2), vrot2e = vrot_end(2); vrot2 <= vrot2e; ++vrot2 )
				if ( vrot_vrot_repE(vrot1,vrot2) < repE_limit ) {
					vrot_tmp = vrot1;
					output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
												vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
												vbval(1,vrot_tmp), iunit );
					vrot_tmp = vrot2;
					output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
												vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
												vbval(1,vrot_tmp), iunit );
					iunit << "TER" << "\n";
				}
		return;
	case  3:
		for ( int vrot1 = vrot_begin(1), vrot1e = vrot_end(1); vrot1 <= vrot1e; ++vrot1 )
			for ( int vrot2 = vrot_begin(2), vrot2e = vrot_end(2); vrot2 <= vrot2e; ++vrot2 )
				if ( vrot_vrot_repE(vrot1,vrot2) < repE_limit ) {
					for ( int vrot3 = vrot_begin(3), vrot3e = vrot_end(3); vrot3 <= vrot3e; ++vrot3 )
						if ( vrot_vrot_repE(vrot1,vrot3) < repE_limit &&
							  vrot_vrot_repE(vrot2,vrot3) < repE_limit ) {
							vrot_tmp = vrot1;
							output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
														vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
														vbval(1,vrot_tmp), iunit );
							vrot_tmp = vrot2;
							output_fullatom_pdb( vrot_tmp,vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
														vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
														vbval(1,vrot_tmp), iunit );
							vrot_tmp = vrot3;
							output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
														vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
														vbval(1,vrot_tmp), iunit );
							iunit << "TER" << "\n";
						}
				}
		return;
	case  4:
		for ( int vrot1 = vrot_begin(1), vrot1e = vrot_end(1); vrot1 <= vrot1e; ++vrot1 )
			for ( int vrot2 = vrot_begin(2), vrot2e = vrot_end(2); vrot2 <= vrot2e; ++vrot2 )
				if ( vrot_vrot_repE(vrot1,vrot2) < repE_limit ) {
					for ( int vrot3 = vrot_begin(3), vrot3e = vrot_end(3); vrot3 <= vrot3e; ++vrot3 )
						if ( vrot_vrot_repE(vrot1,vrot3) < repE_limit &&
							  vrot_vrot_repE(vrot2,vrot3) < repE_limit ) {
							for ( int vrot4 = vrot_begin(4), vrot4e = vrot_end(4); vrot4 <= vrot4e; ++vrot4 )
								if ( vrot_vrot_repE(vrot1,vrot4) < repE_limit &&
									  vrot_vrot_repE(vrot2,vrot4) < repE_limit &&
									  vrot_vrot_repE(vrot3,vrot4) < repE_limit ) {
									vrot_tmp = vrot1;
									output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
																vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
																vbval(1,vrot_tmp), iunit );
									vrot_tmp = vrot2;
									output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
																vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
																vbval(1,vrot_tmp), iunit);
									vrot_tmp = vrot3;
									output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
																vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
																vbval(1,vrot_tmp), iunit );
									vrot_tmp = vrot4;
									output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
																vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
																vbval(1,vrot_tmp), iunit );
									iunit << "TER" << "\n";
								}
						}
				}
		return;
	case  5:
		for ( int vrot1 = vrot_begin(1), vrot1e = vrot_end(1); vrot1 <= vrot1e; ++vrot1 )
			for ( int vrot2 = vrot_begin(2), vrot2e = vrot_end(2); vrot2 <= vrot2e; ++vrot2 )
				if (vrot_vrot_repE(vrot1,vrot2) < repE_limit) {
					for ( int vrot3 = vrot_begin(3), vrot3e = vrot_end(3); vrot3 <= vrot3e; ++vrot3 )
						if (vrot_vrot_repE(vrot1,vrot3) < repE_limit &&
							 vrot_vrot_repE(vrot2,vrot3) < repE_limit ) {
							for ( int vrot4 = vrot_begin(4), vrot4e = vrot_end(4); vrot4 <= vrot4e; ++vrot4 )
								if ( vrot_vrot_repE(vrot1,vrot4) < repE_limit &&
									  vrot_vrot_repE(vrot2,vrot4) < repE_limit &&
									  vrot_vrot_repE(vrot3,vrot4) < repE_limit ) {
									for ( int vrot5 = vrot_begin(5), vrot5e = vrot_end(5); vrot5 <= vrot5e; ++vrot5 )
										if ( vrot_vrot_repE(vrot1,vrot5) < repE_limit &&
											  vrot_vrot_repE(vrot2,vrot5) < repE_limit &&
											  vrot_vrot_repE(vrot3,vrot5) < repE_limit &&
											  vrot_vrot_repE(vrot4,vrot5) < repE_limit ) {
											vrot_tmp = vrot1;
											output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
																		vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
																		vbval(1,vrot_tmp), iunit );
											vrot_tmp = vrot2;
											output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
																		vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
																		vbval(1,vrot_tmp), iunit );
											vrot_tmp = vrot3;
											output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
																		vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
																		vbval(1,vrot_tmp), iunit );
											vrot_tmp = vrot4;
											output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
																		vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
																		vbval(1,vrot_tmp), iunit );
											vrot_tmp = vrot5;
											output_fullatom_pdb( vrot_tmp, vrotcoord(1,1,vrot_tmp), vrotaa(vrot_tmp),
																		vres_variant(vrot_tmp), vnres, 'V', vdoms, vdom_end, vocc(1,vrot_tmp),
																		vbval(1,vrot_tmp), iunit );
											iunit << "TER" << "\n";
									}
								}
						}
				}
		return;
	default:
		std::cout << "Failed for output the vort decoy pdb: runcycle is " << cycle <<
			", but virtual_residue_count is " << virtual_residue_count << "\n";
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
}


////////////////////////////////////////////////////////////////////////////////
/// @begin output_fullatom_pdb
///
/// @brief
///
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
output_fullatom_pdb(
	int & nvrot,
	FArray3Da_float xyz, // (xyz,atom#,res#)coordinates
	FArray1Da_int aan, // specifies amino acid at each seqpos
	FArray1Da_int aav, // amino acid variant at each position
	int & nres, // # of residues in the protein
	char const chain, // protein chain
	int & ndomains, // how many domains?
	FArray1Da_int dom_end, // end residues of each domain
	FArray2Da_float occ,
	FArray2Da_float bval,
	utility::io::orstream & iunit
)
{
	using namespace aaproperties_pack;
	using namespace files_paths;
	using namespace param;
	using namespace pdb;
	using namespace enzyme;

	xyz.dimension( 3, MAX_ATOM(), nres );
	aan.dimension( nres );
	aav.dimension( nres );
	dom_end.dimension( ndomains );
	occ.dimension( MAX_ATOM(), nres );
	bval.dimension( MAX_ATOM(), nres );

// local variables
	char chain_out = ' '; // for output, depends on mode
	int res_num_out; // ditto
	char insert_let_out = ' '; // ditto


	if ( !use_pdb_numbering ) {
		insert_let_out = ' ';
		chain_out = chain;
		if ( chain_out == '_' ) chain_out = ' ';
	}
	std::string resname;
	std::string atomname;
	std::string tag = " ";

	int atom_number_out = 0;
	int idomain = 1;
	for ( int i = 1; i <= nres; ++i ) {
		if( !param_aa::is_ligand(aan(i)) ) {
			tag = "ATOM  ";
		}else{
			tag = "HETATM";
		}
		if ( use_pdb_numbering ) {
			res_num_out = pdb_res_num(i);
			insert_let_out = pdb_insert_let(i);
			chain_out = res_chain(i);
		} else if ( enzyme_vrot ) {
			res_num_out = nvrot;
		} else {
			res_num_out = i;
		}

		name_from_num(aan(i),resname);
		for ( int j = 1, je = natoms( aan(i), aav(i) ); j <= je; ++j ) {
			atom_name_from_atom_num( j, aan(i), aav(i), atomname );
			++atom_number_out;
			iunit << "ATOM  " << I( 5, atom_number_out ) << ' ' << atomname << ' '
					<< resname << ' ' << chain_out << I( 4, res_num_out )
					<< insert_let_out << "   " << F( 8, 3, xyz(1,j,i) )
					<<	F( 8, 3, xyz(2,j,i) ) << F( 8, 3, xyz(3,j,i) )
					<< F( 6, 2, occ(j,i) ) << ' ' << F( 5, 2, bval(j,i) ) << "\n";
		}
		if ( multi_chain && i == dom_end(idomain) ) {
			iunit << "TER" << "\n";
			++idomain;
		}

	}
	if ( !multi_chain &&!enzyme_vrot ) iunit << "TER" << "\n";

//            atom23   CA    GLY   L  99 A      x    y    z      occ    bfactor
}

////////////////////////////////////////////////////////////////////////////////
/// @begin setup_bbind_dun
///
/// @brief
/// read dunbrack backbine-inpendent rotamer library from "bbind02.May.lib"
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
setup_bbind_dun()
{
	using namespace enzyme;
	using namespace runlevel_ns;
	using namespace param;
	using namespace param_aa;

	if ( !enzyme_vrot ) return;

//lin  read dunbrack backbine-inpendent rotamer library
//lin  this is for building inverse rotamer tree
	int packed_rotno = 0;
	std::string const bbind_rot_file( "bbind02.May.lib" );
	int phi,psi;
	float perc;

	FArray1D_byte tmp_rotno( MAX_CHI );
	FArray1D_float tmp_chi( MAX_CHI );
	FArray1D_float tmp_sd( MAX_CHI );

	int countrot = 0;
	float perctot = 0.0;
	int aan = -1;

	int n1,n14;
	float p14,s14,p24,s24;


	psi = 0;
	phi = 0;
	perc = 0.9999;

	for ( int i = 1; i <= 20; ++i ) {
		for ( int j = 1; j <= max_vrot_count; ++j ) {
			vdun_perc(i,j)=0.0;
			for ( int k = 1; k <= MAX_CHI; ++k ) {
				vdun_chi(i,j,k) = 0.0;
				vdun_sd(i,j,k) = 0.0;
				vdun_group_rotno_to_rotno(i,j,k) = 0;
			}
		}
	}

	for ( int i = 1; i <= 20; ++i ) {
		vdun_count(i) = 0;
	}

//bk read through header
	std::string three( 3, ' ' );
	std::string prethree( 3, ' ' );
	countrot = 0;
	utility::io::izstream & bbind_stream( open_data_file( bbind_rot_file ) );
	while ( ( bbind_stream ) && ( three != "ARG" ) ) {
		bbind_stream >>
		 bite( three ) >>
		 bite( 2, tmp_rotno(1) ) >>
		 bite( 2, tmp_rotno(2) ) >>
		 bite( 2, tmp_rotno(3) ) >>
		 bite( 2, tmp_rotno(4) ) >>
		 bite( 7, n1 ) >>
		 bite( 7, n14 ) >> skip( 1 ) >>
		 bite( 7, p14 ) >>
		 bite( 7, s14 ) >>
		 bite( 8, p24 ) >>
		 bite( 7, s24 ) >>
		 bite( 7, tmp_chi(1) ) >>
		 bite( 5, tmp_sd(1) ) >>
		 bite( 9, tmp_chi(2) ) >>
		 bite( 5, tmp_sd(2) ) >>
		 bite( 9, tmp_chi(3) ) >>
		 bite( 5, tmp_sd(3) ) >>
		 bite( 9, tmp_chi(4) ) >>
		 bite( 5, tmp_sd(4) ) >> skip;
		if ( bbind_stream.eof() ) {
			// Fall through
		} else if ( bbind_stream.fail() ) { // Continue
			bbind_stream.clear();
		}
	}

	while ( bbind_stream ) {
L27:
		bbind_stream >>
		 bite( three ) >>
		 bite( 2, tmp_rotno(1) ) >>
		 bite( 2, tmp_rotno(2) ) >>
		 bite( 2, tmp_rotno(3) ) >>
		 bite( 2, tmp_rotno(4) ) >>
		 bite( 7, n1 ) >>
		 bite( 7, n14 ) >> skip( 1 ) >>
		 bite( 7, p14 ) >>
		 bite( 7, s14 ) >>
		 bite( 8, p24 ) >>
		 bite( 7, s24 ) >>
		 bite( 7, tmp_chi(1) ) >>
		 bite( 5, tmp_sd(1) ) >>
		 bite( 9, tmp_chi(2) ) >>
		 bite( 5, tmp_sd(2) ) >>
		 bite( 9, tmp_chi(3) ) >>
		 bite( 5, tmp_sd(3) ) >>
		 bite( 9, tmp_chi(4) ) >>
		 bite( 5, tmp_sd(4) ) >> skip;
		if ( bbind_stream.eof() ) {
			goto L26;
		} else if ( bbind_stream.fail() ) {
			// Fall through
		}
		if ( three == "   " ) goto L27;
		if ( p14 < vrot_perc ) goto L27;

		if ( three != prethree ) {
			num_from_name( prethree, aan );
			if ( countrot != 0) vdun_count(aan) = countrot-1;
			num_from_name( three, aan );
			countrot = 1;
			prethree = three;
		}

		vdun_perc(aan,countrot) = p14;
		for ( int i = 1; i <= 4; ++i ) {
			vdun_chi(aan,countrot,i) = tmp_chi(i);
			vdun_sd(aan,countrot,i) = tmp_sd(i);
			vdun_group_rotno_to_rotno(aan,countrot,i) = tmp_rotno(i);
		}

		++countrot;


//$$$         packed_rotno = aa_rotno_to_packedrotno(aan,tmp_rotno(1),
//$$$     #        tmp_rotno(2),tmp_rotno(3),tmp_rotno(4))
//$$$
//$$$         do i=1,4
//$$$            dun_chi(phi,psi,packed_rotno,i) = tmp_chi(i)
//$$$            dun_sd(phi,psi,packed_rotno,i) = tmp_sd(i)
//$$$            dun_group_rotno_to_rotno(phi,psi,aan,countrot,i) = tmp_rotno(i)
//$$$         enddo
//$$$
//$$$         dun_prob(phi,psi,packed_rotno) = perc
//$$$
//$$$         perctot = perctot+perc
//$$$         countrot=countrot+1
//$$$
		if ( runlevel >= verbose) std::cerr << /* 76 */
		 three <<
		 I( 2, tmp_rotno(1) ) <<
		 I( 2, tmp_rotno(2) ) <<
		 I( 2, tmp_rotno(3) ) <<
		 I( 2, tmp_rotno(4) ) <<
		 I( 7, n1 ) <<
		 I( 7, n14 ) << space( 1 ) <<
		 F( 7, 2, p14 ) <<
		 F( 7, 2, s14 ) <<
		 F( 8, 2, p24 ) <<
		 F( 7, 2, s24 ) <<
		 F( 7, 1, tmp_chi(1) ) <<
		 F( 5, 1, tmp_sd(1) ) <<
		 F( 9, 1, tmp_chi(2) ) <<
		 F( 5, 1, tmp_sd(2) ) <<
		 F( 9, 1, tmp_chi(3) ) <<
		 F( 5, 1, tmp_sd(3) ) <<
		 F( 9, 1, tmp_chi(4) ) <<
		 F( 5, 1, tmp_sd(4)  ) <<
		 F( 5, 1, perc ) <<
		 F( 5, 1, perctot ) <<
		 I( 4, countrot ) <<
		 I( 4, packed_rotno ) <<
		 "\n";

	}

L26:
	bbind_stream.close();
	bbind_stream.clear();

}


////////////////////////////////////////////////////////////////////////////////
/// @begin output_fullcoord_vpdb
///
/// @brief
///  output coordinate of inverse rotamer tree
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Lin Jiang
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
output_fullcoord_vpdb( utility::io::orstream & iunit )
{
	using namespace enzyme;
	using namespace param;

	if ( !enzyme_vrot ) return;

	FArray1D_int vres_variant( vrot_counts );
	FArray1D_int vdom_end( MAX_SEGMENTS );
	FArray2D_float vocc( MAX_ATOM()(), vrot_counts );
	FArray2D_float vbval( MAX_ATOM()(), vrot_counts );
	int vdoms;

	for ( int i = 1, max_atom = MAX_ATOM(); i <= vrot_counts; ++i ) {
	  vres_variant(i) = 1;
	  for ( int j = 1; j <= max_atom; ++j ) {
	    make_pdb_ns::occupancy(j,i) = vrotres(i);
	    make_pdb_ns::bfactor(j,i) = vrot_repE(i);
	  }
	}
	vdom_end(1) = vrot_counts;
	vdoms = 1;

	output_fullatom_pdb(vrotcoord,vrotaa,vres_variant, vrot_counts,'V',vdoms,
	 vdom_end,iunit);
}

// =============================================================================
//     Detect possible covalant bond between hetero atom and virtual atom
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin
///
/// @brief
///     Detect possible covalant bond between hetero atom and virtual atom
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors mj
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
detect_virtual_atom_covalent_bond(Ligand & molecule)
{
	using namespace ligand;
	using namespace enzyme;
	using namespace param;
	using namespace aaproperties_pack;

//mj exit if enzyme flag is false
	if ( !get_enzyme_flag() ) return;

//mj local variables
	size_t virt_atom,real_atom;
	int closest;
	float max_repE, solvE, atrE, repE, d2, min_d;
	float const cp_weight = { 1.0 };
	float const repE_limit = { 1.0 };
	FArray1D_float v_coord(3); //transformed coordinates
	FArray1D_float r_coord(3);
	std::string real_atom_name;
	std::string virt_atom_name;

	//lin	float const repE_limit = { 0.1 };

//loop over all real atoms
	for ( real_atom = 1; real_atom <= molecule.atom_vector.size(); ++real_atom ) {
		if ( !molecule.atom_vector[real_atom-1]->Is_Virtual()) {

			// initialize
			max_repE = -1.0; closest = -1; min_d = -1.0;
			molecule.virtual_atom_bnd( real_atom ) = -1;

			// found real atom => loop over all virtual atoms
			for ( virt_atom = 1; virt_atom <= molecule.atom_vector.size(); ++virt_atom ) {
				if ( molecule.atom_vector[virt_atom-1]->Is_Virtual() ) {

					// compute repulsive energy
					repE = 0;
					copy_to_FArray(molecule.atom_vector[virt_atom-1]->get_coordinates(), v_coord);
					copy_to_FArray(molecule.atom_vector[real_atom-1]->get_coordinates(), r_coord);
					fast_pairenergy(v_coord(1),r_coord(1),
					 atom_type_virt( molecule.atom_vector[virt_atom-1]->get_ros_atom_type() ),molecule.atom_vector[real_atom-1]->get_ros_atom_type(),
					 solvE,atrE,repE,d2,cp_weight);

					// check if clashing
					if ( max_repE < 0 || repE > max_repE ) {
						max_repE = repE;
						closest = virt_atom;
						min_d = d2;
					}
				}
			}

	      // check if closest is covalently bound
			if ( max_repE > repE_limit ) {
				molecule.virtual_atom_bnd( real_atom ) = closest;
				virt_atom_name=molecule.atom_vector[closest-1]->get_atom_name();
				real_atom_name=molecule.atom_vector[real_atom-1]->get_atom_name();
				std::cout << "Potential repulsion detected between virtual atom" << SS( closest )
				 << SS( virt_atom_name ) << " and real hetero atom"
				 << SS( real_atom ) << SS( real_atom_name ) << "\nDistance:"
				 << SS( std::sqrt( min_d ) ) << " repE:" << SS( max_repE ) << "\n"
				 << "=> will not compute interactions between real protein atoms mapped\n"
				 << "   on" << SS( closest ) << SS( virt_atom_name )
				 << " and real hetero atom" << SS( real_atom )
				 << SS( real_atom_name ) << "\n";
			}
		}
	}
}



// =============================================================================
//     Computes mapping of virtual atoms on AA for repacking
// =============================================================================

////////////////////////////////////////////////////////////////////////////////
/// @begin get_sc_ha_virtualE
///
/// @brief
///     Computes mapping of virtual atoms on AA for repacking
///
/// @detailed
///
/// @param  aaid - [in/out]? -
/// @param  aa - [in/out]? -
/// @param  aav - [in/out]? -
/// @param  coord - [in/out]? -
/// @param  elecE - [in/out]? -
/// @param  eval_bb - [in/out]? -
/// @param  eval_sc - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
get_sc_ha_virtualE(
	int const aaid,
	int const aa,
	int const aav,
	FArray2Da_float coord,
	float & virtE,
	bool const eval_bb,
	bool const eval_sc,
	bool const more_score,
	Ligand & ligand
)
{
  using namespace aaproperties_pack;
  using namespace interface;
  using namespace ligand;
  using namespace enzyme;
  using namespace param;
  using namespace param_aa;
  using namespace runlevel_ns;
  using namespace numeric::constants::f;

//mj function body
	virtE = 0.0;

//mj exit if enzyme flag is false
	if ( !get_enzyme_flag() ) return;
	if ( ! get_ligand_flag() || ligand.atom_vector.empty() ) return;
	if (( ! int_res(aaid) || ligand.virtual_atom_count == 0 )&& !enzyme_vrot) return;

	coord.dimension( 3, MAX_ATOM() );

//mj local variables
	int start_id, end_id, he_type, min_aaid, min_atom;
	float d, min_d, E;
	float d_cutoff;
	FArray1D_float het_coord(3);
	std::string het_name;
//additional term for virtual energy
	float const Emin_cutoff = { -8.0 };
	float const E_kvalue = { 5.0 };

//lin pass the value to  d_cutoff
	d_cutoff = lig_virE_dmax;
	int hetatom_id=1;
	for ( ligand::Atom_Itr i = ligand.atom_vector.begin();
		i!=ligand.atom_vector.end();
		++i) {

// start loop over all hetero atoms
		he_type = (*i)->get_ros_atom_type() - MAX_REALTYPES();
		if ( he_type > 0 ) {

			//mj compute first and last atom to use depending on eval_bb and eval_sc
	      if ( eval_bb ) {
				start_id = 1;
			} else {
				start_id = 5;
			}

			if ( eval_sc ) {
				end_id = natoms(aa,aav);
			} else {
				end_id = 4;
			}

			//mj compute interactions
			min_d = -1.0; min_aaid = -1; min_atom = -1;
			ligand.virtual_atom_map( hetatom_id ) = -1;
			for ( int atom = start_id; atom <= end_id; ++atom ) { // start atom loop
				if ( map_virtual_real( he_type, atom, aa, aav ) ) {
					copy_to_FArray((*i)->get_coordinates(), het_coord);
					distance_bk( het_coord(1), coord(1,atom), d );
					if ( min_d < 0.0 || d <= min_d ) {
						min_d = d;
						min_aaid = aaid;
						min_atom = atom;
					}
				}
			}                                            // end heavy atom loop
			if ( min_d >= 0.0 && min_d <= d_cutoff ) {
				E = 0.5 * ( -std::cos( min_d / d_cutoff * pi ) - 1.0 );
				virtE += E;
				ligand.virtual_atom_map( hetatom_id ) = min_atom;

				//lin using more constraints on covanlently bonded virtual atom
				//lin or when exact match vatom is used
				if ( more_score && ( ligand.virtual_atom_bnd( hetatom_id ) == 0 || exact_match_vatom)) {
					E = Emin_cutoff * std::exp( -E_kvalue * min_d/d_cutoff);
					virtE += E;
				}

				if ( runlevel >= verbose ){
				 het_name=(*i)->get_atom_name();
				 std::cout << "mapped hetero atom" << SS( hetatom_id )
				 << SS( het_name ) << " to amino acid "
				 << min_aaid << " atom " << min_atom << " with distance " << min_d
				 << " and energy: " << SS( E ) << "\n";
				}
			}
		}                         // end check atom aa distance
	hetatom_id++;
	}                            // end loop over all hetero atoms
}


// =============================================================================
//    checks whether a given virt_type matches a given atom in an amino acid
// =============================================================================
//////////////////////////////////////////////////////////////////////////////
/// @begin
///
/// @brief
///    checks whether a given virt_type matches a given atom in an amino acid
///
/// @detailed
///
/// @param  he_type - [in/out]? -
/// @param  atom - [in/out]? -
/// @param  aa - [in/out]? -
/// @param  aav - [in/out]? -
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
bool
map_virtual_real(
	int const he_type,
	int const atom,
	int const aa,
	int const aav
)
{
	using namespace aaproperties_pack;
	using namespace param_aa;

	int fa_type( fullatom_type( atom, aa, aav ) );

	switch( he_type ) {

	case  1:
		if ( aa == aa_glu && atom ==  8 ) return true; // GLU OE
		if ( aa == aa_glu && atom ==  9 ) return true; // GLU OE
		if ( aa == aa_asp && atom ==  7 ) return true; // ASP OD
		if ( aa == aa_asp && atom ==  8 ) return true; // ASP OD
		return false;

	case  2:
		if ( aa == aa_glu && atom ==  6 ) return true; // GLU CD
		if ( aa == aa_asp && atom ==  5 ) return true; // ASP CG
		return false;

	case  3:
		if ( aa == aa_gln && atom ==  8 ) return true; // GLN OE
		if ( aa == aa_asn && atom ==  7 ) return true; // ASN OD
		if (                 atom ==  4 ) return true; // BB O=C<
		return false;

	case  4:
		if ( aa == aa_gln && atom ==  9 ) return true; // GLN NE
		if ( aa == aa_asn && atom ==  8 ) return true; // ASN ND
		if (                 atom ==  1 ) return true; // BB >N-H
		return false;

	case  5:
		if ( aa == aa_gln && atom ==  7 ) return true; // GLN CD
		if ( aa == aa_asn && atom ==  6 ) return true; // ASN CG
		if (                 atom ==  3 ) return true; // BB >C=O
		return false;

	case  6:
		if ( aa == aa_ser && atom ==  6 ) return true; // SER OG
		return false;

	case  7:
		if ( aa == aa_ser && atom ==  5 ) return true; // SER CB
		return false;

	case  8:
		if ( aa == aa_cys && atom ==  6 ) return true; // CYS SG
		return false;

	case  9:
		if ( aa == aa_cys && atom ==  5 ) return true; // CYS CB
		return false;

	case 10:
		if ( aa == aa_arg && atom == 11 ) return true; // ARG NH
		if ( aa == aa_arg && atom == 10 ) return true; // ARG NH
		return false;

	case 11:
		if ( aa == aa_arg && atom ==  8 ) return true; // ARG NE
		return false;

	case 12:
		if ( aa == aa_lys && atom ==  9 ) return true; // LYS NZ
		return false;

	case 13:
		if ( aa == aa_lys && atom ==  8 ) return true; // LYS CE
		return false;

	case 14:
		if ( aa == aa_his && atom ==  7 ) return true; // HIS ND
		return false;

	case 15:
		if ( aa == aa_his && atom == 10 ) return true; // HIS NE
		return false;

	case 16:
		if ( aa == aa_his && atom ==  5 ) return true; // HIS CB
		return false;

	case 17:
		if ( fa_type == 22 || fa_type == 25 ) return true;// HPOL
		return false;

	default: return false;
	}

	return false;
}

// =============================================================================
//    checks whether a real hetero atom and an atom in an amino acid
//    should be excluded
//    this function does only work properly if called after get_sc_ha_virtualE()
//    for respective aminoa acid
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin
///
/// @brief
///    checks whether a real hetero atom and an atom in an amino acid
///    should be excluded
///
/// @detailed
///    this function does only work properly if called after get_sc_ha_virtualE()
///    for respective aminoa acid
///
/// @param  hetatom_id - [in/out]? -
/// @param  atom - [in/out]? -
/// @param  aa - [in/out]? -
/// @param  aav - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
bool
exclude_interaction(
	int const hetatom_id,
	int const atom,
	int const aa,
	int const aav
)
{
	using namespace ligand;
	using namespace aaproperties_pack;
	using namespace param;
	using namespace water;

	if( !get_ligand_flag() || !get_enzyme_flag() ) return false ;

	//lin check whether hydrogen is a bonded neighbour of atom (atom,aa,aav)
	//lin which mapped by the virtual atom covalently bonded to real hetero
	//lin atoms,
	//lin => return true
	//lin this is a temporary treatment. Finally, if protein heavy atom covallently
	//lin bonds to ligand, the hydrogen attached to this heavy atom should not
	//lin exist any more.
	if ( atom > nheavyatoms(aa,aav) &&  fullatom_type( atom,aa,aav) != type_h2o ) { // is hydrogen or not
		for ( size_t vir_atom = 1; vir_atom <= ligand::ligand_one->atom_vector.size(); ++vir_atom ) {
			if ( ligand::ligand_one->atom_vector[vir_atom-1]->Is_Virtual()  &&
					 ligand::ligand_one->virtual_atom_map(vir_atom) > -1 ) {
				for ( int bnd = 1; bnd <= nbonded_neighbors(atom, aa, aav); ++bnd )
					if ( ligand::ligand_one->virtual_atom_map( vir_atom) ==
							bonded_neighbor(bnd, atom, aa, aav ) ) return true;
			}
		}
	}

	// check whether real hetero atom was within repulsion radius of any virtual atom, if not
	// => return false
	if ( ligand::ligand_one->virtual_atom_bnd( hetatom_id ) == -1 || ligand::ligand_one->virtual_atom_bnd( hetatom_id ) == 0)
		return false;

	// check whether virtual atom was directly mapped on (atom,aa,aav)
	// return true
	if ( ligand::ligand_one->virtual_atom_map( ligand::ligand_one->virtual_atom_bnd( hetatom_id ) ) == atom )
		return true;

	// check whether virtual atom was mapped onto a bonded neighbour of (atom,aa,aav)
	// => return true
	for ( int bnd = 1; bnd <= nbonded_neighbors(atom, aa, aav); ++bnd )
		if ( ligand::ligand_one->virtual_atom_map( ligand::ligand_one->virtual_atom_bnd( hetatom_id ) )
				== bonded_neighbor(bnd, atom, aa, aav ) )
			return true;

	// return false
	// => return false
	return false;
}

///////////////////////////////////////////////////////////////////////////////
//
// cst_mode
// ( new version of enzyme design )
// use input constraints to do design and pose minimization
//
// Lin Jiang
//
// input constraint from two format:
//             single line format: "-cst_from_file <file>"
//             complicate format:  "-cstfile <file>"
//             enzyme cst format:  "-read_enzyme_cst <file>"
//				in the above three options,
//				   if file is empty, read from the starting structure
//				   if file == "auto", read from the ***.cst
//
//   -enable_ligand_aa   turn on the ligaa which treat ligand as a new
//                       amino acid type as a replacement of ligand mode,
//                       indicating that rosetta should assign slightly larger
//                       values to MAX_AA and MAX_ATOM.
//                       Therefor, nothing is special for ligand during
//                       the energy calculation, expect the initial setup for
//                       new amino acid type.
//
//  submode:
//    cst_score            score the input structure with input constraints
//    cst_opt              optimize the catalytic site
//    cst_loop             loop refinement with input constraints
//    cst_design           design by defined design_matrix with input constraints
//    cst_min              pose type minimization with input constraints
//       if no constraint read successfully, the submode will be running without constriants,
//       it means, go to the normal score, design, minimizing and etc.
//       Also, among the above submode, you can run it by combining several flags
//
//  define the interface:
//    design_residues array define design regions
//    repack_residues array define repack regions and allow_move regions when minimizing
//
//  weight_set:
//    specify scoring weight set from file: "-score_wtsfile <default.weight_set>"
//    specify packer weight set from file: "-packer_wtsfile <default.weight_set>"
//
//
//////////////////////////////////////////////////////////////////////////////
//lin set cst_mode flag
void
set_cst_mode_flag( bool setting )
{
	using namespace enzyme;

	enable_cst_mode = setting;

	static bool init = { false };

	if( enable_cst_mode ) {
		if ( !init ) {
			init = true;

			//lin read the options of cst_mode
			cst_mode_options();

		}
	}
}

//////////////////////////////////////////////////////////////////////////////
//lin get cst_mode flag
bool
get_cst_mode_flag( )
{
	using namespace enzyme;

	return enable_cst_mode;

}

//////////////////////////////////////////////////////////////////////////////
//lin get options
void
cst_mode_options() {

  using namespace enzyme;
	using namespace docking;
	using namespace files_paths;

	if( !get_cst_mode_flag() ) return;

	//lin check overwrite
  check_finished = truefalseoption("check_finish") && !overwrite_pdbs ;

	//lin pdb out
	use_pdbout = truefalseoption("pdbout") ;
	pdboutname = "";
	if( use_pdbout ) stringafteroption( "pdbout", "des", pdboutname );

	//lin ndrun
	intafteroption("ndruns",1,design::design_commands::ndruns);

	//lin redirect to logfile
	use_log_file = truefalseoption("log_file") ;
	log_file_name = "";
	if( use_log_file ) log_file_name = stringafteroption("log_file");

	//lin output_structures
	dump_structures = runlevel_ns::benchmark || truefalseoption("dump_structures");

	//lin ndruns
	intafteroption("nstruct",1,ndruns);
	iterative_run=truefalseoption("iterative_run");//do iterative run with ndruns

	//lin debugging
	safety_check = runlevel_ns::benchmark || truefalseoption("debug_output");
	if( safety_check ) {
		cst_set_ns::debug_output = true;
	}

	//lin set up constraint
	complex_cstfile = truefalseoption("cstfile") ;
	if( complex_cstfile ) {
		cstfile_name = stringafteroption("cstfile");
	}
	read_enzyme_cst = truefalseoption("read_enzyme_cst") ;
	if( read_enzyme_cst ) {
		enzymecst_name = stringafteroption("read_enzyme_cst");
	}
	single_line_cst = truefalseoption("cst_from_file") ;
	if( single_line_cst ) {
		singlecst_name = stringafteroption("cst_from_file");
	}
	read_old_header = truefalseoption("read_old_header") ;

	//lin if take the covalent bond info from cst file "is_covalent"
	//lin otherwise calculation it
	//lin default: true if read_enzyme_cst
	//lin          false if ! read_enzyme_cst
	if( read_enzyme_cst ) {
		covalent_from_cstfile = truefalseoption("covalent_from_cstfile");
	} else {
		covalent_from_cstfile = ! truefalseoption("detect_covalent_bond") ;
	}

	//lin submode
	cst_conformer = truefalseoption("cst_conformer");
	cst_dockpert = truefalseoption("cst_dockpert") ; //perturb the ligand
	cst_score  = truefalseoption("cst_score") ; //score with input cst
	cst_opt    = truefalseoption("cst_opt") ;   //optimize the cst
	cst_design = truefalseoption("cst_design") ;//design with input cst
	cst_min    = truefalseoption("cst_min") ;   //pose minimization with input cst
  cst_loop   = truefalseoption("cst_loop") ; // loop refinement with input cst and ligand

	//lin define ligand interface
	{
		design_cut_1 = 8.0;
		design_cut_2 = 8.0;
		repack_cut_1 = 12.0;
		repack_cut_2 = 12.0;

		short_interface = truefalseoption( "short_interface" );
		if( short_interface ) {
			realafteroption( "cut1", 5.0, design_cut_1 );
			realafteroption( "cut2", 7.0, design_cut_2 );
			realafteroption( "cut3", 11.0, repack_cut_1 );
			realafteroption( "cut4", 12.0,repack_cut_2 );
		} else if ( cst_dockpert ) {
			short_interface=true;
			design_cut_1=0.0; design_cut_2=0.0; repack_cut_1=8.0; repack_cut_2=8.0;
		}
	}

	//lin allow move for pose minimizing
	if( cst_min || cst_opt ) {
		intafteroption( "cst_min_cycles", 1, cst_min_cycles );

		bb_move = truefalseoption("bb_move");
		chi_move = truefalseoption("chi_move");
		rb_move	= truefalseoption("rb_move");
		fix_lig2 = truefalseoption("fix_lig2");

		//lin additional pose.constraint setup and pose_allow_move to tether the ligand
		if( get_enable_ligaa_flag() ) {
			minimize_ligaa_bonds = truefalseoption("bonds");   //minimize_ligand_bonds
			minimize_ligaa_angles = truefalseoption("angles");  //minimize_ligand_angles
			minimize_ligaa_torsions	=	truefalseoption("torsions"); //minimize_ligand_torsions
		}
	}

	//lin optimize the cst residues

	//lin cst_conformer
	if( cst_conformer ) attach_ligaa_by_jump = false;
	//lin end

	//lin limit the perturbation from cst_opt, cst_conformer, cst_dockpert
	limit_perturb = truefalseoption("limit_perturb");
	if( limit_perturb ) {
		realafteroption("repE_limit",10.0,repE_limit);
		realafteroption("cstE_limit",50.0,cstE_limit);
		if( bb_move ) {
			realafteroption("chainbreakE_limit",3.0,chainbreakE_limit);
		}
		crop_pocket=true;
	}

	//lin cst opt
	if( cst_opt ) crop_pocket = true ;

	//lin perturb the ligand
	if( cst_dockpert ) {
		real2afteroption("cst_dockpert",1.0,normal_perturbation,
										 8.0,rotational_perturbation);
	}

	//lin crop the pocket to crop_aa ( poly_ala or poly_gly )
	if( crop_pocket ) {
		if( truefalseoption("poly_ala") ) {
			crop_aa = param_aa::aa_ala;
		} else {
			crop_aa = param_aa::aa_gly;
		}
	}

	//lin get design options
	if( cst_design ) {
		using namespace favor_residue;
		using namespace design;
		//lin give native residues a bonus so that less residues are mutated
		favor_native_residue = truefalseoption("favor_native_residue");
		if (favor_native_residue) {
			realafteroption("favor_native_residue",-1.5,native_bonus);
			std::cout << "favor_native_residue set to true and native_bonus set to " << native_bonus
								<< " as requested by the -favor_native_residue flag " << "\n";
		}

		if ( truefalseoption( "dump_rotamers_pdb" ) ) {
			active_rotamer_options.dump_rotamers_pdb_flag = true;
			intafteroption( "dump_rotamers_pdb", 0, active_rotamer_options.dump_rotamers_pdb_res );
		}
	}

	//lin fix the aa in the catalytic positions
	fix_cstaa = truefalseoption("fix_catalytic_aa") ;

	//lin setup score weight set
	use_score_wtsfile = truefalseoption("score_wtsfile");

  //lin setup score weight set
  use_packer_wtsfile = truefalseoption("packer_wtsfile");

	//lin cst_min and cst_score: if zero the constraint sd
	keep_constraint_sd = !truefalseoption( "zero_constraint_sd" );

	//lin use loop file to define the bb move region
	use_loop_file = truefalseoption("loop_file");
	if( use_loop_file ) {
		loop_filename = stringafteroption("loop_file");
	}

	//lin set the linmem_ig
	if( !truefalseoption("no_linmem_ig") ){
		pack::linmem_ig = true;
		pack::dynamically_decide_between_lazy_and_precomputed = false;
	}

}

//////////////////////////////////////////////////////////////////////////////
//lin main function
void
cst_mode_test( pose_ns::Pose & pose, std::string & outpdbname )
{
  // using
	using namespace cst_allow_move_ns;
  using namespace cst_set_ns;
  using namespace cst_countpair_ns;
  using namespace cst_descriptor_ns;
  using namespace packer_cst_ns;

  //function param
	Packer_cst_set packer_cst; //lin constraint for packer
	Cst_set pose_cst; //lin constraint for pose minimization
	Allow_move_set allow_move; //lin set of allow_move
  cst_set_descriptor csts;   //lin cst class for handling the input and output

	//lin read the options
	cst_mode_options();

	//lin run
	cst_mode_test( outpdbname, pose, pose_cst, packer_cst, csts, allow_move );

}

//////////////////////////////////////////////////////////////////////////////
//lin main function
void
cst_mode_test( std::string const & inputpdbname, std::string & outpdbname )
{

  using namespace enzyme;
  using namespace pose_ns;
	using namespace cst_allow_move_ns;
  using namespace cst_set_ns;
  using namespace cst_countpair_ns;
  using namespace cst_descriptor_ns;
  using namespace packer_cst_ns;

  //function param
	Pose pose;
	Packer_cst_set packer_cst; //lin constraint for packer
	Cst_set pose_cst; //lin constraint for pose minimization
	Allow_move_set allow_move; //lin set of allow_move
  cst_set_descriptor csts;   //lin cst class for handling the input and output

	//lin set the cst_mode flag and get the cst_mode option
	set_cst_mode_flag( true );

  //lin initialize pose, -read pose from pdb
  bool const fullatom( true );
	bool const ideal_pose( false );
	if( scaffold_from_misc ) {
		pose_from_misc( pose, fullatom, ideal_pose, true );
	}	else {
		pose_from_pdb( pose, inputpdbname, fullatom, ideal_pose, true );
	}

	//lin read the ligaa
	//already been read from pose_from_pdb

	//lin reading and set up all classes
	cst_mode_io( inputpdbname, pose, pose_cst, packer_cst, csts, allow_move );

	//lin run
	cst_mode_test( outpdbname, pose, pose_cst, packer_cst, csts, allow_move );

}

//lin reading and set up all classes
void cst_mode_io(
  std::string const & inputname,
  pose_ns::Pose & pose,
  cst_set_ns::Cst_set & pose_cst,
	packer_cst_ns::Packer_cst_set & packer_cst,
	cst_descriptor_ns::cst_set_descriptor & csts,
  cst_allow_move_ns::Allow_move_set & allow_move) {

  using namespace cst_countpair_ns;
  using namespace cst_descriptor_ns;
  using namespace enzyme;

  std::string filename;

  //lin initialize covalent bond
	covalent_bonds.clear();

	//lin reset the cst class
	pose_cst.erase_atom_constraints();
	packer_cst.clear();
	csts.erase();
	allow_move.erase();

	//lin set up constraint
	if( complex_cstfile || read_enzyme_cst || single_line_cst ) {

		//lin read cst constaints for packer and pose_min
		if( complex_cstfile ){
			csts.read_cstfile( get_filename( cstfile_name, inputname ) );
			csts.read_enzyme_constraint( get_filename( cstfile_name, inputname ) );
		}

		//lin add the constraints from enzyme constraints
		//lin only for compatiable with the old format
		if( read_enzyme_cst ){
			csts.read_enzyme_constraint( get_filename( enzymecst_name, inputname ) );
		}

		//lin read the catalytic map from header
		if( read_old_header ) {
			csts.read_old_catalytic_map( inputname );
		} else {
			csts.read_catalytic_map( inputname );
		}

		//lin clean up the cst and fill the allow_move and packer_cst
		if( complex_cstfile || read_enzyme_cst ) {
			//lin clean up the constraint
			csts.cleanup( pose.total_residue() );

			//lin get packer constraints set from cst_descriptor
			csts.fill_cst_allow_move_set( packer_cst, allow_move );
		}

		//lin setup a constraint, allow move and covalent bond
		//lin from the simple format
		if( complex_cstfile ) {
			cst_from_file( get_filename( cstfile_name, inputname ),
										 pose, pose_cst, packer_cst, allow_move );
		}
		if( single_line_cst ) {
			cst_from_file( get_filename( singlecst_name, inputname ),
										 pose, pose_cst, packer_cst, allow_move );
		}

		//lin cleanup packer_cst for efficiency
		//std::cout << packer_cst;
		packer_cst.clean_up();

		//lin debug output
		if( safety_check ){
			std::cout << csts << "\n";
			std::cout << packer_cst;
			std::cout << allow_move;
		}
	}

	//lin setup the resfile name if auto_resfile
	if( design::auto_resfile ) {
		std::string pdbfile ( inputname );
		if ( has_suffix( pdbfile, ".pdb" ) ) pdbfile.erase( pdbfile.length() - 4 );
		files_paths::resfile = pdbfile + ".resfile";
	}

}

//lin main function call with ndruns, plus setup the ligand and cst
void cst_mode_test(
	std::string const & outname,
  pose_ns::Pose & pose,
  cst_set_ns::Cst_set & pose_cst,
	packer_cst_ns::Packer_cst_set & packer_cst,
	cst_descriptor_ns::cst_set_descriptor & csts,
  cst_allow_move_ns::Allow_move_set & allow_move	) {

	using namespace enzyme;
	using namespace cst_allow_move_ns;
  using namespace cst_set_ns;
  using namespace cst_countpair_ns;
  using namespace cst_descriptor_ns;
	using namespace design;
	using namespace enable_ligaa_ns;
	using namespace files_paths;
	using namespace kin;
  using namespace packer_cst_ns;
	using namespace param;
	using namespace param_aa;
	using namespace pose_ns;

	//lin param for ligand aa when using pose_min
	//FArray2D_float lig_coord( 3, MAX_ATOM()() );	//ligand coord
	int lig_rsd( 1 );	// ligand rsd
	//lin anchor atoms informations
	int anchor_atomno(1);
	int anchor_rsd(1);
	int lig_root_atomno( 1 );

	//lin out pdb name
	std::string outpdbname ( outname );

	//lin redirect the std::cout to file
	std::ofstream file;
	std::streambuf* old_buffer=NULL;
	std::string filename;
	if( use_log_file ){
		if( log_file_name == "auto" ) {
			filename = outpdbname + ".log";
		} else {
			filename = pdb_out_path + log_file_name;
		}
		file.open( filename.c_str() );
		// replace the buffer in cout, remember the old one.
		old_buffer = std::cout.rdbuf( file.rdbuf() );
	}

  //lin read resfile
  PackerTask Task( pose );
  if( files_paths::resfile != "none" ) {
    FArray1D_bool allow_repack( MAX_RES()(), true );
    Task.set_allow_repack(allow_repack);
    Task.load_resfile();
  }

	//lin redefine the fold tree
	if( pose.pdb_info().multi_chain() ) {
		// find closest C-alpha between two partners
		using numeric::xyzVector_float;
		float min_d( 1000.0f );
		int anchor1_rsd(0), anchor2_rsd(0);

		for ( int i=docking::docking_query::part_begin(1); i<= docking::docking_query::part_end(1); ++i ) {
			for ( int j=docking::docking_query::part_begin(2); j<= docking::docking_query::part_end(2); ++j ) {
				float const d = distance( xyzVector_float( &(pose.full_coord()(1,2,i))),
																	xyzVector_float( &(pose.full_coord()(1,2,j))) );
				if ( d<min_d ) {
					min_d = d;
					anchor1_rsd = i;
					anchor2_rsd = j;
				}
			}
		}

		Fold_tree f ( pose.fold_tree() );
		f.new_jump( anchor1_rsd, anchor2_rsd, docking::docking_query::part_end(1) );
		pose.set_fold_tree( f );
		std::cout << "Fold_tree: " << f ;
	}

	if( get_enable_ligaa_flag() ) {
		//lin find the stat constraint to attach ligand
		//lin if csts is empty, attach ligand to the closed ca
		bool attach_by_jump;
		csts.get_ligand_anchor_atoms( pose, param_aa::ligand_aa_vector[1],get_ligaa_icoord( param_aa::ligand_aa_vector[1] ),
															anchor_atomno, anchor_rsd, lig_root_atomno, attach_by_jump );

		//lin add ligand to the pose
		pose.attach_ligand( param_aa::ligand_aa_vector[1], 1 /* aav */, anchor_atomno, anchor_rsd,
											lig_root_atomno, get_ligaa_icoord( param_aa::ligand_aa_vector[1] ), attach_by_jump );
		lig_rsd = pose.total_residue() ;// ligand rsd

		if( read_lig2 ) {
			csts.get_ligand_anchor_atoms( pose, ligand_aa_vector[2], get_ligaa_icoord( ligand_aa_vector[2] ),
															anchor_atomno, anchor_rsd, lig_root_atomno, attach_by_jump );
			//lin add ligand to the pose
			pose.attach_ligand( ligand_aa_vector[2], 1 /* aav */, anchor_atomno, anchor_rsd,
											lig_root_atomno, get_ligaa_icoord( ligand_aa_vector[2] ), attach_by_jump );
			lig_rsd = pose.total_residue() ;// ligand rsd
		}

	}	else {
		// now build the atom_tree
		pose.setup_atom_tree();
	}

	//make sure turn off the ligand flag
	set_ligand_flag(false);
	//lin after this, we use the pose atom_tree representation

	//lin get the current pose cst
	packer_cst.get_cst_set( pose, pose_cst, keep_constraint_sd, single_line_cst );

	//lin define a loop to guide pose to reset the fold tree
	pose_ns::Loops loops;
	if( use_loop_file ) {//loop from file
		loops.read_loops_from_file( loop_filename );
	}

	//lin define the repack and design region
  FArray1D_bool repack_residues( pose.total_residue(), false );
  FArray1D_bool design_residues( pose.total_residue(), false );
	cst_mode_detect_repack_design_regions( pose, Task, loops, csts,
																				 design_residues,
																				 repack_residues );

	//lin allow move for pose minimizing
	{
		//lin initialize pose allow move
		pose.set_allow_move( ALL, false );

		//jumping: rigid-body degrees of freedom between ligand and protein
		pose.set_allow_jump_move( rb_move );
		if( read_lig2 ) pose.set_allow_jump_move( 2,!fix_lig2 );
	}

	//lin setup packer weight set
	PackerWeights design_weight;
	{
		if( param_pack::packer_logical::soft_rep_design ) {
			design_weight=RetrieveWeights( PW_SOFT_REP_DESIGN ); //default the PW_STANDARD
		} else {
			design_weight=RetrieveWeights( PW_STANDARD ); //default the PW_STANDARD
		}

		//lin input: design_matrix define the designed sequence profile
		//lin input: weight set take the standard packer weights
		//lin input:            or take from the file if the file exist
		if( use_packer_wtsfile ) {
		  design_weight.read_weight_file(stringafteroption("packer_wtsfile"));
		}
	}

	//lin setup score weight set
	Score_weight_map score_weight(score12);
	{
		score_weight.set_weight( KIN_1D_CST, 1.0 ); // the torsion/bond/angle tether
		score_weight.set_weight( KIN_3D_CST, 1.0 ); // the cst Torsion, Angle weight
		score_weight.set_weight( ATOMPAIR_CST, 1.0 ); // the cst destance
// 		score_weight.set_weight( CHAINBREAK_OVERLAP, 1.0 ); //
// 		if( cst_loop || bb_move ) {
// 			score_weight.set_weight( CHAINBREAK, 1.0 ); // CHAINBREAK
// 		}
    //score_weight.set_weight( SASA, 1.0 ); // SASA
    //score_weight.set_weight( SASA_PACK, 1.0); //SASA_PACK

		if( use_score_wtsfile ){
			score_weight.read_weight_file(stringafteroption("score_wtsfile"));
		}
	}

	//lin set up the ligand weight
	if( enzyme::ligand_weight_scale != 1.0f ) {
    set_scale_res_energy_flag( true, true );
		for( int seqpos1=1; seqpos1<=pose.total_residue();seqpos1++ ) {
			if( !param_aa::is_ligand( pose.res(seqpos1) ) ) continue;
			for( int seqpos2=1; seqpos2<=pose.total_residue();seqpos2++ ) {
				if( param_aa::is_ligand( pose.res(seqpos2) ) ) continue;
				scale_res_energy_ns::scale_energy_matrix( seqpos1, seqpos2 ) = true;
				scale_res_energy_ns::scale_energy_matrix( seqpos2, seqpos1 ) = true;
			}
		}
		set_scale_res_energy_weight(ligand_weight_scale);
	}

	//lin additional pose.constraint setup and pose_allow_move to tether the ligand
	if( get_enable_ligaa_flag() ) {
		set_cst_pose_by_rsd( pose, pose_cst, lig_rsd, lig_root_atomno,
												 minimize_ligaa_bonds,   //minimize_ligand_bonds
												 minimize_ligaa_angles,  //minimize_ligand_angles
												 minimize_ligaa_torsions //minimize_ligand_torsions
												 );
	}

	//lin backup pose
	Pose pose_saved;
	pose_saved = pose ;

	//lin functional call
	//lin loop the nstruct
	int ke ;// loop the nstruct
	if( cst_conformer ) {
		ke=allow_move.conformer_counter(pose);
	} else {
		ke=enzyme::cst_mode_flag::ndruns;
	}
	for( int kk=0; kk<ke; kk++ ) {

		//lin update the outname
		if( !runlevel_ns::benchmark ) {
			if( kk!=0 ) {
				outpdbname.erase( outpdbname.length()-5 );
			}
			outpdbname = outpdbname + '_' + lead_zero_string_of( kk+1, NUMBER_MAX_LENGTH ) ;
		}

		//lin output tag
		std::cout<<" cst_mode: output to "<< outpdbname << "*" <<"\n";

		if( kk!=0 && !iterative_run ) pose = pose_saved;//restore the pose if independ run
		//lin function call
		cst_mode_single_run( outpdbname, pose, pose_cst, packer_cst, csts, allow_move,
												 score_weight, Task, design_weight, repack_residues,
												 design_residues, loops );
	}

	//lin and restore the old buffer
	if( use_log_file ){
		std::cout.rdbuf(old_buffer);
		file.close();
	}

}

//lin main function call with single run
void cst_mode_single_run(
	std::string & outpdbname,
	pose_ns::Pose & pose,
	cst_set_ns::Cst_set & pose_cst,
	packer_cst_ns::Packer_cst_set & packer_cst,
	cst_descriptor_ns::cst_set_descriptor & csts,
	cst_allow_move_ns::Allow_move_set & allow_move,
	pose_ns::Score_weight_map & score_weight,
	PackerTask & Task,
	PackerWeights design_weight,
	FArray1D_bool & repack_residues,
	FArray1D_bool & design_residues,
  pose_ns::Loops & loops
	) {

	using namespace enzyme;
	using namespace cst_allow_move_ns;
  using namespace cst_set_ns;
  using namespace cst_countpair_ns;
  using namespace cst_descriptor_ns;
	using namespace design;
	using namespace enable_ligaa_ns;
	using namespace files_paths;
	using namespace kin;
  using namespace packer_cst_ns;
	using namespace param;
	using namespace param_aa;
	using namespace pose_ns;

	//lin local var
  FArray2D_bool design_matrix(  MAX_AUTH_AA, pose.total_residue(), false );

	Score_weight_map opt_cst_weight;
	{
		opt_cst_weight.set_weight( FA_SCOREFXN, 1.0 );
		opt_cst_weight.set_weight( RAMACHANDRAN, 0.2 );
		opt_cst_weight.set_weight( FA_DUN, 1.0 );
		opt_cst_weight.set_weight( FA_REP, 1.0 );
		opt_cst_weight.set_weight( KIN_1D_CST, 1.0 ); // the torsion/bond/angle tether
		opt_cst_weight.set_weight( KIN_3D_CST, 1.0 ); // the cst Torsion, Angle weight
		opt_cst_weight.set_weight( ATOMPAIR_CST, 1.0 ); // the cst destance
// 		opt_cst_weight.set_weight( CHAINBREAK_OVERLAP, 1.0 ); //
// 		if( cst_loop || bb_move ) {
// 			opt_cst_weight.set_weight( CHAINBREAK, 1.0 ); // CHAINBREAK
// 		}
	}

	Score_weight_map only_cst_weight;
	{
		only_cst_weight.set_weight( KIN_1D_CST, 1.0 ); // the torsion/bond/angle tether
		only_cst_weight.set_weight( KIN_3D_CST, 1.0 ); // the cst Torsion, Angle weight
		only_cst_weight.set_weight( ATOMPAIR_CST, 1.0 ); // the cst destance
	}

	// optimize H
	if( !files_paths::no_optH ) {
		std::string pack_mode ("optimizeH");
		std::cout << "optimizing hydrogen positions" << "\n";
		fill_cst_count_pair();
		pack_set_current_pose( pose );
		pack_set_current_cst_set( packer_cst );

		PackerTask OptHTask( pose );
		OptHTask.set_task("optimizeH", false, missingres, false );
		OptHTask.setup_residues_to_vary();

		pack_rotamers( pose, OptHTask );

		pack_reset_current_cst_set();
		pack_reset_current_pose();
		//chu -- bugfix: optmizeH may change aav info as in try_both_his_tautomer case and therefore pose_cst needs to be updated
		packer_cst.get_cst_set( pose, pose_cst, keep_constraint_sd ); //update the pose cst
	}

	//lin start pose
	Pose start_pose;
	start_pose = pose ;
	pose.set_native_pose( start_pose );//set the native pose

#ifdef GL_GRAPHICS
	GRAPHICS_LOG("CST_MODE:: process "+outpdbname+" ... ");
	gl_graphics_clear_trajectory();
	gl_graphics_new_pose();
	protein_graphics::set_show_sc_array(repack_residues);
#endif
#ifdef BOINC_GRAPHICS
	clear_trajectory();
	protein_graphics::set_show_sc_array(repack_residues);
#endif

  //lin begin score the structure with the constraint
  if( cst_score ){
		if( dump_structures ) cst_score_test( pose, pose_cst, csts, score_weight,
										outpdbname + "_score.pdb", safety_check );
  }//lin end score the structure with the constraint

	//lin crop the pocket if cst_opt or cst_dockpert
	if( crop_pocket ) {

		design_matrix = false;
		//lin setup the design_matrix
		//chu 2008-03-25 modify the logic here to allow residues defined in cst_file to change based on resfile definition
		//chu fix_cstaa flag still works as it used to
		for ( int seqpos = 1; seqpos <= pose.total_residue(); ++seqpos ) {
			if ( is_ligand( pose.res(seqpos) ) ) continue;
			if ( csts.is_cstpos(seqpos) ) { // a seqpos defined in the cst_set
				if ( ! enzyme::fix_cstaa ) { // if not to fix_cstaa, allow it to be designed based on resfile and cstfile
					design_matrix(pose.res(seqpos),seqpos)=true;
					//for ( int aa = 1; aa <= MAX_AUTH_AA; ++aa ) {
					//	design_matrix(aa,seqpos) = Task.get_designmap().get(seqpos,aa);
					//}
				}
			} else { // non-cst residues, crop to ALA or GLY accordingly
				if ( design_residues( seqpos ) && start_pose.res(seqpos) != aa_gly && start_pose.res(seqpos) != aa_pro ) {
					design_matrix(crop_aa,seqpos) = true;
				}
			}
		}

		cst_design_test( pose, design_weight, design_matrix, packer_cst, safety_check );
    packer_cst.get_cst_set( pose, pose_cst, keep_constraint_sd ); //update the pose cst

	}

	//lin begin perturb the rb movement of jump (ligand)
	if( cst_dockpert ) {
		int const dock_jump ( 1 );
		int const n2c( 1 );//dir
		if ( dock_jump > pose.num_jump() ) {
			std::cout << "cst_dockpert perturb_rigid_body is not allowed,"
								<< " skip the pertubation "<<"\n";
		} else {
			pose_ns::Jump perturbed_jump( pose.get_jump( dock_jump ) );
			pose_ns::Jump saved_jump = perturbed_jump;
			std::cout << "pose_docking_perturb_rigid_body: trans/rot mag "
								<< docking::normal_perturbation << "/" << docking::rotational_perturbation << "\n";
			//		int const ca( 2 );//atom
			// 		const FArray3D_float & Epos( pose.Eposition() );
			// 		rot_center = &Epos(1,ca,pos1); // ca of jump_pos2
			// 		perturbed_jump.set_rb_center( n2c, Epos(1,1,pos2)/*downstream_jump*/, rot_center );
			int counter (0);
			bool good_perturb (false);
			do {
				counter++;
				perturbed_jump.gaussian_move( n2c, docking::normal_perturbation, docking::rotational_perturbation );
				pose.set_jump( dock_jump, perturbed_jump );
				if( limit_perturb ) {
					float const ratio = { 3.0 };
					pose.new_score_pose();
					pose.set_constraints(pose_cst);
					fill_cst_count_pair(pose);
					pose.score(score_weight);
					float cst_score ( pose.get_0D_score( pose_ns::KIN_3D_CST ) +
														pose.get_0D_score( pose_ns::ATOMPAIR_CST ) );
					float rep_score ( pose.get_0D_score( pose_ns::FA_REP ) );
					if( safety_check ) std::cout<< "pert structure, cst_score "<<cst_score<<" rep_score "
																			<< rep_score << " counter "<< counter <<"\n";
					good_perturb = cst_score < ratio*cstE_limit && rep_score < ratio*repE_limit;
					perturbed_jump=saved_jump;
				}
			} while ( limit_perturb && counter <=500 && !good_perturb );
			if( dump_structures ) cst_score_test( pose, pose_cst, csts, opt_cst_weight,
																						outpdbname + "_dockpert.pdb", safety_check );
		}
	} //lin end perturb the ligand

	//lin conformer
	if( cst_conformer ) {
    //lin update additional pose allow move
    allow_move.set_pose_allow_move( pose );
		allow_move.conformer( pose );
	}// end conformer

	//lin minimize the cropped pocket
	if( cst_opt ) {
		if( truefalseoption("ideal_cst") ) {
			bool cycles_saved = cst_min_cycles;
			cst_min_cycles = 1;
			FArray1D_bool allow_sc( pose.total_residue(), false );//fix the sc
			pose_ns::Loops dum_loops;//no loop
			cst_min_test( allow_sc, dum_loops, pose, pose_cst, allow_move,
										only_cst_weight, safety_check );
			cst_min_cycles = cycles_saved;
			if( dump_structures ) cst_score_test( pose, pose_cst, csts, only_cst_weight,
										outpdbname + "_idealcst.pdb", safety_check );
		}
		//update the design repack arrays
		cst_mode_detect_repack_design_regions( pose, Task, loops, csts,
																					 design_residues, repack_residues );
		cst_min_test( repack_residues, loops, pose, pose_cst, allow_move,
									opt_cst_weight, safety_check );
		std::cout<<pose.show_scores()<<" "<<outpdbname<<" "<<" CSTOPT "<<"\n";
		if( dump_structures ) cst_score_test( pose, pose_cst, csts, opt_cst_weight,
																				outpdbname + "_cstopt.pdb", safety_check );
	}

 	//lin limit the pertubation
	if( limit_perturb ) {
		pose.new_score_pose();
		pose.set_constraints(pose_cst);
		fill_cst_count_pair(pose);
		pose.score(score_weight);
		float cst_score ( pose.get_0D_score( pose_ns::KIN_3D_CST ) +
											pose.get_0D_score( pose_ns::ATOMPAIR_CST ) );
		float rep_score ( pose.get_0D_score( pose_ns::FA_REP ) );
		std::cout<< "limit_perturb: cst_score "<<cst_score<<" rep_score "
							 << rep_score << "\n";
		if( cst_score > cstE_limit || rep_score > repE_limit ) {
			std::cout<< "bad structure and skip it" <<"\n";
			return;
		}
		if( bb_move ) {
			float chainbreak_score ( pose.get_0D_score( pose_ns::CHAINBREAK_CST ) );
			std::cout<< "limit_perturb: chainbreak_score "
								 << chainbreak_score << "\n";
			if( chainbreak_score > chainbreakE_limit ) {
				std::cout<< "bad structure and skip it" <<"\n";
				return;
			}
		}
	}

	//lin copy the cropped sc back to pose
	if( crop_pocket ) {
		//copy the cropped sc back to pose
		const FArray3D_float & full_coord( start_pose.full_coord( ) );
	  for ( int seqpos = 1; seqpos <= pose.total_residue(); ++seqpos ) {
			if ( !csts.is_cstpos(seqpos) && design_residues( seqpos )
					 && start_pose.res(seqpos) != aa_gly && start_pose.res(seqpos) != aa_pro ) {
				pose.copy_sidechain( seqpos, start_pose.res(seqpos),
							start_pose.res_variant(seqpos), full_coord(1,1,seqpos) );
			}
		}
		update_sequence();

		if( dump_structures ) cst_score_test( pose, pose_cst, csts, opt_cst_weight,
																					outpdbname + "_rbmin.pdb", safety_check );

	}//lin end optimize cst

	//sk begin loop minimize with cst
	Fold_tree f_saved( pose.fold_tree() );//lin backup the fold_tree for further cst_min
  if (cst_loop){
		FArray1D_bool cat_pos (pose.total_residue(), false);
		for ( int seqpos = 1; seqpos <= pose.total_residue(); ++seqpos ) {
			if( csts.is_cstpos(seqpos) ) {
				cat_pos(seqpos) = true;
			}
		}
		cst_loop_move( pose, packer_cst, loops, pose_cst, allow_move, cat_pos,safety_check );
		packer_cst.get_cst_set( pose, pose_cst, keep_constraint_sd ); //update the pose cst

		pose.set_fold_tree(f_saved);//restore the fold tree
		if( dump_structures ) cst_score_test( pose, pose_cst, csts, score_weight,
													outpdbname + "_looprefine.pdb", safety_check );

	}//sk end loop minimize with csts

	//lin begin design with input cst
	if( cst_design ) {
		if( resfile != "none" ) {
			design_matrix = false;
			for( int seqpos =1; seqpos <= pose.total_residue(); seqpos++ ) {
				if( is_ligand( pose.res(seqpos) ) ) {
					//lin nothing for design_matrix
				} else if( enzyme::fix_cstaa && csts.is_cstpos(seqpos) ) {
					//chu 2008-03-25 modify the logic here to allow residues defined in cst_file to change based on resfile
					//chu definition. fix_cstaa flag still works as it used to
				} else {
					for ( int aa = 1; aa <= MAX_AUTH_AA; ++aa ) {
						design_matrix(aa,seqpos) = Task.get_designmap().get(seqpos,aa);
					}
				}
			}
		} else {
 			design_matrix = false;
			//lin setup the design_matrix
			for ( int seqpos = 1; seqpos <= pose.total_residue(); ++seqpos ) {
			if( is_ligand( pose.res(seqpos) ) ) {}
				else if( design_residues( seqpos ) ) {
					for ( int aa = 1; aa <= MAX_AUTH_AA; ++aa ) {
						if ( is_protein(aa) || is_nonnatural(aa) ) {
							if ( aa != aa_cys ) {
								design_matrix(aa,seqpos) = true;
							}
						}
					}
				} else if ( repack_residues( seqpos ) ) {
					design_matrix( pose.res(seqpos), seqpos ) = true;
				}
			}
		}

		cst_design_test( pose, design_weight, design_matrix, packer_cst, safety_check );
		packer_cst.get_cst_set( pose, pose_cst, keep_constraint_sd ); //update the pose cst
		if( dump_structures ) cst_score_test( pose, pose_cst, csts, score_weight,
										outpdbname + "_design.pdb", safety_check );
	}//lin end design with input cst

	//lin begin pose minimization with input cst
	if( cst_min ) {
		if( truefalseoption("ideal_cst") ) {
			bool cycles_saved = cst_min_cycles;
			cst_min_cycles = 1;
			FArray1D_bool allow_sc( pose.total_residue(), false );//fix the sc
			pose_ns::Loops dum_loops;//no loop
			cst_min_test( allow_sc, dum_loops, pose, pose_cst, allow_move,
										only_cst_weight, safety_check );
			cst_min_cycles = cycles_saved;
			if( dump_structures ) cst_score_test( pose, pose_cst, csts, only_cst_weight,
										outpdbname + "_idealcst.pdb", safety_check );
		}
		//update the design repack arrays
		cst_mode_detect_repack_design_regions( pose, Task, loops, csts,
																					 design_residues, repack_residues );
		cst_min_test( repack_residues, loops, pose, pose_cst, allow_move,
									score_weight, safety_check );
		if( dump_structures ) cst_score_test( pose, pose_cst, csts, score_weight,
										outpdbname + "_min.pdb", safety_check );
	}//lin end pose minimization with input cst

	//lin output final structure if ! dump_structures
	if( ! dump_structures ) {
		cst_score_test( pose, pose_cst, csts, score_weight,
										outpdbname + ".pdb", safety_check );
	}

}

//lin  score the input structure with input constraints
void
cst_score_test(
  pose_ns::Pose & pose,
  cst_set_ns::Cst_set const & pose_cst,
	cst_descriptor_ns::cst_set_descriptor const & csts,
  pose_ns::Score_weight_map const & score_weight,
  std::string const & output_file,
  bool const safety_check ) {

	using namespace cst_countpair_ns;

	//lin reset the map and nblist, and force to rescore the entire structure
	//lin even if it is not efficient
  pose.new_score_pose();

  //lin score the structure with the constraint

  //lin update cst count pair information from covalent bond for pose
  fill_cst_count_pair(pose);

  //lin set up the pose constraint
  pose.set_constraints( pose_cst );

  //lin debugging count pair
	bool old_flag = cst_set_ns::debug_output;
	cst_set_ns::debug_output = true;
  if( safety_check ){
		std::cout<<pose.constraints();
		show_cst_count_pair();
	}

	utility::io::ozstream out ;
	pose.open_scored_pdb_outfile( output_file, out );
	csts.write_catalytic_map( out );
	pose.dump_scored_pdb( out, score_weight );
	out.close();

  if( safety_check ){
		std::cout<<pose.show_scores()<<"\n";
		//dump_scorefxn_weights(std::cout);
	}
 	cst_set_ns::debug_output = old_flag;
	pose.reset_constraints();
}

//lin pose type minimization with input constraints
void
cst_min_test(
	FArray1D_bool & repack_residues,//define the sc chi and bb phi/psimove region
	pose_ns::Loops & loops,//use the loop to create the chain cut for bb move
  pose_ns::Pose & pose,
  cst_set_ns::Cst_set & pose_cst,
  cst_allow_move_ns::Allow_move_set & cst_allow_move,//additional allow_move set
  pose_ns::Score_weight_map & score_weight,
  bool const safety_check ) {

	using namespace cst_countpair_ns;
  using namespace pose_ns;
	using namespace kin;
	using namespace enzyme;

  //lin begin cst_min
  {
		bool old_flag = cst_set_ns::debug_output;
    if( runlevel_ns::runlevel > runlevel_ns::standard ) {
      cst_set_ns::debug_output=true;
    } else {
      cst_set_ns::debug_output=false;
    }

    //lin update cst count pair information from covalent bond for pose
    fill_cst_count_pair(pose);

		//lin backup the fold_tree and jump move
		Fold_tree f_saved( pose.fold_tree() );

		//lin backup the pose allow move
		FArray1D_bool bb_move_old,chi_move_old,jump_move_old;
		pose.retrieve_allow_move( bb_move_old, chi_move_old, jump_move_old );

		//lin allow move for pose minimizing
		{
			//lin initialize pose allow move
			pose.set_allow_move( ALL, false );
			pose_cst.clear_all_chainbreaks();

			//lin if loop indicate to allow backbone move, reset the fold tree
			//lin cut the middle of each repack region and add
			//lin the chainbreak score
			FArray1D_bool bb_move_region( pose.total_residue(), false );
			if( loops.loop_size() > 0 && enzyme::bb_move ) {
				Fold_tree f ( pose.fold_tree() );
				for( Loops::const_iterator it=loops.begin(), it_end=loops.end();
						 it != it_end; ++it ) {
					if( it->start() != 1 && it->stop() != pose.total_residue() &&
							!param_aa::is_ligand(pose.res(it->stop()+1)) ) {
						f.new_jump( it->start()-1, it->stop()+1, it->cut() );
						pose_cst.add_chainbreak( it->cut(), 1 );
					}
					for( int ii=it->start(); ii<=it->stop(); ii++ ) {
						if( repack_residues(ii) ) bb_move_region(ii) = true;
					}
				}
				pose.set_fold_tree( f );
				std::cout << "Fold_tree: " << f ;
			}

			// set pose_allow_move first based on cst definitions first,
			// then followed by command-line flags, such as rb_move, chi_move and bb_move
			// chu 2008/01/16
			//lin update additional pose allow move from constraint
			cst_allow_move.set_pose_allow_move( pose );

			//lin jump move
			assert( int(jump_move_old.size1()) <= pose.num_jump() );
			pose.set_allow_jump_move( false );
			for( int ii=1, ie=int(jump_move_old.size1()); ii<=ie; ii++) {
				if( jump_move_old(ii) ) pose.set_allow_jump_move( ii, rb_move );
			}
			//lin protein backbone, set up for repack_residues array
			if( bb_move )	pose.set_allow_bb_move( bb_move_region );
			// protein chi angles, set up for repack_residues array
			if( chi_move ) pose.set_allow_chi_move( repack_residues );
		}


		//lin copy the pose constraint
		cst_set_ns::Cst_set current_cst;
		current_cst.collect( pose_cst );
		current_cst.cst_take_input_value( pose );

		//lin set up the pose constraint
		pose.set_constraints( current_cst );

		bool vary_cb_bond_angles( truefalseoption("vary_cb_bond") );
		if ( vary_cb_bond_angles ){
			set_sidechain_bond_angle_allow_move( pose );
		}

    //lin debugging before  minimize
    //output the pose_cst, allow_move and count pair
    if( safety_check ){
      std::cout<<pose.constraints();
      pose.show_allow_move();
      show_cst_count_pair();
    }

    //lin  minimizing
		{
			float lj_increment,mintol_increment;
			float lj_low_cut, lj_high_cut, mintol_low_cut, mintol_high_cut;
			float chainbreak_low_cut,chainbreak_high_cut,chainbreak_increment;

			bool const nblist_old_flag ( get_use_nblist_during_minimization() );
			pose_set_use_nblist( false ); // may set be true???
			int lj_ramp_cycles;
			lj_ramp_cycles =  enzyme::cst_min_cycles ;
			assert( lj_ramp_cycles > 0 );
			lj_low_cut = 1e-6; lj_high_cut=score_weight.get_weight( FA_REP );
			mintol_low_cut = 1e-6; mintol_high_cut=1e-2;
			chainbreak_low_cut = 1; chainbreak_high_cut=5;
			lj_increment = ( lj_high_cut - lj_low_cut ) / float(lj_ramp_cycles);
			mintol_increment = ( mintol_high_cut - mintol_low_cut ) / float(lj_ramp_cycles);
			chainbreak_increment = ( chainbreak_high_cut - chainbreak_low_cut ) / float(lj_ramp_cycles);
			int begin, end;
			if( lj_ramp_cycles == 1 ) {
				begin = 1; end =1;
			} else {
				begin = 0; end = lj_ramp_cycles - 1 ;
			}
			if( vary_cb_bond_angles ) {
				score_weight.set_weight( SIDECHAIN_BOND_ANGLE,
													 realafteroption("bond_angle_weight",100.0));
			}
			for ( int k = begin; k <= end; ++k ) {
				score_weight.set_weight( FA_REP, lj_low_cut + k * lj_increment );
				minimize_set_tolerance( mintol_high_cut - k * mintol_increment );
				if( enzyme::bb_move || enzyme::cst_loop ) {
// 					score_weight.set_weight( CHAINBREAK_OVERLAP, 1.0 );
// 					score_weight.set_weight( CHAINBREAK, chainbreak_low_cut+k*chainbreak_increment );
					score_weight.set_weight( CHAINBREAK_CST, chainbreak_low_cut+k*chainbreak_increment );
				}
				pose.main_minimize( score_weight, "dfpmin" );
			}
			pose_set_use_nblist( nblist_old_flag );
		}

		if( loops.loop_size() > 0 && enzyme::bb_move ) {
			pose.set_fold_tree( f_saved );//restore the fold tree
		}
		//lin rescore the structures to assure
		pose.score( score_weight );

		//restore
		cst_set_ns::debug_output = old_flag;
		pose.reset_constraints();
		current_cst.erase_atom_constraints();
		pose.set_allow_jump_move( jump_move_old );//restore the jump move
		pose.set_allow_bb_move( bb_move_old );
		pose.set_allow_chi_move( chi_move_old );
  }
  //lin end cst_min

}

//lin  design by defined design_matrix with input constraints
void
cst_design_test(
	pose_ns::Pose & pose,
	PackerWeights design_weight,
	FArray2D_bool const & design_matrix,
	packer_cst_ns::Packer_cst_set & packer_cst,
	bool const safety_check ) {

	using namespace cst_countpair_ns;

	//lin begin design
  {
		//lin fill cst count pair information from covalent bond
		fill_cst_count_pair();

		//lin combine the pose.constraint and input packer_cst
		//lin and put it to current_packer_cst
		//packer_cst_ns::Packer_cst_set  current_cst;
		//current_cst.collect(packer_cst);
		{
			//if pose cst exist, add it into packer cst
			if( pose.constraints_exist() ) {
				pose.constraints().get_packer_cst( pose, packer_cst );
			}

			//lin put it to current_packer_cst
			packer_cst.cst_take_input_value( pose );
			pack_set_current_cst_set( packer_cst );
		}

		//lin output the packer_cst, allow_move and count pair
		bool old_flag = cst_set_ns::debug_output;
		if( safety_check ){
			cst_set_ns::debug_output=true;
			//std::cout<<pack_get_current_cst_set();
			show_cst_count_pair();
		}

		//lin design from pose
		pose.redesign( design_matrix, design_weight );

		cst_set_ns::debug_output = old_flag;
		pack_reset_current_cst_set();

	}
	//lin end design

}

//sk loop refinement with pose style constraints and ligand
void
cst_loop_move(
  pose_ns::Pose & pose,
	packer_cst_ns::Packer_cst_set & packer_cst, //variable, be added if pose cst exist
  pose_ns::Loops & all_loops,
  cst_set_ns::Cst_set const & pose_cst,
  cst_allow_move_ns::Allow_move_set const & cst_allow_move,
  FArray1D_bool const & cat_aa,
  bool const safety_check ) {

  using namespace pose_ns;
  using namespace files_paths;
  using namespace cst_countpair_ns;

  std::string loops_filename;
  stringafteroption( "loopout_file", "", loops_filename);
  if ( loops_filename == "" ) {
  std::cout<< "Specify loopout_file name" << "\n";
	utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	all_loops.clear();
	all_loops.read_loops_from_file( loops_filename );
  minimize_exclude_sstype( false, false );
  minimize_set_vary_phipsi( true );
  minimize_set_vary_chi( true );
  minimize_set_vary_omega( false ); // NOT omega, but everything else
  minimize_set_vary_rb_angle( true );
  minimize_set_vary_rb_trans( true );
  minimize_set_tolerance( 0.005 );
  minimize_set_local_min( false, 0 ); // all non-move-list rsds minimized
  score_set_try_rotamers( false ); // may be turned on inside moves
  set_use_nblist(false);
  set_smallmove_size( 2.0, 2.0, 3.0 );
  pose_setup_packer();
  set_loops_ns_fixnatsc( truefalseoption("fix_natsc") );
  if( !pose.fullatom() ) pose.set_fullatom_flag( true, true );
  pose_set_allow_chi_move_loops( all_loops, pose );
  // constraint stuff
  fill_cst_count_pair(pose);
  // update pose allow move
  cst_allow_move.set_pose_allow_move( pose );
  // set up the pose constraint
  pose.set_constraints( pose_cst );
  for( pose_ns::Loops::iterator it=all_loops.v_begin(), it_end=all_loops.v_end();
         it != it_end; ++it ) {
    if( get_random_cutpoint() ){
       it->set_cut( choose_cutpoint( pose, it->start(), it->stop() ) );
     }
		 pose_ns::Loops loops;
     loops.add_loop( it );
     pose.simple_fold_tree( pose.total_residue() );
     Fold_tree f;
     pose_loops_build_fold_tree( pose.total_residue(), loops, f );
     pose.set_fold_tree( f );
     std::cout << "Loop_fold_tree: " << f ;
     pose.set_allow_jump_move( false );
     pose_loops_set_allow_bb_move( pose, loops );
     Score_weight_map weight_map;
     setup_score_weight_map( weight_map, score12 );
     weight_map.set_weight( CHAINBREAK, 1.0 );
     weight_map.set_weight( CHAINBREAK_OVERLAP, 1.0 );
     weight_map.set_weight( CST_SCORE, 1.0 );
     weight_map.set_weight( FA_DUN, 1.0 );
     weight_map.set_weight( FA_REP, 1.0 );
     weight_map.set_weight( KIN_1D_CST, 1.0 ); // the torsion/bond/angle tether
     weight_map.set_weight( KIN_3D_CST, 1.0 ); // the cst Torsion, Angle weight
     weight_map.set_weight( ATOMPAIR_CST, 1.0 ); // the cst distance
    if( safety_check ){
      cst_set_ns::debug_output=true;
      show_cst_count_pair();
    }
     // now refine loops with ccd
     cst_pose_refine_loops_with_ccd( pose, packer_cst, weight_map, loops, cat_aa );
     pose.update_backbone_bonds_and_torsions();
    }
     pose_loops_reset_global_ns();
     pose.reset_constraints();
     minimize_reset();
}

//sk refine loops wrapper function
void
cst_pose_refine_loops_with_ccd(
  pose_ns::Pose & pose,
	packer_cst_ns::Packer_cst_set & packer_cst, //variable, be added if pose cst exist
  pose_ns::Score_weight_map & wt_map,
  const pose_ns::Loops & loops,
  FArray1D_bool const & cat_aa
      )
{
  using namespace pose_ns;
  assert( pose.fullatom() );
  int const loop_size ( loops.loop_size() );
  bool const include_neighbors = {!(truefalseoption("fix_natsc"))};
  // param for small/shear moves
  int const nmoves = { 1 };
  // param for MC cycles
  int   const cycle_number( std::max( 2, static_cast<int>( loop_size*get_looprlx_cycle_ratio())));
  int   outer_cycles = { 3 };
  int   inner_cycles = (std::min( 200, 5*cycle_number ) );
  cst_pose_refine_loops_with_ccd( pose, packer_cst, wt_map, loops, outer_cycles, inner_cycles,
                              nmoves, include_neighbors, cat_aa );
}
//sk refine loops with csts- chu-style ccd based refinement with constraints
void
cst_pose_refine_loops_with_ccd(
  pose_ns::Pose & pose,
	packer_cst_ns::Packer_cst_set & packer_cst, //variable, be added if pose cst exist
  pose_ns::Score_weight_map & wt_map,
  const pose_ns::Loops & loops,
  int const outer_cycles,
  int const inner_cycles,
  int const nmoves,
  bool const include_neighbors,
  FArray1D_bool const & cat_aa
)
{
  using namespace pose_ns;
  using namespace packer_cst_ns;
	using namespace param;
  using namespace param_aa;
  using namespace enzyme;


  FArray2D_bool design_matrix(  MAX_AUTH_AA, pose.total_residue(), false );
  FArray1D_bool allow_repack( pose.total_residue(), false );
  //FArray1D_bool is_loop( pose.total_residue(), false );
  pose_loops_select_loop_residues( pose, loops, include_neighbors,
    allow_repack);
   //  pose_loops_select_loop_residues( pose, loops, false,
  //  is_loop);
    //int const nres = pose.total_residue();
  for( int seqpos =1; seqpos <= pose.total_residue(); seqpos++ ){
    if( is_ligand( pose.res(seqpos) ) > 0 ) allow_repack(seqpos) = false; // no ligand move
     if (fix_cstaa){
      if (cat_aa(seqpos)){
    allow_repack(seqpos) = false;
  //  std::cout << "SAGAR: no repack for " << seqpos << "\n";;
    }
   }
  }
  if (truefalseoption("cst_loop_fix_loopsc")){ // only backbone moves for loop
    for( Loops::const_iterator it=loops.begin(), it_end=loops.end();
           it != it_end; ++it ) { // begin traverse loops
      for( int i = it->start(); i <= it->stop() ; ++i ) {
        allow_repack(i) = false;
        }
      } // finish traverse loops
    }
  pose.set_allow_chi_move( allow_repack );
    for( int seqpos =1; seqpos <= pose.total_residue(); seqpos++ ){
    if (allow_repack(seqpos)) {
  design_matrix( pose.res(seqpos), seqpos ) = true;
    }
  }
  PackerWeights design_weight=RetrieveWeights( PW_STANDARD ); //default the PW_STANDARD
  cst_design_test(pose, design_weight, design_matrix, packer_cst, false );
  pose.score( wt_map );

  float const init_temp = { 1.5 };
  float const last_temp = { 0.5 };
  float const gamma =
    std::pow( (last_temp/init_temp), 1.0f/(outer_cycles*inner_cycles) );
  int small_accepted(0), shear_accepted(0), n_trial(0); //diagnostics

  // mc obj
	Monte_carlo mc( pose, wt_map, init_temp );

  float temperature = init_temp;

  for ( int i=1, ii=i+3; i<=outer_cycles; ++i, ++ii ) {
    // increase CHAINBREAK weight
    wt_map.set_weight( CHAINBREAK, float(i) ); //chutmp std::pow(float(ii),4.0f)/50.0f );
    mc.set_weight_map( wt_map );
    // recover low
    pose = mc.low_pose();
    // score info
    std::cout << "cycle: " << i << "  ";
    pose.show_scores( std::cout );
    std::cout << "\n";
    for ( int j=1; j<=inner_cycles; ++j ) {
      temperature *= gamma;
      mc.set_temperature( temperature );
      n_trial++;
      { // small min trial
        Loops one_loop;
        one_loop.add_loop( loops.one_random_loop() );
        pose_loops_set_allow_bb_move( pose, one_loop );
        pose_small_moves( pose, nmoves);
        if( one_loop.begin()->stop()  != pose.total_residue() &&
            one_loop.begin()->start() != 1 )
          pose_ccd_close_loops( pose, one_loop);
        pose_loops_set_allow_bb_move( pose, loops );
        pose.main_minimize( wt_map, "dfpmin" );
        if( mc.boltzmann( pose ) ) { small_accepted++; }
      }

      { //shear min trial
        Loops one_loop;
        one_loop.add_loop( loops.one_random_loop() );
        pose_loops_set_allow_bb_move( pose, one_loop );
        pose_shear_moves( pose, nmoves);
        if( one_loop.begin()->stop()  != pose.total_residue() &&
          one_loop.begin()->start() != 1 )
        pose_ccd_close_loops( pose, one_loop );
        pose_loops_set_allow_bb_move( pose, loops );
        pose.main_minimize( wt_map, "dfpmin" );
        if( mc.boltzmann( pose ) ) { shear_accepted++; }
      }

      if ( j==inner_cycles ) {
          // repack trial
         PackerWeights design_weight=RetrieveWeights( PW_STANDARD ); //default the PW_STANDARD
         cst_design_test(pose, design_weight, design_matrix, packer_cst, false );
				 pose.score (wt_map );
        mc.boltzmann( pose );
      }
 } // inner cycles

  } // outer cycles

  pose = mc.low_pose();

  std::cout << "pose_refine_loops_with_ccd -- trial/accepted/ratio:\n"
            << small_accepted << "/" << n_trial << "/"
            << float(small_accepted)/float(n_trial) << " for small moves\n"
            << shear_accepted << "/" << n_trial << "/"
            << float(shear_accepted)/float(n_trial) << " for shear moves"
            << "\n";
}

//lin setup docking part_begin, part_end to define the interface
void 	setup_part_from_domains() {

	if( ( !files_paths::multi_chain || !get_cst_mode_flag() )
			&& !get_enable_ligaa_flag()
			&& !files_paths::antibody_modeler ) return;

	int ie(0),end(0);
	if( files_paths::multi_chain ) {
		docking::docking_query::part_begin(1) = 1;
		ie = misc::ints::total_domains ;
		end = misc::ints::total_residue;

		for ( int i = 2; i <= ie; ++i ) {
			docking::docking_query::part_begin(i) = misc::ints::domain_end(i-1)+1;
			docking::docking_query::part_end(i-1) = docking::docking_query::part_begin(i) - 1;
		}
		docking::docking_query::part_end(ie)=end;
	} else {//lin assume the protein-ligand interface
		//lin if get_enable_ligaa, force the protein-ligand interace is the partI and PartII
		end = misc::ints::total_residue + 1;
		ie = 2;
		docking::docking_query::part_begin(1) = 1;
		docking::docking_query::part_begin(2) = end;
		docking::docking_query::part_end(1) = misc::ints::total_residue;
		docking::docking_query::part_end(2)=end;
	}

	if( ie == 1 ) {//not multi_chain
		docking::docking_query::part_begin(2) = end+1;
		docking::docking_query::part_end(2) = end;
	}
}

void get_loop_from_array(FArray1D_bool const & repack_residues, pose_ns::Loops & loops ) {
	loops.clear();
	int const shiff_step = { 1 };
	bool read_loop_begin = true, read_loop_end = true, old_tag = false ;
	int loop_begin=0, loop_end=0;
	for( int ii=1,ie=repack_residues.size(); ii<=ie; ii++ ) {
		if( repack_residues(ii)!=old_tag ) {
			if( repack_residues(ii) ) {
				if( read_loop_begin ) {
					loop_begin=std::max(ii-shiff_step,1);
					read_loop_begin = false;
				}
			} else {
				read_loop_end=true;
				for( int jj=1;jj<=shiff_step*2; jj++ )
					//if( repack_residues(ii+jj) ) { read_loop_end=false; break; }
					if( ii+jj<=ie && repack_residues(ii+jj) ) { read_loop_end=false; break; }
				if( read_loop_end ) {
					loop_end=std::min( ii+shiff_step-1, ie-enzyme::ligaaN );
					loops.add_loop(loop_begin,loop_end,int((loop_begin+loop_end)/2.0),0,0);
					//std::cout<<" tag: "<<loops;
					read_loop_begin = true;
				}
			}
		}
		old_tag=repack_residues(ii);
	}
}

void cst_mode_detect_repack_design_regions(
	  pose_ns::Pose & pose,
		PackerTask & Task,
	  pose_ns::Loops & loops,
		cst_descriptor_ns::cst_set_descriptor & csts,
		FArray1D_bool & design_residues,
		FArray1D_bool & repack_residues		) {

	using namespace enzyme;
	using namespace design;
  using namespace cst_descriptor_ns;
	using namespace pose_ns;
	using namespace files_paths;
	using namespace param_aa;
	using namespace param;

  repack_residues = false ;
  design_residues = false ;

  if( resfile != "none" ) {
    for( int seqpos =1; seqpos <= pose.total_residue(); seqpos++ ) {
      if( is_ligand( pose.res(seqpos) ) ) {
        repack_residues( seqpos ) = false;
      } else if( Task.get_designmap().repack_residue( seqpos ) ) {
        repack_residues( seqpos ) = true;
        for ( int aa = 1; aa <= MAX_AUTH_AA; ++aa ) {
          if( Task.get_designmap().get( seqpos, aa )
              && aa != pose.res( seqpos ) ) {
            design_residues( seqpos ) = true;
            break;
          }
        }
      }
    }
  } else if( pose.num_jump() > 0 ) { // use the pose jump to define the interface
		set_pose_jump_interface_res( pose, design_residues, repack_residues );
	} else if( get_enable_ligaa_flag() ) {//if ligand define the ligand interface
		for( int ii=1,ie=pose.total_residue(); ii<=ie; ii++ ) {
			if ( is_ligand( pose.res(ii) ) ) continue;
			for ( int jj=1,je=pose.total_residue(); jj<=je; jj++ ) {
				if ( !is_ligand( pose.res(jj) ) ) continue;
				are_they_neighbors(pose.res(ii),pose.res(jj),pose.full_coord()(1,1,ii),
													 pose.full_coord()(1,1,jj),design_cut_1,design_cut_2,
													 repack_cut_1,repack_cut_2,
													 design_residues(ii),repack_residues(ii) );
			}
		}
	} else {
		//otherwise, it will repack the whole protein
		design_residues = true; repack_residues = true;
		std::cout<<" You donnot specify the resfile and it is not protein ligand complex, "
						 <<"so we will redesign the whole protein"<<"\n";
	}

	if( use_loop_file ) {//if cst_loop refine, focus on the loop region
		if( cst_loop ) {design_residues = false; repack_residues = false;}//reset
		FArray1D_bool allow_design ( pose.total_residue(), false );
		FArray1D_bool allow_repack ( pose.total_residue(), false );
		pose_loops_select_loop_residues( pose, loops, false, allow_design );
		pose_loops_select_loop_residues( pose, loops, true, allow_repack );
		for(int ii=1,ie=pose.total_residue(); ii<=ie; ii++ ) {
			if( allow_design(ii) ) design_residues = true;
			if( allow_repack(ii) ) repack_residues = false;
		}
	}

	//lin correct the design_repack region by cst
	for( int ii=1,ie=pose.total_residue(); ii<=ie; ii++ ) {
		if( csts.is_cstpos(ii) ){
			design_residues(ii)=false;
			if( fix_cstaa )	repack_residues(ii)=false;
		}
	}
	if( safety_check ) {//lin debug output the design_residues and repack_residues array
		std::cout<<"cst_mode: design_region  select( 0";
		for(int ii=1,ie=pose.total_residue(); ii<=ie; ii++ ){
			if( design_residues(ii) ) std::cout<<", "<<ii;
		}
		std::cout<<" )"<<"\n";

		std::cout<<"cst_mode: repack_region  select( 0";
		for(int ii=1,ie=pose.total_residue(); ii<=ie; ii++ ){
			if( repack_residues(ii) ) std::cout<<", "<<ii;
		}
		std::cout<<" )"<<"\n";
	}

	//lin if not loop file, define loop from the repack region
	if( !use_loop_file ) {
		get_loop_from_array( repack_residues,loops );
	}
	if( safety_check ) std::cout<<"LOOPs: "<<loops<<"\n";

}

void
set_pose_jump_interface_res(
	pose_ns::Pose & pose,
	FArray1D_bool & design_residues,
	FArray1D_bool & repack_residues
)
{
	using namespace pose_ns;
	using namespace enzyme;
	using namespace param_aa;

	Fold_tree const & fold_tree ( pose.fold_tree() );
	for( int ii=1; ii<=pose.num_jump(); ii++ ) {
		FArray1D_bool partner( pose.total_residue(), false );
		bool allow_design ( false ), allow_repack ( false );
		fold_tree.partition_by_jump( ii, partner );

		for ( int i=1; i<=pose.total_residue(); ++i ) {
			for ( int j=i+1; j<=pose.total_residue(); ++j ) {
				if ( partner(i) == partner(j) ) continue;
				are_they_neighbors(pose.res(i),pose.res(j),pose.full_coord()(1,1,i),
													 pose.full_coord()(1,1,j),design_cut_1,design_cut_2,
													 repack_cut_1,repack_cut_2,
													 allow_design,allow_repack );
				if( allow_design ) {
					if( is_protein( pose.res(i) ) ) design_residues(i)=true;
					if( is_protein( pose.res(j) ) ) design_residues(j)=true;
				}
				if( allow_repack ) {
					if( is_protein( pose.res(i) ) ) repack_residues(i)=true;
					if( is_protein( pose.res(j) ) ) repack_residues(j)=true;
				}
			}
		}
	}
	return;
}

void creat_scaffolds_list(
  std::vector< std::string > & files,
	std::string const & list_tag,
	std::string const & file_tag,
	std::string inputpdbname ) {//lin default is ""

	using namespace enzyme;
	using namespace files_paths;

	//lin erase the old value;
	files.clear();

	std::string filename;
	if( truefalseoption( list_tag ) ) {
		filename = stringafteroption( list_tag );
		if( filename == "auto" && inputpdbname != "NULL" ) {
			filename = inputpdbname;
		} else {
			filename = filename ;
		}
		std::ifstream data( filename.c_str() );
		std::string line,pdbfile;
		std::istringstream line_stream;
		while ( getline( data,line ) ) {
			line_stream.clear();
			line_stream.str(line);
			line_stream.seekg( std::ios_base::beg );
			line_stream >> pdbfile ;
			if( pdbfile != "" ) {
				if ( has_suffix( pdbfile, ".pdb" ) ) pdbfile.erase( pdbfile.length() - 4 );
				files.push_back( pdbfile );
			}
		}
		data.close();
		std::cout<<" cst_mode: read the list of the file from " << filename <<"\n";
	} else if( truefalseoption( file_tag ) ) {
		filename = stringafteroption( file_tag );
		if( filename == "auto" && inputpdbname != "" ) {
			filename = inputpdbname;
		} else if ( has_suffix( filename, ".pdb" ) ) {
			filename.erase( filename.length() - 4 );
		}
		files.push_back( filename );
	}
}

bool check_overwrite_decoys( std::string const & outname ) {

	using namespace enzyme;
	using namespace files_paths;

	bool found( false );
	if( !overwrite_pdbs ) {
		std::string filename;
		std::string claim_tag, append_tag;
		filename = pdb_out_path + "CHECKPOINT";
		std::ifstream data( filename.c_str() );
		if( check_finished ) {
			append_tag = ":END";
		} else {
			append_tag = ":BEGIN";
		}
		while( getline( data, claim_tag ) ) {
			if( claim_tag == outname+append_tag ) { found=true; break;}
		}
		data.close();
	}
	return found;
}

void write_checkpoint(
   std::string const & outname,
   std::string const & tag ){

	using namespace files_paths;

	if( overwrite_pdbs ) return;

	std::string filename;
	filename = pdb_out_path + "CHECKPOINT";
	std::ofstream out( filename.c_str(), std::ios::app );
	out << outname + ":" + tag <<"\n";
	out.close();

}
