// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14367 $
//  $Date: 2007-04-19 12:08:54 +0300 (Thu, 19 Apr 2007) $
//  $Author: yab $

#ifndef INCLUDED_enzyme
#define INCLUDED_enzyme

// Rosetta Headers
#include "cst_allow_move.h"
#include "cst_packer.h"
#include "cst_set.h"
#include "PackerTask_fwd.h"
#include "packer_weights.h"
#include "pose_fwd.h"
#include "loop_class.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <iosfwd>

// Forward Declarations
class Ligand;

namespace cst_descriptor_ns {
	class cst_set_descriptor;
}

// Enzyme Function Declarations


bool
get_enzyme_flag();


void
set_enzyme_flag( bool setting );

void
set_enable_ligaa_flag( bool setting );

bool
get_enable_ligaa_flag( );

void
set_read_ligaa_flag( bool setting );

bool
get_read_ligaa_flag( );


void
reset_enzyme();


void
get_inverse_rotamers();


void
detect_virtual_residue_base();


void
build_virtual_residue_fullcoord();


void
get_vrot_vseqpos_vaan_vaav(
	int aan,
	int aav,
	int seqpos,
	int nrot,
	int & nrotamers,
	bool const flip,
	bool const rot,
	float const rot_ang
);


void
get_funrot_coord(
	FArray3Da_float xyz,
	int const aan,
	int const aav,
	FArray1Da_float chi,
	FArray2Da_float rotcoord,
	int const vpos,
	bool const flip,
	bool const fixed,
	float const rot_ang
);


void
detect_virtual_rotamer_clash();


void
get_vrot_vrotE(
	int res1,
	int res2,
	int aa1,
	int aa2,
	int aav1,
	int aav2,
	FArray2Da_float coord1,
	FArray2Da_float coord2,
	float & repE
);


void
make_table_file( std::string const &  VROT_REP_TABLE );


void
vrot_pdb( std::string const & filename );


void
make_vrot_decoy_file(
	int const cycle,
	utility::io::orstream & iunit
);


void
output_fullatom_pdb(
	int & nvrot,
	FArray3Da_float xyz, // (xyz,atom#,res#)coordinates
	FArray1Da_int aan, // specifies amino acid at each seqpos
	FArray1Da_int aav, // amino acid variant at each position
	int & nres, // # of residues in the protein
	char const chain, // protein chain
	int & ndomains, // how many domains?
	FArray1Da_int dom_end, // end residues of each domain
	FArray2Da_float occ,
	FArray2Da_float bval,
	utility::io::orstream & iunit
);


void
setup_bbind_dun();


void
output_fullcoord_vpdb( utility::io::orstream & iunit );


void
detect_virtual_atom_covalent_bond(Ligand & molecule);


void
get_sc_ha_virtualE(
	int const aaid,
	int const aa,
	int const aav,
	FArray2Da_float coord,
	float & virtE,
	bool const eval_bb,
	bool const eval_sc,
	bool const more,
	Ligand & ligand
);


bool
map_virtual_real(
	int const he_type,
	int const atom,
	int const aa,
	int const aav
);


bool
exclude_interaction(
	int const hetatom_id,
	int const atom,
	int const aan,
	int const aav
);

void
set_cst_mode_flag( bool setting );

bool
get_cst_mode_flag( );

void cst_mode_options();

void cst_mode_io(
  std::string const & inputname,
  pose_ns::Pose & pose,
  cst_set_ns::Cst_set & pose_cst,
	packer_cst_ns::Packer_cst_set & packer_cst,
	cst_descriptor_ns::cst_set_descriptor & csts,
  cst_allow_move_ns::Allow_move_set & cst_allow_move
);

void cst_mode_test(
  std::string const & inputname,
	std::string & outname
);

void cst_mode_test(
  pose_ns::Pose & pose,
  std::string  & outpdbname
);

void cst_mode_test(
	std::string const & outname,
  pose_ns::Pose & pose,
  cst_set_ns::Cst_set & pose_cst,
	packer_cst_ns::Packer_cst_set & packer_cst,
	cst_descriptor_ns::cst_set_descriptor & csts,
  cst_allow_move_ns::Allow_move_set & cst_allow_move
);

void cst_mode_single_run(
	std::string & outname,
  pose_ns::Pose & pose,
  cst_set_ns::Cst_set & pose_cst,
	packer_cst_ns::Packer_cst_set & packer_cst,
	cst_descriptor_ns::cst_set_descriptor & csts,
  cst_allow_move_ns::Allow_move_set & cst_allow_move,
	pose_ns::Score_weight_map & score_weight,
	PackerTask & Task,
	PackerWeights design_weight,
	FArray1D_bool & repack_residues,
	FArray1D_bool & design_residues,
  pose_ns::Loops & loops
);

void
cst_score_test(
  pose_ns::Pose & pose,
  cst_set_ns::Cst_set const & pose_cst,
	cst_descriptor_ns::cst_set_descriptor const & csts,
  pose_ns::Score_weight_map const & score_weight,
  std::string const & output_file,
  bool const safety_check );

void
cst_min_test(
	FArray1D_bool & repack_residues,
	pose_ns::Loops & loops,
  pose_ns::Pose & pose,
  cst_set_ns::Cst_set & pose_cst,
  cst_allow_move_ns::Allow_move_set & cst_allow_move,
  pose_ns::Score_weight_map & score_weight,
  bool const safety_check );

void
cst_design_test(
	pose_ns::Pose & pose,
	PackerWeights design_weight,
	FArray2D_bool const & design_matrix,
	packer_cst_ns::Packer_cst_set & packer_cst,
	bool const safety_check );

void
cst_loop_move(
  pose_ns::Pose & pose,
  packer_cst_ns::Packer_cst_set & packer_cst, //variable, be added if pose cst exist
	pose_ns::Loops & all_loops,
  cst_set_ns::Cst_set const & pose_cst,
  cst_allow_move_ns::Allow_move_set const & cst_allow_move,
  FArray1D_bool const & cat_aa,
  bool const safety_check );

void
cst_pose_refine_loops_with_ccd(
  pose_ns::Pose & pose,
	packer_cst_ns::Packer_cst_set & packer_cst, //variable, be added if pose cst exist
  pose_ns::Score_weight_map & wt_map,
  const pose_ns::Loops & loops,
  FArray1D_bool const & cat_aa );

void
cst_pose_refine_loops_with_ccd(
  pose_ns::Pose & pose,
  packer_cst_ns::Packer_cst_set & packer_cst, //variable, be added if pose cst exist
	pose_ns::Score_weight_map & wt_map,
  const pose_ns::Loops & loops,
  int const outer_cycles,
  int const inner_cycles,
  int const nmoves,
  bool const include_neighbors,
  FArray1D_bool const & cat_aa );

void setup_part_from_domains();

void get_loop_from_array( FArray1D_bool const & allow_move, pose_ns::Loops & loops );

void cst_mode_detect_repack_design_regions(
	  pose_ns::Pose & pose,
		PackerTask & Task,
 	  pose_ns::Loops & loops,
		cst_descriptor_ns::cst_set_descriptor & csts,
		FArray1D_bool & design_residues,
		FArray1D_bool & repack_residues );

void
set_pose_jump_interface_res(
	pose_ns::Pose & pose,
	FArray1D_bool & design_residues,
	FArray1D_bool & repack_residues
	);

void creat_scaffolds_list(
  std::vector< std::string > & files,
	std::string const & list_tag,
	std::string const & file_tag,
	std::string inputpdbname = "NULL"); //lin default is "NULL"

bool check_overwrite_decoys( std::string const & outname );

void write_checkpoint( std::string const & outname, std::string const & tag );

#endif
