// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15424 $
//  $Date: 2007-06-12 21:26:56 +0300 (Tue, 12 Jun 2007) $
//  $Author: bcorreia $

#ifndef INCLUDED_enzyme_ns
#define INCLUDED_enzyme_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


namespace enzyme {

//****************************************************************//
//     enzyme_ns
//     Lin Jiang September 2004
//
//lin  begin enzyme namespaces
//lin  enzyme_logical: the flag for enzyme design and inverse rotamer tree
//lin  lig_virE_param: the paerameter for virtaul energy calculation
//lin  virtual_rot:    inverse rotamer tree and bbind rotamer library
//lin
//lin
//****************************************************************//

//lin ligand aa flag
namespace ligaa_flag {
	extern bool enable_ligaa; // enable ligand as aa
	extern bool read_ligaa; // read ligand as aa
	extern bool read_occ_weights; // if enable_ligaa, read the atomic weight from occ
	extern bool read_bvalue_charge;// if enalbe_ligaa, read the atomic charge from bfactor
	extern bool attach_ligaa_by_jump; // if enable_ligaa, attach ligand by jump
	extern bool read_ligaa_mdl; // if enable_ligaa, read ligand from mdl format
	extern bool use_mdl_connect;// if enable_ligaa, use mdl connectivity from mdl file
	extern bool read_lig2;  // read the second ligand
	extern std::string lig2_file; //file name of the second ligand
	extern int ligaaN ;    //number of the ligand as aa
	extern float ligand_weight_scale; //weight for ligand interface
}
using namespace ligaa_flag;

//lin cst_mode flag
namespace cst_mode_flag {

	extern bool enable_cst_mode;

	//lin cst_mode_io_flag
	extern bool check_finished;           //lin check overwrite
	extern bool use_pdbout ;              //lin pdb out
	extern std::string pdboutname ;
	extern bool use_log_file ;            //lin redirect to logfile
	extern std::string log_file_name;
	extern bool dump_structures ;         //lin output pdb in different stages
	extern int ndruns ;                   //lin how many runs are processed
	extern bool iterative_run ;           //lin do iterative run with ndruns
	extern bool use_loop_file;          // use loop file to define the allow bb move region
	extern std::string loop_filename;   // loop file name
	extern bool use_common_flag;        // common flag
	extern std::string flag_file;       // common flag from file

	//lin cst_mode constraint flag
	extern bool covalent_from_cstfile; //take the covalent bond info from cst file
	extern bool safety_check;     // debugging
	extern bool scaffold_from_misc; // scaffold from misc, default is from pdb file
	extern bool complex_cstfile;  // read constraint of complicated format
	extern std::string cstfile_name;
	extern bool read_enzyme_cst;  // read constraint by old enzyme format
	extern std::string enzymecst_name;
	extern bool single_line_cst;  // read constraint of single line format
	extern std::string singlecst_name;
	extern bool read_old_header;  // read old header format
	extern float covalent_cst_scale;

	//lin cst_submode flag
	extern bool cst_conformer ;      // conformer
	extern bool cst_dockpert ;       // perturb the ligand
	extern bool cst_score ;       // score with input cst
	extern bool cst_opt ;         // optimize the cst
	extern bool cst_design;       // design with input cst
	extern bool fix_cstaa;        // fix the aa in the constraint positions
	extern bool cst_min;          // pose minimization with input cst
	extern bool cst_loop;         // loop refinement with input cst and ligand
	extern bool short_interface;  // define ligand interface
	extern float  design_cut_1;     // cutoff 1 for design residues
	extern float  design_cut_2;     // cutoff 2 for design residues
	extern float  repack_cut_1;     // cutoff 1 for repack residues
	extern float  repack_cut_2;     // cutoff 2 for repack residues
	extern int  crop_aa;          // crop the pocket to crop_aa if cst_opt
	extern bool use_score_wtsfile;    // setup score weight set
  extern bool use_packer_wtsfile;    // setup packer weight set
	extern bool minimize_ligaa_bonds;   // minimize_ligand_bonds if cst_min and ligaa
	extern bool minimize_ligaa_angles;  // minimize_ligand_angles if cst_min and ligaa
	extern bool minimize_ligaa_torsions;// minimize_ligand_torsions if cst_min and ligaa
	extern bool bb_move;                // vary bb phi, psi if cst_min
	extern bool chi_move;               // vary sc chi if cst_min
	extern bool rb_move;                // vary 6 rigid body param if cst_min
	extern bool fix_lig2;
	extern int cst_min_cycles;          // how many cycle to do cst_min
	extern bool keep_constraint_sd;     // if keep the cst sd when cst_min
	extern bool crop_pocket;            // crop the pocket to poly_ala/poly_gly
	extern bool limit_perturb;           //only keep the good perturb
	extern float repE_limit;
	extern float cstE_limit;
	extern float chainbreakE_limit;
// 	extern bool ;
// 	extern bool ;
// 	extern bool ;

	extern FArray1D_bool missingres;
}
using namespace cst_mode_flag;

	//lin cst_mode_io
//lin only enzyme stuff
namespace enzyme_logical {
	extern bool enzyme_flag;
	extern bool enzyme_vrot;
	extern float vrot_perc;
}
using namespace enzyme_logical;

namespace lig_virE_param {
	extern bool exact_match_vatom;
	extern float lig_virE_dmax;
}
using namespace lig_virE_param;

namespace virtual_rot {
	extern float vrot_repmaxE;
	extern int const VIRTUAL_RESIDUE_MAX;
	extern int virtual_residue_count;
	extern FArray1D_string virtual_residue_id;
	extern FArray2D_string virtual_resbase_name;
	extern FArray3D_float virtual_resbase_coord;
	extern int const max_vrot_count;
	extern Dimension max_vrotamers;
	extern int vrot_counts;
	extern FArray1D_int vrotaa;
	extern FArray1D_int vrotres;
	extern FArray1D_int vrot_begin,vrot_end;
	extern FArray1D_float vrot_repE;
	extern FArray2D_float vrot_vrot_repE;
	extern FArray2D_float vrchi;
	extern FArray2D_float vdun_perc;
	extern FArray3D_float vrotcoord;
	extern FArray3D_float vdun_chi;
	extern FArray3D_float vdun_sd;
	extern FArray3D_int vdun_group_rotno_to_rotno;
	extern FArray1D_int vdun_count;
}
using namespace virtual_rot;


} // namespace enzyme


#endif
