// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13068 $
//  $Date: 2007-02-25 07:23:03 +0200 (Sun, 25 Feb 2007) $
//  $Author: johnk $

#ifndef INCLUDED_etable
#define INCLUDED_etable


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <string>


//------------------------------------------------------------------------------
//
//  etable include file:
//
//    initialization of all parameters and tables used to generate
//      lj vdw and lk solv energy tables
//
//    ctsa - note that this file was assembled to support the etable
//      calculation functions run at fullatom mode startup - don't
//      store variables here unless they are exclusively used to
//      setup the etable, and don't include this file elsewhere
//
//------------------------------------------------------------------------------


namespace etable {


//car cvs revision and date
extern std::string const fa_etable_revision;
extern std::string const fa_etable_date;


//car declaration of variables for values precomputed from adjustable parameters

namespace fa_etable_precompute {
	extern double fa_lj_switch_sigma2dis;
	extern double fa_lj_switch_value2wdepth;
	extern double fa_lj_switch_slope_sigma2wdepth;
}
using namespace fa_etable_precompute;


//------------------------------------------------------------------------------
//  adjustable parameters
//------------------------------------------------------------------------------
//   parameter set identification:
extern std::string const fa_etable_label;

//
//  global modification to CHarMM radii
//
extern float fa_Wradius;

//
//  distance at which two S are considered diS
//
extern float const fa_disulfide_dis_thresh; // take the disulfide scheme out

//
//  lj vdw radius between disulfide cysteines
//
extern float const fa_disulfide_radius;

	//// ctsa - when the distance/sigma ratio is below the
	////   switchover threshold: fa_lj_switch_dis2sigma, then
	////   the potential is calculated from a linear projection of the
	////   lj value rather than the true lj value.
	////


namespace etable_runtime_parameters {
	extern float fa_lj_switch_dis2sigma; // actual value used
}
using namespace etable_runtime_parameters;

extern float highres_lj_lin_sig; // default
extern float const lowres_lj_lin_sig;

//
// if true, use the lj deriv as slope from sigma linear start point
//
extern bool const fa_lj_use_lj_deriv_slope;

//
//  if not, then force the y-axis intercept here
//
extern float const fa_lj_slope_intercept;

//
//  if true, use special radii for hbond donor acceptor pairs
//
extern bool const fa_lj_use_hbond_radii;

//
//  special radius for hbond donor acceptor pairs,and polar H acceptors
//
extern float const fa_lj_hbond_dis;
extern float const fa_lj_hbond_hdis;
//pb  special radius for hbonds with charged oxygen acceptor and oxygen donor
extern float const fa_lj_hbond_accOch_dis;
//pb  special radius for polar hydrogen donor and charged O acceptor
extern float const fa_lj_hbond_accOch_hdis;

//
//  if true, use special radii for water-polar pairs
//
extern bool const fa_lj_use_water_radii;

//
//  special radius for water-polar atom pairs
//
extern float const fa_lj_water_dis;
extern float const fa_lj_water_hdis;


	//// ctsa - when the distance/sigma ratio is below
	////   the switchover ratio: fa_lk_min_dis2sigma,
	////   then the lk solvation is constant, with a value
	////   equal to the solvation value at the switchover ratio
	////
extern float const fa_lk_min_dis2sigma;

	//// an interatomic distance less than fa_min_dis
	////   will be set to fa_min_dis
	////
extern float const fa_min_dis;

	//// derived from fa_min_dis...
extern double const fa_min_dis2;


//
//  if true, add a linear smooth to 0. at the max distance range
//    for all lj and lk terms
//
extern bool const fa_add_long_range_damping;


//
//  if damping is turned on, then...
//    at fa_max_dis - fa_long_range_damping_length, set lj and lk to
//    a linear slope to reach 0. at fa_max_dis
//
extern float const fa_long_range_damping_length;


//
//  lj, lk, hbond tables
//
extern FArray1D_float fa_lj_radius; // lj vdw radii
extern FArray1D_float const fa_lj_wdepth; // lj vdw well depths
extern FArray1D_float const fa_lk_volume; // lk solvation volume
extern FArray1D_float const fa_lk_lambda; // lk solvation lda
extern FArray1D_float fa_lk_dgfree; // lk solvation change in free energy
extern FArray1D_bool const fa_acceptor; // hbond acceptors
extern FArray1D_bool const fa_donor; // hbond donors
extern FArray1D_bool const fa_hbondH; // hydrogens that hbond

//mj make these functions available from outside
void
fa_lj_soft_initializer( FArray1D_float & fa_lj_radius );

void
fa_lj_radius_initializer( FArray1D_float & fa_lj_radius );

void
fa_lk_dgfree_initializer( FArray1D_float & fa_lk_dgfree );

}


#endif







