// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12824 $
//  $Date: 2007-02-14 16:50:02 -0800 (Wed, 14 Feb 2007) $
//  $Author: johnk $

#ifndef INCLUDED_etable_manager
#define INCLUDED_etable_manager

#include <map>

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

#include <etable_class.h>

// jk An enumeration for Etable tags
enum etable_id {
	ETAB_STANDARD,
	ETAB_SOFT_REP,
	ETAB_SMALL_RADII,
	ETAB_AW,
	ETAB_BW
};

// jk Typedef for the map-based container and an iterator
typedef std::map< etable_id, Etable > EtableMap;
typedef EtableMap::iterator EtableMap_Iter;

// jk Class definition for EtableManager
class EtableManager {

private:

	EtableMap EtableMap_;

public:

	EtableManager();

	inline EtableMap_Iter find( etable_id const & etab_id ) { return EtableMap_.find(etab_id); };

	inline EtableMap_Iter end() { return EtableMap_.end(); };

};


bool setCurrentEtable( etable_id const & etab_id );

void disable_packing_etables(
														 int total_residue,
														 FArray1D_int const & res,
														 FArray1D_int const & res_variant,
														 FArray3D_float const & full_coor,
														 bool const suppress_output = false );

void enable_packing_etables(
														int total_residue,
														FArray1D_int const & res,
														FArray1D_int const & res_variant,
														FArray3D_float const & full_coord,
														bool const suppress_output = false );


namespace etable_manager_ns {
	extern EtableManager Etable_db;
}



#endif
