// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.21 $
//  $Date: 2005/11/04 01:15:15 $
//  $Author: chu $

#ifndef INCLUDED_evolve
#define INCLUDED_evolve


// Rosetta Headers
#include "pose.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray3Dp.hh>
#include <ObjexxFCL/FArray4D.hh>

// C++ Headers
#include <string>
#include <vector>


void evolution_manager(
	int nstruct,
	int nstart
);


void end_generation_check(
	int noutput,
	float percentage_finished_tol,
	float & current_percentage,
	bool & end_generation
);


void prepare_next_generation(
);


void
modify_jobfile(
	int const & iteration_num
);


void
get_tribe_list_index(
	int & tribe_list_index
);



void
choose_parents_by_score(
	std::string const & temp_parents_dir,
	int const & iteration_num,
	int & nstart,
	int tribe_list_index
);


void
choose_parents_by_cluster(
	std::string const & temp_parents_dir,
	int const & iteration_num,
	int & nstart,
	int tribe_list_index
);


void
prepare_parents(
	std::string const & temp_parents_dir
);


bool
assign_offspring_to_tribes(
	std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > & tribe_list,
	std::pair< std::pair< std::string, pose_ns::Pose* >, float > & offspring,
	int & tribe_list_index,
	std::vector< std::string > & tribe_names,
	int & changed_tribe_index,
	int & changed_tribe_member
);


void
make_clusters(
	std::string const & temp_parents_dir,
	std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > & new_tribes,
	std::vector< std::string > & new_tribe_names,
	int tribe_list_index,
	int & parent_size
);


void
make_new_parents(
	std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > const & tribe_list,
	std::vector< std::string > const & tribe_names,
	std::string const & temp_parents_dir,
	bool get_loop_def,
	std::string const & getDsspSS_location,
	int const & iteration_num
);


void
get_tribe_coordcst(
	std::vector< std::pair< pose_ns::Pose*, float > > const & tribe,
//	std::string const & tribe_name,
//	std::string const & temp_parents_dir,
	std::vector<float> & ave_allrms,
	std::vector< std::pair< int, int > > & loopfile
);


void
make_list_name(
	std::string const & temp_parents_dir
);


void
prepare_outdir(
	int const & iteration_num
);


float
get_perc_loop(
);


void
read_pdb_to_tribes(
	std::string const & list_name,
	std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > & tribe_list,
	std::vector< std::string > & tribe_names,
	std::string const & code,
	bool const & fullatom,
	bool const & ideal_pose

);


void
read_pdblist_to_pose(
	std::string list_name,
	std::vector< std::pair< std::pair< std::string, pose_ns::Pose* >, float > > & pose_list,
	bool const & fullatom,
	bool const & ideal_pose
);


bool
read_score_from_decoy(
	std::string decoy_file,
	float & score
);


std::string
get_dssp_loc(
);


void
initialize_evolve(
);


int
get_iteration_num(
);


bool
get_loopfile_exist(
);


void
recombination(
	int const nstruct
);


void
recombine_two_poses(
	pose_ns::Pose & pose1,
	pose_ns::Pose & pose2,
	std::vector<std::string> const & tag1,
	std::vector<std::string> & tag2,
	std::vector< std::pair< int, int > > const & variable_segs
);


void
delete_intervals
(
	std::vector< std::vector< std::pair< pose_ns::Pose*, float > > > & tribe_list,
	std::vector< std::pair< int, int > > & variable_regions
);


void
get_variable_regions(
	std::vector< std::pair< int, int > > & variable_regions
);


void evolution_manager_recomb(
	int nstruct
);


#endif
