// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13104 $
//  $Date: 2007-02-26 21:09:45 -0800 (Mon, 26 Feb 2007) $
//  $Author: bblum $

#ifndef INCLUDED_featurizer
#define INCLUDED_featurizer

// Rosetta Headers
#include "featurizer_classes.h"
#include "dssp.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <vector>

void
identify_contact_features(
	int const total_residue,
	FArray4D_int const & contact_count,
	int const num_bins,
	featurizer_ns::Contact_list & contact_list,
	float prob_cutoff,
	float KL_cutoff
);


void
identify_pairing_features(
	int const total_residue,
	FArray2D_int const & pairing_count,
	int const total_decoys,
	featurizer_ns::Pairing_list & pairing_list
);


void
merge_pairing_feature_list(
	featurizer_ns::Pairing_list &result,
	featurizer_ns::Pairing_list &other
);


void
merge_pairing_feature(
	featurizer_ns::Pairing_list &result,
	featurizer_ns::Pairing_feature f
);


void
featurize();

void
extract_centroid_information_wrapper();

void 
add_user_pairing_feature(const int total_residue, featurizer_ns::Pairing_list &feature_list, int res1, int res2, int orientation);

void merge_topologies(std::list<dssp_ns::StrandPairingSet> &topologies);

std::list<std::list<int> > extract_strand_pairings(std::list<dssp_ns::StrandPairingSet> &topologies, std::list<dssp_ns::StrandPairing> &pairings);

#endif
