// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8196 $
//  $Date: 2006-05-05 19:17:51 -0700 (Fri, 05 May 2006) $
//  $Author: rhiju $

#ifndef INCLUDED_featurizer_classes
#define INCLUDED_featurizer_classes

// Rosetta Headers
#include "barcode_stats_classes.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/formatted.o.hh>

//Utility Headers
#include "utility/basic_sys_util.hh"

// C++ Headers
#include <cstdlib>
#include <iostream>
#include <list>
#include <vector>

namespace featurizer_ns {
	using namespace barcode_stats_ns;
	//////////////////////////////////////////
	class Pairing_feature : public Beta_feature {
		public:
			static int const MM = 0;
			static int const MP = 1;
			static int const PP = 2;
			static int const PM = 3;

		public:
			int maxpos;
			int extent[4];
			int DIFF1[4]; // = {-1, -1, +1, +1};
			int DIFF2[4]; // = {-1, +1, +1, -1};

			Pairing_feature ( int const i, int const j, int const o, int const p );
			Pairing_feature ( int const i, int const j, int const maxi, int const o, int const p );
			~Pairing_feature();
		private:
			void initialize_shifts(int orientation);

		public:
			int shiftmin();
			int shiftmax();
			bool contains_square(const int i1, const int i2);
		private:
			void get_start_corner(int &i1, int &i2, int dir, int dirextent, int backextent);
			bool raw_contains_square(const int i1, const int i2);
			bool satisfies_constraint(const int i1, const int i2, const int dir);
		public:
			void get_start_corner(int &i1, int &i2, int dir);
			void dir_move(int &i1, int &i2, int dir);
			int matching_coord2(int offset1, int dir, int extent);
			void get_shift_start_corner(int &i1, int &i2, int s);
			void shift_move(int &i1, int &i2);
			bool legal_square(int i1, int i2);
			bool legal();
			bool grow(int dir);
			bool shrink(int dir);
			float match(Pairing_feature &other);
			void merge(const Pairing_feature &other);
			void outputEdges(std::ostream &out);
			int center1();
			int center2();
			void recenter(const int i1, const int i2);
	};

	std::ostream & operator <<( std::ostream & os, Pairing_feature const & c );
	typedef std::list< std::pair< float, Pairing_feature > > Pairing_sorter;
	typedef std::vector< Pairing_feature > Pairing_list;

	/////////////////
	class Contact_feature {
		public:
			Contact_feature(int res1, int res2) : res1(res1), res2(res2) {
			}
		  bool operator==(const Contact_feature &other) {
				return (res1 == other.res1 && res1 == other.res2);
			}
			int getRes1() { return res1; }
			int getRes2() { return res2; }

//			int int_value1;
//			char char_value1;


		private:
			int res1, res2;
	};

	typedef std::vector< Contact_feature > Contact_list;

} // namespace

#endif
