// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 23432 $
//  $Date: 2008-06-24 16:25:52 +0300 (Tue, 24 Jun 2008) $
//  $Author: yab $


// Rosetta Headers
#include "files_paths.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/DimensionExpressions.hh>

// Utility Headers
#include <utility/io/izstream.hh>
#include <utility/io/ozstream.hh>

// C++ Headers
#include <fstream>


// ____________________________________________________
//
// Contains Paths and FileNames Used in program
// ___________________________________________________


namespace files_paths {


int const TAG_MAX_LENGTH = { 30 }; // tags for scorefiles, etc
int const NUMBER_MAX_LENGTH = { 4 }; // length of field for structure numbers
int const NAME_LENGTH = { 4 }; // length of field for protein_name


std::string protein_name( NAME_LENGTH, ' ' );
char protein_chain;
std::string code;
std::string movie_path;
std::string movie_file;
std::string pdb_out_path;
std::string score_path;
std::string score_file;
std::string status_path;
std::string status_file;
std::string user_path;
std::string pdb_path_1;
std::string pdb_path_2;
std::string fragments_path_1;
FArray1D_string frag_file_name( n_frag_files() );
FArray1D_int frag_sizes( n_frag_files() + 1, 0 ); // Extra element for 1mer library
std::string constraints_path;
std::string cst_ext; // extension for constraints file
std::string dpl_ext; // extension for dipolar file
std::string ss_path;
std::string seq_path;
std::string start_path;
std::string start_file;
std::string output_file;
std::string silent_input_file;
std::string ligand_input_mdlfile;
std::string data_path;
std::string data_path_2;
std::string disulf_connectivity_file;
std::string disulf_logfile;
std::string exrot_file;
std::string Eout;
std::string sqc;
std::string resfile;
std::string equiv_resfile;
std::string pdbout;
std::string alter_spec_mutfile;
std::string point_mut_energies;
std::string mut_mut_energies;
std::string ms_comp_list;
std::string ms_out_name;
std::string libraryname;
bool preserve_header = { false };
std::vector<std::string> header_info;
std::string mode_title = "";
// used to allow unique names for input files w/ names based on protein_name
std::string protein_name_prefix = "";
std::string frags_name_prefix = "";
bool homolog_to_query_mapping = false;

//-----------------------
// file streams
//-----------------------
utility::io::izstream pdb_x;
utility::io::izstream start_x;
utility::io::izstream data_x;
utility::io::ozstream status_x;
utility::io::ozstream fa_status_x;
std::ofstream user_x;
std::ofstream opte_x; // used for calibrating design module
std::ofstream sqc_x; // design module, sequence comparisons
std::ofstream disulf_log_x; // used for outputting disulf parameters

bool concat_outpdbs = { false };
std::string cat_outpdb_filename = "";
std::string cat_list_filename   = "";

bool single_silent_writer = { false };

//-------
// command line flags
//-------
//car  precedence/dependence

//car  require_start:  if not true, following options are not relevant
//car  use_fasta

//car  require_3args:  requires the query to be defined by code,protein and
//car                  chain; query must be defined for the following to be true:
//car    require_frags, use_constraints, use_fasta

//car if any of the following options are true, require_3args must also
//car be true because 'code' 'pdb' and/or 'chain' are part of naming conventions:
//	require_frags
//	use_constraints
//	use_scorefile

namespace query_defined_common {
	bool query_defined = { false }; // is the code,name,chain defined?
}


namespace io_options_bool {
	bool require_3args = { true }; // require code name chain on command line
		// required for constraints, native struct, frags
	bool require_frags = { true }; // read frag files
	bool require_start = { false }; // require at least one starting conformation
	bool use_fasta = { false }; // obtain sequence from fasta or dat
		// (otherwise from starting structure) // fasta requires default 3 args
	bool use_constraints = { true }; // look for constraint files
	bool output_all = { false }; // write out all structures (even if rg cut exceeded)
	bool accept_all = { false }; // accept all structures, even if they fail filters... useful for BOINC
	bool use_status = { false };
	bool use_decoy_status = { false };
	bool use_scorefile = { true };
	bool input_fa = { false }; // fullatom input
	bool no_optH = { false }; // skip hydrogen optimization on input structure
	bool include_inputchi = { false }; // include input rotamers when packing
	bool output_coord = { true }; // write out a coordinate file
	bool output_fa = { false }; // fullatom output
	bool output_centroids = { false }; // put centroid dummy atoms in output pdb.
	bool refold_input = { true }; // refold starting structures before using
	bool require_ss = { true }; // require ss for starting structure
	bool idealized_structure = { true }; // sets default for refolding
		// if true, residues assumed to be refoldable from angles
		// if true, residues cannot be refolded from angles //???
		// false if using nonideal backbone e.g. when redesigning native backbone
	bool repack_input = { false }; // repack input pdb structures?
	bool allow_missing = { false }; // use pdb file even if missing bb atoms
	bool randomize_missing = { false }; // randomize missing backbone coordinates
	bool skip_missing = { false }; // skip residues with missing atoms in pdb file
	bool read_all_chains = { false };
	bool chain_last_char = { false }; // if true the last character in the
		// start file name is the chain id
	bool multi_chain = { false }; // protein has multiple chains
	bool prevent_multi_chain = { false }; // jk override multi_chain if it would be on by default
	bool use_pdb_numbering = { false }; // use atom/chain/res from starting pdbfile
	bool silent_input = { false }; // input from silent mode file (default F)
	bool by_index = { false }; // silent mode by_index (default by_name)
	bool overwrite_pdbs = { false }; // allow pdb files to be overwritten
	bool touch_before_reading = { false }; // jk create empty output file before
	bool touch_before_starting = { true }; // create empty files before running desired simulation
	  // reading input pdb, if only one output structure is desired
	bool disable_filters = { false }; // disables all filters
	bool disable_output_decoy_filters = { false }; // disables filters at output
		// some may be re-enabled by command line
	bool use_timer = { false }; // write time per decoy to scorefile
	bool count_attempts = { false };
	bool scorefile_output_full_filename = { false }; // don't allow filenames to be truncated
	bool make_ise_movie = { false }; // dump pdbs for reading ise_movie.py
	bool IUPAC = { false }; // use IUPAC proton numbering when reading/writing in pdb/data files
	bool pose_looping = { false }; // pose looping mode
	bool domain_insertion = { false }; // protein insertion mode
	bool antibody_modeler = { false }; // antibody modeling mode
	bool create_domins_fasta = { false }; // creates a specialized fasta file for fragments of protein insertion
	bool window = { false }; // checks for window option, window option determines whether or not to use windows when creating a loop
	bool map_start_sequence = { false }; // allow re-mapping from start to fasta sequence
	bool output_chi_silent = { false };
	bool new_silent_reader = { false };
	bool skip_scorefile_check = { false };
    // gzipped output
	bool output_pdb_gz = { false }; // outputs gzipped decoy pdbs
	bool output_silent_gz = { false }; // outputs gzipped silent file
	bool output_scorefile_gz = { false }; // outputs gzipped score file
	bool pose_silent_out = { false }; // output structure has non-ideal geometry
	bool sasapack_bvalues = { false }; // bvalues reflect sasapack and unsatisfied hbond
	bool output_cen_vals = { false }; // add columns with cen6 and cen10 vals to "complete" lines
	bool use_conformer = { false }; // use conformer library
	bool use_bbind_conformer = { false }; // use backbone independent conformer library
	bool flip_symmetric_sidechains = { false }; // to agree w/ rosetta chi's
	bool use_homolog_env_stats = { false }; // to use homolog env statistics
	bool use_homolog_pair_stats = { false }; // to use homolog pair statistics
	bool use_homolog_cendist_stats = { false }; // to use homolog james statistics
	bool use_homolog_env_stats_in_farlx = { false }; // to use homolog env statistics
	bool use_homolog_pair_stats_in_farlx = { false }; // to use homolog pair statistics
	bool use_homolog_cendist_stats_in_farlx = { false }; // to use homolog james statistics
	bool output_hbond_info = { false }; // force output of hbond info when outputting pdb stats
	bool output_interface_hbonds_only = { false };
	bool remark_output = { false }; // Remark output of energies, so result can be redesign in rosetta and other software
	bool skip_dun = { false }; // skip bbdep, dunbrack, etc... good if you have no proteins.
}


namespace io_options_int {
	int default_nstruct = { 1000 }; // default number of structures
	int max_frags = { 200 }; // max fragments from frag file
}


int const MAX_FILTERS = { 7 };

int const rg_type = { 1 };
int const co_type = { 2 };
int const sheet_type = { 3 };
int const rms_type = { 4 };
int const disulfide_type = { 5 };
int const dock_type = { 6 };
int const knot_type = { 7 };


namespace io_options_filters {


	void
	use_filter_initializer( FArray1D_bool & use_filter )
	{
		//car filtering options
		use_filter(rg_type) = true; // filter structures by rg
		use_filter(co_type) = true; // filter structures by contact order
		use_filter(sheet_type) = true; // identify poor sheets
		use_filter(rms_type) = false;
		use_filter(disulfide_type) = false; // identify disulfides
		use_filter(dock_type) = false; // docking filters
		use_filter(knot_type) = false; // look for knots
	}


	FArray1D_bool use_filter( MAX_FILTERS, use_filter_initializer );
}


} // namespace files_paths


