// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 18467 $
//  $Date: 2007-11-16 23:20:47 +0200 (Fri, 16 Nov 2007) $
//  $Author: yab $


// Rosetta Headers
#include "after_opts.h"
#include "fold_abinitio.h"
#include "constraints.h"
#include "counters.h"
#include "diagnostics_rosetta.h"
#include "dipolar.h"
#include "fold_constraints.h"
#include "fragments.h"
#include "fullatom.h"
#include "maps.h"
#include "misc.h"
#include "monte_carlo.h"
#include "orient_rms.h"
#include "param.h"
#include "random_numbers.h"
#include "recover.h"
#include "refold.h"
#include "score.h"
#include "ssblocks.h"
#include "taboo_search.h"
#include "torsion_bbmove_trials.h"
#include "trajectory.h"
#include "structure.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/Fmath.hh>
#include <ObjexxFCL/formatted.o.hh>

// C++ Headers
#include <iostream>


////////////////////////////////////////////////////////////////////////////////
/// @begin fold_abinitio
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
fold_abinitio()
{
	using namespace counters;
	using namespace misc;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

	int number3merfrags = get_number3merfrags(); // Default 25
	int number9merfrags = get_number9merfrags(); // Default 200

	if (use_random_top_frags()){
		number3merfrags= static_cast< int >( (number3merfrags-100)*ran3() ) + 100;
		number9merfrags= static_cast< int >( (number9merfrags-25)*ran3() ) + 25;
		std::cout << "NUMBER 3MER FRAGS = " << number3merfrags << ";   NUMBER 9MER FRAGS = " << number9merfrags <<  std::endl;
	}
	float increase_cycles = get_increase_cycles(); // default is just 1
	// params
	int score0_cycles(  static_cast< int > (2000 * increase_cycles) );
	int score1_cycles(  static_cast< int > (2000 * increase_cycles) );
	int score25_cycles( static_cast< int > (2000 * increase_cycles) );
	int score3_cycles(  static_cast< int > (4000 * increase_cycles) );

	int const contig_cut1 = { 4 };
	 // cutoffs for largest insertable region // return
	int const contig_cut2 = { 10 }; // use 3mers only
	int const contig_cut3 = { 30 };
	 // when contig < cutoff then: // use 3mers and 9mers in early sections

	int size;
	float cutoff;
	float init_temp;

	int nloop2,nloop,cycles;

	int contig_size,total_size;

// User may want to only run smooth fragment insertions to "refine" an input conformation.
	bool const just_smooth_cycles = get_just_smooth_cycles();
	if (just_smooth_cycles){ // No score0/score1/score25 moves. See below for score3.
		score0_cycles  = 0;
		score1_cycles  = 0;
		score25_cycles = 0;
	}

// Score can include a component proportional to -1/rms -- attempt to figure
//  out the best we can do with given fragments.
	bool const optimize_rmsd = get_optimize_rmsd();

//------------------------------------------------------------------------------
	clear_trajectory();
	structure::BOUNDARY::setup_rsd_weight();  // get residue specific temperatures
	structure::BOUNDARY::setup_SS_weight();  // get weights for sec. struct. terms
	classical_constraints::BOUNDARY::setup_cst_res_weight();
	if ( classical_constraints::BOUNDARY::get_constraints_exist() ) {
		fold_constraints();
    classical_constraints::BOUNDARY::reset_cst_res_wt();
		return;
	}

// initial conditions for the protocol
	init_temp = get_abinitio_temperature(); //default is 2.0
	monte_carlo_set_quench_temp(init_temp);
	monte_carlo_set_temp(init_temp); // reset temp
	monte_carlo_set_simannealing(true); // don't let mc change temp
	set_fullatom_flag(false); // should be off, but ensure it is
	choose_frag_set_top_N_frags(number9merfrags); // use top 25 frags

  if (get_random_frag_state()) {
		pick_random_frags(200,100,30,12);// randomly pick 100 of the top 200 3mers and 10 of the top 30 9mers.  different choice for each trajectory to spread out sampling
	}

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//  insert secondary structure, bump check only
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
	std::cout << "starting fragment insertions..." << std::endl;

	decide_block_state();
// parameters
	recover_LOW(score0);
	cycles = score0_cycles;
	size = 9;
	insert_map_get_max_contig_size(contig_size,total_size);
	if ( contig_size < contig_cut1 ) return;
	if ( contig_size < contig_cut2 ) size = 3; // use 3mers only

// diagnostics
	reset_trial_counters();

// frag insertions
	for ( int j = 1; j <= cycles; ++j ) {
		main_frag_trial(size,score0,-1);
		if ( start_sim() == 1 ) goto L101; // all swapped one or more times
	}
	for ( int j = 1; j <= cycles; ++j ) {
	 // if still not all swapped, try smaller frags
		main_frag_trial(3,score0,-1);
		if ( start_sim() == 1 ) goto L101;
	}
	std::cout << "WARNING: extended chain may still remain!" << std::endl;
L101:

// diagnostics
	refold(1,total_residue); // recover current structure
	calc_rms();
	std::cout << "score0 done: (best, low) rms" << std::endl;
	std::cout << SS( best_score ) << SS( low_score ) << SS( rms_err ) << std::endl;
	output_trial_counters( std::cout );
	std::cout << "---------------------------------------------------------" << std::endl;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//    regular moves   w/bumps,secondary structure, light strand pairing
//    no rg or cbeta yet
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

// parameters/setup
	monte_carlo_set_simannealing(false); // let mc raise temp

	cycles = score1_cycles;
	if ( contig_size < contig_cut3 ) cycles /= 2; // do 3mers too
	new_score_function(score1);

// diagnostics
	reset_trial_counters();

// frag insertions
	for ( int j = 1; j <= cycles; ++j ) {
		main_frag_trial(size,score1,j);
		if ( contig_size < contig_cut3 ) main_frag_trial(3,score1,j);
	}

// diagnostics
	refold(1,total_residue);
	calc_rms();
	std::cout << "score1 done: (best, low) rms (best,low)" << std::endl;
	std::cout << SS( best_score ) << SS( low_score ) << SS( rms_err ) <<
	 SS( low_rms ) << std::endl;
	output_trial_counters( std::cout );
	std::cout << "-----------------------------------------------------" << std::endl;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   Add cbeta, rg (collapse chain)
//   alternate score2/score5 (high/low sheet weight)
//   convergence-checking enabled in monte_carlo
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

// setup
	recover_LOW(score2);
	if (optimize_rmsd) recover_LOW(score99); // score99 cheats: optimizes rms to native.

	nloop = 1;
	nloop2 = 10;
	cycles = score25_cycles;
	if ( contig_size < contig_cut3 ) {
		nloop = 2; // 9mers, then 3mers
		nloop2 = 5;
		cycles = score25_cycles;
	}
	monte_carlo_set_temp(init_temp); // reset mc temp

// diagnostics
	std::cout << "Alternate score2/score5..." << std::endl;
	std::cout << "kk score2 score5 low_score n_low_accept" <<
	 " rms rms_min low_rms" << std::endl;
	std::cout << I( 3, 0 ) << ' ' << F( 8, 3, score ) << ' ';
	std::cout << F( 8, 3, score5() ) << ' '; // Sequence point
	std::cout << F( 8, 3, low_score ) << ' ' <<
	 I( 4, n_low_accept ) << ' ' << F( 8, 3, rms_err ) << ' ' <<
	 F( 8, 3, rms_min ) << ' ' << F( 8, 3, low_rms ) << std::endl;

	reset_trial_counters();

// frag insertions
	for ( int jj = 1; jj <= nloop; ++jj ) {
		if ( jj > 1 ) size = 3;
		for ( int kk = 1; kk <= nloop2; ++kk ) {
			if (!optimize_rmsd){
				if ( mod( kk, 2 ) == 0 || kk > 7 ) {
					recover_LOW(score2);
				} else {
					recover_LOW(score5);
				}
			}

			for ( int j = 1; j <= cycles; ++j ) {
				if (!optimize_rmsd){
					if ( mod( kk, 2 ) == 0 || kk > 7 ) {
						main_frag_trial(size,score2,j*kk+100000);
					} else {
						main_frag_trial(size,score5,j*kk+100000);
					}
				} else {
					main_frag_trial(size,score99,j*kk+100000); // Cheating: Score includes rms to native.
				}
				if ( get_monte_carlo_converged() == 1 ) goto L112;
			}               // j
L112:; //  escape

//$ diagnostics
			refold(1,total_residue); // recover current structure
			calc_rms();
			std::cout << I( 3, kk ) << ' ' <<
			 F( 8, 3, score2() ) << ' '; // Sequence point
			std::cout << F( 8, 3, score5() ) << ' '; // Sequence point
			std::cout << F( 8, 3, low_score ) << ' ' <<
			 I( 4, n_low_accept ) << ' ' << F( 8, 3, rms_err ) << ' ' <<
			 F( 8, 3, rms_min ) << ' ' << F( 8, 3, low_rms ) << std::endl;
//$ end diagnostics

		}                  // kk
	}                     // jj

// diagnostics
	output_trial_counters( std::cout );


	std::cout << "-----------------------------------------------------" << std::endl;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   regular moves/smooth moves
//   score 3 ->all centroid based terms on
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	std::cout << "Starting score3 moves..." << std::endl;

// setup
	recover_LOW(score3);
	nloop = 3;
	if (optimize_rmsd) {
		recover_LOW(score99); // score99 cheats: optimizes rms to native.
		nloop = 10; // More 3mer moves seem to help a lot.
	}
	cycles = score3_cycles;
	cutoff = 7;
	size = 3;

// diagnostics
	reset_trial_counters();
	std::cout << "kk,score3,low_score,rms_err,low_rms,rms_min,naccept" << std::endl;
	calc_rms();
	std::cout << I( 3, 0 ) << ' ' <<
	 F( 8, 3, score ) << ' ' <<
	 F( 8, 3, low_score ) << ' ' <<
	 F( 8, 3, rms_err ) << ' ' <<
	 F( 8, 3, low_rms ) << ' ' <<
	 F( 8, 3, rms_min ) << ' ' <<
	 I( 4, naccept ) << std::endl;

//  frag insertions
	for ( int kk = 1; kk <= nloop; ++kk ) {
		recover_LOW(score3);
		if (optimize_rmsd) recover_LOW(score99); // score99 cheats: optimizes rms to native.
		monte_carlo_set_temp(init_temp); // reset mc temp
		if ( kk == 2 ) choose_frag_set_top_N_frags(number3merfrags);
		for ( int j = 1; j <= cycles; ++j ) {
			if ( kk == 1 && !just_smooth_cycles) {
				if (!optimize_rmsd) main_frag_trial(size,score3,j*kk);
				else  main_frag_trial(size,score99,j*kk); // Cheating: Score includes rms to native.
			} else {
				if (!optimize_rmsd) main_smooth_trial(size,cutoff,score3,j*kk);
				else  main_smooth_trial(size,cutoff,score99,j*kk); // Cheating: Score includes rms to native.
			}
		}                  // loop j

//$ diagnostics
		refold(1,total_residue);
		calc_rms();
		std::cout << I( 3, kk ) << ' ' <<
		 F( 8, 3, score3() ) << ' '; // Sequence point
		std::cout <<
		 F( 8, 3, low_score ) << ' ' <<
		 F( 8, 3, rms_err ) << ' ' <<
		 F( 8, 3, low_rms ) << ' ' <<
		 F( 8, 3, rms_min ) << ' ' <<
		 I( 4, naccept ) << std::endl;
//$ end diagnostics

	}                     // kk

// diagnostics
	output_block_state( std::cout );
	output_trial_counters( std::cout );
	std::cout << "-----------------------------------------------------" << std::endl;
	std::cout << "-----------------------------------------------------" << std::endl;

	if ( get_dipolar_exist() && ! get_fast_cst_protocol()) refine_constraints();
 	structure::BOUNDARY::reset_rsd_wt();
	structure::BOUNDARY::setup_SS_default_weight();
}

//------------------------------------------------------------------------------
int
start_sim()
{
	using namespace misc;
	using namespace param;

	int start_sim = 1; // Return value

//car returns 1 if no initial angles remain

	for ( int i = 1; i <= total_residue; ++i ) {
		if ( phi(i) == init_phi ) start_sim = 0;
		if ( psi(i) == init_psi ) start_sim = 0;
	}

	return start_sim;
}


float
get_increase_cycles()
{
	static float increase_cycles = 1.0;
	static bool init = { false };

	if ( !init ) {
		realafteroption("increase_cycles",1.0, increase_cycles);
		init = true;
	}
	return increase_cycles;
}

bool
get_just_smooth_cycles()
{
	static bool just_smooth = { false};
	static bool init = { false };

	if ( !init ) {
		just_smooth  = truefalseoption("just_smooth_cycles");
		init = true;
	}
	return just_smooth;
}

bool
get_optimize_rmsd()
{
	static bool optimize_rmsd = { false};
	static bool init = { false };

	if ( !init ) {
		optimize_rmsd  = truefalseoption("optimize_rmsd");
		init = true;
	}
	return optimize_rmsd;
}

bool
use_random_top_frags()
{
	static bool random_top_frags = { false };
	static bool init = {false};

	if ( !init ) {
		random_top_frags = truefalseoption("use_random_top_frags");
		init = true;
	}

	return random_top_frags;
}

int
get_number9merfrags()
{
	static int number9merfrags;
	static bool init = { false };

	if ( !init ) {
		intafteroption("number_9mer_frags",25, number9merfrags);
		init = true;
	}
	return number9merfrags;
}

int
get_number3merfrags()
{
	static int number3merfrags;
	static bool init = { false };

	if ( !init ) {
		intafteroption("number_3mer_frags",200, number3merfrags);
		init = true;
	}
	return number3merfrags;
}

float
get_abinitio_temperature()
{
	static float abinitio_temperature;
	static bool init = { false };

	if ( !init ) {
		abinitio_temperature = realafteroption("abinitio_temperature",2.0);
		init = true;
	}
	return abinitio_temperature;
}

int
get_score0fragsize()
{
	static int score0fragsize;
	static bool init = { false };

	if ( !init ) {
		intafteroption("vf_score0_fragsize",9, score0fragsize);
		init = true;
	}
	return score0fragsize;
}

int
get_score1fragsize()
{
	static int score1fragsize;
	static bool init = { false };

	if ( !init ) {
		intafteroption("vf_score1_fragsize",9, score1fragsize);
		init = true;
	}
	return score1fragsize;
}

int
get_score25fragsize()
{
	static int score25fragsize;
	static bool init = { false };

	if ( !init ) {
		intafteroption("vf_score25_fragsize",9, score25fragsize);
		init = true;
	}
	return score25fragsize;
}

int
get_score3fragsize()
{
	static int score3fragsize;
	static bool init = { false };

	if ( !init ) {
		intafteroption("vf_score3_fragsize",3, score3fragsize);
		init = true;
	}
	return score3fragsize;
}


bool
get_skipscore3()
{
	static bool skipscore3;
	static bool init = { false };

	if ( !init ) {
		skipscore3 = truefalseoption("vf_skip_score_3");
		init = true;
	}
	return skipscore3;
}




////////////////////////////////////////////////////////////////////////////////
/// @begin fold_abinitio_variable_fragment_lengths()
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
fold_abinitio_variable_fragment_lengths()
{
	using namespace counters;
	using namespace misc;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

	int number3merfrags = get_number3merfrags(); // Default 25
	int number9merfrags = get_number9merfrags(); // Default 200

	int score0_fragsize = get_score0fragsize();
	int score1_fragsize = get_score1fragsize();
	int score25_fragsize = get_score25fragsize();
	int score3_fragsize = get_score3fragsize();

	bool skipscore3 = get_skipscore3();

	if (use_random_top_frags()){
		number3merfrags= static_cast< int >( (number3merfrags-100)*ran3() ) + 100;
		number9merfrags= static_cast< int >( (number9merfrags-25)*ran3() ) + 25;
		std::cout << "NUMBER 3MER FRAGS = " << number3merfrags << ";   NUMBER 9MER FRAGS = " << number9merfrags <<  std::endl;
	}
	float increase_cycles = get_increase_cycles(); // default is just 1
	// params
	int score0_cycles(  static_cast< int > (2000 * increase_cycles) );
	int score1_cycles(  static_cast< int > (2000 * increase_cycles) );
	int score25_cycles( static_cast< int > (2000 * increase_cycles) );
	int score3_cycles(  static_cast< int > (4000 * increase_cycles) );

	int const contig_cut1 = { 4 };
	 // cutoffs for largest insertable region // return
	int const contig_cut2 = { 10 }; // use 3mers only
	int const contig_cut3 = { 30 };
	 // when contig < cutoff then: // use 3mers and 9mers in early sections

	int size;
	float cutoff;
	float init_temp;

	int nloop2,nloop,cycles;

	int contig_size,total_size;

// User may want to only run smooth fragment insertions to "refine" an input conformation.
	bool const just_smooth_cycles = get_just_smooth_cycles();
	if (just_smooth_cycles){ // No score0/score1/score25 moves. See below for score3.
		score0_cycles  = 0;
		score1_cycles  = 0;
		score25_cycles = 0;
	}

// Score can include a component proportional to -1/rms -- attempt to figure
//  out the best we can do with given fragments.
	bool const optimize_rmsd = get_optimize_rmsd();

//------------------------------------------------------------------------------
	clear_trajectory();
	structure::BOUNDARY::setup_rsd_weight();  // get residue specific temperatures
	structure::BOUNDARY::setup_SS_weight();  // get weights for sec. struct. terms
	classical_constraints::BOUNDARY::setup_cst_res_weight();
	if ( classical_constraints::BOUNDARY::get_constraints_exist() ) {
		fold_constraints();
    classical_constraints::BOUNDARY::reset_cst_res_wt();
		return;
	}

// initial conditions for the protocol
	init_temp = get_abinitio_temperature(); //default is 2.0
	monte_carlo_set_quench_temp(init_temp);
	monte_carlo_set_temp(init_temp); // reset temp
	monte_carlo_set_simannealing(true); // don't let mc change temp
	set_fullatom_flag(false); // should be off, but ensure it is
	choose_frag_set_top_N_frags(number9merfrags); // use top 25 frags

  if (get_random_frag_state()) {
		pick_random_frags(200,100,30,12);// randomly pick 100 of the top 200 3mers and 10 of the top 30 9mers.  different choice for each trajectory to spread out sampling
	}

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//  insert secondary structure, bump check only
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
	std::cout << "starting fragment insertions..." << std::endl;

	decide_block_state();
// parameters
	recover_LOW(score0);
	cycles = score0_cycles;
	size = score0_fragsize;
	insert_map_get_max_contig_size(contig_size,total_size);
	if ( contig_size < contig_cut1 ) return;
	if ( contig_size < contig_cut2 ) size = 3; // use 3mers only

// diagnostics
	reset_trial_counters();

// frag insertions
	for ( int j = 1; j <= cycles; ++j ) {
		main_frag_trial(size,score0,-1);
		if ( start_sim() == 1 ) goto L101; // all swapped one or more times
	}
	for ( int j = 1; j <= cycles; ++j ) {
	 // if still not all swapped, try smaller frags
		main_frag_trial(3,score0,-1);
		if ( start_sim() == 1 ) goto L101;
	}
	std::cout << "WARNING: extended chain may still remain!" << std::endl;
L101:

// diagnostics
	refold(1,total_residue); // recover current structure
	calc_rms();
	std::cout << "score0 done: (best, low) rms" << std::endl;
	std::cout << SS( best_score ) << SS( low_score ) << SS( rms_err ) << std::endl;
	output_trial_counters( std::cout );
	std::cout << "---------------------------------------------------------" << std::endl;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//    regular moves   w/bumps,secondary structure, light strand pairing
//    no rg or cbeta yet
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	size = score1_fragsize;

// parameters/setup
	monte_carlo_set_simannealing(false); // let mc raise temp

	cycles = score1_cycles;
	if ( contig_size < contig_cut3 ) cycles /= 2; // do 3mers too
	new_score_function(score1);

// diagnostics
	reset_trial_counters();

// frag insertions
	for ( int j = 1; j <= cycles; ++j ) {
		main_frag_trial(size,score1,j);
		if ( contig_size < contig_cut3 ) main_frag_trial(3,score1,j);
	}

// diagnostics
	refold(1,total_residue);
	calc_rms();
	std::cout << "score1 done: (best, low) rms (best,low)" << std::endl;
	std::cout << SS( best_score ) << SS( low_score ) << SS( rms_err ) <<
	 SS( low_rms ) << std::endl;
	output_trial_counters( std::cout );
	std::cout << "-----------------------------------------------------" << std::endl;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   Add cbeta, rg (collapse chain)
//   alternate score2/score5 (high/low sheet weight)
//   convergence-checking enabled in monte_carlo
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

// setup
	recover_LOW(score2);
	if (optimize_rmsd) recover_LOW(score99); // score99 cheats: optimizes rms to native.

	nloop = 1;
	nloop2 = 10;
	cycles = score25_cycles;
	if ( contig_size < contig_cut3 ) {
		nloop = 2; // 9mers, then 3mers
		nloop2 = 5;
		cycles = score25_cycles;
	}
	monte_carlo_set_temp(init_temp); // reset mc temp

	size = score25_fragsize;

// diagnostics
	std::cout << "Alternate score2/score5..." << std::endl;
	std::cout << "kk score2 score5 low_score n_low_accept" <<
	 " rms rms_min low_rms" << std::endl;
	std::cout << I( 3, 0 ) << ' ' << F( 8, 3, score ) << ' ';
	std::cout << F( 8, 3, score5() ) << ' '; // Sequence point
	std::cout << F( 8, 3, low_score ) << ' ' <<
	 I( 4, n_low_accept ) << ' ' << F( 8, 3, rms_err ) << ' ' <<
	 F( 8, 3, rms_min ) << ' ' << F( 8, 3, low_rms ) << std::endl;

	reset_trial_counters();

// frag insertions
	for ( int jj = 1; jj <= nloop; ++jj ) {
		if ( jj > 1 ) size = 3;
		for ( int kk = 1; kk <= nloop2; ++kk ) {
			if (!optimize_rmsd){
				if ( mod( kk, 2 ) == 0 || kk > 7 ) {
					recover_LOW(score2);
				} else {
					recover_LOW(score5);
				}
			}

			for ( int j = 1; j <= cycles; ++j ) {
				if (!optimize_rmsd){
					if ( mod( kk, 2 ) == 0 || kk > 7 ) {
						main_frag_trial(size,score2,j*kk+100000);
					} else {
						main_frag_trial(size,score5,j*kk+100000);
					}
				} else {
					main_frag_trial(size,score99,j*kk+100000); // Cheating: Score includes rms to native.
				}
				if ( get_monte_carlo_converged() == 1 ) goto L112;
			}               // j
L112:; //  escape

//$ diagnostics
			refold(1,total_residue); // recover current structure
			calc_rms();
			std::cout << I( 3, kk ) << ' ' <<
			 F( 8, 3, score2() ) << ' '; // Sequence point
			std::cout << F( 8, 3, score5() ) << ' '; // Sequence point
			std::cout << F( 8, 3, low_score ) << ' ' <<
			 I( 4, n_low_accept ) << ' ' << F( 8, 3, rms_err ) << ' ' <<
			 F( 8, 3, rms_min ) << ' ' << F( 8, 3, low_rms ) << std::endl;
//$ end diagnostics

		}                  // kk
	}                     // jj

	if (skipscore3) goto L12312;
// diagnostics
	output_trial_counters( std::cout );


	std::cout << "-----------------------------------------------------" << std::endl;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   regular moves/smooth moves
//   score 3 ->all centroid based terms on
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	std::cout << "Starting score3 moves..." << std::endl;

// setup
	recover_LOW(score3);
	nloop = 3;
	if (optimize_rmsd) {
		recover_LOW(score99); // score99 cheats: optimizes rms to native.
		nloop = 10; // More 3mer moves seem to help a lot.
	}
	cycles = score3_cycles;
	cutoff = 7;
	size = score3_fragsize;

// diagnostics
	reset_trial_counters();
	std::cout << "kk,score3,low_score,rms_err,low_rms,rms_min,naccept" << std::endl;
	calc_rms();
	std::cout << I( 3, 0 ) << ' ' <<
	 F( 8, 3, score ) << ' ' <<
	 F( 8, 3, low_score ) << ' ' <<
	 F( 8, 3, rms_err ) << ' ' <<
	 F( 8, 3, low_rms ) << ' ' <<
	 F( 8, 3, rms_min ) << ' ' <<
	 I( 4, naccept ) << std::endl;

//  frag insertions
	for ( int kk = 1; kk <= nloop; ++kk ) {
		recover_LOW(score3);
		if (optimize_rmsd) recover_LOW(score99); // score99 cheats: optimizes rms to native.
		monte_carlo_set_temp(init_temp); // reset mc temp
		if ( kk == 2 ) choose_frag_set_top_N_frags(number3merfrags);
		for ( int j = 1; j <= cycles; ++j ) {
			if ( kk == 1 && !just_smooth_cycles) {
				if (!optimize_rmsd) main_frag_trial(size,score3,j*kk);
				else  main_frag_trial(size,score99,j*kk); // Cheating: Score includes rms to native.
			} else {
				if (!optimize_rmsd) main_smooth_trial(size,cutoff,score3,j*kk);
				else  main_smooth_trial(size,cutoff,score99,j*kk); // Cheating: Score includes rms to native.
			}
		}                  // loop j

//$ diagnostics
		refold(1,total_residue);
		calc_rms();
		std::cout << I( 3, kk ) << ' ' <<
		 F( 8, 3, score3() ) << ' '; // Sequence point
		std::cout <<
		 F( 8, 3, low_score ) << ' ' <<
		 F( 8, 3, rms_err ) << ' ' <<
		 F( 8, 3, low_rms ) << ' ' <<
		 F( 8, 3, rms_min ) << ' ' <<
		 I( 4, naccept ) << std::endl;
//$ end diagnostics

	}                     // kk

 L12312:
// diagnostics
	output_block_state( std::cout );
	output_trial_counters( std::cout );
	std::cout << "-----------------------------------------------------" << std::endl;
	std::cout << "-----------------------------------------------------" << std::endl;



	if ( get_dipolar_exist() && ! get_fast_cst_protocol()) refine_constraints();
 	structure::BOUNDARY::reset_rsd_wt();
	structure::BOUNDARY::setup_SS_default_weight();
}

//------------------------------------------------------------------------------
