// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13036 $
//  $Date: 2007-02-23 05:03:09 +0200 (Fri, 23 Feb 2007) $
//  $Author: yab $


// Rosetta Headers
#include "fold_constraints.h"
#include "after_opts.h"
#include "constraints.h"
#include "counters.h"
#include "diagnostics_rosetta.h"
#include "fold_abinitio.h"
#include "force_barcode.h"
#include "fragments.h"
#include "fullatom.h"
#include "loops.h"
#include "maps.h"
#include "misc.h"
#include "monte_carlo.h"
#include "orient_rms.h"
#include "param.h"
#include "recover.h"
#include "refold.h"
#include "runlevel.h"
#include "score.h"
#include "score_ns.h"
#include "ssblocks.h"
#include "torsion_bbmove_trials.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/Fmath.hh>
#include <ObjexxFCL/formatted.o.hh>

// C++ Headers
#include <cmath>
#include <iostream>


////////////////////////////////////////////////////////////////////////////////
/// @begin fold_constraints
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
fold_constraints()
{
	using namespace counters;
	using namespace misc;
	using namespace runlevel_ns;
	using namespace scores;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

	int const contig_cut1 = { 4 };
	 // cutoffs for largest insertable region // return
	int const contig_cut2 = { 10 }; // use 3mers only
	int const contig_cut3 = { 30 };
	 // when contig < cutoff then: // use 3mers and 9mers in early sections

	int size, noe_stage;
	int nloop, cycles;
	int contig_size, total_size;
	float init_temp, temperature;
	float old_pc;

//------------------------------------------------------------------------------
  if (get_random_frag_state()) {
		pick_random_frags(200,100,75,25);// use 100 randomly picked 3mers and
		//25 randomly picked (from the top 75) 9mers
	}

	if ( get_fast_cst_protocol() ) {
		fold_constraints_fast();
		return;
	}
  if (barcode_exist()) {
		choose_frag_set_check_ss(false);
	}
	set_fullatom_flag(false);
	size = 9; // 9mers til otherwise changed
	score_set_cst_mode(3);

	bool const fold_constraints_no_minimize = get_fold_constraints_no_minimize();

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//  get the initial structure
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	recover_LOW(score0);

	insert_map_get_max_contig_size(contig_size,total_size);
	if ( contig_size < contig_cut1 ) return;
	if ( contig_size < contig_cut2 ) size = 3; // use 3mers only

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//  insert secondary structure, bump check,short range constraints
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	temperature = 2.0;
	monte_carlo_set_simannealing(true); // don't let mc change temp
	monte_carlo_set_temp(temperature);
  if (get_ssblock_state()) {
		decide_block_state();
			}
	cycles = 2000;
	choose_frag_set_top_N_frags(25);

	reset_trial_counters();
	classical_constraints::BOUNDARY::set_max_seqSep(3);

	std::cout << "starting fragment insertions..." << std::endl;
	for ( int j = 1; j <= cycles; ++j ) {
		main_frag_trial(size,score0,j);
		if ( start_sim() == 1 ) goto L101; // all swapped one or more times
	}
	for ( int j = 1; j <= cycles; ++j ) { // if still not all swapped, try smaller frags
		main_frag_trial(3,score0,j);
		if ( start_sim() == 1 ) goto L101;
	}
	std::cout << "WARNING: extended chain may still remain!" << std::endl;
L101:

	refold(1,total_residue); // recover current structure
	calc_rms();
	std::cout << "score0 done: (best, low) rms pc_score" << std::endl;
	std::cout << SS( best_score ) << SS( low_score ) << SS( rms_err ) <<
	 SS( pc_score ) << std::endl;
	output_trial_counters( std::cout );
	std::cout << "-----------------------------------------------------" << std::endl;

//car satisfy all sort range constraints if possible:
	cycles = 500; // is this enough? from 2000
	old_pc = pc_score;
	choose_frag_set_top_N_frags(200);
	temperature = .0001f; // only accept lower score
	monte_carlo_set_temp(temperature);
	for ( int jk = 3; jk <= 15; jk += 2 ) {
		classical_constraints::BOUNDARY::set_max_seqSep(jk);
		recover_LOW(score0);
		if ( pc_score == old_pc ) goto L102;
		for ( int j = 1; j <= cycles; ++j ) {
			if ( pc_score < 10.0 ) goto L102;
			if (barcode_exist()) {
				main_frag_trial(size,score0,j);
			} else {
				main_frag_cst_trial(size,score0,j,2.0f);
			}
		}
L102:
		old_pc = pc_score;
	}

	refold(1,total_residue);
	score = score0();
	calc_rms();
	std::cout << "stage " << classical_constraints::BOUNDARY::get_max_seqSep() <<
	 " done: (best, low) rms pc_score" << std::endl;
	std::cout << SS( best_score ) << SS( low_score ) << SS( rms_err ) <<
	 SS( pc_score ) << std::endl;
	output_trial_counters( std::cout );
	std::cout << "-----------------------------------------------------" << std::endl;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//    regular moves   w/bumps, short-range dist constraints
//         secondary structure, light strand pairing
//    no rg or cbeta yet
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	monte_carlo_set_simannealing(false); // let mc raise temp
	init_temp = 2.0;
	monte_carlo_set_quench_temp(init_temp);
	monte_carlo_set_temp(init_temp);

	cycles = 5000;
	if ( contig_size < contig_cut3 ) cycles /= 2; // do 3mers too

	choose_frag_set_top_N_frags(200);
	classical_constraints::BOUNDARY::set_max_seqSep(15);
	recover_LOW(score1);
	reset_trial_counters();
	std::cout << "score1 start" << std::endl;
	std::cout << "score1 low_score n_low_accept rms rms_min" <<
	 " low_rms  pc  noe_stage dipolar projection" << std::endl;
	std::cout << ' ' << F( 9, 1, score ) << ' ' <<
	 F( 9, 1, low_score ) << ' ' << I( 4, n_low_accept ) << ' ' <<
	 F( 7, 2, rms_err ) << ' ' << F( 7, 2, rms_min ) << ' ' <<
	 F( 7, 2, low_rms ) << ' ' << F( 7, 2, pc_score ) << ' ' <<
	 I( 3, classical_constraints::BOUNDARY::get_max_seqSep() ) << ' ' << F( 7, 2, dipolar_score ) << ' ' <<
	 F( 7, 2, projection_score ) << std::endl;

	for ( int j = 1; j <= cycles; ++j ) {
		main_frag_cst_trial(size,score1,j,2.0f);
		if ( contig_size < contig_cut3 ) main_frag_cst_trial(3,score1,j,2.0f);
	}

	refold(1,total_residue);
	calc_rms();
	score = score1();
	std::cout << "score1 end" << std::endl;
	std::cout << ' ' << F( 9, 1, score ) << ' ' <<
	 F( 9, 1, low_score ) << ' ' << I( 4, n_low_accept ) << ' ' <<
	 F( 7, 2, rms_err ) << ' ' << F( 7, 2, rms_min ) << ' ' <<
	 F( 7, 2, low_rms ) << ' ' << F( 7, 2, pc_score ) << ' ' <<
	 I( 3, classical_constraints::BOUNDARY::get_max_seqSep() ) << ' ' << F( 7, 2, dipolar_score ) << ' ' <<
	 F( 7, 2, projection_score ) << std::endl;

	std::cout << "score1 done: (best, low) rms (best,low) pc_score" << std::endl;
	std::cout << SS( best_score ) << SS( low_score ) << SS( rms_err ) <<
	 SS( low_rms ) << SS( pc_score ) << std::endl;
	if (!fold_constraints_no_minimize) main_minimize_trial(score1,"dfpmin");
	std::cout << "score1 done: (best, low) rms (best,low) pc_score" << std::endl;
	std::cout << SS( best_score ) << SS( low_score ) << SS( rms_err ) <<
	 SS( low_rms ) << SS( pc_score ) << std::endl;
	output_trial_counters( std::cout );
	std::cout << "-----------------------------------------------------" << std::endl;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   Add cbeta, rg (collapse chain)
//   alternate score2/score5 (high/low sheet weight)
//   cycle the noe_stage
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	recover_LOW(score2);

	std::cout << "Alternate score2/score5" << std::endl;
	std::cout << "kk score2 score5 low_score n_low_accept rms rms_min" <<
	 " low_rms  pc  noe_stage dipolar projection" << std::endl;
	calc_rms();
	std::cout << I( 3, 0 ) << ' ' << F( 9, 1, score ) << ' ';
	std::cout << F( 9, 1, score5() ) << ' '; // Sequence point
	std::cout << F( 9, 1, low_score ) << ' ' <<
	 I( 4, n_low_accept ) << ' ' << F( 7, 2, rms_err ) << ' ' <<
	 F( 7, 2, rms_min ) << ' ' << F( 7, 2, low_rms ) << ' ' <<
	 F( 7, 2, pc_score ) << ' ' << I( 3, classical_constraints::BOUNDARY::get_max_seqSep() ) << ' ' <<
	 F( 7, 2, dipolar_score ) << std::endl;

	choose_frag_set_top_N_frags(200);
	nloop = 10; // 7
	cycles = 2000;
	size = 9;

	if ( benchmark ) nloop = 1;

	reset_trial_counters();
	monte_carlo_set_temp(init_temp);


//db does score2 only for last 3  (no constraints)
//car 7 cycles up to stage=length/2
	for ( int kk = 1; kk <= nloop; ++kk ) {
		if ( kk > 10 ) size = 3;
		noe_stage = 15 + (total_residue/2-15)*kk/nloop;
		classical_constraints::BOUNDARY::set_max_seqSep(noe_stage);
		if ( kk > nloop-2 ) {
			recover_LOW(score2);
		} else {
			recover_LOW(score5);
		}
		calc_rms();
		std::cout << I( 3, kk ) << ' ' <<
		 F( 9, 1, score2() ) << ' '; // Sequence point
		std::cout << F( 9, 1, score5() ) << ' '; // Sequence point
		std::cout << F( 9, 1, low_score ) << ' ' <<
		 I( 4, n_low_accept ) << ' ' << F( 7, 2, rms_err ) << ' ' <<
		 F( 7, 2, rms_min ) << ' ' << F( 7, 2, low_rms ) << ' ' <<
		 F( 7, 2, pc_score ) << ' ' << I( 3, classical_constraints::BOUNDARY::get_max_seqSep() ) << ' ' <<
		 F( 7, 2, dipolar_score ) << ' ' << F( 7, 2, projection_score ) <<
		 "   start" << std::endl;
		for ( int j = 1; j <= cycles/2; ++j ) {
			if (barcode_exist()) {
			 if ( kk > nloop-2 ) {
				main_frag_trial(size,score2,j);
		  	} else {
				main_frag_trial(size,score5,j);
			 }
			} else {
			 if ( kk > nloop-2 ) {
				main_frag_cst_trial(size,score2,j+kk*100000,2.0f);
			 } else {
				main_frag_cst_trial(size,score5,j+kk*100000,5.0f);
			 }
			}
			if ( get_monte_carlo_converged() == 1 ) goto L112;
		}

		new_score_function(score2);
		calc_rms();
		std::cout << I( 3, kk ) << ' ' <<
		 F( 9, 1, score2() ) << ' '; // Sequence point
		std::cout << F( 9, 1, score5() ) << ' '; // Sequence point
		std::cout << F( 9, 1, low_score ) << ' ' <<
		 I( 4, n_low_accept ) << ' ' << F( 7, 2, rms_err ) << ' ' <<
		 F( 7, 2, rms_min ) << ' ' << F( 7, 2, low_rms ) << ' ' <<
		 F( 7, 2, pc_score ) << ' ' << I( 3, classical_constraints::BOUNDARY::get_max_seqSep() ) << ' ' <<
		 F( 7, 2, dipolar_score ) << ' ' << F( 7, 2, projection_score ) <<
		 " halfway" << std::endl;
		for ( int j = 1; j <= cycles/2; ++j ) {
			if (barcode_exist()) {
				main_frag_trial(size,score2,j+kk);
		  } else {
				main_frag_cst_trial(size,score2,j+kk*100000,2.0f);
			}
			if ( get_monte_carlo_converged() == 1 ) goto L112;
		}                  // j

L112:; //  escape

//$ diagnostics
		refold(1,total_residue); // recover current structure
		calc_rms();
		std::cout << I( 3, kk ) << ' ' <<
		 F( 9, 1, score2() ) << ' '; // Sequence point
		std::cout << F( 9, 1, score5() ) << ' '; // Sequence point
		std::cout << F( 9, 1, low_score ) << ' ' <<
		 I( 4, n_low_accept ) << ' ' << F( 7, 2, rms_err ) << ' ' <<
		 F( 7, 2, rms_min ) << ' ' << F( 7, 2, low_rms ) << ' ' <<
		 F( 7, 2, pc_score ) << ' ' << I( 3, classical_constraints::BOUNDARY::get_max_seqSep() ) << ' ' <<
		 F( 7, 2, dipolar_score ) << ' ' << F( 7, 2, projection_score ) <<
		 "     end" << std::endl;
//$ end diagnostics

		if (!fold_constraints_no_minimize) main_minimize_trial(score2,"dfpmin");
		refold(1,total_residue); // recover current structure
		calc_rms();
		std::cout << I( 3, kk ) << ' ' <<
		 F( 9, 1, score2() ) << ' '; // Sequence point
		std::cout << F( 9, 1, score5() ) << ' '; // Sequence point
		std::cout << F( 9, 1, low_score ) << ' ' <<
		 I( 4, n_low_accept ) << ' ' << F( 7, 2, rms_err ) << ' ' <<
		 F( 7, 2, rms_min ) << ' ' << F( 7, 2, low_rms ) << ' ' <<
		 F( 7, 2, pc_score ) << ' ' << I( 3, classical_constraints::BOUNDARY::get_max_seqSep() ) << ' ' <<
		 F( 7, 2, dipolar_score ) << ' ' << F( 7, 2, projection_score ) <<
		 "  dfpmin" << std::endl;
	}                     // kk

//-----noe stage from total_res/2 to total_res------------
	nloop = 5; // 3
	cycles = 2000;

	if ( benchmark ) nloop = 1;
	size = 9;
	check_secstruct(secstruct,total_residue);
//db does score2 only for last 3
	for ( int kk = 1; kk <= nloop; ++kk ) {
		noe_stage = total_residue/2 + (total_residue/2)*kk/nloop;
		classical_constraints::BOUNDARY::set_max_seqSep(noe_stage);
		recover_LOW(score2);
		calc_rms();
		std::cout << I( 3, kk ) << ' ' <<
		 F( 9, 1, score2() ) << ' '; // Sequence point
		std::cout << F( 9, 1, score5() ) << ' '; // Sequence point
		std::cout << F( 9, 1, low_score ) << ' ' <<
		 I( 4, n_low_accept ) << ' ' << F( 7, 2, rms_err ) << ' ' <<
		 F( 7, 2, rms_min ) << ' ' << F( 7, 2, low_rms ) << ' ' <<
		 F( 7, 2, pc_score ) << ' ' << I( 3, classical_constraints::BOUNDARY::get_max_seqSep() ) << ' ' <<
		 F( 7, 2, dipolar_score ) << ' ' << F( 7, 2, projection_score ) <<
		 "   start" << std::endl;
		for ( int j = 1; j <= cycles; ++j ) {
			main_frag_cst_trial(size,score2,j+kk*100000,2.0f);
			if ( get_monte_carlo_converged() == 1 ) goto L115;
		}
L115:; //  escape

		refold(1,total_residue); // recover current structure
		calc_rms();
		std::cout << I( 3, kk ) << ' ' <<
		 F( 9, 1, score2() ) << ' '; // Sequence point
		std::cout << F( 9, 1, score5() ) << ' '; // Sequence point
		std::cout << F( 9, 1, low_score ) << ' ' <<
		 I( 4, n_low_accept ) << ' ' << F( 7, 2, rms_err ) << ' ' <<
		 F( 7, 2, rms_min ) << ' ' << F( 7, 2, low_rms ) << ' ' <<
		 F( 7, 2, pc_score ) << ' ' << I( 3, classical_constraints::BOUNDARY::get_max_seqSep() ) << ' ' <<
		 F( 7, 2, dipolar_score ) << ' ' << F( 7, 2, projection_score ) <<
		 "     end" << std::endl;

		if (!fold_constraints_no_minimize) main_minimize_trial(score2,"dfpmin");
		refold(1,total_residue); // recover current structure
		calc_rms();
		std::cout << I( 3, kk ) << ' ' <<
		 F( 9, 1, score2() ) << ' '; // Sequence point
		std::cout << F( 9, 1, score5() ) << ' '; // Sequence point
		std::cout << F( 9, 1, low_score ) << ' ' <<
		 I( 4, n_low_accept ) << ' ' << F( 7, 2, rms_err ) << ' ' <<
		 F( 7, 2, rms_min ) << ' ' << F( 7, 2, low_rms ) << ' ' <<
		 F( 7, 2, pc_score ) << ' ' << I( 3, classical_constraints::BOUNDARY::get_max_seqSep() ) << ' ' <<
		 F( 7, 2, dipolar_score ) << ' ' << F( 7, 2, projection_score ) <<
		 "  dfpmin" << std::endl;
	}                     // kk
//
	output_trial_counters( std::cout );
	std::cout << "-----------------------------------------------------" << std::endl;
//      refine_constraints();

}

////////////////////////////////////////////////////////////////////////////////
/// @begin refine_constraints
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
refine_constraints()
{
	using namespace counters;
	using namespace misc;
	using namespace runlevel_ns;
	using namespace scores;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

	int size;
	float cutoff;
	int nloop,cycles;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   wobble moves, small moves, min moves
//   score 7 ->all centroid based terms on
//             all constraints on
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	std::cout << "Starting (score7)..." << std::endl;
	monte_carlo_set_simannealing(false);
	nloop = 3;
	cycles = 1000;

	if ( benchmark ) {
		nloop = 1;
		cycles = 10;
	}

	monte_carlo_set_temp(2.0);
	size = 3;
	cutoff = 60.0;

	reset_trial_counters();
	choose_frag_set_top_N_frags(200);

	score_set_cst_weight(5.0);
	score_set_dpl_weight(10.0);
	classical_constraints::BOUNDARY::set_max_seqSep(total_residue);
	recover_LOW(score7);
	std::cout << "jk n_low_accept score7 low_score  low_rms rms_min " <<
	 "pc dipolar projection" << std::endl;
	std::cout << I( 3, 0 ) << ' ' <<
	 I( 5, n_low_accept ) << ' ' << ' ' <<
	 F( 8, 2, score ) << ' ' <<
	 F( 8, 2, low_score ) << ' ' <<
	 F( 8, 2, low_rms ) << ' ' <<
	 F( 8, 2, rms_min ) << ' ' <<
	 F( 8, 3, pc_score ) << ' ' <<
	 F( 8, 3, dipolar_score ) << ' ' <<
	 F( 8, 3, projection_score ) << std::endl;
	for ( int jk = 1; jk <= nloop; ++jk ) {
		for ( int j = 1; j <= cycles; ++j ) {
			main_wobble_trial(3,cutoff,score7,j,3,0);
			main_wobble_trial(9,cutoff,score7,j,3,-1);
			main_small_trial(score7,j*jk);
		}
		refold(1,total_residue);
		std::cout << I( 3, jk ) << ' ' <<
		 I( 5, n_low_accept ) << ' ' << ' ' <<
		 F( 8, 2, score ) << ' ' <<
		 F( 8, 2, low_score ) << ' ' <<
		 F( 8, 2, low_rms ) << ' ' <<
		 F( 8, 2, rms_min ) << ' ' <<
		 F( 8, 3, pc_score ) << ' ' <<
		 F( 8, 3, dipolar_score ) << ' ' <<
		 F( 8, 3, projection_score ) << std::endl;
	}           // jk

	output_trial_counters( std::cout );

	recover_LOW(score7);
	main_minimize_trial(score7,"dfpmin");

	std::cout << "-----------------------------------------------------" << std::endl;
	std::cout << "-----------------------------------------------------" << std::endl;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin fold_constraints_fast
///
/// @brief
/// this is basically main_separate from con_fullatom_6 for a single trial
/// if wobble function isn't given a starting structure, it calls this
/// function to start from extended chain
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
/// differs from fold_abinitio
///    in score2/score5 section
///    in score3 section
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
fold_constraints_fast()
{

	using namespace counters;
	using namespace misc;
	using namespace scores;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

	int const maxloops = { 10 }; // loops of frag insertion trials

	int const contig_cut1 = { 4 };
	 // cutoffs for largest insertable region // return
	int const contig_cut2 = { 10 }; // use 3mers only
	int const contig_cut3 = { 30 };
	 // when contig < cutoff then: // use 3mers and 9mers in early sections

	int size = 9; // 9mers til otherwise changed;
	float cutoff;

	int nloop2,nloop,cycles;
	FArray1D_int list_depth( maxloops ); // depth of fragment list

	int contig_size,total_size;
	float final_temp,temperature,init_temp = 2.0;
	float gamma;

//------------------------------------------------------------------------------

	set_fullatom_flag(false);
	score_set_cst_mode(1);

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//  get the initial structure
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
	std::cout << "recover" << std::endl;
	recover_LOW(score0);
	std::cout << "contig" << std::endl;
	insert_map_get_max_contig_size(contig_size,total_size);
	std::cout << "contig2 " << contig_size << std::endl;
	if ( contig_size < contig_cut1 ) return;
	if ( contig_size < contig_cut2 ) size = 3; // use 3mers only
	std::cout << "contig_size " << contig_size << std::endl;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//  insert secondary structure, bump check only
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	monte_carlo_set_temp(init_temp);
	monte_carlo_set_simannealing(true); // don't let mc change temp
	std::cout << "init_temp" << SS( init_temp ) << std::endl;
	cycles = 2000;
	choose_frag_set_top_N_frags(25);
	classical_constraints::BOUNDARY::set_max_seqSep(0);

	reset_trial_counters();

	std::cout << "starting fragment insertions..." << std::endl;
	for ( int j = 1; j <= cycles; ++j ) {
		main_frag_trial(size,score0,j);
		if ( start_sim() == 1 ) goto L101; // all swapped one or more times
	}
	for ( int j = 1; j <= cycles; ++j ) {
	 // if still not all swapped, try smaller frags
		main_frag_trial(3,score0,j);
		if ( start_sim() == 1 ) goto L101;
	}
	std::cout << "WARNING: extended chain may still remain!" << std::endl;
L101:

	refold(1,total_residue); // recover current structure
	calc_rms();
	std::cout << "score0 done: (best, low) rms" << std::endl;
	std::cout << SS( best_score ) << SS( low_score ) << SS( rms_err ) << std::endl;
	output_trial_counters( std::cout );
	std::cout << "-----------------------------------------------------" << std::endl;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//    regular moves   w/bumps, short-range dist constraints
//         secondary structure, light strand pairing
//    no rg or cbeta yet
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	monte_carlo_set_simannealing(false); // let mc raise temp

	cycles = 5000;
	if ( contig_size < contig_cut3 ) cycles /= 2; // do 3mers too

	choose_frag_set_top_N_frags(36);
	classical_constraints::BOUNDARY::set_max_seqSep(9);
	new_score_function(score1);
	reset_trial_counters();

	for ( int j = 1; j <= cycles; ++j ) {
		main_frag_trial(size,score1,j);
		if ( contig_size < contig_cut3 ) main_frag_trial(3,score1,j);
	}

	refold(1,total_residue);
	calc_rms();
	std::cout << "score1 done: (best, low) rms (best,low)" << std::endl;
	std::cout << SS( best_score ) << SS( low_score ) << SS( rms_err ) <<
	 SS( low_rms ) << std::endl;
	output_trial_counters( std::cout );
	std::cout << "-----------------------------------------------------" << std::endl;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   Add cbeta, rg (collapse chain)
//   alternate score2/score5 (high/low sheet weight)
//   cycle the noe_stage
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	recover_LOW(score2);
	std::cout << "Alternate score2/score5" << std::endl;
	std::cout << "kk score2 score5 low_score n_low_accept rms rms_min" <<
	 " low_rms  pc  noe_stage dipolar projection" << std::endl;
	std::cout << I( 3, 0 ) << ' ' <<
	 F( 9, 1, score2() ) << ' '; // Sequence point
	std::cout << F( 9, 1, score5() ) << ' '; // Sequence point
	std::cout << F( 9, 1, low_score ) << ' ' <<
	 I( 4, n_low_accept ) << ' ' << F( 7, 2, rms_err ) << ' ' <<
	 F( 7, 2, rms_min ) << ' ' << F( 7, 2, low_rms ) << ' ' <<
	 F( 7, 2, pc_score ) << ' ' << I( 3, classical_constraints::BOUNDARY::get_max_seqSep() ) << ' ' <<
	 F( 7, 2, dipolar_score ) << ' ' << F( 7, 2, projection_score ) << std::endl;

	list_depth(1) = 36; // db says 25 all the time
	list_depth(2) = 200;
	list_depth(3) = 250;
	nloop = 3;
	nloop2 = 20;
	cycles = 800;

	reset_trial_counters();
	monte_carlo_set_temp(init_temp);


//db does score2 only for last 3  (no constraints)
	for ( int jj = 1; jj <= nloop; ++jj ) {
		size = 9;
		choose_frag_set_top_N_frags(list_depth(jj));
		for ( int kk = 1; kk <= nloop2; ++kk ) {
			if ( kk > 10 ) size = 3;
			if ( mod(kk-1,10) > 9-jj ) {
				classical_constraints::BOUNDARY::set_max_seqSep(total_residue);
			} else {
				classical_constraints::BOUNDARY::set_max_seqSep(3 + 4*mod(kk-1,10) );
			}
			if ( mod(kk,2) == 0 ) {
				new_score_function(score2); // don't want to recover LOW
			} else {
				recover_LOW(score5);
			}

			for ( int j = 1; j <= cycles; ++j ) {
				if ( mod(kk,2) == 0 ) {
					main_frag_trial(size,score2,j*kk+100000);
				} else {
					main_frag_trial(size,score5,j*kk+100000);
				}
				if ( get_monte_carlo_converged() == 1 ) goto L112;
			}               // j
L112:; //  escape

//$ diagnostics
			refold(1,total_residue); // recover current structure
			std::cout << I( 3, kk ) << ' ' <<
			 F( 9, 1, score2() ) << ' '; // Sequence point
			std::cout << F( 9, 1, score5() ) << ' '; // Sequence point
			std::cout << F( 9, 1, low_score ) << ' ' <<
			 I( 4, n_low_accept ) << ' ' << F( 7, 2, rms_err ) << ' ' <<
			 F( 7, 2, rms_min ) << ' ' << F( 7, 2, low_rms ) << ' ' <<
			 F( 7, 2, pc_score ) << ' ' << I( 3, classical_constraints::BOUNDARY::get_max_seqSep() ) << ' ' <<
			 F( 7, 2, dipolar_score ) << ' ' << F( 7, 2, projection_score ) << std::endl;
//$ end diagnostics

		}                  // kk
	}                     // jj

	output_trial_counters( std::cout );
	std::cout << "-----------------------------------------------------" << std::endl;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   smooth moves
//   score 3 ->all centroid based terms on
//             all constraints on
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	std::cout << "Starting score3 moves..." << std::endl;

	nloop = 3;
	cycles = 8000;
	cutoff = 7;
	size = 3;

	reset_trial_counters();
	recover_LOW(score3);

	std::cout << "kk n_low_accept score3 low_score  low_rms rms_min " <<
	 "pc dipolar projection" << std::endl;

	std::cout << I( 3, 0 ) << ' ' <<
	 I( 5, n_low_accept ) << ' ' << ' ' <<
	 F( 8, 2, score ) << ' ' <<
	 F( 8, 2, low_score ) << ' ' <<
	 F( 8, 2, low_rms ) << ' ' <<
	 F( 8, 2, rms_min ) << ' ' <<
	 F( 8, 3, pc_score ) << ' ' <<
	 F( 8, 3, dipolar_score ) << ' ' <<
	 F( 8, 3, projection_score ) << std::endl;

	classical_constraints::BOUNDARY::set_max_seqSep(total_residue);
	choose_frag_set_top_N_frags(200);
	for ( int kk = 1; kk <= nloop; ++kk ) {
		recover_LOW(score3);
		monte_carlo_set_temp(init_temp);
		for ( int j = 1; j <= cycles; ++j ) {
			if ( kk == 1 ) {
				choose_frag_set_top_N_frags(25);
				main_frag_trial(size,score3,j*kk);
			} else {
				choose_frag_set_top_N_frags(200);
				main_smooth_trial(size,cutoff,score3,j*kk);
			}
		}                  // loop j
		refold(1,total_residue);
		std::cout << I( 3, kk ) << ' ' <<
		 I( 5, n_low_accept ) << ' ' << ' ' <<
		 F( 8, 2, score ) << ' ' <<
		 F( 8, 2, low_score ) << ' ' <<
		 F( 8, 2, low_rms ) << ' ' <<
		 F( 8, 2, rms_min ) << ' ' <<
		 F( 8, 3, pc_score ) << ' ' <<
		 F( 8, 3, dipolar_score ) << ' ' <<
		 F( 8, 3, projection_score ) << std::endl;
	}                     // k

	output_trial_counters( std::cout );
	std::cout << "-----------------------------------------------------" << std::endl;

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   wobble moves, simulated annealing
//   score 7 ->all centroid based terms on
//             all constraints on
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	std::cout << "Starting simulated annealing (score7)..." << std::endl;
	nloop = 10;
	cycles = 1000;
	init_temp = 4.0;
	final_temp = 1.5;
	gamma = std::pow( (final_temp/init_temp), (1.0f/(nloop*cycles)) );
	temperature = init_temp;
	monte_carlo_set_temp(init_temp);
	size = 3;
	cutoff = 60.0;

	reset_trial_counters();
	choose_frag_set_top_N_frags(200);

	recover_LOW(score7);
	std::cout << "jk n_low_accept score7 low_score  low_rms rms_min " <<
	 "pc dipolar projection" << std::endl;
	std::cout << I( 3, 0 ) << ' ' <<
	 I( 5, n_low_accept ) << ' ' << ' ' <<
	 F( 8, 2, score ) << ' ' <<
	 F( 8, 2, low_score ) << ' ' <<
	 F( 8, 2, low_rms ) << ' ' <<
	 F( 8, 2, rms_min ) << ' ' <<
	 F( 8, 3, pc_score ) << ' ' <<
	 F( 8, 3, dipolar_score ) << ' ' <<
	 F( 8, 3, projection_score ) << std::endl;

	for ( int jk = 1; jk <= nloop; ++jk ) {
		recover_LOW(score7);

		for ( int j = 1; j <= cycles; ++j ) {
			temperature *= gamma;
			monte_carlo_set_temp(temperature);
			main_wobble_trial(3,cutoff,score7,j*jk,1,0);
			main_wobble_trial(9,cutoff,score7,j*jk,1,-1);
			main_small_trial(score7,j*jk);

		}
		refold(1,total_residue);
		std::cout << I( 3, jk ) << ' ' <<
		 I( 5, n_low_accept ) << ' ' << ' ' <<
		 F( 8, 2, score ) << ' ' <<
		 F( 8, 2, low_score ) << ' ' <<
		 F( 8, 2, low_rms ) << ' ' <<
		 F( 8, 2, rms_min ) << ' ' <<
		 F( 8, 3, pc_score ) << ' ' <<
		 F( 8, 3, dipolar_score ) << ' ' <<
		 F( 8, 3, projection_score ) << std::endl;
	}                     // jk

	output_trial_counters( std::cout );


	std::cout << "-----------------------------------------------------" << std::endl;
	std::cout << "-----------------------------------------------------" << std::endl;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_fast_cst_protocol
///
/// @brief
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
bool
get_fast_cst_protocol()
{

	static int protocol = { 0 }; // 0 = undef; 1=fast; 2=standard

	if ( protocol == 0 ) {
		protocol = 2;
		if ( truefalseoption("fast") ) protocol = 1;
	}

	return ( protocol == 1 );
}

bool
get_fold_constraints_no_minimize()
{
	static bool fold_constraints_no_minimize = { false };
	static bool init = {false};

	if ( !init ) {
		fold_constraints_no_minimize = truefalseoption("use_fold_constraints_no_minimize");
		init = true;
	}

	return fold_constraints_no_minimize;
}
