// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 11985 $
//  $Date: 2007-01-09 12:58:35 +0200 (Tue, 09 Jan 2007) $
//  $Author: johnk $

#ifndef INCLUDED_fullatom
#define INCLUDED_fullatom


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Rosetta Headers
#include "RotamerOptions.h"

// STL
#include <string>

// Types
typedef  float (*Scoring_Function)();


// fullatom Function Declarations


void
get_packing_options();


void // do not call this unless you know what you're doing
set_fullatom_flag_simple( bool yes_no );


void
set_fullatom_flag( bool yes_no );


bool
get_fullatom_flag();


void
set_allow_repack(
	FArray1DB_bool const & setting,
	int total_residue
);


void
retrieve_allow_repack(
	FArray1DB_bool & allow,
	int total_residue
);


void
fullatom_set_packall( bool setting );


bool
fullatom_get_packall();


void
select_interface( FArray1DB_bool & allow_repack );


void
main_repack_trial(
	Scoring_Function scoring_function,
	int cycle_number,
	bool do_rtmin = false
);


void
main_repack( bool const rotamers_exist );


void
fullatom_score_position(
	bool const repack,          // repack the sidechains before scoring?
	bool const include_current  // include current rotamers?
);


void
fullatom_pack_position(
	bool const rotamers_exist // include current rotamers?
);


void
copy_position_to_fullcoord(
	FArray3DB_float const & pos,
	FArray3DB_float & fullcrd,
	int nres
);


void
initialize_fullcoord_array(
	FArray3DB_float const & position,
	FArray3DB_float & fullcoord,
	int nres,
	FArray1DB_int const & aan,
	FArray1DB_int const & aa_variant
);


void
set_checkpoint_status(
	bool const & fullatom
);


#endif
