// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7523 $
//  $Date: 2006-02-20 15:10:59 -0800 (Mon, 20 Feb 2006) $
//  $Author: jiangl $

//////////////////////////////////////////////
#ifndef INCLUDED_fullatom_id
#define INCLUDED_fullatom_id

// Rosetta Headers
#include "kin_id.h"
#include "param.h"

namespace kin {

  /////////////////////////////////////////////////////////////////////////////
  // Fullatom_id
  /////////////////////////////////////////////////////////////////////////////
  //lin add a data structure containing res, atom, aa,aav
  //lin the class derived from Atom_id

  //lin convert the res, atom, aa,aav into unique key
  inline
  int fullatom_index(int const res_in, int const atm_in, int const aa_in, int const aav_in) {
    return ( (atm_in-1)+(aa_in-1)*param::MAX_ATOM()()+(aav_in-1)*param::MAX_ATOM()()*param::MAX_AA()()
	     +(res_in-1)*param::MAX_ATOM()()*param::MAX_AA()()*param::MAX_AA_VARIANTS()() );
  }

  inline
  void fullatom_id_from_index( int const key_in, int & res_out, int & atm_out, int & aa_out, int & aav_out ){
    atm_out=key_in % param::MAX_ATOM()()+1;
    aa_out= int ( key_in % ( param::MAX_ATOM()()*param::MAX_AA()() ) / param::MAX_ATOM()() )+1;
    aav_out= int ( key_in % (param::MAX_ATOM()()*param::MAX_AA()()*param::MAX_AA_VARIANTS()() )
		   / ( param::MAX_ATOM()()*param::MAX_AA()() ) ) +1;
    res_out= int ( key_in / (param::MAX_ATOM()()*param::MAX_AA()()*param::MAX_AA_VARIANTS()() ) ) +1;
  }

  class Fullatom_id : public Atom_id{
  public:
    Fullatom_id(int const res_in, int const atm_in, int const aa_in, int const aav_in)
    { assign( res_in, atm_in, aa_in, aav_in ); };
    Fullatom_id(){ assign(); };
    Fullatom_id(Atom_id const & atom_id){ assign(atom_id); };
    Fullatom_id(Atom_id const & atom_id, int const aa_in, int const aav_in )
		{ assign( atom_id, aa_in, aav_in ); };
    Fullatom_id( int const key )
    { key_=key; fullatom_id_from_index( key, rsd_, atomno_, aa_, aav_ ); };

    inline
    int
    aa() const { return aa_; }

    inline
    int
    aav() const { return aav_; }

    inline
    int
    key() const { return key_; }

    inline
    int &
    aa() { return aa_; }

    inline
    int &
    aav() { return aav_; }

    //lin get all four values
    inline
    void get_values(int & res_out, int & atm_out, int & aa_out, int & aav_out) const
    { res_out=rsd(); atm_out=atomno(); aa_out=aa(); aav_out=aav(); }

    //lin get all four values
    inline
    void set_key( )
    { key_= fullatom_index(rsd(),atomno(),aa(),aav()); }

    void assign( int const res_in, int const atm_in, int const aa_in, int const aav_in );
    void assign();
    void assign( Atom_id const & atom_id );
    void assign( Atom_id const & atom_id, int const aa_in, int const aav_in );

    friend bool operator==( Fullatom_id const & ta1, Fullatom_id const & ta2 );
    friend bool operator>( Fullatom_id const & ta1, Fullatom_id const & ta2 );
    friend bool operator<( Fullatom_id const & ta1, Fullatom_id const & ta2 );

    friend std::ostream& operator<< ( std::ostream& s, Fullatom_id const & d );

  protected:
    int aa_, aav_;

  private:
    int key_;
  };

}
#endif
