// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 11690 $
//  $Date: 2006-12-06 01:54:36 +0200 (Wed, 06 Dec 2006) $
//  $Author: snoeyink $


// Rosetta Headers
#include "fullatom_sasa_ns.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ubyte.hh>
#include <ObjexxFCL/FArray2D.hh>


namespace fullatom_sasa {


//cj    ---------------------------------------
//cj    commons & parameters for sasa functions
//cj    ---------------------------------------
//cj    nbytes - number of bytes used for a mask
//cj    nphi   - number of angle for orientation lookup
//cj    ntheta - number of angle for orientation lookup
//cj    nolp   - number of overlaps
//cj    nori   - number of orientations specificied by angles
//cj    maskbits - number of mask bits used
int const nbytes = { 21 };
int const nphi = { 64 };
int const ntheta = { 64 };
int const nolp = { 100 };
int const nori = { 162 };
int const maskbits = { 162 };

//cj    angles and mask lookup tables


namespace a_sasa {
	FArray2D_int angles( nphi, ntheta );
	FArray2D_ubyte masks( nbytes, nolp*nori );
}

//cj    Ones that are commented are not used, but could be
//cj    ----------------------------
//cj    These are for the SASA score
//cj    ----------------------------
//cj    float hpbur,hpexp,pobur,poexp,
//cj   #     sdhpbur,sdhpexp,sdpobur,sdpoexp,
//cj   #     mnhpbur,mnhpexp,mnpobur,mnpoexp
//cj    common/SASAscores/hpbur,hpexp,pobur,poexp,
//cj   #                  sdhpbur,sdhpexp,sdpobur,sdpoexp,
//cj   #                  mnhpbur,mnhpexp,mnpobur,mnpoexp


//cj    --------------------------------------------------
//cj    Patrice"s environment and other scores
//cj      - see Koehl & Delarue, Proteins 20:264-278(1994)
//cj    gsol - solvation free energy
//cj    genv - environment free energy
//cj    np - non polar
//cj    po - polar
//cj    first is the center ie:
//cj          npnp is non polar group covered by non polar
//cj          nppo is non polar group covered by polar
//cj    --------------------------------------------------


namespace Koehlscores {
	float gsolt;
	float sasa_gsolt;
	float ponpf;
	float sasa_polar;   // polar solvent accessible surface area
	float sasa_apolar;  // apolar solvent accessible surface area
}


namespace Koehlscorestuff {
	float gsolt_wt;
	float ponpf_wt;
	float gsolt_wt_store;
	float gsolt_sc;
	float ponpf_sc;
}


}
