// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 11690 $
//  $Date: 2006-12-06 01:54:36 +0200 (Wed, 06 Dec 2006) $
//  $Author: snoeyink $

#ifndef INCLUDED_fullatom_sasa_ns
#define INCLUDED_fullatom_sasa_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/ubyte.hh> //Objexx:SGM Keep VC++ 2003 happy


namespace fullatom_sasa {


//cj    ---------------------------------------
//cj    commons & parameters for sasa functions
//cj    ---------------------------------------
//cj    nbytes - number of bytes used for a mask
//cj    nphi   - number of angle for orientation lookup
//cj    ntheta - number of angle for orientation lookup
//cj    nolp   - number of overlaps
//cj    nori   - number of orientations specificied by angles
//cj    maskbits - number of mask bits used
extern int const nbytes;
extern int const nphi;
extern int const ntheta;
extern int const nolp;
extern int const nori;
extern int const maskbits;

//cj    angles and mask lookup tables


namespace a_sasa {
	extern FArray2D_int angles;
	extern FArray2D_ubyte masks;
}
using namespace a_sasa;


//cj    Ones that are commented are not used, but could be
//cj    ----------------------------
//cj    These are for the SASA score
//cj    ----------------------------
//cj    float hpbur,hpexp,pobur,poexp,
//cj   #     sdhpbur,sdhpexp,sdpobur,sdpoexp,
//cj   #     mnhpbur,mnhpexp,mnpobur,mnpoexp
//cj    common/SASAscores/hpbur,hpexp,pobur,poexp,
//cj   #                  sdhpbur,sdhpexp,sdpobur,sdpoexp,
//cj   #                  mnhpbur,mnhpexp,mnpobur,mnpoexp


//cj    --------------------------------------------------
//cj    Patrice"s environment and other scores
//cj      - see Koehl & Delarue, Proteins 20:264-278(1994)
//cj    gsol - solvation free energy
//cj    genv - environment free energy
//cj    np - non polar
//cj    po - polar
//cj    first is the center ie:
//cj          npnp is non polar group covered by non polar
//cj          nppo is non polar group covered by polar
//cj    --------------------------------------------------


namespace Koehlscores {
	extern float gsolt;
	extern float sasa_gsolt;
	extern float ponpf;
	extern float sasa_polar;  // polar solvent accessible surface area
	extern float sasa_apolar; // apolar solvent accessible surface area
}
using namespace Koehlscores;


namespace Koehlscorestuff {
	extern float gsolt_wt;
	extern float ponpf_wt;
	extern float gsolt_wt_store;
	extern float gsolt_sc;
	extern float ponpf_sc;
}
using namespace Koehlscorestuff;


}


#endif
