// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 18466 $
//  $Date: 2007-11-16 23:05:47 +0200 (Fri, 16 Nov 2007) $
//  $Author: yab $


// Rosetta Headers
#include "gb_elec_ns.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// Using
using namespace param;

//jjh   extra data for generalized Born electrostatics
namespace gb_elec {


	// Dielectric constants for protein (Ep) and for solvent (Ew)
	float const Ep = 4.0;
	float const Ew = 80.0;

	// Parameters for determination of Generalized Born radii
	float const ParamS = 0.09;
	float const ParamD = 1.00;
	float const ParamB = 0.80;
	float const ParamG = 4.850000;

	// More parameters for GB burial
	float const Param_TA  = 0.333333333333333;
	float const Param_TB  = 0.4;
	float const Param_TC  = 0.42857142857142857143;
	float const Param_TD  = 0.444444444444444;
	float const Param_TDD = 0.45454545454545454545;
	float const Param_TE  = 1.333333333333333;
	float const Param_TF  = 2.4;
	float const Param_TG  = 3.42857142857142857143;
	float const Param_TH  = 4.44444444444444444;
	float const Param_THH = 5.45454545454545454545;



	bool update_radii( true );

	// hack: simple electrostatics
	bool use_no_intra_res( false );
	bool use_simple_elec( false );
	FArray3D_float simple_charge;
	FArray3D_float simple_elecE_table;
	FArray3D_int charge_bin;

	// from:  Alexyey Onufriev, Donald Bashford, and David A. Case,
	// "Exploring protein native states and large-scale conformational
	// changes with a modified generalized Born model."
	// Proteins, 55:383-394 (2004)

	void
	gb_radius_initializer( FArray1D_float & gb_radius )
	{
		if ( gb_radius.u() == 0 ) return;
		int i = 0;
		gb_radius( ++i ) = 1.7000; // 1  carbonyl C in Asn and Gln and guanidyl C in Arg
		gb_radius( ++i ) = 1.7000; // 2  carboxyl C in Asp and Glu
		gb_radius( ++i ) = 1.7000; // 3  aliphatic C with one H (Val, Ile, Thr)
		gb_radius( ++i ) = 1.7000; // 4  aliphatic C with two H (other residues)
		gb_radius( ++i ) = 1.7000; // 5  aliphatic C with three H (Ala)
		gb_radius( ++i ) = 1.7000; // 6  aromatic ring C (His, Phe, Tyr, Trp)
		gb_radius( ++i ) = 1.5500; // 7  N in Trp side-chain
		gb_radius( ++i ) = 1.5500; // 8  N in His side-chain
		gb_radius( ++i ) = 1.5500; // 9  N in Asn and Gln side-chain
		gb_radius( ++i ) = 1.5500; // 10 N in Lys side-chain, N-terminus?
		gb_radius( ++i ) = 1.5500; // 11 N in Arg side-chain
		gb_radius( ++i ) = 1.5500; // 12 N in Pro backbone
		gb_radius( ++i ) = 1.5000; // 13 hydroxyl O in Ser, Thr and Tyr
		gb_radius( ++i ) = 1.5000; // 14 carbonyl O in Asn and Gln
		gb_radius( ++i ) = 1.5000; // 15 carboyxl O in Asp and Glu
		gb_radius( ++i ) = 1.8000; // 16 sulfur in Cys and Met
		gb_radius( ++i ) = 1.5500; // 17 backbone N'
		gb_radius( ++i ) = 1.7000; // 18 backbone CA
		gb_radius( ++i ) = 1.7000; // 19 backbone C'
		gb_radius( ++i ) = 1.5000; // 20 backbone O'
		gb_radius( ++i ) = 2.1500; // 21 P in phosphate; CHARMM27;Kosta Makrodimitri
		gb_radius( ++i ) = 1.3000; // 22 polar H
		gb_radius( ++i ) = 1.3000; // 23 nonpolar H
		gb_radius( ++i ) = 1.3000; // 24 aromatic H
		gb_radius( ++i ) = 1.3000; // 25 backbone HN
		if ( gb_radius.u() == 25 ) return;
		gb_radius( ++i ) = 1.5000; // H2O
		if ( gb_radius.u() == 26 ) return;
// jjh: I'm not touching ligand radii
		gb_radius( ++i ) = 1.4700; // F  taken from tinker
		gb_radius( ++i ) = 1.7350; // Cl taken from tinker
		gb_radius( ++i ) = 1.9000; // Br taken from tinker
		gb_radius( ++i ) = 2.3600; // I  taken from MM3 forcefield ???
		gb_radius( ++i ) = 1.0900; // Zn2p ion radius CHARMM27 ???
		gb_radius( ++i ) = 0.7800; // Fe2p ion radius CHARMM27 ???
		gb_radius( ++i ) = 0.6500; // Fe3p ion radius CHARMM27 ???
		gb_radius( ++i ) = 1.7000; // Mg2p ion radius tinker
		gb_radius( ++i ) = 1.8170; // Ca2p ion radius tinker
		gb_radius( ++i ) = 1.9920; // Na1p ion radius tinker
		gb_radius( ++i ) = 1.8120; // K1p  ion radius tinker
		gb_radius( ++i ) = 1.2000; // Au ;  kosta makrodimitris 11/2005
		gb_radius( ++i ) = 1.5000; // 0 in ice
		gb_radius( ++i ) = 1.2000; // H in ice
		gb_radius( ++i ) = 1.8500; // Si in Quartz ;  kosta makrodimitris 11/2005
		gb_radius( ++i ) = 1.5500; // O in Quartz ;  kosta makrodimitris 11/2005
		gb_radius( ++i ) = 1.4500; // OP  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		gb_radius( ++i ) = 1.5500; // OH  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		gb_radius( ++i ) = 0.1900; // HO  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		gb_radius( ++i ) = 1.8500; // P/HA; CHARMM27;  kosta makrodimitris 11/2005
		gb_radius( ++i ) = 1.4500; // OP/HA;  CHARMM27; kosta makrodimitris  11/2005
		gb_radius( ++i ) = 1.5500; // OH/HA;  CHARMM27; kosta makrodimitris 11/2005
		gb_radius( ++i ) = 0.1900; // HO/HA ;  CHARMM27; kosta makrodimitris 11/2005
		gb_radius( ++i ) = 1.7000; // CS1
		gb_radius( ++i ) = 1.7000; // CS2
		gb_radius( ++i ) = 1.7000; // CS5
		gb_radius( ++i ) = 1.7000; // CS6
		gb_radius( ++i ) = 1.5000; // O5
		gb_radius( ++i ) = 0.000;  //   V01
		gb_radius( ++i ) = 0.000;  //   V02
		gb_radius( ++i ) = 0.000;  //   V03
		gb_radius( ++i ) = 0.000;  //   V04
		gb_radius( ++i ) = 0.000;  //   V05
		gb_radius( ++i ) = 0.000;  //   V06
		gb_radius( ++i ) = 0.000;  //   V07
		gb_radius( ++i ) = 0.000;  //   V08
		gb_radius( ++i ) = 0.000;  //   V09
		gb_radius( ++i ) = 0.000;  //   V10
		gb_radius( ++i ) = 0.000;  //   V11
		gb_radius( ++i ) = 0.000;  //   V12
		gb_radius( ++i ) = 0.000;  //   V13
		gb_radius( ++i ) = 0.000;  //   V14
		gb_radius( ++i ) = 0.000;  //   V15
		gb_radius( ++i ) = 0.000;  //   V16
		gb_radius( ++i ) = 0.000;  //   V17
//******************************************************************************
//vats Vatsan Raman (ref etable.h)
//vats Nucleic acid vdw radius from CHARMM 27  (NA=Nucleic acid)
// Foloppe et al Journal of Comp. Chem 21:86-104 (2000)
// Mackerell,Jr et al Journal of Comp. Chem 21:105-120 (2000)
//******************************************************************************
// jjh:  The GB model I'm using calls for Bondi radii, which
// are the values used above.  I'm not going to change Vatsan's
// stuff below, though.
//		gb_radius( ++i ) = 1.900;  // CN1  carbonyl carbon
//		gb_radius( ++i ) = 1.900;  // CN2  aromatic carbon to amide
//		gb_radius( ++i ) = 1.900;  // CN3  aromatic carbon
//		gb_radius( ++i ) = 1.900;  // CN4  purine C8 and ADE C2
//		gb_radius( ++i ) = 1.900;  // CN5  purine C4 and C5
//		gb_radius( ++i ) = 1.900;  // CN7  carbon (C1',C2',C3',C4')
//		gb_radius( ++i ) = 2.000;  // CN8  carbon (C5')
//		gb_radius( ++i ) = 2.000;  // CN9  carbon (C5M)
//		gb_radius( ++i ) = 1.850;  // NN1  amide nitrogen
//		gb_radius( ++i ) = 1.850;  // NN2  protonated ring nitrogen U N3, GN1, A and G N9, C U T N1
//		gb_radius( ++i ) = 1.850;  // NN3  unprotonated ring nitrogen ADE N1 and N3, inosine N3, G N3
//		gb_radius( ++i ) = 1.850;  // NN4  purine N7
//		gb_radius( ++i ) = 1.700;  // ON1  carbonyl oxygen
//		gb_radius( ++i ) = 1.770;  // ON2  phosphate ester oxygen
//		gb_radius( ++i ) = 1.700;  // ON3  =O in phosphate
//		gb_radius( ++i ) = 1.770;  // ON4  phosphate hydroxyl oxygen
//		gb_radius( ++i ) = 1.770;  // ON5  ribose hydroxyl oxygen
//		gb_radius( ++i ) = 1.770;  // ON6  deoxyribose, ribose ring oxygen
//		gb_radius( ++i ) = 1.340;  // H    polar hydrogen
//		gb_radius( ++i ) = 1.200;  // H    non-polar hydrogen
	}

	void
	gb_scale_initializer( FArray1D_float & gb_scale )
	{
		if ( gb_scale.u() == 0 ) return;
		int i = 0;
		gb_scale( ++i ) = 0.7200; // 1  carbonyl C in Asn and Gln and guanidyl C in Arg
		gb_scale( ++i ) = 0.7200; // 2  carboxyl C in Asp and Glu
		gb_scale( ++i ) = 0.7200; // 3  aliphatic C with one H (Val, Ile, Thr)
		gb_scale( ++i ) = 0.7200; // 4  aliphatic C with two H (other residues)
		gb_scale( ++i ) = 0.7200; // 5  aliphatic C with three H (Ala)
		gb_scale( ++i ) = 0.7200; // 6  aromatic ring C (His, Phe, Tyr, Trp)
		gb_scale( ++i ) = 0.7900; // 7  N in Trp side-chain
		gb_scale( ++i ) = 0.7900; // 8  N in His side-chain
		gb_scale( ++i ) = 0.7900; // 9  N in Asn and Gln side-chain
		gb_scale( ++i ) = 0.7900; // 10 N in Lys side-chain, N-terminus?
		gb_scale( ++i ) = 0.7900; // 11 N in Arg side-chain
		gb_scale( ++i ) = 0.7900; // 12 N in Pro backbone
		gb_scale( ++i ) = 0.8500; // 13 hydroxyl O in Ser, Thr and Tyr
		gb_scale( ++i ) = 0.8500; // 14 carbonyl O in Asn and Gln
		gb_scale( ++i ) = 0.8500; // 15 carboyxl O in Asp and Glu
		gb_scale( ++i ) = 0.9600; // 16 sulfur in Cys and Met
		gb_scale( ++i ) = 0.7900; // 17 backbone N'
		gb_scale( ++i ) = 0.7200; // 18 backbone CA
		gb_scale( ++i ) = 0.7200; // 19 backbone C'
		gb_scale( ++i ) = 0.8500; // 20 backbone O'
		gb_scale( ++i ) = 0.8600; // 21 nucleic acid P
		gb_scale( ++i ) = 0.8500; // 22 polar H
		gb_scale( ++i ) = 0.8500; // 23 nonpolar H
		gb_scale( ++i ) = 0.8500; // 24 aromatic H
		gb_scale( ++i ) = 0.8500; // 25 backbone HN
		if ( gb_scale.u() == 25 ) return;
		gb_scale( ++i ) = 0.8500; // H2O
		if ( gb_scale.u() == 26 ) return;
// jjh:  There are no published scaling factors for these atom,
//       so I'm setting them to 0.85.
		gb_scale( ++i ) = 0.800; // F  taken from tinker
		gb_scale( ++i ) = 0.800; // Cl taken from tinker
		gb_scale( ++i ) = 0.800; // Br taken from tinker
		gb_scale( ++i ) = 0.800; // I  taken from tinker
		gb_scale( ++i ) = 0.800; // Zn2p ion radius tinker
		gb_scale( ++i ) = 0.800; // Fe2p ion radius tinker
		gb_scale( ++i ) = 0.800; // Fe3p ion radius tinker
		gb_scale( ++i ) = 0.800; // Mg2p ion radius tinker
		gb_scale( ++i ) = 0.800; // Ca2p ion radius tinker
		gb_scale( ++i ) = 0.800; // Na1p ion radius tinker
		gb_scale( ++i ) = 0.800; // K1p  ion radius tinker
		gb_scale( ++i ) = 0.850; // Au ??????????????????
		gb_scale( ++i ) = 0.850; // O in ice
		gb_scale( ++i ) = 0.850; // H in ice
		gb_scale( ++i ) = 0.850; // Si in Quartz ??????????????????
		gb_scale( ++i ) = 0.850; // O in Quartz ???????????????????
		gb_scale( ++i ) = 0.850; // OP  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		gb_scale( ++i ) = 0.850; // OH  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		gb_scale( ++i ) = 0.850; // HO  in Phosphate ;  CHARMM27 for DNA, MacKerell 2004; kosta makrodimitris
		gb_scale( ++i ) = 0.860;  //  P/HA/HydroxyApatite;  CHARMM27 ; kosta makrodimitris 11/2005
		gb_scale( ++i ) = 0.850;  // OP/HA/HydroxyApatite;  CHARMM27 ; kosta makrodimitris 11/2005
		gb_scale( ++i ) = 0.850;  // OH/HA/HydroxyApatite;  CHARMM27 ; kosta makrodimitris 11/2005
		gb_scale( ++i ) = 0.850;  // HO/HA/HydroxyApatite;  CHARMM27 ; kosta makrodimitris 11/2005
		gb_scale( ++i ) = 0.720;  //   CS1
		gb_scale( ++i ) = 0.720;  //   CS2
		gb_scale( ++i ) = 0.720;  //   CS5
		gb_scale( ++i ) = 0.720;  //   CS6
		gb_scale( ++i ) = 0.850;  //   O5
		gb_scale( ++i ) = 0.000;  //   V01
		gb_scale( ++i ) = 0.000;  //   V02
		gb_scale( ++i ) = 0.000;  //   V03
		gb_scale( ++i ) = 0.000;  //   V04
		gb_scale( ++i ) = 0.000;  //   V05
		gb_scale( ++i ) = 0.000;  //   V06
		gb_scale( ++i ) = 0.000;  //   V07
		gb_scale( ++i ) = 0.000;  //   V08
		gb_scale( ++i ) = 0.000;  //   V09
		gb_scale( ++i ) = 0.000;  //   V10
		gb_scale( ++i ) = 0.000;  //   V11
		gb_scale( ++i ) = 0.000;  //   V12
		gb_scale( ++i ) = 0.000;  //   V13
		gb_scale( ++i ) = 0.000;  //   V14
		gb_scale( ++i ) = 0.000;  //   V15
		gb_scale( ++i ) = 0.000;  //   V16
		gb_scale( ++i ) = 0.000;  //   V17
//******************************************************************************
//vats Vatsan Raman (ref etable.h)
//vats Nucleic acid vdw radius from CHARMM 27  (NA=Nucleic acid)
// Foloppe et al Journal of Comp. Chem 21:86-104 (2000)
// Mackerell,Jr et al Journal of Comp. Chem 21:105-120 (2000)
//******************************************************************************
//		gb_scale( ++i ) = 0.720;  // CN1  carbonyl carbon
//		gb_scale( ++i ) = 0.720;  // CN2  aromatic carbon to amide
//		gb_scale( ++i ) = 0.720;  // CN3  aromatic carbon
//		gb_scale( ++i ) = 0.720;  // CN4  purine C8 and ADE C2
//		gb_scale( ++i ) = 0.720;  // CN5  purine C4 and C5
//		gb_scale( ++i ) = 0.720;  // CN7  carbon (C1',C2',C3',C4')
//		gb_scale( ++i ) = 0.720;  // CN8  carbon (C5')
//		gb_scale( ++i ) = 0.720;  // CN9  carbon (C5M)
//		gb_scale( ++i ) = 0.790;  // NN1  amide nitrogen
//		gb_scale( ++i ) = 0.790;  // NN2  protonated ring nitrogen U N3, GN1, A and G N9, C U T N1
//		gb_scale( ++i ) = 0.790;  // NN3  unprotonated ring nitrogen ADE N1 and N3, inosine N3, G N3
//		gb_scale( ++i ) = 0.790;  // NN4  purine N7
//		gb_scale( ++i ) = 0.850;  // ON1  carbonyl oxygen
//		gb_scale( ++i ) = 0.850;  // ON2  phosphate ester oxygen
//		gb_scale( ++i ) = 0.850;  // ON3  =O in phosphate
//		gb_scale( ++i ) = 0.850;  // ON4  phosphate hydroxyl oxygen
//		gb_scale( ++i ) = 0.850;  // ON5  ribose hydroxyl oxygen
//		gb_scale( ++i ) = 0.850;  // ON6  deoxyribose, ribose ring oxygen
//		gb_scale( ++i ) = 0.850;  // H    polar hydrogen
//		gb_scale( ++i ) = 0.850;  // H    non-polar hydrogen
	}

	// Also for diagnostics, I sometimes accumlate the direct
	// coulombic and polarization electrostatics separately.
	float total_coul;
	float total_gb;

	float gb_dummy_rad = 2.39;
	float gb_dummy_dist = 2.44;

	// radii for GB electrostatics
	FArray1D_float const gb_radius( MAX_ATOMTYPES(), gb_radius_initializer );

	// scaling factor for GB electrostatics
	FArray1D_float const gb_scale( MAX_ATOMTYPES(), gb_scale_initializer );

	FArray2D_float born_rad( MAX_ATOM(), MAX_RES() );
	FArray3D_float place_holder_xyz( 3, MAX_ATOM(), MAX_RES() );


} // namespace gb_elec
