// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14080 $
//  $Date: 2007-04-09 23:55:07 +0300 (Mon, 09 Apr 2007) $
//  $Author: yab $

#ifndef INCLUDED_gunn
#define INCLUDED_gunn

#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// gunn Function Declarations


void
gunn(
	int j,
	int k,
	FArray3Da_float Epos,
	float & q1a,
	float & q2a,
	float & q3a,
	float & q4a,
	float & q5a,
	float & q6a
);


void
precompute_gunn(
	int length,
	int frag_start,
	int frag_depth,
	int size_bin,
	FArray3Da_float Eposition
);


void
compare_gunn(
	int i,
	int length,
	int size,
	FArray1DB_float & cost
);


void
choose_fragment_gunn(
	int size,
	float cutoff,
	int & frag_begin // return value (not the global)
);


void
choose_fragment_gunn_pose(
	pose_ns::Pose & pose,
	int const size,
	float const cutoff
);

void
choose_fragment_gunn_pose(
	pose_ns::Pose & pose,
	const int size,
	int & frag_begin,
	float const cutoff
);


#endif
