// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 18466 $
//  $Date: 2007-11-16 23:05:47 +0200 (Fri, 16 Nov 2007) $
//  $Author: yab $

#ifndef INCLUDED_hbonds
#define INCLUDED_hbonds

#include "pose_fwd.h"
#include "hbonds_ns.h" // for NODERIV sentinel

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray3Da.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>

// C++ Headers
#include <iosfwd>



// hbonds Function Declarations
float
hb_env_dep_burial_tk(int const nb1, int const nb2);

float
hb_env_dep_burial_lin(int const nb1, int const nb2);

void
evaluate_hbenergy(  // minimizers call this
  hbonds::HBDerivType deriv_type,
	float & srhb_score,
	float & lrhb_score
);

void
fill_hbond_arrays(
	bool const fullatom,
  FArray1DB_int const & aan,
	FArray1DB_int const & aav, // aa variant
	FArray3DB_float const & xyz,
	int const nres,
	FArray2DB_bool const & neighborlist,
	FArray1DB_int const & neighbors,
  hbonds::HBDerivType const deriv_type,
	float & sr_bb_hbenergy, // short range bb-bb total
	float & lr_bb_hbenergy, // long range bb-bb total
	float & scbb_hbenergy, // sc-bb total
	float & sc_hbenergy, // sc-sc total
	FArray2D_float & hb_atom_energy
									);

void
fill_hbond_arrays(
  bool const fullatom,
  FArray1DB_int const & aan,
  FArray1DB_int const & aav, // aa variant
  FArray3DB_float const & xyz,
  int const nres,
  FArray2DB_bool const & neighborlist,
  FArray1DB_int const & neighbors,
  hbonds::HBDerivType const deriv_type,
	float & sr_bb_hbenergy, // short range bb-bb total
	float & lr_bb_hbenergy, // long range bb-bb total
	float & scbb_hbenergy, // sc-bb total
	float & sc_hbenergy // sc-sc total
);

void
get_hbE(  // dna, pack, & rotamer call this
  bool const fullatom,
	int const aa1,
	int const aa2,
	int const aav1,
	int const aav2,
	int const res1,
	int const res2,
	int const nb1,
	int const nb2,
	FArray2Da_float const xyz1,
	FArray2Da_float const xyz2,
	float & scenergy,
	float & sr_bbenergy,
	float & lr_bbenergy,
	float & sc_bbenergy,
	int & nhbonds_l = HBdum1,
	FArray1Da_float hbenergies_l = HBdum2,
	FArray1Da_int hbdonh_atm_l = HBdum3,
	FArray1Da_int hbdon_res_l = HBdum4,
	FArray1Da_int hbact_atm_l = HBdum5,
	FArray1Da_int hbact_res_l = HBdum6,
	FArray1Da_int hbtype_l = HBdum7,
	FArray1Da_bool hbchk1_l = HBdum8,
	FArray1Da_bool hbchk2_l = HBdum9,
  hbonds::HBDerivType const deriv_type = hbonds::hbderiv_NONE,
  FArray3Da_float hbderiv_l = hbonds::NODERIV3Da // f1,f2 deriv components
	);

void
get_hbE(  // only for pack && symmetry?
    bool const fullatom,
		int const aa1,
		int const aa2,
		int const aav1,
		int const aav2,
		int const res1,
		int const res2,
		int const nb1,
		int const nb2,
		FArray2Da_float const xyz1,
		FArray2Da_float const xyz2,
		float & scenergy,
		float & sr_bbenergy,
		float & lr_bbenergy,
		float & sc_bbenergy,
		float & sc_bbenergy_1_to_2,
		float & sc_bbenergy_2_to_1,
    int & nhbonds_l = HBdum1,
    FArray1Da_float hbenergies_l = HBdum2,
    FArray1Da_int hbdonh_atm_l = HBdum3,
    FArray1Da_int hbdon_res_l = HBdum4,
    FArray1Da_int hbact_atm_l = HBdum5,
    FArray1Da_int hbact_res_l = HBdum6,
    FArray1Da_int hbtype_l = HBdum7,
    FArray1Da_bool hbchk1_l = HBdum8,
    FArray1Da_bool hbchk2_l = HBdum9,
    hbonds::HBDerivType const deriv_type = hbonds::hbderiv_NONE,
    FArray3Da_float hbderiv_l = hbonds::NODERIV3Da // f1,f2 deriv components
		);


void  // only in minimize
hbond_compute_deriv(
	int const first_res,
	int const last_res,
	FArray3Da_float F1_hbondE,
	FArray3Da_float F2_hbondE
);


bool // only in decoystats
allow_hbond_by_idx( int const idx );


bool
allow_hbond( // only in rotamer trials
	int const dres,
	bool const dhatm_is_bb,
	int const ares,
	bool const aatm_is_bb
);


void
hbond_neighbors(  // only in pdbstats
	int nres,
	FArray1Da_int aan,
	FArray3Da_float xyz,
	FArray2Da_int hb_nbors,
	FArray3Da_float hcent
);


void
set_use_W_hb_env_dep_tk( bool truefalse );

void  // repatriated from water
set_use_W_hb_env_dep_lin( bool truefalse );

void
set_fine_hb_categories( bool truefalse );

bool
get_fine_hb_categories();


void  // repatriated from docking_minimize
get_total_hb_deriv_docking(
													 FArray1Da_float dE_dTR,
													 int nfree,
													 FArray2Da_bool jneighborlist
													 );



void // repatriated from atom_tree_minimize
compute_atom_hbond_deriv(
												 int const atomno,
												 int const rsd,
												 numeric::xyzVector_float & F1, // accumulate contributions
												 numeric::xyzVector_float & F2
												 );


void // repatriated from jumping_minimize.cc
jmp_hbond_compute_deriv(
	pose_ns::Pose const & pose,
	float const srbb_weight,
	float const lrbb_weight,
	float const scbb_weight,
	float const sc_weight,
	FArray3DB_float & F1_hbondE,
	FArray3DB_float & F2_hbondE
);


void
fast_backbone_hbE(
	pose_ns::Pose & pose,
	float & hb_srbb_score,
	float & hb_lrbb_score
);

void
find_CO_bb_hbond_partner(
	pose_ns::Pose & pose,
	int this_pos,
	int & ret_arm,
	int & ret_res
);

void
find_NH_bb_hbond_partner(
	pose_ns::Pose & pose,
	int this_pos,
	int & ret_arm,
	int & ret_res
);


#endif
