// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14246 $
//  $Date: 2007-04-15 23:21:01 -0700 (Sun, 15 Apr 2007) $
//  $Author: bqian $

#ifndef INCLUDED_homolog_distances
#define INCLUDED_homolog_distances

// Rosetta Headers
#include "pose.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <numeric/all.fwd.hh>

// C++ Headers
#include <string>

void
get_homolog_stats_options();

void
get_distances();

void
homolog_rescore();

void
misc_homolog_score( float & homolog_score );

void
pose_homolog_score(
	pose_ns::Pose & my_pose,
	float & homolog_score
);

void read_distance_pdf(
	std::string pdf_file_name
);

void get_homolog_jumps(
	pose_ns::Pose & my_pose
);

inline void get_coefficients (
	double e_value,
	double pred_dist,
	double avg_d_gap,
	double seq_score,
	double & a_out,
	double & b_out,
	double & c_out
);

inline void get_bg_coefficients (
	double pred_dist,
	double avg_d_gap,
	double seq_score,
	double & a_out,
	double & b_out,
	double & c_out,
	double & d_out
);

double
calc_resi_resj_score(
	double x,
	double pred_dist,
	double a,  double b,  double c,
	double a0, double b0, double c0, double d0
);

double
calc_resi_resj_score(
	std::string atom_pair,
	int resi,
	int resj,
	double pred_dist
);

double
calc_resi_resj_deriv(
	double r,	// radius between two residues
	int resi,
	int resj,
	double pred_dist
);

double
calc_resi_resj_deriv(
	double r,	// radius between two residues
	double pred_dist,
	double a,  double b,  double c,
	double a0, double b0, double c0, double d0
);

inline int get_bin_index(
	std::string variable_name,
	float value
);

int
get_atom_index(
	char residue,
	std::string atom_name
);

void
initialize_distance_pdf();

void
dump_distance_pdf();

void
get_distance_hist();

void
make_homolog_scored_pdbs();

double
get_resi_resj_score(
	int resi,
	int resj,
	FArray3D_float full_coord
);

#endif
