// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14080 $
//  $Date: 2007-04-09 23:55:07 +0300 (Mon, 09 Apr 2007) $
//  $Author: yab $


// Rosetta Headers
#include "idealize.h"
#include "after_opts.h"
#include "angles.h"
#include "constraints.h"
#include "files_paths.h"
#include "fullatom.h"
#include "jumping_minimize.h"
#include "maps.h"
#include "maps_ns.h"
#include "minimize.h"
#include "misc.h"
#include "monte_carlo.h"
#include "orient_rms.h"
#include "param.h"
#include "param_torsion.h"
#include "pdb.h"
#include "recover.h"
#include "refold.h"
#include "score.h"
#include "score_ns.h"
#include "status.h"
#include "tether.h"
#include "termini.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2Da.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/formatted.o.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <iostream>


// Namespaces
namespace check_chainbreak_common {
	bool check_chainbreak = { true };
}
namespace check_no_faidl {
	bool no_faidl = { false };
}
namespace idl_hijack {
	using namespace param;
	FArray1D_float save_phi( MAX_RES() );
	FArray1D_float save_psi( MAX_RES() );
	FArray1D_float save_omega( MAX_RES() );
	FArray2D_float save_centroid( 3, MAX_RES() );
	FArray3D_float save_Eposition( 3, MAX_POS, MAX_RES() );
	FArray3D_float save_full_coord( 3, MAX_ATOM(), MAX_RES() );
	FArray1D_int save_res( MAX_RES() );
	int save_residue;
	int restore_start;
	int restore_end;
	int hijack_start;
	FArray1D_int save_res_variant( MAX_RES() );
	FArray1D_char save_secstruct( MAX_RES(), ' ' );
}

//------------------------------------------------------------------------------
//     turn off chain-break checking if desired
void
idealize_set_check_chainbreak( bool const setting )
{
	using namespace check_chainbreak_common;

	std::cout << "setting check_chainbreak from,to" <<
	 SS( check_chainbreak ) << SS( setting ) << std::endl;

	check_chainbreak = setting;
}

//------------------------------------------------------------------------------
//     turn off chain-break checking if desired
bool
idealize_get_check_chainbreak()
{
	return check_chainbreak_common::check_chainbreak;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin idealize
///
/// @brief - adjust coords to ideal bond lengths and angles
///         while tethered to initial position
///
/// @detailed
///
/// @param  fail - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks - if multiple chain segments are detected, each is independently
///         idealized, first in isolation, then in the presence of all segments
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
idealize( bool & fail )
{
	using namespace files_paths;
	using namespace misc;
	using namespace param;
	using namespace pdb;

//car parameter
	float const chain_break_cutoff = { 4.0 };
	 // squared distance at which C-N bond // is considered discontinuous

//car local
	int last_break;
	FArray1D_int break_points( MAX_SEGMENTS );
	FArray1D_int seg_begin( MAX_SEGMENTS );
	FArray1D_int seg_end( MAX_SEGMENTS );
	bool chain_break;
	float dist2;
	float fret;
	bool gfrag( true );
	bool exist;

	static bool idealize_init = { false };
	static bool local_idl;
	static bool no_chain_breaks;

	bool const check_chainbreak = idealize_get_check_chainbreak();
	 // should we perform chainbreak checking?

// initialize_maps to avoid the bug when there is a chain break in a -l
// operation - bqian 09/06/05
	idealized_structure = true;
	initialize_maps();

//car save initial coords for  re-orientation
	refold_set_orient_position(total_residue,position);

//car idealization parameters
	if ( !idealize_init ) {
		local_idl = truefalseoption("local");
		no_chain_breaks = truefalseoption("idl_no_chain_break");
		idealize_init = true;
	}

//car set parameters
	if ( ( input_fa || repack_input ) && !get_no_faidl() ) set_fullatom_flag(true);
	classical_constraints::BOUNDARY::set_max_seqSep(0); // don't use any constraints
	minimize_set_func(3);
	minimize_exclude_sstype(false,false);
	minimize_reset_exclude_list();

	score_reset_weights();
	tether_reset();
	scorefxn_set_rama_weight(0.1);
	scorefxn_set_tether_weight(1.0); // tether coords
	scorefxn_set_torsion_weight(0.2,1.0); // tether phipsi,omega

//car find chain breaks, assign fixed c_terminal residues
	int nsegments = 0;
	last_break = total_residue+1;
	for ( int i = total_residue; i >= 1; --i ) {

		chain_break = false;
		if ( i == 1 ) {
			chain_break = true;
		} else if ( check_chainbreak ) {
			if ( pdb_res_num(i-1)+1 != pdb_res_num(i) ) {
				std::cout << "non-sequential pdb residue numbers " << i-1 << '-' << i <<
				 std::endl;
				std::cout << "pdb res nums " << pdb_res_num(i-1) << ' ' <<
				 pdb_res_num(i) << std::endl;
				chain_break = true;
			} else {
				float const Edif1 = Eposition(1,4,i-1) - Eposition(1,1,i);
				float const Edif2 = Eposition(2,4,i-1) - Eposition(2,1,i);
				float const Edif3 = Eposition(3,4,i-1) - Eposition(3,1,i);
				dist2 = ( Edif1 * Edif1 ) + ( Edif2 * Edif2 ) + ( Edif3 * Edif3 );
				if ( dist2 > chain_break_cutoff ) {
					std::cout << "chain break: " << i-1 << '-' << i << ' ' << std::sqrt(dist2) <<
					 std::endl;
					std::cout << SS( Eposition(1,4,i) ) << SS( Eposition(1,1,i+1) ) << std::endl;
					chain_break = true;
				} else if ( dist2 < 0.1 ) {
					std::cout << "zero length peptide bond: " << i << '-' << i+1 << std::endl;
					std::cout << SS( Eposition(1,4,i) ) << SS( Eposition(1,1,i+1) ) << std::endl;
					chain_break = true;
				}
			}
		}

		if ( chain_break ) {  // idealize i to last_break-1
// bqian command line option to set idealize fails if there is chain break
			if ( i != 1 && no_chain_breaks ) {
				fail = true;
				idealized_structure = false;
				initialize_maps();
				tether_reset();
				score_reset_weights();
				minimize_reset();
				return;
			}
			std::cout << "idealizing residues " << i << " to " << last_break-1 << std::endl;
//car set psi,omega and phi to zero across break
			phi(i) = 0.0;
			psi(last_break-1) = 0.0;
			omega(last_break-1) = 0.0;
			++nsegments;
			break_points(nsegments) = i;

//car put contig at begining of position array & idealize
			idealize_hijack_pose(i,last_break-1,1);
			idealize_position(local_idl,fret,gfrag,true);
			if ( !gfrag ) {
				std::cout << "idealization FAILED!!" << std::endl;
				fail = true;
				return;
			}
//car restore
			idealize_unhijack_pose();
			last_break = i;
		}
	}

//car save as LOW!!
	save_status_info("minimize",0,0);
	monte_carlo_reset();

//glb if multi segment - allow segments to interact
	if ( nsegments > 1 && !local_idl ) {
		refold_set_orient_flag(true);

//car setup the segment map:
		for ( int i = 1; i <= nsegments; ++i ) {
			seg_begin(i) = break_points(nsegments-i+1);
		}
		for ( int i = 1; i < nsegments; ++i ) {
			seg_end(i) = seg_begin(i+1) - 1;
		}
		seg_end(nsegments) = total_residue;
		refold_set_segments(1,nsegments,seg_begin,seg_end,FArray1D_int(nsegments,0));

		std::cout << "found" << SS( nsegments ) << " segments in protein" << std::endl;
		std::cout << "idealizing interacting segments" << std::endl;

//glb allow interacting segments (alternating between the segments)
		for ( int i = 1; i <= nsegments; ++i ) {
			std::cout << "idealizing residues " << SS( seg_begin(i) ) << " to " <<
			 SS( seg_end(i) ) << std::endl;
			set_allow_insert_by_region(seg_begin(i),seg_end(i),true,exist);
			if ( exist ) idealize_position(local_idl,fret,gfrag,false);

			if ( !gfrag ) {
				std::cout << "idealization FAILED!!" << std::endl;
				fail = true;
				refold_set_orient_flag(false);
				return;
			}
		}
		refold_set_orient_flag(false);

//car save as LOW!!
		save_status_info("minimize",0,0);
		monte_carlo_reset();
	}

	if ( nsegments > 1 ) {
//car no refolding allowed
		idealized_structure = false;
		initialize_maps();
	}

	tether_reset();
	score_reset_weights();
	minimize_reset();

	fail = false;
}


////////////////////////////////////////////////////////////////////////////////
/// @begin idealize_position
///
/// @brief
///
/// @detailed
///
/// @param  local_idl - [in/out]? -
/// @param  fret - [in/out]? -
/// @param  gfrag - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
idealize_position(
	bool const local_idl,
	float & fret,
	bool & gfrag,
	bool const single_segment
)
{
	using namespace misc;
	using namespace param;
	using namespace param_torsion;
	using namespace scores;
	using namespace termini_ns;

//car local
	int window;
	bool vary_omega;
	float idl_weight;
	FArray2D_float tether_position( 3, MAX_POS * MAX_RES()() );
	FArray1D_float phipsi( total_bb_torsion * MAX_RES()() );
	int nangles;
	int iter;
	float tether_rms;
	float angle_rms;
	float tether_dme;
	float pass_ftol;

	int save_residue;
	float ca_rms, window_rms;
	int first_res,last_res;

	int const local_tether_window = { 15 };

//car setup
	gfrag = true;
	bool const fullatom = get_fullatom_flag();
	tether_setup();

	for ( int i = 1; i <= total_residue*5; ++i ) {
		for ( int j = 1; j <= 3; ++j ) { // save starting point locally for rms
			tether_position(j,i) = position(j,i);
		}
	}

//car get starting scores
	refold(1,total_residue); // see where we're starting from

	if ( fullatom ) {
//car replace non-ideal full_coord backbone with idealized backbone
//car and rebuild HNs
		copy_position_to_fullcoord(Eposition,full_coord,total_residue);
		put_nh(full_coord,1,total_residue,res,res_variant,is_N_terminus,is_C_terminus,phi(1));
	}
	monte_carlo_reset(); // save idealized bb coords (best_fullcoord)
	fast_rms_x(position,tether_position,tether_rms);

//  initialize parameters to report start values
	iter = 0;
	idl_weight = 1.0;
	vary_omega = true;
	window = total_residue;

	minimize_set_vary_omega(vary_omega);
	tether_set_window_size(window);
	scorefxn_set_bump_weight(idl_weight);
	pack_phipsi(phipsi,nangles,1,total_residue);
	fret = func(gfrag,phipsi);
	std::cout << "minimization" << std::endl;
	if ( fullatom ) {
		std::cout << "window weight vomega iter   fret      rms       rama  " <<
			"    ljrep     ljatr    tether    omega    phipsi" << std::endl;
		std::cout << "------ ------ ------ ---- --------- -------- ---------" <<
			" --------- --------- --------- --------- ---------" << std::endl;
		std::cout << I( 6, window ) << ' ' << F( 6, 3, idl_weight ) << "   " <<
			L( 1, vary_omega ) << "   " << I( 4, iter ) << ' ' <<
			F( 10, 2, fret ) << ' ' <<
			F( 9, 3, tether_rms ) << ' ' <<
			F( 9, 3, ramachandran_score ) << ' ' <<
			F( 9, 3, fa_rep_score ) << ' ' <<
			F( 9, 3, fa_atr_score ) << ' ' <<
			F( 9, 3, tether_score ) << ' ' <<
			F( 9, 3, omega_score ) << ' ' <<
			F( 9, 3, phipsi_score ) << std::endl;
	} else {
		std::cout << "window weight vomega iter   fret      rms      rama  " <<
			"   bump    tether   omega    phipsi" << std::endl;
		std::cout << "------ ------ ------ ---- --------- -------- --------" <<
			" -------- -------- -------- --------" << std::endl;
		std::cout << I( 6, window ) << ' ' << F( 6, 3, idl_weight ) << "   " <<
			L( 1, vary_omega ) << "   " << I( 4, iter ) << ' ' <<
			F( 10, 2, fret ) << ' ' <<
			F( 8, 3, tether_rms ) << ' ' <<
			F( 8, 3, ramachandran_score ) << ' ' <<
			F( 8, 3, vdw_score ) << ' ' <<
			F( 8, 3, tether_score ) << ' ' <<
			F( 8, 3, omega_score ) << ' ' <<
			F( 8, 3, phipsi_score ) << std::endl;
	}

//car pass 1: single segment: omega fixed, idl_weight=0.1, partial window
//glb pass 1: multi segment:  omega fixed, idl_weight=5.0, partial window
	if ( local_idl ) {
		window = std::min(total_residue,local_tether_window);
	} else if ( fullatom ) {
		window = static_cast< int >( 0.8*total_residue );
	} else {
		window = static_cast< int >( 0.4*total_residue );
	}
	vary_omega = false;
	if ( single_segment ) {
		idl_weight = 0.10;
	} else {
		idl_weight = 5.00;
	}
	pass_ftol = 0.00001;

	minimize_set_vary_omega(vary_omega);
	minimize_reset_exclude_list();
	pack_phipsi(phipsi,nangles,1,total_residue);
	tether_set_window_size(window);
	scorefxn_set_bump_weight(idl_weight);
	dfpmin(phipsi,nangles,pass_ftol,iter,fret,gfrag);
	if ( !gfrag ) return;
	unpack_phipsi(phipsi,first_res,last_res,gfrag);
	if ( !gfrag ) return;
	refold(first_res,last_res);
	fast_rms_x(position,tether_position,tether_rms);
	if ( get_fullatom_flag() ) {
		std::cout << I( 6, window ) << ' ' << F( 6, 3, idl_weight ) << "   " <<
		 L( 1, vary_omega ) << "   " << I( 4, iter ) << ' ' <<
		 F( 10, 2, fret ) << ' ' <<
		 F( 9, 3, tether_rms ) << ' ' <<
		 F( 9, 3, ramachandran_score ) << ' ' <<
		 F( 9, 3, fa_rep_score ) << ' ' <<
		 F( 9, 3, fa_atr_score ) << ' ' <<
		 F( 9, 3, tether_score ) << ' ' <<
		 F( 9, 3, omega_score ) << ' ' <<
		 F( 9, 3, phipsi_score ) << std::endl;
	} else {
		std::cout << I( 6, window ) << ' ' << F( 6, 3, idl_weight ) << "   " <<
		 L( 1, vary_omega ) << "   " << I( 4, iter ) << ' ' <<
		 F( 10, 2, fret ) << ' ' <<
		 F( 8, 3, tether_rms ) << ' ' <<
		 F( 8, 3, ramachandran_score ) << ' ' <<
		 F( 8, 3, vdw_score ) << ' ' <<
		 F( 8, 3, tether_score ) << ' ' <<
		 F( 8, 3, omega_score ) << ' ' <<
		 F( 8, 3, phipsi_score ) << std::endl;
	}


//car pass 2: single segment: omega variable, idl_weight=0.001, full window
//glb pass 2:     2 segments: omega variable, idl_weight=0.1, full window
	vary_omega = true;
	if ( single_segment ) {
		idl_weight = 0.001;
	} else {
		idl_weight = 0.1;
	}
	if ( local_idl ) {
		window = std::min(total_residue,local_tether_window);
	} else {
		window = total_residue;
	}
	pass_ftol = 0.0001;

	minimize_set_vary_omega(vary_omega);
	minimize_reset_exclude_list();
	pack_phipsi(phipsi,nangles,1,total_residue);
	tether_set_window_size(window);
	scorefxn_set_bump_weight(idl_weight);
	dfpmin(phipsi,nangles,pass_ftol,iter,fret,gfrag);
	if ( !gfrag ) return;
	unpack_phipsi(phipsi,first_res,last_res,gfrag);
	if ( !gfrag ) return;
	refold(first_res,last_res);
	fast_rms_x(position,tether_position,tether_rms);
	if ( get_fullatom_flag() ) {
		std::cout << I( 6, window ) << ' ' << F( 6, 3, idl_weight ) << "   " <<
		 L( 1, vary_omega ) << "   " << I( 4, iter ) << ' ' <<
		 F( 10, 2, fret ) << ' ' <<
		 F( 9, 3, tether_rms ) << ' ' <<
		 F( 9, 3, ramachandran_score ) << ' ' <<
		 F( 9, 3, fa_rep_score ) << ' ' <<
		 F( 9, 3, fa_atr_score ) << ' ' <<
		 F( 9, 3, tether_score ) << ' ' <<
		 F( 9, 3, omega_score ) << ' ' <<
		 F( 9, 3, phipsi_score ) << std::endl;
	} else {
		std::cout << I( 6, window ) << ' ' << F( 6, 3, idl_weight ) << "   " <<
		 L( 1, vary_omega ) << "   " << I( 4, iter ) << ' ' <<
		 F( 10, 2, fret ) << ' ' <<
		 F( 8, 3, tether_rms ) << ' ' <<
		 F( 8, 3, ramachandran_score ) << ' ' <<
		 F( 8, 3, vdw_score ) << ' ' <<
		 F( 8, 3, tether_score ) << ' ' <<
		 F( 8, 3, omega_score ) << ' ' <<
		 F( 8, 3, phipsi_score ) << std::endl;
	}

//car pass 3: single segment: omega variable, idl_weight=1.0, full window
//glb pass 3:     2 segments: omega variable, idl_weight=1.0, full window
	vary_omega = true;
	idl_weight = 1.0;
	if ( local_idl ) {
		window = std::min(total_residue,local_tether_window);
	} else {
		window = total_residue;
	}
	pass_ftol = 0.0001;

	pack_phipsi(phipsi,nangles,1,total_residue);
	tether_set_window_size(window);
	scorefxn_set_bump_weight(idl_weight);
	dfpmin(phipsi,nangles,pass_ftol,iter,fret,gfrag);
	if ( !gfrag ) return;
	unpack_phipsi(phipsi,first_res,last_res,gfrag);
	if ( !gfrag ) return;

	refold(first_res,last_res);
	fast_rms_x(position,tether_position,tether_rms);
	if ( fullatom ) {
		std::cout << I( 6, window ) << ' ' << F( 6, 3, idl_weight ) << "   " <<
		 L( 1, vary_omega ) << "   " << I( 4, iter ) << ' ' <<
		 F( 10, 2, fret ) << ' ' <<
		 F( 9, 3, tether_rms ) << ' ' <<
		 F( 9, 3, ramachandran_score ) << ' ' <<
		 F( 9, 3, fa_rep_score ) << ' ' <<
		 F( 9, 3, fa_atr_score ) << ' ' <<
		 F( 9, 3, tether_score ) << ' ' <<
		 F( 9, 3, omega_score ) << ' ' <<
		 F( 9, 3, phipsi_score ) << std::endl;
	} else {
		std::cout << I( 6, window ) << ' ' << F( 6, 3, idl_weight ) << "   " <<
		 L( 1, vary_omega ) << "   " << I( 4, iter ) << ' ' <<
		 F( 10, 2, fret ) << ' ' <<
		 F( 8, 3, tether_rms ) << ' ' <<
		 F( 8, 3, ramachandran_score ) << ' ' <<
		 F( 8, 3, vdw_score ) << ' ' <<
		 F( 8, 3, tether_score ) << ' ' <<
		 F( 8, 3, omega_score ) << ' ' <<
		 F( 8, 3, phipsi_score ) << std::endl;
	}

//car calculate final scores
	calculate_angle_rms(angle_rms);
	std::cout << "rms to starting angles" << SS( angle_rms ) << std::endl;

	calculate_tether_dme(tether_dme);
	std::cout << "root mean dme to starting coordinates" << SS( tether_dme ) << std::endl;

//car calculate final scores
	if ( local_idl ) {
		ca_rms = 0.0;
		save_residue = total_residue;
		total_residue = window;

		for ( int i = 1; i <= save_residue-window+1; ++i ) {
			fast_rms_x(Eposition(1,1,i),tether_position(1,5*(i-1)+1),window_rms);
			ca_rms += window_rms;
		}
		ca_rms /= (save_residue-window+1);
		std::cout << "mean CA rmsd to starting coordinates over " <<
			"all windows" << SS( ca_rms ) << std::endl;
		total_residue = save_residue;
	}

//glb reorient coords (redundant in 2 segment idealization but gives ca_rms)
	orient_region(total_residue,position,full_coord,tether_position,
		1,1,total_residue,1,1,total_residue,ca_rms);

	std::cout << "global ca_rms to starting coordinates" << SS( ca_rms ) << std::endl;

	minimize_set_vary_omega(false);

	minimize_uninit_exclude_list(); // prepare for future minimization
	set_currently_minimizing( false ); // was set to true in pack_phipsi

//car set names associated with angle source to indicate idealization
	for ( int i = 1; i <= total_residue; ++i ) name(i) = "IDLZ";

}


////////////////////////////////////////////////////////////////////////////////
/// @begin idealize_hijack_pose
///
/// @brief
///
/// @detailed
///
/// @param  src_start - [in/out]? -
/// @param  src_end - [in/out]? -
/// @param  dst_start - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
idealize_hijack_pose(
	int src_start,
	int src_end,
	int dst_start
)
{
//car assumes src is C-terminal to dst

	using namespace idl_hijack;
	using namespace misc;
	using namespace param;

	int const max_atom = MAX_ATOM();

	for ( int i = 1; i <= total_residue; ++i ) {
		save_phi(i) = phi(i);
		save_psi(i) = psi(i);
		save_omega(i) = omega(i);
		save_res(i) = res(i);
		save_res_variant(i) = res_variant(i);
		save_secstruct(i) = secstruct(i);
		for ( int k = 1; k <= 3; ++k ) {
			for ( int j = 1; j <= 5; ++j ) {
				save_Eposition(k,j,i) = Eposition(k,j,i);
			}
			for ( int j = 1; j <= max_atom; ++j ) {
				save_full_coord(k,j,i) = full_coord(k,j,i);
			}
			save_centroid(k,i) = centroid(k,i);
		}
	}
	save_residue = total_residue;

	for ( int i = src_start, ii = dst_start; i <= src_end; ++i, ++ii ) {
		phi(ii) = phi(i);
		psi(ii) = psi(i);
		omega(ii) = omega(i);
		res(ii) = res(i);
		res_variant(ii) = res_variant(i);
		secstruct(ii) = secstruct(i);
		for ( int k = 1; k <= 3; ++k ) {
			for ( int j = 1; j <= 5; ++j ) {
				Eposition(k,j,ii) = Eposition(k,j,i);
			}
			for ( int j = 1; j <= max_atom; ++j ) {
				full_coord(k,j,ii) = full_coord(k,j,i);
			}
			centroid(k,ii) = centroid(k,i);
		}
	}
	total_residue = src_end-src_start+1;
	int first_res = 1;
	refold_set_segments(1,1,first_res,total_residue,0);

	update_sequence();

	hijack_start = dst_start;
	restore_start = src_start;
	restore_end = src_end;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin idealize_unhijack_pose
///
/// @brief
/// copies back idealized section, reset head of array with tether values
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
idealize_unhijack_pose()
{

	using namespace idl_hijack;
	using namespace misc;
	using namespace param;

	total_residue = save_residue;
	int hijack_end = hijack_start + ( restore_end - restore_start );
	int const max_atom = MAX_ATOM();

//car move hijack region
	for ( int i = hijack_end, ii = restore_end; i >= hijack_start; --i, --ii ) {
		phi(ii) = phi(i);
		psi(ii) = psi(i);
		omega(ii) = omega(i);
		res(ii) = res(i);
		res_variant(ii) = res_variant(i);
		secstruct(ii) = secstruct(i);
		for ( int k = 1; k <= 3; ++k ) {
			for ( int j = 1; j <= 5; ++j ) {
				Eposition(k,j,ii) = Eposition(k,j,i);
			}
			for ( int j = 1; j <= max_atom; ++j ) {
				full_coord(k,j,ii) = full_coord(k,j,i);
			}
			centroid(k,ii) = centroid(k,i);
		}
	}

//car restore remainder from saved
	for ( int i = 1; i < restore_start; ++i ) {
		phi(i) = save_phi(i);
		psi(i) = save_psi(i);
		omega(i) = save_omega(i);
		res(i) = save_res(i);
		res_variant(i) = save_res_variant(i);
		secstruct(i) = save_secstruct(i);
		for ( int k = 1; k <= 3; ++k ) {
			for ( int j = 1; j <= 5; ++j ) {
				Eposition(k,j,i) = save_Eposition(k,j,i);
			}
			for ( int j = 1; j <= max_atom; ++j ) {
				full_coord(k,j,i) = save_full_coord(k,j,i);
			}
			centroid(k,i) = save_centroid(k,i);
		}
	}

	for ( int i = restore_end+1; i <= total_residue; ++i ) {
		phi(i) = save_phi(i);
		psi(i) = save_psi(i);
		omega(i) = save_omega(i);
		res(i) = save_res(i);
		res_variant(i) = save_res_variant(i);
		secstruct(i) = save_secstruct(i);
		for ( int k = 1; k <= 3; ++k ) {
			for ( int j = 1; j <= 5; ++j ) {
				Eposition(k,j,i) = save_Eposition(k,j,i);
			}
			for ( int j = 1; j <= max_atom; ++j ) {
				full_coord(k,j,i) = save_full_coord(k,j,i);
			}
			centroid(k,i) = save_centroid(k,i);
		}
	}
	update_sequence();
	int first_res = 1;
	refold_set_segments(1,1,first_res,total_residue,0);

}

//////////////////////////////////////////////////////////////////////
void
set_no_faidl(
	bool const & setting
){

	using namespace check_no_faidl;

	no_faidl = setting;
//	minimize_set_vary_chi( !setting );

}

bool
get_no_faidl()
{
	return check_no_faidl::no_faidl;
}
