// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 08:39:36 +0200 (Sun, 18 Mar 2007) $
//  $Author: stuartm $

#ifndef INCLUDED_input_pdb
#define INCLUDED_input_pdb


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <iosfwd>
#include <string>


// input_pdb Function Declarations


void
input_pdb(
	utility::io::irstream & iunit,
	bool const seq_defined, // sequence already defined by fasta/dat etc
	bool const fullatom, // read fullatom coordinates?
	bool & fail // read failure?
);


void
clear_header();


void
append_header_line( std::string hline );


void
read_pdb_header( utility::io::irstream & iunit );


void
check_missing_residue(
	FArray1D_bool const & missing_atom,
	int const ires,
	int & nmissing,
	int & nmissing_res,
	bool & is_missing, // does residue have missing atoms
	int const res_num,
	char const chain_id,
	std::string const & res_name
);


void
read_pdb_phipsi(
	utility::io::irstream & funit,
	bool & fail
);


void
get_atom_num(
	std::string const & name, // atom name
	int & number // atom number
);


void
centroid_place_useinputsidechain();

void
centroid_place();


void
orient_centroid( float & centroid_rms );


void
random_rot();


void
torsion_from_position(
	int const nres, // # of residues in the protein, logical
	FArray3Da_float xyz, // (xyz,atom#,res#) atom order:N CA CB C O
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_float omega
);


float
dihedral(
	FArray1Da_float a1,
	FArray1Da_float a2,
	FArray1Da_float a3,
	FArray1Da_float a4
);


void
compute_CB_position( FArray2Da_float position );


bool
clean_pdb( FArray2D_bool const & missingatoms );


void
count_neighbors_wrap(
	FArray1Da_int res,
	int & total_residue,
	FArray3Da_float full_coord,
	FArray2Da_bool nlist_out
);


void
fill_missingatoms( FArray2D_bool const & missingatoms );


void
get_missingchi(
	FArray2D_bool const & missingatoms,
	int const total_residue,
	FArray2Da_bool missingchi,
	FArray1Da_int res,
	FArray1Da_int res_variant
);


void
input_compressed( bool & fail, bool & coord_fila );

void
input_compressed_istream(utility::io::irstream &pdb_stream,
                  bool & fail );

void
input_compressed_new( bool & fail, bool & coord_fail );


void
get_size_from_first_pdb(
	bool const require_start,
	bool const silent_input
);


std::string
open_start_pdb( utility::io::izstream & pdb_stream );

std::string
open_start_pdb(
	utility::io::izstream & pdb_stream,
	std::string filename
);

std::string
open_compressed_start_pdb( utility::io::izstream & pdb_stream );


int
input_compressed_get_sequence(
	utility::io::irstream & pdb_stream,
	std::string & sequence
);


int
input_pdb_get_size( utility::io::irstream & pdb_stream );


void
save_missing_atoms(
	FArray1D_bool const & missing_atom,
	int const ires
);


bool
flip_symmetric_coords(
	int const aa,
	int const aav,
	FArray2Da_float coords
);


#endif
