// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 08:39:36 +0200 (Sun, 18 Mar 2007) $
//  $Author: stuartm $


// Rosetta Headers
#include "ise_movies.h"
#include "counters.h"
#include "files_paths.h"
#include "fullatom.h"
#include "make_pdb.h"
#include "output_decoy.h"

// Utility Headers
#include <utility/io/ozstream.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>


void
output_movie_frame(
	float const local_mc_score,
	float const local_mc_best_score,
	int const local_mc_accept
)
{
//car write the fullcoord array to a file in pdb format

	using namespace counters;
	using namespace files_paths;

	static int frame_count = { 0 };

	int number;
	get_decoy_number(number);

	if ( frame_count < 10000 ) {
		std::string filename;
		if ( local_mc_accept == 0 ) {
			return; // uncomment this to get rejects too
			filename = movie_path + code + "_" + lead_zero_string_of( number, 4 )
			 + "_movie_" + lead_zero_string_of( frame_count, 4 ) + "_reject.pdb";
			++frame_count;
		} else {
			filename = movie_path + code + "_" + lead_zero_string_of( number, 4 )
			 + "_movie_" + lead_zero_string_of( frame_count, 4 ) + "_accept.pdb";
			++frame_count;
		}

		utility::io::ozstream movie_x( filename );

		movie_x << "ise frame: " << filename << '\n';
		movie_x << "ise mc score best type accept: "  <<
		 F( 13, 4, local_mc_score ) << F( 13, 4, local_mc_best_score ) <<
		 I( 3, local_mc_accept ) << space( 3 ) << move_type << '\n';
		bool fullatom = get_fullatom_flag();
		if ( fullatom ) {
			output_fullcoord_pdb(movie_x);
			output_chi(movie_x);
		} else {
			output_position_pdb(movie_x);
		}
		output_pdb_stats(movie_x,fullatom);
		output_torsion_angles(movie_x);
		movie_x.close();
		movie_x.clear();
	} else {
		std::cout << "more output frames than recommended for file system: "
		 << frame_count << std::endl;
	}
}
